% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HierarchicalMetaAnalysis.R
\name{computeHierarchicalMetaAnalysis}
\alias{computeHierarchicalMetaAnalysis}
\title{Compute a Bayesian random-effects hierarchical meta-analysis}
\usage{
computeHierarchicalMetaAnalysis(
  data,
  settings = generateBayesianHMAsettings(),
  alpha = 0.05,
  seed = 1,
  showProgressBar = TRUE
)
}
\arguments{
\item{data}{A data frame containing either normal, skew-normal, custom parametric,
or grid likelihood data, with one row per database.}

\item{settings}{Model settings list generated by \code{generateBayesianHMAsettings()}}

\item{alpha}{The alpha (expected type I error) used for the credible intervals.}

\item{seed}{Seed for the random number generator.}

\item{showProgressBar}{Showing a progress bar for MCMC?}
}
\value{
A data frame with the point estimates, 95\% credible intervals and sample standard errors
for the (de-biased) global main effect, the average outcome effect, the average data source effect,
and precision of random errors.
Attributes of the data frame contain the MCMC trace and the detected approximation type.
}
\description{
Compute a Bayesian hierarchical meta-analysis (two-level model) to learn the global effect
with bias correction via negative control outcomes analysis.
Bayesian inference is performed using the Markov chain Monte Carlo (MCMC) engine BEAST.
Normal priors are used for the global effect, outcome-specific effects, and data-source-specific effects;
a half normal prior is used for the standard deviation; a gamma prior is used for the precision parameters.
}
\examples{
data("hmaLikelihoodList")
estimates <- EvidenceSynthesis::computeHierarchicalMetaAnalysis(
  data = hmaLikelihoodList,
  seed = 666
)

}
\seealso{
\link{approximateLikelihood}, \link{computeBayesianMetaAnalysis}
}
