% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetermineIsomainPeaks.R
\name{DetermineIsomainPeaks}
\alias{DetermineIsomainPeaks}
\title{DetermineIsomainPeaks.}
\usage{
DetermineIsomainPeaks(spec = NULL, int_cutoff = 0.03, dmz_cutoff = 0.001,
  precursor = NULL)
}
\arguments{
\item{spec}{A two-column matrix with mz and int.}

\item{int_cutoff}{Do not consider isomain peaks below this intensity cutoff (relative to base peak).}

\item{dmz_cutoff}{Expected maximum within scan mass defect of your device in milli Dalton.}

\item{precursor}{Specify the assumed precursor explicitly (ensure that precursor mass is included in list and everything above/higher is removed).}
}
\value{
A vector of ion masses from a spectrum which are potential fragment masses (without isotopes).
}
\description{
\code{DetermineIsomainPeaks} will evaluate a mass spectrum and try to find the main isotopic clusters.
}
\details{
This function is used within \link{PlotSpec} and \link{InterpretMSSpectrum} to identify main isotopic clusters.
It is currently exported to allow the user to modify/substitute the result but may become an internal function in the future.
}
\keyword{internal}

