/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5FDdirect_H
#define H5FDdirect_H

#include "H5FDpublic.h" 

#ifdef H5_HAVE_DIRECT

#define H5FD_DIRECT (H5OPEN H5FD_DIRECT_id_g)

#define H5FD_DIRECT_VALUE H5_VFD_DIRECT

#else

#define H5FD_DIRECT       (H5I_INVALID_HID)

#define H5FD_DIRECT_VALUE H5_VFD_INVALID

#endif 

#define MBOUNDARY_DEF 4096

#define FBSIZE_DEF 4096

#define CBSIZE_DEF (16 * 1024 * 1024)

#ifdef H5_HAVE_DIRECT
#ifdef __cplusplus
extern "C" {
#endif

H5_DLLVAR hid_t H5FD_DIRECT_id_g;

H5_DLL herr_t H5Pset_fapl_direct(hid_t fapl_id, size_t alignment, size_t block_size, size_t cbuf_size);

H5_DLL herr_t H5Pget_fapl_direct(hid_t fapl_id, size_t *boundary , size_t *block_size ,
                                 size_t *cbuf_size );

#ifdef __cplusplus
}
#endif

#endif 

#endif
