#ifndef H5_PUBCONF_H
#define H5_PUBCONF_H

/* ========================================================================== */
/* 1. Runtime / Generator Definitions & Overrides                           */
/* ========================================================================== */
/* Expects H5_SIZEOF_* macros and Endianness definitions from find_byte_widths.c */
#include "H5_byte_widths.h"

/* Compiler Override Strategy:
 * If the compiler defines standard size macros (GCC/Clang), prefer those
 * over the runtime values generated by find_byte_widths.c
 */
#ifdef __SIZEOF_CHAR__
    #undef H5_SIZEOF_CHAR
    #define H5_SIZEOF_CHAR __SIZEOF_CHAR__
#endif
#ifdef __SIZEOF_SHORT__
    #undef H5_SIZEOF_SHORT
    #define H5_SIZEOF_SHORT __SIZEOF_SHORT__
#endif
#ifdef __SIZEOF_INT__
    #undef H5_SIZEOF_INT
    #define H5_SIZEOF_INT __SIZEOF_INT__
    #undef H5_SIZEOF_UNSIGNED
    #define H5_SIZEOF_UNSIGNED __SIZEOF_INT__
#endif
#ifdef __SIZEOF_LONG__
    #undef H5_SIZEOF_LONG
    #define H5_SIZEOF_LONG __SIZEOF_LONG__
#endif
#ifdef __SIZEOF_LONG_LONG__
    #undef H5_SIZEOF_LONG_LONG
    #define H5_SIZEOF_LONG_LONG __SIZEOF_LONG_LONG__
#endif
#ifdef __SIZEOF_FLOAT__
    #undef H5_SIZEOF_FLOAT
    #define H5_SIZEOF_FLOAT __SIZEOF_FLOAT__
#endif
#ifdef __SIZEOF_DOUBLE__
    #undef H5_SIZEOF_DOUBLE
    #define H5_SIZEOF_DOUBLE __SIZEOF_DOUBLE__
#endif
#ifdef __SIZEOF_LONG_DOUBLE__
    #undef H5_SIZEOF_LONG_DOUBLE
    #define H5_SIZEOF_LONG_DOUBLE __SIZEOF_LONG_DOUBLE__
#endif
#ifdef __SIZEOF_SIZE_T__
    #undef H5_SIZEOF_SIZE_T
    #define H5_SIZEOF_SIZE_T __SIZEOF_SIZE_T__
#endif
#ifdef __SIZEOF_PTRDIFF_T__
    #undef H5_SIZEOF_PTRDIFF_T
    #define H5_SIZEOF_PTRDIFF_T __SIZEOF_PTRDIFF_T__
#endif

/* Endianness Override */
#ifdef __BYTE_ORDER__
    #if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
        #undef WORDS_BIGENDIAN
    #elif __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__
        #undef WORDS_BIGENDIAN
        #define WORDS_BIGENDIAN 1
    #endif
#endif
#ifdef __BIG_ENDIAN__
  #define WORDS_BIGENDIAN 1
#endif


/* ========================================================================== */
/* 2. Project Metadata & Policy                                             */
/* ========================================================================== */
/* These settings define package info and enable core library policies. */
#define H5_PACKAGE_NAME                 "HDF5"
#define H5_PACKAGE_VERSION              "2.0.0"
#define H5_PACKAGE_STRING               "HDF5 2.0.0"
#define H5_PACKAGE_BUGREPORT            "help@hdfgroup.org"
#define H5_PACKAGE                      "hdf5"
#define H5_PACKAGE_TARNAME              "hdf5"
#define H5_PACKAGE_URL                  "https://www.hdfgroup.org"
#define H5_VERSION                      "2.0.0"

#define H5_USE_FILE_LOCKING             1
#define H5_IGNORE_DISABLED_FILE_LOCKS   1
#define H5_HAVE_EMBEDDED_LIBINFO        1
#define H5_WANT_DATA_ACCURACY           1
#define H5_WANT_DCONV_EXCEPTION         1
#define H5_INCLUDE_HL                   1

/* ========================================================================== */
/* 3. Universal Compiler & Language Features                                */
/* ========================================================================== */
/* Features guaranteed by a C99/C11 compliant compiler. */
#define H5_HAVE_ATTRIBUTE               1
#define H5_HAVE_C99_COMPLEX_NUMBERS     1
#define H5_HAVE_COMPLEX_NUMBERS         1
#define H5_STDC_HEADERS                 1
#define H5_HAVE_IEEE_754                1

/* ========================================================================== */
/* 4. Universal Library & Header Availability                               */
/* ========================================================================== */
/* Headers and libraries present on all CRAN platforms (R >= 4.1). */
#define H5_HAVE_FILTER_DEFLATE          1
#define H5_HAVE_ZLIB_H                  1
#define H5_HAVE_LIBZ                    1
#define H5_HAVE_DIRENT_H                1
#define H5_HAVE_SYS_STAT_H              1
#define H5_HAVE_SYS_TIME_H              1
#define H5_HAVE_SYS_TYPES_H             1
#define H5_HAVE_UNISTD_H                1
#define H5_HAVE_TIME_H                  1
#define H5_HAVE_PTHREAD_H               1 /* pthreads are standard in R's toolchain */
#define H5_HAVE_THREADSAFE              1
#define H5_HAVE_THREADS                 1

/* ========================================================================== */
/* 5. Universal System Function Availability                                */
/* ========================================================================== */
/* C functions present on all CRAN platforms (POSIX and MinGW). */
#define H5_HAVE_CLOCK_GETTIME           1
#define H5_HAVE_GETHOSTNAME             1
#define H5_HAVE_GETTIMEOFDAY            1
#define H5_HAVE_STRDUP                  1
#define H5_HAVE_SYSTEM                  1
#define H5_HAVE_TMPFILE                 1

/* ========================================================================== */
/* 6. Platform-Specific Features (Additive Only)                            */
/* ========================================================================== */

/* --- Windows Specifics (Rtools / MinGW) --- */
#if defined(_WIN32) || defined(__MINGW32__)
    #define H5_HAVE_WINDOWS             1
    #define H5_HAVE_WIN32_API           1
    #define H5_HAVE_MINGW               1
    #define H5_HAVE_LIBWS2_32           1
    #define H5_HAVE_WINDOW_PATH         1
    #define H5_DEFAULT_PLUGINDIR        "%ALLUSERSPROFILE%\\hdf5\\lib\\plugin"

/* --- POSIX Specifics (Linux / macOS / BSD) --- */
#else
    #define H5_DEFAULT_PLUGINDIR        "/usr/local/hdf5/lib/plugin"
    #define H5_HAVE_PWD_H               1
    #define H5_HAVE_NETDB_H             1
    #define H5_HAVE_FCNTL_H             1
    #define H5_HAVE_ALARM               1
    #define H5_HAVE_FORK                1
    #define H5_HAVE_WAITPID             1
    #define H5_HAVE_SYMLINK             1
    #define H5_HAVE_STAT_ST_BLOCKS      1
    #define H5_HAVE_FLOCK               1
    #define H5_HAVE_SYS_FILE_H          1
    #define H5_HAVE_GETRUSAGE           1
    #define H5_HAVE_SYS_RESOURCE_H      1
    #define H5_HAVE_DLFCN_H             1 /* For dynamic filter plugins */
    #define H5_HAVE_LIBDL               1
    
    #if defined(__APPLE__)
        #define H5_HAVE_DARWIN          1
        #define H5_HAVE_PREADWRITE      1
    #elif defined(__sun)
        /* pread/pwrite may be missing on older Solaris */
    #else
        #define H5_HAVE_PREADWRITE      1
    #endif
#endif


/* ========================================================================== */
/* 7. Explicitly Disabled Features                                          */
/* ========================================================================== */
/* These features are explicitly disabled on all platforms to ensure maximum
   portability and avoid reliance on non-standard or problematic extensions. */
#undef H5_HAVE_WIN_THREADS          /* Use pthreads instead */
#undef H5_HAVE_STRCASESTR           /* Non-standard string function */
#undef H5_HAVE_ASPRINTF             /* Non-standard string function */
#undef H5_HAVE_VASPRINTF            /* Non-standard string function */
#undef H5_HAVE_QSORT_REENTRANT      /* Incompatible signatures (GNU vs BSD) */
#undef H5_HAVE_TM_GMTOFF            /* Non-standard time.h member */
#undef H5_HAVE_TIMEZONE             /* Non-standard time.h member */
#undef H5_HAVE_STRUCT_TIMEZONE      /* Non-standard time.h struct */
#undef H5_HAVE_IOCTL                /* Terminal/device specific I/O */
#undef H5_HAVE_TIOCGETD             /* Terminal/device specific I/O */
#undef H5_HAVE_TIOCGWINSZ           /* Terminal/device specific I/O */
#undef H5_HAVE_GETCONSOLESCREENBUFFERINFO /* Windows-specific console I/O */

#endif /* H5_PUBCONF_H */
