# This file was autogenerated.
use 5.008001;
use strict;
use warnings;
no warnings qw( void once );
use Hydrogen ();

package Hydrogen::Topic::String;

our $AUTHORITY = 'cpan:TOBYINK';
our $VERSION   = '0.021001';

=head1 NAME

Hydrogen::Topic::String - functions from Hydrogen::String applied to C<$_>

=head1 VERSION

This documentation is for Hydrogen::Topic::String 0.021001,
which is based on Sub::HandlesVia::HandlerLibrary::String 0.050005.

=cut

=head1 FUNCTIONS

Each function implicitly operates on C<< $_ >>, expecting it to be a string scalar.

=cut

use Exporter::Shiny qw(
    append
    chomp
    chop
    clear
    cmp
    cmpi
    contains
    contains_i
    ends_with
    ends_with_i
    eq
    eqi
    fc
    ge
    gei
    get
    gt
    gti
    inc
    lc
    le
    lei
    length
    lt
    lti
    match
    match_i
    ne
    nei
    prepend
    replace
    replace_globally
    reset
    set
    starts_with
    starts_with_i
    substr
    trim
    uc
);

=head2 C<< append( $tail ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Appends another string to the end of the current string and updates the original value.

=cut

sub append {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "append", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for append: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    (
        $_ = do {
            my $shv_final_unchecked = $_ . $_[0];
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for append: expected %s, got value %s",
                    "Str", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< chomp() >>

Operates on C<< $_ >>, which must be a string scalar.

Like C<chomp> from L<perlfunc>.

=cut

sub chomp {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for chomp; usage: "
          . "Hydrogen::Topic::String::chomp()" );
    1;
    chomp($_);
}

=head2 C<< chop() >>

Operates on C<< $_ >>, which must be a string scalar.

Like C<chop> from L<perlfunc>.

=cut

sub chop {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for chop; usage: "
          . "Hydrogen::Topic::String::chop()" );
    1;
    chop($_);
}

=head2 C<< clear() >>

Operates on C<< $_ >>, which must be a string scalar.

Sets the string to the empty string.

=cut

sub clear {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for clear; usage: "
          . "Hydrogen::Topic::String::clear()" );
    1;
    ( $_ = q() );
}

=head2 C<< cmp( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< $_ cmp $str >>.

=cut

sub cmp {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "cmp", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for cmp: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    $_ cmp $_[0];
}

=head2 C<< cmpi( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< fc($_) cmp fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub cmpi {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "cmpi", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for cmpi: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    Hydrogen::fc($_) cmp Hydrogen::fc( $_[0] );
}

=head2 C<< contains( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns true iff the string contains C<< $str >>.

=cut

sub contains {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "contains", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for contains: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    index( $_, $_[0] ) != -1;
}

=head2 C<< contains_i( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns true iff the string contains C<< $str >> case-insensitvely.

=cut

sub contains_i {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "contains_i", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for contains_i: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    index( Hydrogen::fc($_), Hydrogen::fc( $_[0] ) ) != -1;
}

=head2 C<< ends_with( $tail ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns true iff the string ends with C<< $tail >>.

=cut

sub ends_with {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ends_with", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ends_with: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    substr( $_, -length $_[0] ) eq $_[0];
}

=head2 C<< ends_with_i( $tail ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns true iff the string ends with C<< $tail >> case-insensitvely.

=cut

sub ends_with_i {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ends_with_i", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ends_with_i: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    Hydrogen::fc( substr( $_, -length $_[0] ) ) eq Hydrogen::fc( $_[0] );
}

=head2 C<< eq( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< $_ eq $str >>.

=cut

sub eq {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "eq", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for eq: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    $_ eq $_[0];
}

=head2 C<< eqi( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< fc($_) eq fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub eqi {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "eqi", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for eqi: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    Hydrogen::fc($_) eq Hydrogen::fc( $_[0] );
}

=head2 C<< fc() >>

Operates on C<< $_ >>, which must be a string scalar.

Returns C<< fc($_) >>.

=cut

sub fc {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for fc; usage: "
          . "Hydrogen::Topic::String::fc()" );
    Hydrogen::fc($_);
}

=head2 C<< ge( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< $_ ge $str >>.

=cut

sub ge {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ge", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ge: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    $_ ge $_[0];
}

=head2 C<< gei( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< fc($_) ge fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub gei {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "gei", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for gei: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    Hydrogen::fc($_) ge Hydrogen::fc( $_[0] );
}

=head2 C<< get() >>

Operates on C<< $_ >>, which must be a string scalar.

Gets the current value of the string.

=cut

sub get {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for get; usage: "
          . "Hydrogen::Topic::String::get()" );
    $_;
}

=head2 C<< gt( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< $_ gt $str >>.

=cut

sub gt {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "gt", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for gt: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    $_ gt $_[0];
}

=head2 C<< gti( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< fc($_) gt fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub gti {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "gti", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for gti: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    Hydrogen::fc($_) gt Hydrogen::fc( $_[0] );
}

=head2 C<< inc() >>

Operates on C<< $_ >>, which must be a string scalar.

Performs C<< ++ >> on the string.

=cut

sub inc {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for inc; usage: "
          . "Hydrogen::Topic::String::inc()" );
    1;
    ++$_;
}

=head2 C<< lc() >>

Operates on C<< $_ >>, which must be a string scalar.

Returns C<< lc($_) >>.

=cut

sub lc {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for lc; usage: "
          . "Hydrogen::Topic::String::lc()" );
    lc($_);
}

=head2 C<< le( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< $_ le $str >>.

=cut

sub le {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "le", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for le: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    $_ le $_[0];
}

=head2 C<< lei( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< fc($_) le fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub lei {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "lei", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for lei: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    Hydrogen::fc($_) le Hydrogen::fc( $_[0] );
}

=head2 C<< length() >>

Operates on C<< $_ >>, which must be a string scalar.

Like C<length> from L<perlfunc>.

=cut

sub length {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for length; usage: "
          . "Hydrogen::Topic::String::length()" );
    length($_);
}

=head2 C<< lt( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< $_ lt $str >>.

=cut

sub lt {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "lt", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for lt: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    $_ lt $_[0];
}

=head2 C<< lti( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< fc($_) lt fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub lti {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "lti", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for lti: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    Hydrogen::fc($_) lt Hydrogen::fc( $_[0] );
}

=head2 C<< match( $regexp ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str|RegexpRef >>.

Returns true iff the string matches the regexp.

=cut

sub match {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "match", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str|RegexpRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[0] ) and do {
                        ref( \$_[0] ) eq 'SCALAR'
                          or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
                    }
                  }
                  or (
                    do {

                        package Hydrogen::String::__SANDBOX__;
                        use Scalar::Util ();
                        use re           ();
                        ref( $_[0] ) && !!re::is_regexp( $_[0] )
                          or Scalar::Util::blessed( $_[0] )
                          && $_[0]->isa('Regexp');
                    }
                  )
            );
          }
          or Hydrogen::croak(
            "Type check failed in signature for match: %s should be %s",
            "\$_[0]", "Str|RegexpRef" );

        (@_);
    };
    $_ =~ /$_[0]/;
}

=head2 C<< match_i( $regexp ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str|RegexpRef >>.

Returns true iff the string matches the regexp case-insensitively.

=cut

sub match_i {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "match_i", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str|RegexpRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[0] ) and do {
                        ref( \$_[0] ) eq 'SCALAR'
                          or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
                    }
                  }
                  or (
                    do {

                        package Hydrogen::String::__SANDBOX__;
                        use Scalar::Util ();
                        use re           ();
                        ref( $_[0] ) && !!re::is_regexp( $_[0] )
                          or Scalar::Util::blessed( $_[0] )
                          && $_[0]->isa('Regexp');
                    }
                  )
            );
          }
          or Hydrogen::croak(
            "Type check failed in signature for match_i: %s should be %s",
            "\$_[0]", "Str|RegexpRef" );

        (@_);
    };
    $_ =~ /$_[0]/i;
}

=head2 C<< ne( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< $_ ne $str >>.

=cut

sub ne {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "ne", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for ne: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    $_ ne $_[0];
}

=head2 C<< nei( $str ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns C<< fc($_) ne fc($str) >>. Uses C<lc> instead of C<fc> in versions of Perl older than 5.16.

=cut

sub nei {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "nei", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for nei: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    Hydrogen::fc($_) ne Hydrogen::fc( $_[0] );
}

=head2 C<< prepend( $head ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Prepends another string to the start of the current string and updates the original value.

=cut

sub prepend {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "prepend", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for prepend: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    (
        $_ = do {
            my $shv_final_unchecked = $_[0] . $_;
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for prepend: expected %s, got value %s",
                    "Str", $shv_final_unchecked
                  );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< replace( $regexp, $replacement ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str|RegexpRef >>, B<< Str|CodeRef >>.

Replaces the first regexp match within the string with the replacement string.

=cut

sub replace {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "replace", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str|RegexpRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[0] ) and do {
                        ref( \$_[0] ) eq 'SCALAR'
                          or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
                    }
                  }
                  or (
                    do {

                        package Hydrogen::String::__SANDBOX__;
                        use Scalar::Util ();
                        use re           ();
                        ref( $_[0] ) && !!re::is_regexp( $_[0] )
                          or Scalar::Util::blessed( $_[0] )
                          && $_[0]->isa('Regexp');
                    }
                  )
            );
          }
          or Hydrogen::croak(
            "Type check failed in signature for replace: %s should be %s",
            "\$_[0]", "Str|RegexpRef" );

        # Parameter $_[1] (type: Str|CodeRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[1] ) and do {
                        ref( \$_[1] ) eq 'SCALAR'
                          or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
                    }
                  }
                  or ( ref( $_[1] ) eq 'CODE' )
            );
          }
          or Hydrogen::croak(
            "Type check failed in signature for replace: %s should be %s",
            "\$_[1]", "Str|CodeRef" );

        (@_);
    };
    my $shv_tmp = $_;
    if ( ( ref( $_[1] ) eq 'CODE' ) ) {
        my $shv_callback = $_[1];
        $shv_tmp =~ s/$_[0]/$shv_callback->()/e;
    }
    else { $shv_tmp =~ s/$_[0]/$_[1]/ }
    (
        $_ = do {
            my $shv_final_unchecked = $shv_tmp;
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for replace: expected %s, got value %s",
                    "Str", $shv_final_unchecked
                  );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< replace_globally( $regexp, $replacement ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str|RegexpRef >>, B<< Str|CodeRef >>.

Replaces the all regexp matches within the string with the replacement string.

=cut

sub replace_globally {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 2
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "replace_globally", scalar(@_), "expected exactly 2 parameters" );

        # Parameter $_[0] (type: Str|RegexpRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[0] ) and do {
                        ref( \$_[0] ) eq 'SCALAR'
                          or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
                    }
                  }
                  or (
                    do {

                        package Hydrogen::String::__SANDBOX__;
                        use Scalar::Util ();
                        use re           ();
                        ref( $_[0] ) && !!re::is_regexp( $_[0] )
                          or Scalar::Util::blessed( $_[0] )
                          && $_[0]->isa('Regexp');
                    }
                  )
            );
          }
          or Hydrogen::croak(
"Type check failed in signature for replace_globally: %s should be %s",
            "\$_[0]", "Str|RegexpRef"
          );

        # Parameter $_[1] (type: Str|CodeRef)
        do {

            package Hydrogen::String::__SANDBOX__;
            (
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined( $_[1] ) and do {
                        ref( \$_[1] ) eq 'SCALAR'
                          or ref( \( my $val = $_[1] ) ) eq 'SCALAR';
                    }
                  }
                  or ( ref( $_[1] ) eq 'CODE' )
            );
          }
          or Hydrogen::croak(
"Type check failed in signature for replace_globally: %s should be %s",
            "\$_[1]", "Str|CodeRef"
          );

        (@_);
    };
    my $shv_tmp = $_;
    if ( ( ref( $_[1] ) eq 'CODE' ) ) {
        my $shv_callback = $_[1];
        $shv_tmp =~ s/$_[0]/$shv_callback->()/eg;
    }
    else { $shv_tmp =~ s/$_[0]/$_[1]/g }
    (
        $_ = do {
            my $shv_final_unchecked = $shv_tmp;
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
"Type check failed for replace_globally: expected %s, got value %s",
                    "Str", $shv_final_unchecked
                  );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< reset() >>

Operates on C<< $_ >>, which must be a string scalar.

Resets the original value to its default value, or an empty string if it has no default.

=cut

sub reset {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for reset; usage: "
          . "Hydrogen::Topic::String::reset()" );
    (
        $_ = do {
            my $shv_final_unchecked = q{};
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for reset: expected %s, got value %s",
                    "Str", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< set( $value ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Sets the string to a new value.

=cut

sub set {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "set", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for set: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    (
        $_ = do {
            my $shv_final_unchecked = $_[0];
            do {
                do {

                    package Hydrogen::String::__SANDBOX__;
                    defined($shv_final_unchecked) and do {
                        ref( \$shv_final_unchecked ) eq 'SCALAR'
                          or ref( \( my $val = $shv_final_unchecked ) ) eq
                          'SCALAR';
                    }
                  }
                  or Hydrogen::croak(
                    "Type check failed for set: expected %s, got value %s",
                    "Str", $shv_final_unchecked );
                $shv_final_unchecked;
            };
        }
    );
}

=head2 C<< starts_with( $head ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns true iff the string starts with C<< $head >>.

=cut

sub starts_with {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "starts_with", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for starts_with: %s should be %s",
            "\$_[0]", "Str" );

        (@_);
    };
    substr( $_, 0, length $_[0] ) eq $_[0];
}

=head2 C<< starts_with_i( $head ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Str >>.

Returns true iff the string starts with C<< $head >> case-insensitvely.

=cut

sub starts_with_i {

    package Hydrogen::String::__SANDBOX__;
    @_ = do {
        my ( %tmp, $tmp );

        @_ == 1
          or Hydrogen::croak(
            "Wrong number of parameters in signature for %s: got %d, %s",
            "starts_with_i", scalar(@_), "expected exactly 1 parameters" );

        # Parameter $_[0] (type: Str)
        do {

            package Hydrogen::String::__SANDBOX__;
            defined( $_[0] ) and do {
                ref( \$_[0] ) eq 'SCALAR'
                  or ref( \( my $val = $_[0] ) ) eq 'SCALAR';
            }
          }
          or Hydrogen::croak(
            "Type check failed in signature for starts_with_i: %s should be %s",
            "\$_[0]", "Str"
          );

        (@_);
    };
    Hydrogen::fc( substr( $_, 0, length $_[0] ) ) eq Hydrogen::fc( $_[0] );
}

=head2 C<< substr( $start, $length?, $replacement? ) >>

Operates on C<< $_ >>, which must be a string scalar.

Arguments: B<< Int >>, B<< Optional[Int] >>, B<< Optional[Str] >>.

Like C<substr> from L<perlfunc>, but is not an lvalue.

=cut

{
    my $__signature;

    sub substr {

        package Hydrogen::String::__SANDBOX__;
        $__signature ||= sub {
            my ( %tmp, $tmp );

            @_ >= 1 && @_ <= 3
              or Hydrogen::croak(
                "Wrong number of parameters in signature for %s: got %d, %s",
                "substr", scalar(@_), "expected exactly 1 parameters" );

            # Parameter $_[0] (type: Int)
            (
                do {
                    my $tmp = $_[0];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for substr: %s should be %s",
                "\$_[0]", "Int" );

            # Parameter $_[1] (type: Optional[Int])
            $#_ >= 1
              or return (@_);
            (
                do {
                    my $tmp = $_[1];
                    defined($tmp) and !ref($tmp) and $tmp =~ /\A-?[0-9]+\z/;
                }
              )
              or Hydrogen::croak(
                "Type check failed in signature for substr: %s should be %s",
                "\$_[1]", "Optional[Int]" );

            # Parameter $_[2] (type: Optional[Str])
            $#_ >= 2
              or return (@_);
            do {

                package Hydrogen::String::__SANDBOX__;
                defined( $_[2] ) and do {
                    ref( \$_[2] ) eq 'SCALAR'
                      or ref( \( my $val = $_[2] ) ) eq 'SCALAR';
                }
              }
              or Hydrogen::croak(
                "Type check failed in signature for substr: %s should be %s",
                "\$_[2]", "Optional[Str]" );

            (@_);
        };
        @_ = &$__signature;
        if    ( ( 0 + @_ ) == 1 ) { substr( $_, $_[0] ) }
        elsif ( ( 0 + @_ ) == 2 ) { substr( $_, $_[0], $_[1] ) }
        elsif ( ( 0 + @_ ) == 3 ) {
            my $shv_tmp    = $_;
            my $shv_return = substr( $shv_tmp, $_[0], $_[1], $_[2] );
            (
                $_ = do {
                    my $shv_final_unchecked = $shv_tmp;
                    do {
                        do {

                            package Hydrogen::String::__SANDBOX__;
                            defined($shv_final_unchecked) and do {
                                ref( \$shv_final_unchecked ) eq 'SCALAR'
                                  or ref( \( my $val = $shv_final_unchecked ) )
                                  eq 'SCALAR';
                            }
                          }
                          or Hydrogen::croak(
"Type check failed for substr: expected %s, got value %s",
                            "Str", $shv_final_unchecked
                          );
                        $shv_final_unchecked;
                    };
                }
            );
            $shv_return;
        }
    }
}

=head2 C<< trim() >>

Operates on C<< $_ >>, which must be a string scalar.

Like C<trim> from L<builtin>, but in-place.

=cut

sub trim {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for trim; usage: "
          . "Hydrogen::Topic::String::trim()" );
    1;
    s/\A\s+//, s/\s+\z// for $_;
}

=head2 C<< uc() >>

Operates on C<< $_ >>, which must be a string scalar.

Returns C<< uc($_) >>.

=cut

sub uc {

    package Hydrogen::String::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for uc; usage: "
          . "Hydrogen::Topic::String::uc()" );
    uc($_);
}

1;

=head1 EXPORT

No functions are exported by this module by default. To import them all (this is usually a bad idea), use:

    use Hydrogen::Topic::String -all;

To import a particular function, use:

    use Hydrogen::Topic::String 'chop';

To rename functions:

    use Hydrogen::Topic::String 'chop' => { -as => 'myfunc' };

On Perl 5.37.2+ (or if L<Lexical::Sub> is installed) you can import lexically:

    use Hydrogen::Topic::String -lexical, 'chop';

See L<Exporter::Tiny::Manual::Importing> for more hints on importing.

=head1 BUGS

Please report any bugs to
L<http://github.com/tobyink/p5-hydrogen/issues>.

=head1 SEE ALSO

L<Hydrogen>,
L<Hydrogen::String>,
L<Hydrogen::Curry::String>,
L<Sub::HandlesVia::HandlerLibrary::String>,
L<String::Util>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022-2025 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

