# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'
#########################
# change 'tests => 1' to 'tests => last_test_to_print'
#use FindBin;
#use lib "$FindBin::Bin/..";
use Test::More qw(no_plan);

#BEGIN { plan tests => 1 };
require_ok("ABI");
my $abi = ABI->new("t/TEST_modified.ab1");
isa_ok( $abi, "ABI" );
my @base_calls = $abi->get_base_calls;

#print STDERR "@base_calls";
my @b_calls =
  qw(20 33 46 56 67 82 89 102 111 124 136 151 163 174 185 192 204 215
  225 233 246 258 274 285 297 308 324 340 349 356 369 383 393 403 413
  422 434 447 458 467 477 487 499 513 523 529 544 552 562 570 581 593
  603 615 624 634 644 657 668 680 690 702 714 726 736 746 756 766 776
  784 796 808 820 830 842 854 863 874 884 897 906 918 930 940 949 960
  972 983 996 1005 1017 1027 1039 1049 1063 1074 1086 1097 1109 1117 1131
  1143 1153 1163 1174 1186 1196 1208 1218 1232 1243 1255 1266 1278 1288
  1298 1310 1323 1333 1345 1357 1368 1380 1392 1402 1413 1425 1436 1448
  1459 1469 1481 1493 1504 1513 1524 1537 1547 1559 1570 1583 1595 1606
  1616 1629 1638 1650 1664 1673 1684 1694 1704 1716 1727 1737 1749 1761
  1774 1786 1796 1810 1820 1834 1844 1855 1865 1874 1887 1900 1913 1926
  1937 1946 1958 1970 1983 1994 2007 2019 2029 2040 2055 2066 2075 2088
  2102 2112 2121 2134 2146 2159 2169 2180 2192 2206 2218 2230 2239 2254
  2264 2276 2286 2302 2314 2323 2338 2350 2360 2371 2382 2395 2408 2418
  2432 2442 2454 2467 2479 2489 2502 2516 2528 2540 2551 2565 2574 2587
  2598 2610 2621 2634 2644 2656 2667 2682 2693 2705 2716 2727 2740 2753
  2766 2778 2790 2803 2816 2827 2838 2852 2865 2876 2887 2898 2912 2924
  2934 2945 2957 2969 2982 2992 3005 3016 3028 3040 3053 3065 3075 3091
  3103 3115 3128 3138 3151 3164 3176 3189 3201 3214 3226 3237 3251 3262
  3276 3285 3299 3313 3322 3337 3350 3360 3373 3385 3398 3410 3423 3435
  3445 3460 3472 3484 3496 3509 3520 3531 3544 3557 3569 3581 3593 3604
  3615 3628 3640 3653 3664 3674 3687 3700 3714 3725 3739 3751 3763 3773
  3787 3797 3810 3821 3834 3847 3859 3871 3883 3897 3909 3921 3935 3946
  3959 3970 3982 3994 4007 4019 4031 4044 4057 4069 4078 4091 4101 4116
  4127 4142 4154 4166 4176 4190 4202 4215 4227 4240 4252 4265 4277 4288
  4301 4313 4326 4337 4351 4362 4373 4385 4397 4410 4422 4436 4448 4459
  4471 4484 4497 4508 4523 4535 4545 4558 4569 4582 4596 4608 4621 4633
  4645 4656 4670 4681 4695 4708 4719 4733 4744 4755 4768 4781 4794 4806
  4819 4830 4842 4856 4867 4880 4891 4902 4915 4928 4941 4954 4966 4979
  4991 5002 5016 5027 5039 5052 5065 5077 5089 5103 5115 5128 5139 5153
  5166 5177 5190 5203 5214 5225 5238 5251 5262 5274 5285 5298 5310 5323
  5336 5348 5360 5372 5386 5399 5412 5423 5437 5450 5462 5473 5488 5499
  5510 5523 5535 5547 5558 5570 5584 5596 5609 5622 5635 5646 5658 5670
  5681 5692 5706 5718 5732 5744 5756 5770 5782 5797 5810 5822 5835 5847
  5860 5872 5884 5897 5908 5921 5934 5948 5959 5971 5983 5996 6008 6020
  6033 6046 6059 6072 6085 6096 6110 6123 6134 6149 6161 6172 6187 6200
  6210 6224 6235 6248 6259 6272 6285 6299 6312 6324 6339 6352 6364 6375
  6389 6402 6414 6426 6439 6451 6463 6477 6489 6502 6513 6528 6541 6554
  6568 6580 6593 6603 6617 6632 6644 6658 6671 6682 6695 6709 6721 6734
  6747 6758 6770 6783 6795 6807 6820 6833 6845 6858 6871 6884 6895 6908
  6920 6934 6947 6960 6972 6985 6996 7011 7024 7038 7051 7063 7077 7088
  7100 7115 7127 7140 7151 7162 7176 7191 7203 7220 7230 7241 7254 7267
  7279 7294 7307 7322 7335 7347 7361 7371 7383 7395 7410 7423 7434 7450
  7461 7473 7487 7499 7510 7520 7533 7548 7559 7570 7583 7597 7610 7622
  7637 7653 7663 7673 7684 7699 7711 7723 7735 7747 7761 7774 7789 7801
  7813 7828 7838 7851 7864 7876 7888 7901 7917 7930 7941 7954 7967 7980
  7995 8008 8020 8032 8043 8054 8065 8074 8086 8099 8112 8126 8140 8153
  8164 8177 8188 8202 8211 8221 8230 8239 8249 8262 8274 8287 8301 8315
  8326 8342 8354 8366 8378 8391 8406 8419 8431 8443 8456 8471 8481 8490
  8499 8508 8519 8530 8541 8552 8566 8579 8592 8604 8616 8629 8642 8655
  8668 8680 8693 8708 8723 8734 8745 8756 8769 8780 8792 8804 8814 8829
  8842 8851);
is_deeply( \@b_calls, \@base_calls );
is( 1600, $abi->get_max_trace );
is( "M3", $abi->get_sample_name );
my $seq = "TTTTGACGCNCCTTACGCAAATCTCGNCACGAACCTTCCCCTGAAGAAATTGCCAATCTGC
 TCGAAAAACCCGTCGCAGAGGTCAAGCGCATGCTTGGACTGAATGAGCGGGTGTCCTCGGTG
 GATGTTTCTTTAGGCCCTGATTCCGATAAAACCCTGCTCGATACCCTGACAGATGATCGACCT
 ACAGATCCTTGCTAGCTGCTTCAGGACGATGACCTGTCGCAAAGTATCGATCAGTGGTTGTCT
 GAACTTACAGACAAGCAGCGTGAGGTGGTGATTCGCCGCTTCGGGTTGCGTGGTCATGAAAGC
 AGTACCCTCGAAGATGTTGGTCTGGAGATTGGTCTGACACGCGAACGTGTTCGGCAGATTCAA
 GTCGAGGGGCTCAAGCGTTTGCGCGAGATCCTTGAGCGCAACGGTTTGTCCAGTGAGTCGCTG
 TTTCAGTAACAGGCATCCTGCTCGCTAAAAAGCCCCGAAATATTCGGGGCTTTTTTGTGCCCG
 CAGAATCTGGACCGCTGCTGCCAAGGGGTTTTTTTGAGTGCGTGCGGGTGACCGGTCAGTCTC
 AAAAGTGCAGTCAGGCAGGGGTTGGAACTTTATCTGTCATGGGCTGTAAGCCTTTGCTTACCT
 TTNATGTAAGCCAAGGGCGAAAACAGGCTTGCGGATAGNTTCGCTTCTGACTTTTCATAGGTT
 GNAACTGATTGAAATTTAAACATTNTNATTGTTNTGNTAAGAN";
$seq =~ s/\n//g;
$seq =~ s/\s//g;
is( $seq, $abi->get_sequence() );

#print STDERR $abi->get_sequence_length();
is( 733, $abi->get_sequence_length() );
my @trace = qw(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 1 3 6 8 11 12 10 7 4 1 0 12 42 92 161 251 341 416 460 462 423
  349 254 163 90 38 8 0 0 0 0 0 0 0 0 1 4 8 13 20 26 34 44 56 72 90 110 128
  146 163 183 207 242 287 342 405 475 548 622 698 775 852 929 1008 1093 1187
  1294 1417 1556 1600 1600 1600 1600 1600 1600 1600 1600 1600 1565 1395 1265
  1174 1101 1020 914 775 611 439 281 159 75 25 2 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 13 73 182 339 533 739 898 976 956 843 663 455 276 138 48
  4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 23 101 236 420 642 857
  1007 1063 1022 913 784 681 633 641 678 706 694 625 507 368 248 183 197
  295 458 647 817 928 956 905 800 683 597 570 609 695 793 863 877 821 704
  548 381 235 127 54 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 1 4 6 8 10 9 7 4 2 0 0 0 0 0 0 0 0 0 0 0 0 5 59 163 314 495 691
  835 892 850 720 533 346 191 80 17 0 0 0 0 0 0 0 0 0 0 0 0 53 165 337 554
  803 1005 1112 1099 969 754 509 301 141 42 0 0 5 10 15 20 26 28 30 33 36
  41 46 51 54 53 46 35 29 46 110 243 454 729 1028 1292 1461 1491 1380 1165
  915 711 618 662 824 1048 1257 1383 1383 1251 1018 735 465 253 109 29 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2
  51 147 285 448 623 743 783 743 650 552 500 522 618 755 880 940 906
  776 579 379 209 86 17 0 0 0 0 0 0 0 57 204 438 732 1063 1342 1490
  1489 1375 1218 1102 1081 1158 1283 1377 1368 1230 992 730 537 480
  578 792 1040 1232 1299 1214 998 705 439 222 77 3 0 0 0 0 0 0 0 0 0
  0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 32 127 282 483 709 902 997 967 826 629 452 372 439 652 958
  1272 1499 1570 1462 1201 854 534 275 99 10 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 37 135 289 484 699 872 947 906 773 602 467 428
  512 696 919 1100 1172 1108 934 718 545 485 562 748 971 1145 1205
  1130 955 752 604 569 656 824 998 1099 1080 943 745 563 478 531
  713 965 1201 1339 1329 1171 903 605 349 157 42 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 12 73 182 333 510 688 805 833
  768 626 443 275 141 51 6 0 0 0 0 0 0 0 0 1 57 173 349 571
  823 1024 1126 1102 961 737 491 283 128 35 0 5 10 12 11 12
  9 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 36 159 370 652 978 1282 1460 1466 1299 1011 690 432 314 361
  548 806 1045 1190 1195 1060 824 555 325 150 42 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 43 139 284 463 663 817 884 847 715 523 336 180 70 10 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 0 0 0 0 0 0 1 2 2 1 1 0 0 0 0 0
  0 0 0 0 0 0 0 0 34 135 304 528 789 1030 1177 1196 1084 868 601 367
  182 61 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  39 145 315 531 773 976 1072 1037 885 670 465 341 344 476 693 924
  1095 1150 1070 877 621 386 196 69 6 1 6 9 10 10 10 6 2 0 0 0 0 0
  0 0 0 0 0 66 217 450 743 1077 1351 1494 1472 1294 1005 677 399 188
  57 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 4 5 6 5 4 2 1 0 0 0 1 2 3 3
  2 1 0 0 0 0 0 2 3 4 5 5 4 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 7
  10 13 15 13 10 6 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 1 1 1 1 0 0 0 0 0 0 1 2 3 3 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 1 4 8 13 17 19 17 13 9 4 2 3 6 10 15 19 20 19 14 9 5 2 0 0 0
  0 0 0 0 0 12 77 196 364 566 775 923 975 919 771 567 365 199 83 19 0
  1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 67 186 359 570
  798 968 1039 998 856 650 428 246 113 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 46 137
  269 430 609 745 806 779 673 515 342 198 92 27 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 4 50 137 265 421 590 719 776 749 647 493 327 189 87 25
  0 0 0 0 0 0 15 58 127 220 338 458 551 595 582 513 415 323 280 315 433
  608 793 931 978 913 751 536 335 198 179 292 517 791 1056 1237 1287 1197
  997 751 533 405 400 510 690 879 1014 1053 981 819 606 391 219 97 26 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 76 187 340 523
  708 837 881 831 701 520 338 190 82 20 0 0 0 0 0 0 24 84 181 307 454 586
  669 685 631 521 381 244 134 57 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 45 133 263 424 605 746 817 802 708 558 384 233 117 42 5 0 0 0 0 0 38 127
  267 447 660 846 963 984 908 755 560 362 206 95 29 0 0 0 0 0 0 0 0 0 0 23 96
  222 395 605 813 964 1023 978 839 640 424 247 115 34 0 0 2 2 2 2 2 0 0 0 0 0 0
  0 0 0 0 0 0 0 29 128 302 541 830 1119 1327 1407 1344 1153 882 587 344 163 52
  2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 29 107 236
  406 609 799 925 960 900 758 569 373 214 99 30 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32 120 265 456 685 901 1047 1094 1032 878
  668 445 260 125 41 3 0 0 0 0 0 3 65 185 365 589 846 1055 1172 1176 1067
  874 639 409 229 104 32 1 0 0 0 0 0 0 0 0 1 55 167 337 550 797 1001 1118
  1123 1017 826 593 373 201 84 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 27 89
  182 302 443 565 641 656 608 510 382 249 144 67 20 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 24 116 276 499 769 1045 1249 1341 1303 1147 910 641 397 212 88
  21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 57 172 346 566 825 1042 1174
  1195 1104 923 693 455 264 126 42 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 52 161
  327 536 780 985 1107 1122 1027 848 620 398 222 97 25 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 24 104 239 424 650 877 1044 1118 1086 957 761 541 336 182
  77 20 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10 64 163 303 473 655 793 858 841 752
  621 492 402 378 422 515 624 709 739 700 599 463 327 231 202 251 368 528 690
  817 877 858 764 618 448 286 160 73 22 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3
  37 99 190 301 424 519 566 555 488 379 257 153 72 21 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 1 2 3 3 3 2 1 0 0 0 0 0 0 0 0 8 53 135 253 401 563 694 768 770
  703 581 429 277 158 72 21 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 72 174 318
  499 691 848 939 948 875 738 565 389 235 124 53 14 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 1 2 3 3 3 2 1 0 0 2 3 4 4 4 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 2 42 117 228 365 518 637 699 691 619 508 393 311 290 340 449 591
  728 823 852 808 701 553 393 245 135 60 18 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 39 123 254 421 621 800 921 961 916 796 626 439
  272 145 61 15 0 0 0 0 0 0 33 111 235 399 597 781 911 964 930 821 660 478 306
  173 81 26 2 0 0 0 0 0 0 0 0 0 33 103 212 354 526 681 791 834 803 707 566 408
  258 143 64 19 0 0 0 0 0 0 8 56 147 278 441 621 764 843 845 775 659 532 430 381
  392 451 535 612 657 653 600 507 393 276 173 95 44 15 2 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 3 35 97 189 307 442 558 632 651 612 524 409 285 174 93 40 10
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 35 95 189 314 464 605 714 771 766 702
  593 460 325 206 116 56 21 5 2 5 8 11 15 16 17 16 15 13 10 7 5 2 1 0 0 0 0 0
  0 0 0 0 0 0 3 6 11 17 22 25 26 24 20 17 13 10 9 10 12 15 17 19 19 20 20 19
  18 16 12 8 5 1 0 0 0 0 0 0 0 0 0 0 1 2 4 6 8 9 10 10 11 10 8 6 4 1 0 0 27 87
  185 316 481 640 766 834 833 764 642 490 335 202 105 42 9 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 4 6 7 8 9 9 9 10 11 12 14 16 18 19 19 17 13
  9 5 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 1 3 3 4 4 3 1 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 38 100 190 304 434 545 619 641 608 527
  415 292 181 97 40 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 26 84 179 308
  472 631 759 832 836 774 666 539 429 364 359 414 511 622 716 767 762 701 602
  490 395 340 336 381 462 551 627 668 665 616 533 429 321 221 141 80 41 18 8 3
  2 1 1 0 0 0 0 0 0 0 0 0 0 0 0 15 48 103 179 275 372 453 503 517 490 430 348
  260 176 107 58 27 9 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 19 49 93 149 213
  270 308 323 312 280 232 179 127 83 48 25 11 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9 38 89 162 254 354 438 494 513 495 449
  388 332 297 292 317 366 424 475 504 501 465 402 320 234 154 90 45 18 4 0
  0 0 0 0 5 34 91 179 297 437 569 672 728 728 672 572 447 317 201 113 53 18
  5 5 8 11 12 11 9 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 16 54 116 196 295 389 461 499 497 458 390
  306 218 138 78 36 12 0 0 0 0 0 0 0 26 83 175 300 457 611 734 807 817 763 657 521
  376 241 138 67 24 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 42 87 147 222 294 352 386 392 371 325
  264 198 135 81 44 19 6 0 0 0 0 20 59 119 198 296 389 463 507 515 487 427 348 261
  177 106 56 24 6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 22 65 134 227 343 455 547 602 615 585 522 442 367 311 285
  290 320 363 405 431 434 411 365 303 234 167 109 63 32 13 3 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9 32 68 116 174 232 277 302 307 290
  256 210 160 110 67 36 15 3 0 0 0 0 0 0 0 9 35 81 145 228 317 395 451 474 462 417
  348 265 183 111 59 25 6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7
  37 90 169 272 389 497 578 619 616 575 509 436 374 338 333 354 391 429 454 458 434
  387 323 252 181 119 69 35 15 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 16 43 83 135 197 253 295 316 314 289 247 197
  145 98 61 35 18 8 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 2 2 1 1 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 18 54 112 190 289 388 473 530 553 539 494 431 368 318 293 298 327 370
  413 443 450 432 391 332 266 200 140 91 54 28 13 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 44 93 161
  249 339 421 482 513 511 477 417 340 257 178 111 62 29 10 1 0 0 0 0 0 7 37 91 171
  274 392 499 580 622 620 576 499 403 302 208 131 73 36 14 3 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 34 71 120 182 241 290 321 330 318 286 242 191 141
  96 60 33 16 6 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 11 34 69 118 181 244 300 341 361 360 342 313 282 259 247 249 261 280
  296 303 297 274 237 191 142 97 60 32 15 5 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 28 61 109 174 247 317 378 421 442 437 407 358 297
  232 168 114 70 39 18 7 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 4 5 4 4 2 1 0 0 0 0 4
  17 38 69 112 163 216 268 312 342 354 346 320 278 227 174 123 79 46 23 9 2 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 10 35 74 127 198 273 341 395 428 437 420 382 328 266 201 141 90 51 25 9 1 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 23 47 77 113 146 169 182 183 178 168 160 161 172
  195 228 266 301 328 341 336 315 281 239 193 150 111 78 51 31 17 7 2 0 6 23 54 98
  159 228 298 359 402 422 415 385 336 278 216 160 111 73 43 23 11 4 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 11 28 55 92 138 185 228 261 279 281
  264 232 191 145 101 62 34 15 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 24 52 88 134 178 216 242 254
  253 245 234 227 231 247 276 314 354 390 414 421 411 387 356 327 309 306 323 355 396
  436 466 480 474 452 419 385 357 343 345 362 388 416 438 448 442 422 394 366 347 344
  361 395 439 483 516 529 517 479 421 350 276 207 148 102 68 42 25 13 5 1 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 14 30 53 86 123 160 194 221 237 242 237 227 216
  209 210 220 237 257 276 290 295 292 281 267 253 243 240 245 255 266 274 276 267 248
  220 186 148 112 79 51 30 15 6 2 4 12 27 49 79 115 154 190 219 238 244 235 216 187
  155 122 91 64 41 24 12 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 5 7 9 11 11 11 9 6 4 2 0 0 1 3 5 8 9 9 8
  6 5 4 4 5 5 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 7 24 49 83 125 166 199 221 230 225 209 184 154 123 94 67 46 29 16
  8 3 0 0 0 2 12 30 58 96 141 185 225 255 271 277 273 265 260 261 271 288 309
  328 340 340 327 302 267 225 182 141 104 73 49 29 16 8 2 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 4 4 3 2
  1 0 0 0 0 0 0 0 0 8 22 44 75 116 159 201 237 264 279 279 265 241 207 170
  132 98 68 43 25 13 6 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1
  1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 11 29 55
  91 133 175 214 245 264 272 270 260 247 234 226 225 232 245 261 277 289
  292 286 269 244 212 177 140 107 76 50 30 17 8 4 4 6 8 9 9 9 10 11 13
  16 19 20 20 17 13 9 5 2 0 0 0 1 2 5 7 9 10 8 6 4 2 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 8
  19 36 60 87 116 144 168 186 195 196 188 173 152 127 101 74 49 29 15
  4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 12 27 47 74 105 138 170 201 227 246
  256 255 244 224 196 166 134 105 80 59 43 31 22 14 8 4 1 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 6 13 26 45 68 96 125 154 180 200 209 209 198
  178 152 123 95 68 46 28 15 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 15 33 58 92
  130 168 202 230 250 260 263 260 253 247 244 244 249 256 264 271 274 272 264 252
  236 221 210 203 201 205 210 216 221 222 219 213 205 196 188 184 184 187 193 199
  203 202 196 183 165 142 118 94 72 51 33 20 11 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 3 11 21 30 38 40 35 26 16 7 1 0 0 0 0 0 0 0 0 0 5 14 28 47 71 96 118 136
  147 151 147 136 120 103 84 66 51 37 25 15 9 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 4 13 26 45 67 90 111 128 140 148 149 144 134 118 99 77 55 35 20
  10 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 8 17 31 49 69 89
  105 117 122 122 116 105 90 74 58 42 27 16 8 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 13 27 47 73 101 128 152
  171 183 189 191 190 190 190 194 201 209 219 226 229 226 216 199 176 152 126 101 79
  61 44 29 18 10 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 3 12 26 46 72 100 127 150 166 176 178 173 161 144 124 102 79 58 40 25
  14 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 5 9 12 13 12 9 5 2 0 0 0 0 0 3 10 21 36 56 78 100 121
  140 153 160 161 155 142 125 106 84 63 44 27 15 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 6
  12 21 34 50 68 86 103 119 131 141 149 155 160 165 170 175 180 185 187 189 186 180
  169 155 137 118 99 82 66 53 42 34 27 21 16 11 7 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 18 34 54 80 104 126 142 152 154 149 137 121 102 83
  62 44 27 15 6 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 9 19 33 51 73 95 117
  138 158 173 182 184 180 170 155 138 119 101 83 65 48 31 18 9 3 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 10 18 29 42 52 59 65 70 76 84 95 107 121 136 149 160 169
  175 178 178 174 166 156 143 128 113 97 80 62 44 28 16 6 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 1 6 14 25 40 58 77 96 116 134 149 159 165 165 162 156 151 147 145
  145 148 151 154 155 152 146 136 122 106 88 72 55 41 27 17 9 4 1 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1
  5 12 25 44 68 94 120 143 162 178 188 195 197 196 193 189 184 181 179 180 181 182 182
  180 176 170 163 154 148 143 142 143 148 155 163 171 178 182 185 184 181 176 172 168
  167 167 167 168 165 160 152 140 126 111 96 81 67 55 44 35 29 26 26 30 38 51 66 84 103
  122 139 153 162 164 160 150 136 118 99 82 66 52 41 32 25 19 14 11 9 8 6 5 4 2 1 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 7 14 22 31 40 49 56 64 69 74 76 76 72 65 55 43
  31 20 11 5 2 0 0 0 2 5 11 18 28 39 50 60 69 76 79 78 74 67 57 47 37 29 21 14 9
  5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6
  15 26 36 45 46 39 28 18 8 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 2 2 1 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 8 17 29 45 61 77 91 104 115
  124 128 130 126 119 108 93 77 59 43 28 17 9 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 6 10 12 13 11 8 5 1 0 0 0 0 0 1 6 14
  25 41 59 79 100 119 138 152 162 165 162 153 139 123 105 87 72 59 49 41 37
  35 35 36 39 42 47 54 63 73 82 91 97 101 100 95 87 77 64 51 41 33 28 25 24
  23 21 18 14 9 6 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2
  5 10 16 25 33 42 50 58 66 74 82 90 100 110 120 131 140 148 153 158 159
  159 158 153 147 139 130 119 107 93 78 61 44 28 16 7 2 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 9 17 27 39 49 57 62 65 64 61
  58 52 44 35 24 15 8 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
  0 0 0 0 0 0 5 12 23 37 55 73 89 103 113 118 121 122 123 125 129 134 137
  138 135 131 123 116 110 106 102 100 96 89 78 64 47 31 18 8 2 0 0 0 0 0
  0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 10 20 32 46 59 70 77 82 87 92
  99 108 120 134 150 165 178 189 197 199 198 194 187 180 173 168 163 161
  159 159 158 157 154 150 143 136 126 116 106 97 87 79 69 60 50 42 36
  34 36 42 52 63 77 90 102 112 120 124 125 123 117 108 98 85 72 58 46
  34 23 14 8 3 1 0 0 0 0 0 0 0 0 0 0 0 3 8 13 19 24 26 25 20 14 8 4 0
  0 0 0 0 0 0 0 0 2 5 10 15 20 24 24 23 18 13 8 4 2 0 0 0 0 0 2 5 9 16
  25 36 50 63 77 89 99 107 112 114 114 111 103 93 80 66 52 39 27 18 11
  6 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 4 6 7 7 6 4 
  2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 9 15 22 30 36 40 42 40 36 29 20 12 6 1 0 0 0 
  0 0 0 0 0 0 0 0 1 3 6 9 12 14 14 12 9 6 3 1 0 0 0 0 0 1 1 1 1 0 0 0 2 7 13 19 
  27 32 36 39 42 47 54 62 72 82 91 100 107 113 119 124 129 135 141 149 156 162 
  166 168 167 163 157 148 138 126 114 104 94 87 81 77 72 67 60 53 45 38 32 29 
  29 31 35 40 45 51 56 59 59 48 37 26 14 2 0 72 275 433
);
my @array = $abi->get_trace("A");
is_deeply(\@trace, \@array);

@array = $abi->get_trace("G");


@trace = qw(
0 0 0 0 0 0 0 7 22 46 78 120 161 196 219 232 235 236 240 254 277 305 331 347 344 324 292 258 229 215 217 229 243 250 242 218 181 137 92 55 28 11 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
8 42 103 194 313 444 560 638 664 632 551 438 315 205 120 68 46 48 64 88 116 145 175 206 239 273 310 350 395 446 501 560 616 670 720 769 822 888 968 1063 1163 1254 1317 1338 1305 1222 1097 950 800 664 551 462 392 334 282 233 188 154 137 145 
181 241 317 393 451 478 465 412 331 237 149 81 34 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 28 83 167 275 401 506 568 573 521 424 303 191 102 41 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 1 1 1 1 0 0 0 0 0 0 0 0 0 29 99 214 369 555 727 845 882 831 703 528 346 198 91 26 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 1 3 4 5 5 5 4 2 1 0 0 0 
0 6 49 132 256 413 586 727 803 797 711 569 401 247 129 56 28 32 51 73 94 109 120 127 134 139 144 147 149 151 153 154 155 155 154 152 149 145 141 134 126 115 102 86 70 53 37 24 14 7 2 0 0 0 0 0 0 0 0 0 
0 0 0 13 61 144 260 401 540 637 667 624 516 371 235 123 46 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 74 232 473 775 1118 1391 1527 1493 1298 993 661 380 171 46 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 66 212 439 724 1050 1316 1453 1426 1246 956 638 368 166 44 0 0 0 
0 0 0 0 1 1 2 3 4 3 3 3 3 4 3 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 1 2 2 3 4 3 2 2 1 0 0 0 0 0 0 0 0 18 137 359 676 1059 1460 1600 1600 1600 1455 1061 678 364 
145 27 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 25 138 347 649 1021 1409 1600 1600 1600 1478 1099 716 396 166 36 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 
55 154 301 484 685 836 902 865 732 536 346 185 71 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9 82 224 428 677 941 1134 1204 1135 943 677 428 221 79 7 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 18 87 206 369 560 744 862 882 802 641 442 267 129 40 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 22 90 203 351 522 677 768 771 688 540 367 218 103 31 0 0 0 0 0 0 0 0 
41 154 340 585 868 1117 1252 1230 1051 770 498 256 124 209 497 883 1335 1600 1600 1600 1600 1579 1119 697 360 133 17 0 1 3 3 3 4 5 6 9 13 16 18 18 16 13 10 6 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 7 83 235 456 724 1016 1233 1322 1262 1070 795 516 285 120 27 0 0 0 0 0 0 0 0 0 0 0 43 139 291 483 703 883 977 959 834 633 420 237 102 23 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 29 157 381 689 1049 1403 1600 1600 1544 1252 882 545 277 99 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
49 186 407 689 1005 1273 1403 1359 1158 861 559 341 268 352 556 810 1031 1153 1143 1006 780 523 307 144 43 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 72 241 501 
826 1192 1490 1600 1594 1381 1050 695 397 177 47 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 90 256 506 820 1174 1458 1600 1587 1400 1094 740 440 209 64 0 0 0 0 0 0 
0 0 52 161 328 538 778 971 1071 1053 923 715 480 280 130 38 0 0 0 0 0 0 0 0 0 0 0 54 168 343 561 806 993 1072 1023 863 646 450 346 376 536 779 1026 1200 1245 1145 929 662 421 267 236 323 486 667 805 859 814 684 504 324 
178 76 18 0 0 0 0 0 0 0 0 13 91 240 458 730 1025 1255 1368 1336 1168 906 608 359 169 52 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 29 100 213 355 514 641 695 661 552 404 272 208 243 380 586 809 986 1071 1040 903 695 463 271 127 38 0 0 0 0 0 0 0 0 2 55 170 349 583 856 1088 
1219 1215 1072 832 563 352 266 338 556 860 1168 1395 1481 1405 1191 892 582 329 147 41 0 2 5 6 6 8 6 4 2 1 1 2 2 2 2 2 1 0 0 35 148 339 592 889 1168 1345 1377 1260 1025 731 455 238 92 16 0 0 0 0 0 0 
0 0 1 2 3 3 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 1 2 2 1 1 0 0 0 0 0 0 0 0 0 23 96 217 382 574 754 866 878 786 611 417 242 121 124 261 490 768 1063 1285 1384 1338 1164 904 617 369 184 66 10 0 1 1 1 1 1 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 12 70 178 337 536 751 923 1014 1004 896 714 503 310 162 63 12 0 0 0 0 0 0 0 1 2 2 3 3 3 3 2 1 
1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 21 77 162 271 395 501 559 557 496 393 273 166 84 30 4 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 83 207 379 587 804 962 1028 987 853 656 442 261 126 43 4 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 44 119 230 369 523 648 717 713 640 514 364 226 118 47 9 0 0 0 0 0 0 0 0 1 2 2 2 2 2 1 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 23 
85 190 336 514 689 819 876 848 743 584 405 247 127 49 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 25 96 211 365 548 721 836 871 819 694 526 349 203 97 32 2 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 63 170 326 518 729 893 975 957 846 670 469 287 149 59 12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 8 55 142 265 412 566 679 723 691 592 450 297 172 80 24 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 61 136 235 352 462 536 557 523 442 333 219 126 59 18 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 6 9 12 14 14 13 11 9 8 8 11 13 14 12 10 
7 3 0 7 60 166 322 521 744 929 1037 1047 956 789 582 377 213 99 31 2 1 1 1 1 1 0 0 0 0 0 1 2 4 5 6 6 4 3 1 0 0 0 0 0 0 0 0 0 0 27 103 233 413 636 860 1031 1112 1086 960 763 
537 331 174 70 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 73 182 336 527 731 890 971 958 856 689 493 310 168 72 18 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 46 116 216 340 472 574 620 600 516 388 257 147 105 152 294 501 753 993 1174 1257 1228 1095 886 643 
411 230 104 31 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 33 92 178 285 404 498 546 541 484 390 279 175 95 40 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
9 53 133 246 383 528 638 692 679 604 486 349 220 121 53 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 44 136 275 451 659 836 944 963 892 747 562 372 216 105 36 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 21 66 134 221 322 409 463 472 437 367 276 182 106 51 17 2 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 28 104 229 395 595 786 921 974 935 817 645 454 281 151 64 16 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 57 123 211 313 409 473 495 469 405 317 223 138 75 33 10 0 0 0 0 0 0 0 0 
1 1 2 2 3 3 4 5 6 6 6 5 4 4 3 4 4 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 2 27 79 157 259 378 482 550 570 537 460 356 245 148 76 31 7 0 2 2 2 2 2 1 0 0 24 
91 204 360 553 745 891 960 938 832 669 489 336 245 235 302 424 565 690 765 774 715 603 461 315 189 98 40 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 26 97 216 377 573 767 913 983 965 867 709 
524 345 200 98 36 6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 62 146 263 409 560 682 750 751 689 576 437 296 177 91 36 8 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9 40 95 173 271 376 463 514 520 481 405 309 210 125 64 25 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 23 72 147 244 359 461 530 551 523 453 355 249 153 82 34 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 36 
89 162 252 347 420 458 453 409 336 247 161 92 43 14 1 0 0 0 0 0 0 0 0 0 20 63 132 225 339 447 527 566 555 499 407 300 195 112 53 18 2 0 0 0 0 0 0 0 23 77 164 280 423 560 664 715 706 638 528 396 
265 156 79 30 6 0 0 0 0 0 0 18 84 204 378 603 849 1061 1197 1232 1157 991 774 554 384 301 323 444 636 854 1050 1182 1221 1160 1014 812 590 385 220 108 41 11 3 3 3 3 2 0 0 9 50 127 241 390 560 711 815 853 820 724 
593 459 356 307 323 397 508 627 724 775 770 708 602 470 335 214 121 58 21 4 0 0 0 0 0 0 0 11 50 118 217 342 477 590 661 676 635 548 432 310 199 113 55 22 6 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 23 62 117 186 264 329 371 382 360 313 248 179 114 64 30 10 1 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 11 44 98 173 264 356 428 467 467 429 362 279 194 120 65 29 9 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 13 41 85 144 214 278 321 336 320 280 230 190 175 199 260 350 449 535 587 595 554 477 383 294 230 206 224 278 350 421 472 492 473 420 344 259 176 107 58 28 12 6 5 5 4 3 1 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 9 48 117 216 344 485 607 687 713 681 598 482 355 236 138 70 29 8 0 0 0 0 0 0 0 9 38 86 153 238 328 402 449 460 433 376 299 217 142 82 41 17 5 1 0 0 0 0 0 13 50 115 
208 326 450 554 618 632 595 520 428 346 295 289 328 400 484 556 598 597 552 473 373 270 178 106 56 27 12 6 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 2 26 72 142 231 337 432 499 527 512 459 378 286 196 120 65 29 10 3 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 20 61 128 
219 335 452 550 614 633 603 532 433 322 218 132 70 31 12 4 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 8 30 69 125 196 270 333 373 385 365 320 256 187 123 71 35 13 3 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 8 29 63 107 161 210 245 259 250 220 178 129 82 46 21 6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 46 98 166 251 332 395 427 425 389 329 254 178 112 
62 28 9 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 28 73 140 228 329 421 489 521 512 465 390 300 209 131 72 33 12 4 3 4 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 1 
20 59 119 198 292 380 444 476 470 430 369 303 250 222 227 263 320 383 436 465 464 432 373 299 221 148 88 46 20 6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 9 38 88 160 253 354 441 500 522 505 457 392 332 292 282 305 353 413 467 500 503 471 412 333 249 170 105 57 27 10 2 0 0 0 0 1 15 46 92 154 230 303 361 396 403 381 335 274 207 143 89 49 23 8 1 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 51 119 215 341 477 597 680 714 694 628 532 429 340 282 261 274 310 354 392 408 399 364 310 244 179 121 74 42 22 11 5 3 
2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9 37 85 151 235 323 397 444 458 437 387 316 239 165 102 57 28 12 5 3 2 2 1 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 30 67 117 179 243 296 328 336 320 282 230 173 117 71 38 16 4 0 0 0 0 0 0 0 3 17 42 80 126 179 
225 257 270 263 237 199 154 110 70 40 19 7 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 36 77 132 202 272 330 368 379 364 325 270 208 148 95 55 28 
11 3 0 0 0 0 0 2 18 49 95 156 227 293 342 366 363 334 285 224 164 110 67 37 18 8 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 22 
49 85 130 174 209 230 234 223 203 181 168 170 191 230 281 335 381 409 413 391 346 285 218 153 98 56 28 11 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 22 51 92 146 205 258 298 318 316 294 254 203 149 101 
61 33 15 5 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 9 32 72 125 193 263 324 364 379 368 333 280 219 157 101 58 29 11 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 19 43 75 115 156 188 207 209 194 167 
131 94 59 33 15 4 0 0 0 0 0 7 26 60 110 174 245 310 359 384 381 353 308 260 222 208 227 278 353 439 516 569 585 562 504 426 345 279 240 237 268 321 383 438 471 474 447 395 332 273 234 222 244 293 361 432 491 527 530 501 
443 367 282 201 130 75 38 16 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 3 22 57 109 178 259 336 400 440 451 433 390 330 261 193 133 84 48 25 11 3 1 0 0 0 0 0 2 15 38 73 120 175 227 270 295 301 286 254 208 158 109 68 37 17 5 1 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 17 49 101 170 255 338 406 448 459 439 391 326 253 183 120 72 38 17 6 1 0 0 0 0 1 8 22 45 74 112 150 183 207 219 217 200 174 141 105 72 45 25 
12 4 1 0 0 0 0 0 5 21 48 85 133 184 228 259 271 263 239 203 161 119 83 52 30 16 7 2 0 0 4 22 57 111 183 270 355 428 478 497 484 443 379 304 229 160 105 64 36 19 9 4 1 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 23 
57 105 167 239 305 356 384 387 365 323 269 210 153 104 64 35 17 6 1 0 0 2 10 27 53 89 134 180 221 252 265 261 241 208 168 126 88 56 32 16 7 2 0 0 0 0 0 0 0 7 26 58 102 158 217 269 305 322 317 292 
252 204 153 107 69 40 20 9 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 22 48 85 132 181 223 253 266 261 242 217 
192 178 180 200 235 280 325 362 382 382 362 324 274 219 165 116 76 46 25 12 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 15 42 83 139 207 276 335 378 399 
394 365 319 262 202 146 99 64 40 24 15 10 6 4 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9 28 57 97 146 195 238 269 283 
282 265 236 197 156 116 81 51 30 15 6 2 0 0 0 0 2 14 39 77 129 193 257 313 353 372 368 342 299 246 191 139 95 61 35 18 8 3 0 0 2 15 41 83 141 214 292 365 421 454 458 434 388 326 258 193 136 92 59 39 
26 19 14 11 8 5 3 1 0 0 1 2 2 2 2 1 0 0 0 0 0 8 23 46 76 114 150 180 200 207 201 184 159 128 98 70 47 30 18 11 6 4 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 5 19 44 
80 128 182 236 282 313 326 319 293 253 204 154 107 68 39 20 8 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 2 11 27 51 83 119 155 185 205 214 208 192 168 139 109 81 59 41 27 17 10 6 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 8 21 42 73 111 153 192 223 244 249 241 223 202 185 179 188 215 257 308 359 402 428 432 413 375 321 261 200 144 99 64 40 25 15 9 5 3 1 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 4 16 38 70 115 168 225 277 319 345 350 335 301 255 203 151 106 69 41 22 10 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 11 28 53 88 128 
169 204 229 239 235 217 189 155 120 89 63 42 27 16 9 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 17 41 77 125 181 236 285 321 341 342 325 294 252 205 158 116 82 55 35 21 12 6 2 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 11 24 44 69 96 121 141 154 157 151 137 119 97 74 53 35 20 10 4 1 0 0 0 0 0 
0 0 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 10 22 40 63 88 112 131 145 152 154 150 145 141 142 150 166 186 209 228 241 244 236 221 202 183 169 164 167 177 192 205 215 218 214 203 
190 177 169 171 185 210 244 282 315 339 347 338 312 275 229 182 138 100 69 46 28 16 8 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 17 39 70 114 166 220 271 312 339 347 337 310 272 227 180 138 
101 72 49 33 20 11 5 3 5 16 34 61 96 138 180 220 252 273 281 274 254 224 188 148 111 77 51 31 17 8 3 1 0 0 0 0 0 0 1 2 2 2 2 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
3 13 31 55 85 117 146 166 178 177 167 150 129 105 85 67 52 40 30 21 13 7 3 1 0 0 0 0 0 0 0 0 0 1 5 14 29 49 73 100 124 144 157 161 156 144 126 104 81 60 42 27 16 9 4 2 1 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 14 32 58 93 134 175 212 241 261 
268 265 252 234 217 202 194 196 205 218 232 241 242 234 215 188 157 124 94 68 47 33 23 16 11 7 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 11 27 50 82 120 
158 192 220 236 240 233 216 191 162 132 102 75 51 33 19 10 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 12 28 51 82 118 154 186 211 226 230 222 204 179 150 119 92 67 48 33 22 15 10 6 3 1 0 0 
0 0 0 0 0 0 0 0 0 0 0 7 20 40 69 107 148 186 220 243 255 254 240 217 188 155 122 91 65 44 28 17 9 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 3 11 26 48 77 110 141 167 186 196 197 192 185 180 181 192 215 249 291 335 375 404 417 413 392 359 320 281 249 228 219 222 233 247 259 265 262 251 231 210 191 180 180 192 214 243 273 298 314 317 
307 283 249 208 167 127 93 64 42 25 14 6 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 20 41 71 109 151 191 226 250 261 259 243 216 183 146 110 78 51 30 16 7 2 1 5 14 28 49 
76 108 142 174 199 218 226 223 209 187 159 127 96 67 41 23 11 3 0 0 0 0 0 6 19 38 65 101 139 176 206 227 236 232 216 192 161 128 96 68 43 25 13 5 1 0 0 0 0 0 5 15 29 48 70 91 107 116 119 114 
104 90 75 59 45 31 19 11 5 1 0 0 0 2 9 20 36 58 84 110 136 158 173 180 179 169 149 126 99 72 48 28 15 6 2 0 0 0 0 0 3 11 24 41 64 89 112 132 146 153 154 150 144 138 136 141 152 170 191 212 
228 238 237 228 210 189 168 149 137 131 131 134 139 141 140 135 123 107 89 68 47 30 16 7 2 0 0 0 0 0 0 2 10 25 47 75 109 141 168 187 197 197 188 172 150 125 99 74 50 31 17 8 2 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 11 24 42 66 92 115 135 150 160 163 162 158 153 149 148 150 156 163 170 175 176 172 162 147 127 105 82 61 41 26 14 7 2 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 9 19 33 52 72 91 107 119 125 124 118 108 95 80 64 48 33 20 11 4 1 0 0 1 3 5 6 7 7 5 3 1 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 6 15 29 50 74 101 128 153 174 188 195 193 183 167 145 121 97 74 53 35 21 11 4 1 0 0 0 3 10 22 39 62 87 113 136 154 165 168 163 150 133 112 90 
68 49 32 19 10 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 10 19 30 43 56 67 76 82 84 83 79 71 61 50 38 26 16 8 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 1 5 13 26 43 64 85 104 120 131 138 140 140 139 138 140 145 155 168 184 201 215 224 225 220 207 188 165 139 112 88 67 49 36 26 19 13 8 4 2 0 0 0 0 0 0 0 0 0 
0 1 3 8 16 26 39 53 67 80 92 102 108 112 113 114 115 119 126 137 151 169 186 203 216 223 224 220 214 206 200 197 198 201 206 209 211 208 200 187 173 157 144 135 131 134 141 153 167 181 192 197 197 190 178 161 142 122 103 85 
69 54 41 29 19 11 5 1 0 0 0 0 0 1 1 1 1 0 0 0 1 6 15 30 51 77 106 136 163 187 207 219 225 226 221 212 203 195 189 186 186 186 186 183 178 169 155 139 121 101 82 66 49 36 25 17 11 6 3 1 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 10 21 36 57 81 104 
125 143 157 164 166 161 153 140 124 108 91 75 61 48 35 24 15 8 3 1 0 1 3 5 6 6 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 6 14 26 42 
62 84 107 130 152 172 187 199 205 207 204 200 195 191 191 194 199 206 211 213 211 205 195 184 171 161 151 146 142 142 145 149 153 157 159 157 152 142 129 113 94 76 58 41 28 18 10 5 2 1 0 0 0 0 0 0 0 0 0 0 
0 0 0 1 5 11 22 38 57 79 102 124 145 161 172 178 179 175 165 152 133 113 91 71 51 35 22 14 9 7 7 8 8 8 6 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 11 22 37 56 79 101 
121 139 152 158 157 150 139 125 108 93 79 65 52 40 29 20 12 6 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 1 5 12 24 40 60 80 101 120 136 147 153 155 151 141 128 113 95 77 60 43 30 20 13 8 6 5 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 4 6 6 5 4 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 8 20 38 60 87 114 139 
159 174 182 184 178 168 154 137 119 100 82 63 46 30 18 10 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 9 20 33 50 69 88 104 117 126 131 131 126 117 104 89 74 
57 42 30 18 10 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 5 10 18 28 40 54 69 83 96 109 118 125 130 135 138 144 
151 160 173 187 202 217 229 236 238 234 224 212 198 183 170 160 153 150 149 149 148 146 142 135 126 116 103 90 76 62 48 35 23 14 7 3 0 0 1 3 9 17 26 39 51 63 73 82 88 92 92 90 85 79 70 61 51 42 32 24 
18 12 7 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 1 4 9 17 29 44 60 77 93 106 116 123 127 129 130 131 135 141 149 158 169 179 186 191 191 186 176 163 145 127 108 90 72 57 44 33 24 16 10 5 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 1 4 9 18 31 47 65 84 100 114 123 129 132 132 128 122 113 101 86 71 55 40 27 17 10 5 4 6 11 18 26 36 47 58 68 78 87 94 98 100 101 101 103 106 112 121 132 144 155 164 
169 168 163 151 136 118 99 80 63 50 39 31 25 21 17 12 8 5 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 6 13 24 37 52 67 83 99 115 130 143 153 159 160 156 148 136 122 105 88 
71 56 43 33 25 20 16 13 10 7 5 3 1 1 1 2 3 5 5 6 5 4 3 2 1 0 0 0 0 0 0 1 4 7 13 19 27 38 51 64 80 98 114 130 144 154 160 160 155 146 135 121 107 93 79 66 53 42 32 23 
18 14 12 10 8 6 4 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 6 7 9 8 6 4 2 1 0 0 0 0 0 0 0 0 0 0 0 1 3 7 13 19 28 38 51 64 
79 95 110 120 127 129 126 120 111 99 87 75 62 52 43 34 26 19 13 7 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 2 5 10 14 18 20 20 18 14 10 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 7 14 23 35 48 
62 75 88 99 110 119 126 131 135 138 139 141 143 145 149 155 162 170 177 182 185 184 178 169 156 141 124 108 92 79 67 58 49 43 36 30 24 18 13 8 5 2 1 0 0 0 0 0 3 8 15 23 35 48 61 74 88 101 112 122 
130 135 138 138 135 129 121 111 98 85 72 59 48 37 29 23 18 14 12 9 8 6 5 4 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 1 2 4 8 12 18 26 38 51 65 79 92 105 115 123 129 132 132 128 120 110 96 80 65 54 44 37 32 28 23 18 12 7 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 5 9 16 
23 33 44 56 68 81 93 105 114 122 127 131 130 127 121 113 102 90 76 61 47 34 22 13 7 4 4 4 6 6 7 6 4 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 1 2 3 4 5 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 4 3 2 1 0 0 0 0 1 2 3 4 4 4 4 4 4 4 4 4 3 2 1 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 5 7 9 11 11 13 14 14 14 14 13 11 11 9 7 6 5 
3 2 1 0 0 1 3 5 8 10 13 14 14 12 10 6 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 4 7 9 13 19 26 35 46 60 
74 89 103 118 131 142 152 158 160 158 151 140 127 113 97 82 68 56 44 35 26 20 14 10 6 4 2 1 0 1 3 5 8 10 12 12 10 8 5 3 1 0 0 2 6 11 17 23 27 29 31 29 27 25 23 21 20 20 22 25 
31 39 48 59 71 83 93 102 108 112 113 112 110 105 98 89 78 66 53 41 31 22 16 12 10 9 8 7 6 5 3 2 1 2 2 3 4 5 5 5 5 5 5 5 4 3 2 1 0 0 0 0 0 0 0 2 6 10 17 25 
34 42 50 57 64 69 73 76 77 76 73 69 65 60 54 47 39 31 22 15 11 10 12 16 19 16 14 10 4 0 31 104 162
);

is_deeply(\@trace,\@array);

@array = $abi->get_trace("C");



@trace = qw(

631 581 509 451 386 324 273 239 224 224 234 252 271 290 308 323 335 344 347 345 337 324 306 284 259 232 203 173 143 112 81 53 31 15 4 8 29 65 115 177 238 285 308 299 262 202 136 80 37 9 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 2 19 50 94 146 201 238 247 226 176 122 72 31 5 0 17 71 161 285 434 580 684 722 684 579 430 281 157 66 13 0 0 0 0 0 0 0 10 67 172 322 507 708 866 949 941 845 685 494 312 171 74 19 
4 16 34 59 98 151 223 331 499 757 1129 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1417 843 435 179 48 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 50 165 341 562 820 1057 1240 1360 1421 1428 1381 1273 1102 877 622 390 206 81 15 0 0 0 0 0 0 1 58 178 368 618 914 1177 1350 1395 1302 1094 817 533 304 138 40 0 7 17 27 36 44 45 40 34 28 25 24 23 22 19 14 
9 5 1 0 0 3 6 8 10 10 8 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 84 230 440 696 975 1184 1277 1233 1063 806 535 308 138 36 0 0 0 0 0 0 0 0 0 27 99 210 350 505 633 691 665 561 
406 260 135 47 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 55 189 394 651 940 1176 1288 1252 1075 802 526 291 120 22 0 24 114 274 498 775 1061 1273 1365 1313 1129 855 
566 324 144 37 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 10 26 49 80 120 167 223 292 371 457 540 613 682 760 877 1065 1354 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1504 1147 984 1018 1211 1480 1600 1600 1600 1600 1320 919 564 286 
101 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 29 98 202 323 449 532 540 473 357 244 197 257 438 709 1001 1232 1336 1285 1101 851 621 479 457 539 667 772 799 733 598 447 343 332 421 583 764 902 949 888 
732 521 326 167 59 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 2 6 9 11 12 10 7 4 4 6 9 11 11 10 7 4 6 14 26 38 49 52 47 36 24 12 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 87 214 392 
607 823 971 1012 931 743 519 313 146 36 87 265 527 845 1203 1472 1586 1521 1295 966 629 349 147 33 0 0 0 0 0 0 1 10 24 40 56 70 73 64 48 32 17 5 0 0 0 0 0 0 0 0 0 46 165 354 593 862 1088 1200 1172 1011 
761 500 279 118 25 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 41 128 259 423 611 761 836 821 719 557 374 219 103 31 0 0 0 0 0 0 0 0 0 0 46 151 312 512 737 914 993 954 808 591 381 203 
78 10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 2 2 2 1 0 0 2 6 11 15 17 16 12 8 3 0 1 4 8 11 13 12 10 6 2 0 3 7 9 9 9 7 4 1 0 0 0 0 0 0 72 237 
498 831 1218 1544 1600 1600 1496 1137 762 432 182 137 316 627 996 1396 1600 1600 1600 1317 927 571 349 316 466 737 1031 1251 1331 1249 1028 730 456 233 82 7 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 22 98 223 386 
570 735 822 810 702 528 347 193 79 15 0 0 0 0 0 0 0 50 148 293 466 656 793 842 791 655 468 295 152 54 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 
4 4 4 3 2 0 0 1 3 7 11 15 18 19 21 25 31 43 57 74 91 105 115 119 118 113 107 101 94 84 67 50 33 17 29 96 220 391 596 791 922 956 883 723 517 323 168 64 11 7 12 13 12 14 9 3 0 0 0 1 
1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 11 105 282 534 836 1157 1385 1467 1385 1161 851 547 297 122 25 0 0 0 0 0 0 0 0 59 212 462 794 1183 1535 1600 1600 1600 1299 905 554 277 95 7 10 28 47 64 80 84 
74 56 37 21 9 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32 156 378 689 1070 1456 1600 1600 1600 1486 1113 726 409 180 48 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 66 240 523 895 1331 1600 1600 1600 1600 1486 1063 665 352 141 29 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 2 3 3 3 3 1 0 0 1 9 20 35 50 62 65 59 45 30 16 6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 10 18 25 31 32 27 
20 12 5 1 0 0 0 0 0 0 0 0 64 216 455 760 1111 1408 1573 1567 1395 1101 755 454 223 75 5 0 1 2 2 3 4 4 4 3 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 6 9 13 15 14 
11 8 4 1 0 0 0 1 2 2 2 2 1 0 0 0 2 7 12 17 22 22 18 14 8 4 0 0 0 0 0 0 13 57 132 236 360 478 552 557 489 366 245 136 126 244 493 805 1155 1439 1589 1568 1387 1092 755 456 231 85 14 0 
0 0 0 0 0 0 8 45 114 210 326 446 532 565 535 453 338 219 123 53 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 9 20 34 49 60 64 61 50 35 21 11 3 0 0 0 0 0 0 0 0 0 0 0 0 2 5 9 11 12 11 9 5 2 0 0 0 0 2 3 4 
3 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 29 89 177 286 407 501 544 529 461 358 245 146 73 27 4 0 0 0 0 0 1 1 2 2 1 0 0 0 0 0 0 1 2 2 2 2 1 
0 0 0 0 0 0 0 0 0 0 2 6 10 14 17 18 15 10 6 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 59 163 312 492 685 826 880 831 692 494 314 161 77 113 272 487 740 988 1149 
1186 1092 902 677 490 398 429 567 764 953 1073 1087 990 809 585 370 203 89 24 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 9 17 27 37 42 41 33 23 14 6 1 0 0 2 4 5 
5 5 4 2 0 0 0 0 0 0 0 0 4 46 125 235 365 499 587 603 544 432 305 212 197 283 460 693 926 1100 1171 1121 966 743 500 296 144 50 5 0 0 0 0 0 0 0 0 0 0 0 2 6 13 20 28 31 30 24 17 10 
4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 4 4 4 3 1 0 0 0 2 6 10 14 15 13 10 6 3 0 0 0 0 0 0 0 0 35 126 282 498 767 1027 1220 1298 1238 1052 
783 513 285 148 151 290 511 771 1020 1184 1223 1131 935 690 462 308 263 329 479 660 818 909 909 821 669 488 313 176 81 26 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 70 168 301 459 617 727 766 728 624 481 
330 198 102 41 10 0 0 0 0 0 0 0 0 4 40 109 211 338 479 592 653 650 582 468 331 206 108 42 8 0 0 0 0 0 0 0 0 0 0 0 0 2 9 17 28 39 47 48 43 33 22 12 4 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 49 179 393 679 1020 1339 1554 1600 1510 1263 931 603 334 176 169 306 536 807 1067 1242 1291 1203 1003 744 489 303 227 270 410 601 783 909 946 889 756 580 396 238 123 50 12 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10 92 250 487 788 1128 1411 1581 1599 1466 1213 899 584 332 154 50 9 12 18 22 24 22 16 9 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
2 8 16 25 34 39 39 34 25 16 8 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 10 18 27 35 40 41 37 29 20 12 5 1 0 0 0 0 0 0 0 32 120 265 458 687 902 
1046 1087 1019 861 647 423 243 113 34 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 35 118 252 427 635 821 938 959 877 708 495 307 153 88 142 314 545 825 1096 1291 1373 1325 1162 923 656 409 222 97 28 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 31 126 286 506 774 1038 1233 1316 1272 1112 875 611 373 195 78 19 8 17 24 28 31 26 18 10 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 5 12 21 30 38 
41 40 33 24 16 8 2 0 0 0 0 0 0 0 29 102 217 365 536 684 766 761 670 519 355 234 206 298 507 795 1104 1364 1516 1526 1397 1160 866 574 333 163 60 11 0 0 0 0 0 0 1 1 2 2 2 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 4 47 129 249 397 564 697 769 768 696 573 425 282 164 81 32 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 5 7 8 8 7 5 2 0 0 0 0 0 0 0 0 17 
80 191 346 536 731 877 946 925 822 663 483 314 178 86 32 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 35 101 198 317 453 563 624 626 570 472 353 238 141 73 33 12 4 2 2 1 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 23 72 147 241 352 444 499 505 462 382 283 187 109 58 33 28 33 38 40 34 25 16 8 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 6 67 190 377 617 896 1136 1291 1327 1241 1054 808 553 331 171 69 17 0 0 0 0 0 0 0 0 0 0 0 3 6 11 16 21 25 27 27 27 25 22 17 12 7 3 1 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 4 3 3 4 3 0 0 53 167 347 584 869 1126 1302 1361 1289 1102 842 564 332 180 145 228 409 639 881 1076 1185 1186 1084 901 678 455 268 135 52 12 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 2 3 5 5 5 3 2 0 0 0 0 0 0 0 0 28 84 167 275 400 507 575 591 553 471 362 248 150 77 31 7 0 0 0 0 0 0 3 36 97 185 295 418 516 570 571 518 427 316 206 
117 55 18 3 4 6 8 9 8 6 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 2 4 8 11 14 14 12 9 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 1 5 11 17 23 27 27 22 16 10 5 1 0 0 0 0 0 0 0 22 69 142 234 343 436 495 507 473 402 309 213 129 68 29 9 1 0 0 0 0 0 0 0 0 0 0 0 0 2 6 10 16 22 26 27 25 20 14 
8 3 0 0 0 0 0 0 0 0 37 119 248 417 623 809 941 992 953 834 664 476 303 168 77 29 12 14 19 22 22 18 12 7 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 
1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 3 3 2 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 7 30 72 132 208 288 355 396 405 381 330 263 194 130 79 43 21 8 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 7 9 11 9 8 
4 2 0 0 0 0 0 0 0 0 15 74 182 340 541 762 950 1072 1104 1043 907 723 526 348 206 109 51 22 9 5 3 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 73 193 
373 604 869 1101 1258 1310 1249 1091 870 630 410 236 120 57 33 31 35 38 35 27 18 10 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 25 104 243 440 688 948 1161 1288 1305 1211 1030 799 561 353 197 
98 47 30 28 27 24 18 10 3 0 0 2 5 10 14 18 20 20 17 14 9 6 3 1 0 0 0 0 0 0 0 0 0 28 94 200 339 511 673 793 849 834 750 619 464 313 186 96 39 10 0 0 0 0 0 0 0 0 0 0 
1 2 2 2 2 1 0 0 2 26 73 141 225 321 399 445 453 422 362 285 207 138 83 45 22 9 3 0 0 0 0 0 0 1 2 3 4 4 4 2 1 0 0 0 0 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 
0 0 4 10 17 24 31 33 31 27 21 17 13 10 8 6 4 2 0 0 0 1 4 7 8 9 8 6 3 1 0 0 0 0 2 4 7 10 11 10 7 4 2 0 0 0 1 2 3 4 5 6 6 8 9 11 12 12 11 8 
6 3 1 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 2 3 4 4 4 3 1 0 0 0 0 0 0 0 0 2 5 10 15 21 26 30 33 34 33 30 24 17 11 6 2 0 0 0 
0 2 4 5 7 8 7 5 3 1 0 0 0 0 1 20 58 115 189 276 353 405 424 406 358 288 212 139 81 41 16 4 0 0 0 0 0 0 10 35 76 131 200 267 319 344 338 301 243 174 114 78 80 125 215 338 474 600 693 736 
721 652 544 417 292 184 104 50 20 6 1 0 0 0 0 10 31 65 108 162 212 249 268 266 244 207 162 118 80 51 31 20 13 8 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 29 65 114 173 234 280 
305 305 282 241 190 139 94 58 32 16 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 6 9 11 12 11 9 5 3 1 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 11 40 89 157 241 327 398 440 448 422 367 295 220 150 93 52 27 12 5 1 0 0 0 0 0 1 3 4 4 4 3 1 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 1 2 3 3 2 1 0 0 0 0 0 2 4 4 5 4 3 1 0 0 0 0 0 0 0 0 17 52 108 183 277 367 438 478 479 444 380 300 217 144 88 50 28 17 14 14 15 16 17 17 16 13 9 
6 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 5 7 8 7 6 4 2 1 0 1 3 4 5 4 4 2 0 0 0 0 0 3 7 12 16 19 20 17 12 7 3 1 
0 0 0 0 0 0 0 2 24 70 143 242 363 483 580 638 648 610 531 428 318 218 136 78 42 21 10 4 2 0 0 2 5 6 7 7 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 6 40 106 204 336 489 630 735 783 765 687 567 433 312 232 207 239 318 423 530 611 651 640 581 489 387 296 237 222 250 312 390 465 519 541 526 478 407 324 242 167 108 65 36 18 8 3 1 0 0 0 0 7 25 
55 94 143 192 229 249 248 228 193 149 105 65 35 15 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 5 6 7 6 4 2 1 0 0 0 0 0 0 0 0 0 0 0 
0 0 1 5 10 16 23 29 31 31 27 22 16 11 7 4 2 1 0 0 0 1 3 3 3 3 3 1 0 0 0 1 3 5 8 10 11 9 7 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 1 3 5 6 8 8 6 4 3 1 0 0 0 5 25 59 107 169 238 299 342 361 354 323 275 218 162 112 73 44 25 13 6 2 1 0 0 0 
0 0 0 0 0 0 0 0 0 0 1 3 5 6 7 7 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 1 4 7 9 10 9 7 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 5 10 17 25 
32 36 35 31 23 16 9 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 5 8 10 11 10 8 5 2 1 
0 0 0 6 26 60 107 166 230 284 320 333 322 290 243 191 140 95 59 33 17 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 12 44 104 190 305 433 552 645 697 700 
657 576 472 360 257 167 99 52 24 8 1 0 5 27 69 134 225 336 449 550 622 654 641 588 503 402 298 206 130 76 39 18 7 2 0 0 0 0 0 11 38 85 157 254 363 469 558 612 624 593 526 435 335 239 158 96 53 26 11 3 
0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 1 1 1 1 1 0 0 10 44 106 201 328 474 615 729 798 811 768 679 561 433 312 210 131 76 40 19 8 2 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 2 2 2 2 2 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 11 33 67 114 175 235 289 326 341 332 302 255 200 146 99 63 
39 24 17 13 10 8 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 9 29 59 98 147 192 226 244 244 227 197 159 119 84 56 35 22 14 11 11 10 10 9 7 5 2 1 0 0 0 0 0 1 1 1 1 1 0 0 
0 0 0 0 0 1 2 4 6 7 8 8 7 6 4 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 19 46 86 138 198 254 300 327 331 314 279 231 181 133 94 66 49 39 34 30 25 20 13 8 4 
2 3 3 3 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 3 3 3 3 2 0 0 0 0 0 4 16 35 63 100 140 177 206 223 226 216 194 163 129 96 67 44 27 15 7 3 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 1 1 2 2 1 1 0 0 0 0 0 0 0 2 4 6 8 8 6 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0 
0 14 44 89 151 228 302 361 398 406 387 345 290 229 171 122 84 57 38 26 18 12 7 4 1 0 1 10 29 57 95 143 191 232 261 274 268 245 211 170 129 94 67 48 37 30 25 20 14 9 4 1 0 0 0 0 3 6 11 15 
19 20 20 16 11 7 3 1 0 0 0 0 0 0 15 45 95 163 250 337 413 466 488 478 438 377 304 231 163 108 66 38 20 9 5 3 2 2 1 1 0 0 0 0 0 0 0 0 0 0 1 1 2 2 1 1 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 11 34 69 117 178 239 292 327 341 332 302 255 200 146 97 60 34 17 9 4 3 1 0 0 0 13 42 89 155 242 335 421 
488 526 528 496 436 358 276 199 133 83 47 24 11 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 5 6 7 9 9 8 7 5 3 1 0 0 0 0 0 0 0 0 0 1 4 9 14 19 21 21 17 12 7 
3 0 0 0 0 0 0 4 20 50 95 155 226 294 351 386 394 375 336 289 247 223 226 257 311 376 441 492 518 515 483 428 356 280 207 145 97 63 40 26 18 12 8 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 0 0 0 0 12 37 77 134 209 288 363 422 458 466 445 400 338 268 199 139 89 51 27 12 4 0 0 0 1 15 
45 91 156 239 324 399 454 482 477 441 383 313 240 176 126 91 69 56 48 40 32 22 14 7 2 0 0 0 0 0 0 0 0 8 27 61 111 181 261 341 410 457 475 462 423 363 295 227 165 114 73 43 23 11 3 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 
0 0 0 0 2 4 5 7 7 6 4 2 0 0 0 6 18 37 64 97 131 160 180 191 190 181 167 154 149 159 188 238 303 373 439 486 505 496 457 397 325 252 187 134 97 74 60 52 44 36 25 16 8 2 0 0 0 0 0 0 
1 1 1 1 1 0 0 0 0 0 0 1 2 3 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 3 5 6 5 4 3 1 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 5 17 37 66 104 143 178 203 216 212 197 170 136 100 68 40 21 8 2 0 0 0 0 0 7 22 43 71 105 137 162 177 181 173 158 135 110 84 60 39 22 12 4 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 17 37 64 99 135 166 190 202 203 192 172 145 
117 88 63 43 28 17 11 8 5 4 4 3 2 2 1 1 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13 41 87 
152 239 330 416 487 532 547 531 487 424 350 276 206 147 99 65 40 24 14 9 7 6 6 5 3 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10 32 67 112 169 225 273 304 318 312 291 257 
217 175 134 98 66 40 22 10 3 0 0 0 1 3 5 6 7 6 4 3 1 0 0 0 1 9 24 44 68 95 116 129 133 128 116 101 88 80 84 102 138 187 245 305 358 395 411 405 377 334 282 227 176 133 97 68 44 27 15 6 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 19 43 76 119 163 202 229 241 239 220 193 161 128 97 73 53 39 29 21 14 9 5 2 0 0 3 12 29 53 85 122 156 183 201 207 200 182 156 125 93 61 37 19 7 
1 0 0 0 0 7 23 48 80 119 157 186 205 211 207 193 172 148 124 101 81 65 50 38 25 16 8 3 0 0 1 3 4 4 4 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
1 3 5 8 9 8 7 4 2 0 0 0 0 0 0 0 1 2 2 2 2 2 4 7 12 16 18 16 13 9 5 1 0 0 0 0 0 0 0 0 1 6 17 35 62 98 139 184 225 261 284 293 285 264 235 206 182 171 176 196 
229 268 306 335 352 353 341 320 296 275 262 259 266 278 292 301 304 297 282 261 240 221 207 200 199 203 209 214 215 212 202 186 164 140 115 92 72 56 43 33 25 18 13 9 6 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 1 3 5 6 7 8 7 8 7 8 7 6 5 3 1 0 0 0 0 0 0 1 1 2 2 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 2 6 9 11 12 10 7 4 1 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 1 8 21 39 64 93 123 148 167 178 179 170 154 132 108 84 62 44 30 21 16 15 14 12 10 7 4 2 0 0 0 0 0 0 0 1 3 6 8 10 10 8 6 3 1 0 0 0 0 1 3 
4 5 6 5 3 1 0 0 0 0 0 0 1 10 25 47 78 116 155 193 225 249 264 267 260 242 216 185 152 120 90 65 46 32 23 17 14 12 10 9 6 5 4 3 2 2 1 1 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 2 2 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 1 1 2 2 1 1 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 7 16 32 54 84 123 168 216 262 300 325 333 323 300 270 240 217 208 213 231 257 285 308 321 323 315 299 280 265 257 258 267 284 304 323 337 342 336 319 290 253 212 
169 126 89 56 32 16 6 0 2 8 18 32 52 74 97 118 136 149 157 158 154 143 128 109 89 69 50 35 23 14 8 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 1 1 2 2 2 2 2 1 1 1 2 4 5 6 6 6 4 2 1 0 1 5 14 29 51 78 109 139 166 187 199 204 198 184 161 133 101 68 41 22 8 1 0 2 4 6 7 8 6 4 2 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 10 25 48 83 127 178 231 283 327 359 375 372 353 324 290 259 238 232 241 263 295 329 360 380 387 378 354 317 272 223 177 134 97 67 
43 25 13 5 1 3 9 20 34 52 70 87 98 104 104 99 90 80 70 60 51 43 33 23 15 8 3 0 0 0 0 1 3 6 8 10 10 8 5 2 1 0 0 0 8 21 41 67 97 125 147 161 165 162 152 137 121 106 93 80 
68 57 45 32 20 12 5 1 1 2 4 5 7 8 7 5 4 2 1 0 0 1 6 16 31 51 77 104 128 147 158 160 153 139 124 111 108 116 139 174 217 264 306 338 355 356 340 311 273 229 185 144 109 81 59 45 36 32 28 25 
22 17 12 7 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 5 6 8 9 9 8 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 3 6 9 12 14 12 9 6 3 0 0 0 0 
0 0 0 2 4 7 9 10 9 7 4 2 0 0 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 1 2 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 6 9 11 13 12 10 7 5 2 0 0 0 
0 0 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 1 1 1 1 0 0 0 0 0 0 3 14 29 51 81 116 152 189 225 256 279 293 292 279 253 218 179 140 105 76 55 40 31 26 21 17 13 10 
8 6 4 4 3 2 1 1 1 1 1 1 1 0 0 0 0 1 2 2 2 2 1 0 3 14 34 64 104 151 198 240 273 294 301 295 277 252 223 192 162 135 110 87 67 50 35 22 13 7 5 6 10 13 16 18 17 14 9 6 
2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 2 4 7 8 9 7 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 3 9 19 35 57 86 120 158 
195 231 259 276 279 270 250 224 199 181 175 182 203 234 268 298 320 329 324 306 279 246 212 177 145 116 90 67 49 33 22 14 9 8 10 15 19 23 25 23 19 13 8 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
1 5 12 23 39 60 84 109 135 157 174 183 183 174 158 137 114 90 69 52 39 30 24 21 18 16 12 8 5 4 5 8 11 15 17 17 13 10 6 2 0 0 0 0 1 2 5 7 10 13 15 19 24 32 44 58 75 93 111 128 
140 148 150 145 135 121 105 89 74 60 49 39 31 24 19 14 11 11 13 18 26 38 53 69 85 101 113 122 125 124 118 110 98 85 71 59 47 38 32 28 26 25 24 23 21 20 19 18 18 17 14 10 7 4 1 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 16 31 47 64 77 82 83 83 86 95 
114 139 167 195 217 230 232 223 205 182 155 128 103 81 62 46 33 21 12 6 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 7 17 32 51 73 94 110 122 126 125 120 111 
100 90 78 67 55 43 31 21 12 6 2 0 0 0 0 0 0 1 3 5 6 8 9 9 10 10 10 9 8 6 4 2 1 0 0 0 4 12 24 41 63 88 115 140 162 179 191 196 193 184 170 152 132 111 90 69 50 32 18 8 
2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 5 6 7 6 5 3 1 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 2 4 7 9 10 9 7 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 4 6 7 6 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 1 4 9 16 26 41 61 86 116 149 184 218 247 267 278 278 269 251 228 201 173 145 119 94 71 52 36 23 14 7 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 1 2 2 2 2 2 1 0 0 0 0 0 1 1 1 2 3 8 16 28 44 61 77 91 102 108 109 107 102 96 88 80 71 62 51 39 26 16 8 2 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 0 0 1 4 10 18 29 42 56 70 83 95 104 108 107 102 94 83 71 60 48 38 28 20 14 10 8 6 5 4 2 1 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 5 11 21 35 52 70 92 113 135 154 171 184 191 192 187 175 159 138 116 92 68 48 31 19 10 
4 2 0 0 0 0 0 0 0 1 2 2 2 2 2 1 0 0 0 0 0 0 0 0 0 1 2 3 2 2 1 0 0 0 1 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 2 1 
1 0 0 0 0 4 12 24 41 61 83 103 121 135 147 154 158 157 154 148 141 135 131 130 133 141 152 165 177 185 190 187 177 163 145 125 105 85 65 48 31 19 9 3 0 0 0 0 0 0 0 0 0 0 0 2 3 6 8 9 
8 7 4 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 10 19 32 47 64 80 95 107 116 122 122 118 109 97 81 65 47 31 18 9 3 0 1 3 5 8 10 12 12 10 9 7 5 4 2 1 0 
0 0 0 0 0 0 0 0 0 0 3 11 24 44 71 105 140 174 206 231 246 252 248 236 221 205 192 186 186 193 202 212 219 222 219 212 198 182 162 141 120 102 88 77 69 63 56 48 39 30 22 15 10 8 8 10 12 14 14 13 
10 7 4 2 0 0 0 0 0 0 0 0 0 0 1 3 8 13 19 27 34 41 49 59 69 79 88 94 96 95 91 84 75 66 56 46 38 32 26 22 18 14 9 6 3 1 0 0 0 2 5 9 14 20 24 25 24 20 15 10 
5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 5 7 9 9 8 6 3 3 4 6 8 9 10 9 6 4 2 0 0 0 0 0 0 2 5 7 9 9 7 5 2 0 0 0 3 11 23 39 59 79 
98 114 127 137 145 149 151 150 147 144 140 138 140 143 150 160 171 181 189 194 194 190 181 168 151 133 113 92 72 53 38 24 14 7 3 1 0 0 0 0 0 0 0 0 2 3 4 4 4 3 3 2 2 2 2 1 1 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 1 3 6 9 13 16 18 18 18 18 18 19 21 26 36 49 66 86 107 127 143 155 160 160 154 145 134 122 108 95 82 70 59 48 39 31 23 17 11 7 4 2 0 0 0 0 0 0 
0 0 0 0 0 1 3 6 9 13 14 15 13 11 9 8 7 7 8 9 9 9 8 6 4 2 1 0 0 0 0 0 0 0 0 0 2 7 15 26 42 61 82 105 130 155 182 207 230 249 262 267 263 250 229 204 176 149 122 98 
77 60 45 34 24 17 11 6 3 1 0 0 0 0 1 3 4 6 7 7 5 3 2 0 0 0 0 0 0 0 3 9 18 32 50 70 89 109 126 140 149 154 154 150 143 131 118 103 85 68 51 36 22 12 5 2 0 2 3 5 
6 8 8 8 8 8 7 6 5 4 2 1 1 0 0 0 0 0 0 0 0 0 2 7 14 23 35 48 61 74 88 101 111 118 121 119 112 101 87 71 54 38 24 13 6 2 1 2 4 6 7 9 9 8 6 4 2 1 0 0 
0 0 0 0 0 1 2 3 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 5 8 9 10 9 6 4 2 0 0 0 0 0 0 0 
0 0 1 1 1 1 1 2 5 9 14 19 23 23 20 15 10 5 1 0 0 0 0 0 0 0 0 0 7 20 39 61 84 100 105 97 79 55 34 16 4 0 1 5 10 16 23 29 33 36 39 43 49 55 63 71 77 82 86 87 
86 84 79 72 64 55 45 35 26 17 11 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 6 12 20 29 38 46 53 58 63 66 68 67 66 61 54 45 37 28 21 14 10 6 3 1 0 0 1 1 1 1 
0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 9 17 29 43 59 75 92 108 124 141 156 170 181 188 188 182 172 159 142 125 108 91 74 58 44 31 20 12 7 3 1 0 0 0 0 0 0 0 0 0 0 0 2 4 6 
7 7 5 3 2 1 2 6 10 15 21 26 31 37 44 52 62 72 81 88 92 92 86 77 64 50 37 28 22 20 21 22 21 18 15 10 5 2 2 3 5 6 6 5 3 2 0 0 0 0 0 0 0 0 1 2 2 2 2 1 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 5 10 18 30 43 59 75 92 107 122 135 147 157 163 168 168 164 159 150 139 126 111 93 75 
58 42 29 19 11 7 4 3 3 3 3 2 2 2 2 2 2 2 1 1 0 0 0 0 0 0 0 1 1 2 2 2 2 2 3 5 7 10 13 14 14 13 10 6 3 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 1 2 2 2 2 2 1 0 0 0 0 0 2 5 6 8 8 6 4 2 0 0 0 0 2 5 7 10 11 10 7 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 5 8 11 
15 16 15 12 8 5 2 1 1 3 4 6 7 8 8 8 8 9 9 8 6 5 3 2 0 0 2 6 11 17 22 26 28 28 26 24 21 18 16 15 14 13 14 15 18 22 26 33 40 49 60 74 89 106 125 144 163 178 190 196 
197 192 182 170 154 138 123 108 95 82 71 60 52 45 41 38 37 35 33 31 28 24 20 15 10 6 3 1 0 0 0 0 0 2 5 10 14 19 22 23 22 21 20 19 20 21 23 25 26 25 23 19 14 9 6 2 0 0 0 3 
7 14 21 30 37 42 43 41 36 29 22 16 11 7 5 4 2 1 0 1 1 3 4 6 7 8 8 7 7 7 8 10 12 14 15 15 14 12 9 8 7 8 9 11 12 11 8 6 3 1 0 0 2 4 6 7 7 6 4 2 
0 0 2 4 6 8 9 10 9 9 8 8 9 9 9 8 6 4 3 1 0 0 0 0 1 4 7 11 15 17 18 17 14 10 7 3 1 2 5 9 15 20 24 26 25 22 17 11 7 3 1 0 0 0 0 0 0 0 1 2 
5 8 10 12 11 10 7 4 2 0 0 0 0 0 1 2 3 3 2 1 0 0 0 0 0 0 0 0 0 0 1 2 5 7 9 10 10 9 9 8 8 8 8 8 9 9 9 8 6 4 3 1 0 0 0 0 0 1 2 4 
5 8 9 11 13 14 15 16 16 16 15 13 11 10 8 8 7 7 7 6 4 3 4 4 5 5 4 3 2 0 0 3 6
);

is_deeply(\@trace,\@array);

@array = $abi->get_trace("T");



@trace = qw(
67 62 58 75 100 133 174 223 282 358 454 576 733 942 1220 1584 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1497 1256 1062 888 721 563 427 
323 256 221 209 210 212 209 199 183 162 140 118 95 73 52 33 18 8 2 0 0 0 0 0 0 0 0 0 0 0 1 2 5 11 22 37 55 76 98 116 129 135 134 124 108 86 62 39 22 9 2 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 2 7 16 27 40 53 64 73 81 90 99 112 124 136 147 156 163 169 172 173 168 157 137 111 79 51 27 11 1 0 0 0 35 132 286 479 692 868 946 908 768 572 381 250 212 267 389 528 636 676 633 518 366 227 112 
35 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 6 18 37 63 98 139 186 240 301 368 440 515 
592 675 767 871 987 1117 1254 1392 1527 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1600 1549 1381 1218 1060 905 753 606 467 341 230 141 79 36 10 7 72 203 399 646 920 1135 1238 1203 1035 776 510 284 118 24 0 0 0 0 0 0 0 
0 0 0 0 0 0 2 6 12 17 20 20 16 11 6 1 0 0 0 0 38 128 271 453 666 848 955 961 868 702 500 311 165 67 15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 10 16 21 23 
21 16 10 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 4 5 8 12 18 29 45 66 90 113 128 130 119 95 66 39 20 12 14 18 20 19 15 9 3 0 0 0 0 0 0 0 0 0 24 127 306 544 
816 1072 1216 1211 1057 799 528 292 147 139 254 422 605 759 826 792 671 493 318 173 70 13 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
17 101 254 468 724 982 1159 1211 1124 922 655 410 210 75 7 0 8 15 21 23 25 20 12 5 1 0 0 0 0 0 0 0 0 0 0 0 0 0 3 10 20 32 44 52 54 51 45 40 37 40 47 55 62 63 56 44 30 17 7 1 
0 0 0 0 0 0 0 0 9 27 50 75 100 113 113 103 88 75 64 52 39 29 18 46 144 330 592 913 1220 1436 1502 1397 1146 819 510 276 176 212 347 506 648 717 693 587 432 277 149 59 11 3 11 21 28 34 35 29 20 11 5 1 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 9 21 31 36 34 30 21 8 14 101 272 524 836 1169 1421 1528 1462 1240 916 593 324 132 26 0 0 0 0 0 0 0 0 
0 17 98 245 453 704 961 1141 1200 1121 925 659 413 211 74 5 1 10 21 30 38 44 42 34 24 14 7 3 0 0 0 0 0 0 0 0 33 153 361 645 978 1299 1506 1546 1413 1141 801 492 248 87 9 11 24 36 47 58 59 52 43 36 
33 37 48 64 81 95 103 103 96 85 72 59 47 37 29 20 13 8 3 1 1 9 22 38 55 68 72 64 49 32 17 11 18 36 54 70 78 72 57 39 24 20 29 46 65 80 84 75 57 38 24 21 30 48 66 79 82 73 57 42 
33 37 53 76 95 105 97 76 52 28 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 8 15 18 17 17 13 8 39 115 231 377 539 666 726 701 598 444 288 157 64 12 0 0 
0 0 0 0 0 0 0 0 0 0 1 5 10 15 19 21 18 14 8 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 7 16 28 42 57 70 76 78 75 68 57 45 32 20 11 5 1 0 0 0 0 0 0 
0 2 10 24 44 68 93 111 116 107 85 59 35 15 2 5 12 19 18 19 16 10 2 5 72 204 397 632 887 1075 1150 1093 921 676 435 235 95 18 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 12 32 59 87 115 128 124 
104 74 46 23 13 16 29 43 56 64 64 55 41 28 15 6 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 9 14 19 22 22 19 14 9 5 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 57 223 497 858 1275 1600 1600 1600 1600 1320 898 533 251 74 0 4 16 27 35 41 41 31 20 10 3 0 0 0 0 0 0 0 0 0 0 0 64 229 487 810 1165 1452 1578 1511 1271 928 592 312 171 178 308 477 656 773 797 725 579 399 242 
118 38 0 6 13 18 19 20 16 9 3 0 0 2 6 10 12 13 12 8 5 2 0 0 0 0 0 0 0 0 0 0 0 3 13 28 44 60 65 56 44 29 12 0 0 57 229 509 865 1262 1600 1600 1600 1501 1135 745 419 182 46 4 
16 26 33 35 33 24 13 4 0 0 0 0 0 0 0 0 0 5 17 31 46 59 60 50 38 23 7 0 51 195 435 757 1139 1495 1600 1600 1600 1302 912 561 281 97 7 4 13 20 22 22 21 13 5 0 0 0 0 0 0 0 0 3 
18 42 72 107 137 151 146 123 88 56 28 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 6 11 14 17 16 13 8 4 1 0 4 8 13 17 19 17 13 8 4 1 0 0 1 2 2 2 2 1 0 0 
34 134 298 512 757 977 1103 1105 985 773 525 312 147 44 0 3 5 4 4 5 3 0 15 91 231 429 667 913 1088 1149 1082 904 661 423 228 92 18 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 37 150 334 
570 833 1063 1183 1164 1015 776 516 296 134 37 0 0 0 0 0 0 0 0 0 0 0 1 2 4 5 6 5 4 2 0 0 0 0 1 3 3 3 3 3 1 0 9 58 145 265 405 546 640 664 614 503 361 227 119 46 8 3 7 10 
10 11 9 5 1 0 0 4 10 17 24 30 30 26 19 12 5 1 0 0 0 0 0 0 0 0 0 53 191 415 707 1047 1350 1531 1547 1397 1121 784 481 244 89 12 3 8 6 6 7 5 0 1 54 161 322 523 748 924 1004 969 826 613 
399 217 121 133 244 394 558 683 731 689 572 414 261 152 116 158 262 391 511 586 595 538 433 302 186 94 34 4 0 0 0 0 0 0 0 9 99 268 506 788 1084 1283 1339 1238 1011 721 449 262 201 268 425 615 774 849 818 690 504 321 188 154 
231 403 614 818 954 985 906 739 527 329 172 67 11 0 0 0 3 13 30 51 73 91 98 92 75 52 32 15 4 0 0 0 0 2 4 6 8 8 7 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 22 109 258 459 696 928 1082 1123 1043 865 633 405 222 94 23 0 2 3 4 4 4 3 1 0 0 0 0 0 0 0 0 0 0 36 132 290 499 747 974 1117 1142 1040 838 
585 359 184 116 159 298 470 654 790 846 810 693 525 346 199 91 26 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 7 13 20 25 27 24 18 11 5 1 0 0 0 0 0 0 0 56 178 
365 602 876 1105 1236 1240 1120 905 647 404 216 88 20 0 0 0 0 1 6 14 24 35 44 46 42 34 26 22 25 34 48 62 71 73 65 50 33 19 8 8 20 39 62 86 103 109 101 84 61 40 27 24 33 48 64 74 74 64 47 30 
15 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18 100 246 446 683 924 1090 1145 1079 912 684 446 254 116 34 4 11 18 23 28 28 24 18 13 8 5 2 1 0 0 0 0 
0 0 0 0 47 171 370 628 929 1199 1364 1388 1269 1039 754 478 260 111 28 1 3 3 3 3 3 0 0 0 0 1 5 11 17 23 27 27 24 18 12 6 2 0 0 0 0 0 0 0 14 89 225 419 656 909 1102 1193 1163 1023 805 556 
338 172 64 10 0 0 0 0 2 7 16 26 37 44 44 36 27 16 7 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 20 98 234 418 635 851 997 1043 980 828 623 410 236 
110 35 3 5 10 12 14 14 11 7 4 2 1 0 0 0 0 0 0 0 4 12 22 33 44 49 47 38 27 16 7 1 0 0 0 0 0 0 0 0 0 5 19 40 65 93 114 122 117 100 76 51 31 17 8 5 3 2 1 0 
0 0 0 0 0 0 0 0 49 154 315 524 772 988 1127 1160 1083 915 695 468 276 137 51 11 4 7 9 10 11 10 8 6 5 4 2 1 0 0 0 0 0 0 8 59 158 308 502 721 910 1031 1055 979 823 618 406 235 111 36 2 0 
0 0 0 0 0 0 0 0 0 0 0 0 2 6 10 15 18 19 17 13 9 5 3 1 0 0 0 0 2 10 22 37 53 64 67 59 45 30 15 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 20 104 249 448 688 
933 1110 1184 1140 992 776 536 326 168 65 13 0 0 2 7 18 32 51 68 80 82 74 57 39 22 8 1 0 0 0 0 0 0 0 0 2 11 26 45 68 92 109 117 116 106 90 71 50 31 18 7 2 0 0 0 0 0 0 0 0 
0 0 9 68 180 344 550 779 968 1077 1086 994 823 610 396 226 105 33 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 55 175 356 579 831 1031 1127 1101 960 745 509 311 191 168 236 364 512 638 709 709 
640 521 377 240 132 58 15 3 7 9 9 10 7 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 73 220 443 726 1058 1338 1511 1542 1425 1191 890 581 334 155 47 0 0 1 6 13 23 35 48 57 61 59 51 39 26 15 7 2 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 36 140 313 546 825 1096 1286 1356 1294 1116 865 592 356 180 68 15 8 14 17 19 18 13 7 2 0 0 0 0 0 0 0 0 0 0 0 0 23 110 265 479 740 1007 1203 1284 1234 
1067 828 575 368 248 232 304 430 564 665 703 672 579 448 306 184 93 36 7 0 0 0 0 0 0 0 0 0 0 0 0 0 3 13 29 50 73 94 108 112 107 95 77 57 37 23 11 3 0 0 0 1 3 5 7 8 6 5 2 1 
0 0 0 0 0 0 0 0 0 0 8 23 44 66 87 99 95 79 57 35 16 4 0 0 0 0 0 0 5 15 28 42 59 70 74 74 68 60 52 46 43 41 40 37 31 26 29 53 112 214 358 532 712 865 962 983 925 801 637 464 
309 189 109 66 49 49 57 66 75 81 83 82 78 70 61 53 46 43 44 49 58 72 86 99 110 115 112 99 79 56 35 17 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 16 84 203 367 562 761 904 962 925 805 631 
439 268 140 56 14 4 6 5 5 5 3 0 0 20 70 150 257 387 509 597 631 607 529 416 290 178 93 37 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 3 10 20 31 42 49 50 45 35 24 14 6 4 8 16 24 32 35 32 25 17 9 3 0 3 11 24 38 53 63 66 59 45 30 17 7 1 0 0 12 54 125 223 343 464 556 599 585 520 416 295 184 
99 41 9 0 0 0 0 0 0 38 131 284 493 751 1002 1192 1285 1262 1130 919 671 429 242 111 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 39 105 
206 340 497 639 741 780 751 658 523 371 232 125 54 14 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 14 28 46 66 82 91 92 85 73 57 41 26 14 7 2 0 0 3 27 75 147 237 340 427 478 485 445 368 272 176 99 
45 16 7 10 12 13 12 8 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 26 77 156 257 375 476 540 550 504 414 300 190 110 82 113 200 321 453 565 633 644 595 499 377 251 147 72 25 3 0 0 0 0 0 0 0 
14 49 106 181 273 362 427 455 443 391 312 220 137 73 29 5 0 0 0 0 0 0 0 0 0 3 49 137 267 430 615 768 859 871 804 676 514 349 208 107 42 9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 
4 7 8 9 8 6 3 0 2 7 14 24 34 43 48 47 41 31 21 11 4 0 0 0 0 0 51 154 308 500 721 903 1006 1013 925 770 587 420 304 259 286 365 468 561 617 620 571 478 363 245 146 75 29 6 0 0 2 9 19 30 
42 49 49 41 30 19 8 1 0 0 0 0 0 0 0 0 0 0 1 6 17 29 44 59 70 74 73 66 56 43 30 18 10 4 0 0 0 0 0 0 0 0 0 0 1 6 15 27 39 47 49 44 33 21 11 3 0 0 0 0 
0 0 0 0 0 2 9 20 33 49 64 74 78 75 68 57 46 37 33 32 35 41 46 48 48 42 35 25 16 9 4 1 0 1 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 12 23 36 50 61 
66 66 60 51 39 27 16 8 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 4 5 5 5 4 2 3 26 73 145 241 352 453 524 549 526 461 368 266 172 98 48 20 6 2 1 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 4 13 27 43 61 74 78 74 61 44 28 15 5 0 0 2 5 8 11 12 11 8 5 2 0 0 0 0 16 55 118 203 308 408 485 523 517 468 390 295 201 121 63 27 10 6 7 8 8 6 3 
1 0 0 0 0 0 0 1 1 1 1 1 0 0 2 26 71 139 225 324 408 460 472 440 375 291 205 131 77 43 25 16 11 8 4 1 2 6 9 11 11 10 7 3 0 0 0 0 0 1 21 66 143 252 392 538 665 749 774 735 
641 511 373 254 176 151 177 242 330 417 481 510 496 442 359 262 168 95 43 13 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 6 9 12 14 15 13 10 7 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 2 7 14 20 26 28 26 20 13 7 3 0 0 0 0 0 0 0 0 0 12 62 152 283 451 638 798 904 934 887 775 626 475 353 279 261 290 348 411 460 480 464 415 343 260 179 110 59 27 9 
2 0 0 0 0 0 0 0 0 0 0 1 3 4 5 5 4 3 1 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 37 92 171 275 390 489 558 581 555 489 399 305 230 189 189 226 
289 360 421 457 459 428 369 293 213 142 86 48 26 17 14 14 14 12 9 6 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 13 40 88 159 252 356 457 535 578 577 532 453 355 253 163 93 
47 20 7 2 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 20 50 97 159 231 298 349 375 371 339 286 223 160 106 65 35 17 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9 31 75 147 251 
378 513 636 723 758 733 654 536 403 275 170 95 50 28 19 16 12 9 5 2 0 1 3 4 6 8 9 10 11 15 20 29 40 51 60 65 65 58 46 34 24 18 18 25 36 47 55 58 54 45 33 22 14 11 14 20 29 38 46 52 
56 57 55 50 42 32 21 12 5 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 9 16 25 35 42 46 47 44 39 32 22 14 8 3 0 0 5 25 60 110 171 236 289 321 326 305 263 209 154 103 
65 36 19 9 4 1 0 0 2 5 8 11 12 10 8 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 45 111 204 320 446 549 610 620 579 498 394 283 
183 104 51 19 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 9 15 19 20 18 14 9 4 0 0 2 8 15 23 33 39 41 38 31 22 13 7 2 0 0 
0 0 0 0 0 0 0 0 0 8 38 94 176 286 413 531 624 676 679 633 547 436 318 208 121 60 23 4 0 0 0 0 0 4 20 53 104 175 258 341 409 450 455 427 370 300 229 175 145 144 170 213 260 301 324 323 299 257 203 148 
97 57 29 12 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 13 37 76 131 200 270 329 368 379 361 317 257 191 129 77 41 18 6 0 0 0 0 0 0 0 0 23 72 149 247 366 474 554 590 581 529 
447 347 247 160 92 46 21 8 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 7 12 18 24 29 32 33 31 27 21 15 8 4 1 0 0 0 0 0 0 0 0 
0 5 29 74 142 235 346 454 545 602 618 590 524 435 341 259 202 180 190 224 269 309 334 335 312 270 217 161 112 73 47 31 22 18 15 12 8 6 3 1 0 0 0 0 0 0 0 0 0 0 0 4 19 46 85 137 196 251 296 321 
323 303 264 213 159 108 67 37 18 7 2 0 0 0 0 0 0 5 36 93 173 273 386 480 543 565 544 487 406 313 224 146 86 45 21 8 2 0 0 0 0 0 0 0 0 0 0 0 1 3 6 10 14 16 17 16 12 8 5 2 
0 0 0 0 0 0 0 0 0 0 0 0 3 9 16 24 31 33 31 24 16 9 3 0 0 0 0 0 0 0 0 0 1 4 8 14 19 23 23 20 14 9 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 6 12 19 27 33 37 37 36 32 28 24 21 19 19 19 21 22 22 20 16 11 7 3 1 0 0 0 0 0 0 0 1 4 8 11 13 14 12 10 13 26 54 100 164 239 
316 381 424 438 420 375 310 240 172 116 77 53 40 33 28 21 15 9 3 6 25 59 109 176 253 325 381 413 415 387 337 277 220 175 152 152 171 201 234 261 275 272 252 219 177 132 89 53 28 12 3 0 0 0 0 0 0 0 0 0 
0 0 0 0 1 2 2 2 2 2 1 0 0 0 1 2 3 4 5 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 6 10 14 19 23 24 25 24 21 17 13 8 4 1 
0 0 0 0 0 0 0 0 0 11 36 80 144 229 320 407 475 514 518 490 435 365 291 228 184 163 168 192 225 260 286 294 283 254 212 163 115 74 42 20 8 2 0 0 0 0 0 0 0 0 0 0 1 6 14 24 34 44 49 49 
45 38 31 25 21 20 21 24 29 35 41 46 50 49 45 37 27 18 9 3 0 0 7 25 56 101 159 223 280 324 347 348 327 290 244 195 148 107 72 44 24 11 3 0 0 0 0 0 0 0 0 0 1 4 8 11 13 13 11 8 
4 1 0 0 0 0 0 0 1 3 5 7 8 11 14 17 22 27 29 29 27 22 17 13 10 8 6 5 4 2 2 2 3 2 3 2 2 3 5 8 11 13 15 13 10 7 3 1 0 0 1 2 3 4 4 4 3 1 0 0 
1 3 4 4 4 3 2 1 0 0 0 0 0 0 0 6 31 79 150 246 358 465 551 603 614 582 516 428 333 243 169 113 73 46 28 16 8 2 0 0 0 0 0 0 0 0 2 7 13 21 30 35 37 34 29 21 14 10 10 13 
20 29 38 45 49 50 47 42 35 30 24 19 13 9 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 5 16 38 72 120 180 244 304 351 378 381 360 318 268 217 176 152 148 160 184 210 
231 241 236 220 195 169 147 136 137 151 175 204 228 244 245 230 201 163 123 86 55 32 18 9 5 2 1 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 0 0 0 0 1 5 10 15 20 23 20 15 10 5 1 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 1 4 9 14 18 21 20 17 13 9 7 6 6 7 7 5 4 3 4 9 19 34 50 66 79 87 88 85 77 65 52 37 24 13 6 1 0 0 0 0 0 0 0 5 19 45 84 139 202 
268 327 373 399 404 388 352 303 246 189 134 89 54 30 15 6 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 47 96 161 242 321 385 426 437 419 377 322 265 220 193 188 202 230 260 285 295 287 262 223 178 134 
95 66 47 37 31 28 25 22 19 15 13 11 11 11 11 9 7 5 2 1 0 2 7 14 23 35 46 53 57 54 45 34 22 12 5 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 4 8 11 
14 15 14 12 8 5 2 1 0 0 0 0 0 0 0 0 0 1 3 7 12 17 20 22 22 21 20 20 21 23 26 29 31 32 31 28 24 19 14 9 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 1 3 7 13 18 
23 25 26 24 21 17 12 7 4 1 0 0 0 5 18 39 67 104 140 172 194 205 203 192 173 152 133 120 117 128 150 183 218 250 271 275 262 235 199 164 138 127 133 153 180 205 223 226 215 190 159 123 89 61 37 21 10 4 0 0 
0 3 9 19 35 58 87 120 153 182 203 209 201 181 151 119 87 61 39 23 12 5 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 7 13 19 25 30 32 33 34 34 33 31 
28 23 19 18 21 31 48 72 103 136 169 195 213 218 210 189 159 125 90 60 38 25 19 19 21 22 20 16 11 6 2 0 0 0 0 0 0 0 0 3 8 15 23 34 44 52 56 56 51 42 31 20 10 5 7 19 43 80 128 184 
240 288 321 334 325 296 253 203 155 114 83 64 51 43 34 25 16 8 2 0 0 0 0 0 1 3 6 10 13 15 15 14 11 8 7 7 8 8 8 7 5 2 1 0 1 12 35 73 128 200 277 352 413 454 468 454 415 357 289 221 
159 109 73 49 35 27 23 21 21 22 27 37 52 73 98 123 145 159 163 155 139 118 100 89 90 104 130 164 198 227 244 248 236 213 185 158 137 128 130 144 164 189 210 224 226 214 190 157 120 86 58 37 23 13 8 4 1 0 0 0 
0 0 0 0 0 0 0 0 3 8 16 24 33 38 40 39 35 29 22 16 10 7 8 15 30 53 82 116 151 182 205 215 213 199 175 144 113 83 58 38 24 13 7 3 3 4 8 12 17 21 24 25 24 22 17 12 7 3 1 1 
2 3 3 3 3 1 1 0 0 0 0 0 0 0 0 0 0 0 3 7 13 20 27 32 35 37 36 34 32 28 24 19 16 13 11 11 11 12 13 13 11 9 6 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 1 9 29 61 109 174 249 329 403 464 503 517 503 463 404 335 262 194 135 86 50 26 11 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 29 62 107 165 226 279 318 337 
337 319 286 246 203 163 129 101 78 58 39 25 14 6 1 0 2 5 8 9 9 7 5 2 0 0 0 0 0 8 30 68 123 195 276 351 411 447 456 437 395 338 274 210 153 105 68 41 23 12 5 1 0 0 0 0 0 0 0 3 
9 16 24 33 36 36 32 25 16 9 4 1 0 0 0 0 0 0 0 9 33 73 131 209 298 385 461 519 548 548 519 465 393 312 232 161 105 65 42 31 27 28 30 31 31 29 25 20 14 8 4 1 0 2 6 11 16 22 25 25 
23 19 15 12 11 13 16 19 21 21 18 13 8 4 1 3 9 15 22 28 29 26 20 14 9 6 6 6 8 9 10 12 15 20 27 35 41 45 45 41 34 24 15 8 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 1 2 4 7 10 14 18 22 24 25 24 20 15 10 6 2 0 0 1 8 21 42 74 116 166 220 272 316 345 357 348 322 281 231 178 128 85 52 29 16 12 13 21 36 61 97 143 198 256 311 356 383 390 378 350 313 274 239 214 
200 197 203 215 228 237 241 236 222 199 171 139 107 76 48 27 13 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 4 4 5 5 5 4 5 5 5 4 4 2 1 0 0 0 
2 3 5 6 7 5 4 2 1 0 0 0 1 3 4 6 6 6 5 3 1 1 0 0 0 0 0 0 6 23 52 96 156 225 297 364 417 452 464 453 422 378 329 283 248 226 218 219 226 231 231 224 208 189 171 157 151 154 166 184 
203 219 229 231 222 207 187 168 154 148 151 162 177 194 208 215 213 205 191 175 161 154 155 164 179 196 210 218 217 207 192 175 162 156 160 172 190 209 226 236 238 230 212 185 155 123 95 72 54 43 34 26 20 17 16 20 30 44 63 86 
113 140 164 183 192 191 180 160 134 107 82 60 45 36 31 30 32 33 32 28 22 15 8 3 0 0 0 2 5 7 9 9 8 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 2 3 6 10 16 20 24 26 25 20 14 9 4 1 0 0 1 2 4 5 6 5 4 2 1 0 2 7 13 20 28 36 41 46 49 52 52 49 42 33 23 13 6 2 0 0 0 1 4 9 14 20 25 29 
32 32 31 30 28 25 23 20 19 19 23 32 48 73 107 148 195 242 284 317 336 338 323 293 255 212 171 132 101 76 55 38 24 14 7 2 0 4 18 41 74 117 166 212 252 283 300 303 292 270 237 199 160 124 93 70 54 44 37 33 
27 21 15 10 7 8 11 16 22 26 29 30 29 26 22 18 13 9 5 2 0 0 0 0 1 4 8 15 22 28 31 31 28 21 14 8 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 1 5 10 17 23 27 27 23 17 10 5 1 0 0 0 0 0 3 13 30 57 94 141 193 246 294 332 355 360 348 320 280 233 184 138 97 64 41 27 20 18 18 20 21 22 23 22 20 17 12 8 4 1 0 0 0 8 25 
54 93 143 198 252 299 335 358 366 359 340 309 270 227 184 143 107 79 57 42 31 22 14 9 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 7 10 13 
14 11 8 5 2 0 0 0 0 0 2 6 11 17 23 28 32 34 35 34 32 30 26 22 17 14 11 9 10 13 17 21 23 23 18 13 8 3 0 3 7 10 13 14 12 10 7 4 4 4 5 5 4 3 1 0 0 0 0 1 
5 11 18 27 37 50 66 86 110 135 159 177 187 187 180 169 157 149 147 152 162 174 186 194 197 196 192 186 178 170 161 153 146 142 141 145 151 159 165 168 166 161 152 142 134 130 131 136 145 157 168 176 181 180 175 169 162 157 156 160 
165 173 181 188 191 190 185 176 165 154 147 145 148 155 163 168 168 164 156 145 135 128 126 130 140 155 171 185 195 198 191 178 157 132 105 80 58 41 30 22 19 17 17 16 15 13 11 8 5 2 1 0 0 0 0 0 0 0 0 0 
1 2 4 6 9 12 14 16 18 19 23 30 44 65 93 125 158 187 210 223 228 220 204 180 151 119 89 62 41 26 18 14 14 15 16 14 11 7 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 
12 27 47 75 105 135 162 184 200 208 211 207 197 181 161 137 111 87 65 48 36 28 22 18 14 10 5 3 2 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 8 12 15 16 
15 11 7 5 4 5 8 11 13 13 12 11 9 8 9 11 15 20 27 37 51 69 92 116 141 164 183 196 203 202 192 174 150 122 92 65 43 28 19 15 15 14 13 10 7 3 1 0 0 0 0 0 0 2 7 15 24 35 43 47 
45 39 28 18 9 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 4 4 4 3 2 1 0 0 1 3 5 6 7 5 4 2 1 0 0 1 3 4 5 7 8 11 15 23 33 48 65 86 105 120 129 130 
121 106 88 69 53 41 33 29 25 22 18 13 8 4 1 0 0 0 0 1 5 10 14 17 19 16 12 7 4 3 4 7 10 14 17 19 20 20 19 19 19 22 28 38 50 66 83 99 111 119 120 115 105 92 78 63 50 38 28 18 
11 6 2 0 0 2 11 27 52 84 122 158 190 213 225 227 218 202 179 152 123 94 68 47 30 19 13 10 8 7 5 3 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 8 
13 19 23 23 22 18 14 11 9 9 10 12 13 14 14 13 12 11 11 12 14 17 21 24 25 24 19 13 8 3 0 3 10 23 42 67 95 123 148 165 174 173 163 146 127 106 88 72 55 38 25 14 5 0 3 16 37 62 88 109 
116 107 83 57 33 14 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 5 9 12 17 22 29 39 53 69 84 97 104 103 95 82 66 49 35 23 14 8 5 2 1 0 0 0 
0 0 0 0 0 0 0 0 1 5 11 17 23 25 23 17 11 5 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 1 3 4 5 6 6 6 5 6 6 6 5 4 3 1 0 0 0 0 0 1 3 4 5 6 6 6 5 5 5 6 6 6 5 4 3 1 0 0 0 0 0 1 1 1 1 1 0 1 5 13 25 42 65 
90 115 137 155 164 166 162 153 142 130 120 113 109 107 108 111 114 116 116 114 108 100 89 77 63 49 37 27 21 18 18 19 20 17 14 9 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 1 3 4 5 6 7 7 6 5 4 3 1 0 0 0 0 0 0 0 0 0 0 0 0 1 7 20 41 68 102 137 169 196 214 224 224 216 201 184 167 152 141 136 135 135 136 134 130 123 115 107 102 100 102 108 116 124 130 135 
136 133 127 117 104 88 70 52 34 20 10 4 3 11 27 48 77 111 145 177 203 221 231 232 224 209 190 167 144 120 97 74 53 34 20 9 2 0 0 1 7 18 33 53 74 96 114 130 143 153 160 164 164 161 153 142 128 112 94 75 
56 41 27 18 13 11 12 17 23 31 39 47 54 59 61 62 63 63 65 68 70 69 64 55 42 28 16 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 11 26 47 72 100 128 151 171 186 197 203 203 195 181 160 134 
108 84 64 49 40 33 27 21 14 9 4 1 0 0 1 2 3 3 3 2 1 0 0 0 0 0 0 0 0 0 1 2 4 5 6 5 4 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 4 15 32 56 88 124 160 194 
223 243 254 254 244 226 203 178 154 132 115 100 89 77 63 48 33 20 11 8 12 22 35 50 64 77 85 89 89 84 76 64 50 37 24 14 6 2 0 0 0 0 0 0 1 3 5 6 6 6 5 4 4 6 9 13 16 16 16 13 
9 5 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 8 18 32 53 75 101 126 148 165 178 184 184 180 174 168 163 157 155 152 150 147 143 137 128 119 109 
99 92 87 85 87 92 100 109 118 126 130 132 128 120 108 94 79 64 49 36 24 14 7 2 0 0 0 0 0 0 0 0 0 0 0 0 0 5 18 37 62 93 125 155 180 201 218 230 238 240 237 229 218 205 192 180 169 161 152 143 
132 120 107 93 79 67 54 44 33 25 16 11 6 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 19 39 65 100 134 168 195 214 224 226 220 210 196 182 170 160 151 145 138 132 
124 117 109 103 99 98 99 103 108 112 114 115 114 113 112 111 111 109 103 93 80 64 46 30 17 8 3 0 0 0 0 0 0 0 0 0 0 0 0 6 19 37 60 91 121 149 175 197 216 229 236 234 226 209 186 160 133 107 84 64 
48 36 27 19 15 14 17 26 41 60 83 104 124 139 151 158 162 162 160 153 141 124 102 77 51 31 15 4 0 0 0 0 0 0 0 0 0 0 0 0 0 1 3 5 6 8 8 6 5 3 1 0 0 0 0 0 1 3 4 5 
5 4 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 7 12 18 24 28 30 30 27 22 16 11 6 2 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 1 2 3 4 3 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
1 4 7 10 13 13 10 7 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 11 23 40 63 88 114 140 164 185 201 212 214 210 
199 184 166 147 131 119 109 102 97 94 90 84 77 66 53 39 25 14 5 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 1 2 2 2 2 1 0 1 5 15 27 45 65 88 109 129 147 165 180 191 199 202 198 185 165 140 114 89 70 57 51 47 43 38 31 21 13 6 2 0 0 0 0 0 0 0 0 0 0 1 5 12 20 
30 39 47 51 53 54 55 55 57 59 62 66 69 71 73 74 72 70 66 63 61 60 62 66 70 74 74 69 59 48 35 26 24 30 44 62 81 95 100 95 78 56 36 18 6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
0 2 7 14 23 34 46 58 71 85 103 121 142 160 177 190 198 199 195 186 172 155 138 121 106 93 84 76 69 63 58 53 48 43 38 34 31 29 28 27 28 29 32 37 43 50 59 68 78 88 98 108 113 116 114 109 99 88 76 63 
51 40 31 22 15 10 5 2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 9 22 39 62 87 112 136 155 171 183 191 195 195 191 185 177 168 158 146 135 122 111 100 93 90 92 98 106 
116 121 123 120 111 100 90 81 74 70 68 64 59 51 40 27 17 9 2 0 0 0 0 0 0 0 0 0 0 0 1 9 21 39 61 86 110 132 153 170 184 194 198 195 185 168 144 118 91 66 47 34 26 24 22 20 16 12 7 3 
1 1 3 5 6 6 5 3 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 3 5 8 13 21 32 46 62 76 88 94 96 92 87 81 77 76 79 85 92 99 103 104 100 93 85 76 69 63 59 55 49 42 32 22 
13 6 1 0 1 5 10 17 25 32 39 43 46 47 47 45 42 37 32 26 20 16 14 14 14 14 14 11 8 5 2 0 0 0 0 0 0 1 2 3 4 3 2 1 0 0 0 0 0 0 0 0 0 0 1 4 9 17 29 43 
58 74 91 107 120 129 134 134 129 120 107 91 73 56 40 27 17 11 8 5 3 2 1 0 0 0 0 0 0 0 0 0 0 0 3 11 23 38 58 79 99 115 128 136 140 138 132 125 117 109 104 100 98 97 96 94 92 87 82 74 
65 54 42 30 19 10 4 2 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 7 17 31 50 70 90 107 120 130 137 143 145 146 146 143 137 131 123 115 106 98 92 86 
82 79 75 71 66 60 55 51 50 50 52 54 56 55 52 47 40 32 24 16 9 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 2 2 2 2 1 0 0 0 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 9 19 33 51 70 88 105 119 129 135 137 137 134 130 125 120 115 111 108 104 101 97 94 91 88 86 83 80 76 71 65 58 51 44 38 34 30 29 29 32 36 40 45 50 56 
60 64 66 65 62 57 50 41 34 27 23 22 24 28 31 34 36 36 36 35 35 35 36 36 36 34 29 24 19 17 18 25 38 54 73 91 108 121 131 137 140 139 136 131 124 116 109 104 100 99 101 103 105 106 103 98 90 79 65 50 
34 21 10 3 0 0 0 4 9 15 21 26 29 27 24 21 18 18 21 27 34 43 49 54 55 56 55 56 57 59 62 63 64 65 65 65 65 65 63 62 59 56 52 48 42 36 29 22 18 16 17 23 33 44 56 66 71 73 71 65 
57 46 35 24 14 7 2 0 0 0 0 1 4 7 11 14 16 15 13 12 13 14 19 26 34 43 53 64 74 82 90 94 96 95 92 85 76 65 54 43 35 28 25 22 19 17 13 10 6 3 1 0 0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 4 10 19 28 37 43 45 40 30 22 12 4 5 22 35
);

is_deeply(\@trace,\@array);

is (8853, $abi->get_trace_length());
#print STDERR $abi->get_trace_length();

#my $abi1 = ABI->new("t/TEST_modified.abi");

is(734, $abi->get_corrected_sequence_length());
@base_calls = $abi->get_corrected_base_calls();
@b_calls =
  qw(20 33 46 52 56 67 82 89 102 111 124 136 151 163 174 185 192 204 215
  225 233 246 258 274 285 297 308 324 340 349 356 369 383 393 403 413
  422 434 447 458 467 477 487 499 513 523 529 544 552 562 570 581 593
  603 615 624 634 644 657 668 680 690 702 714 726 736 746 756 766 776
  784 796 808 820 830 842 854 863 874 884 897 906 918 930 940 949 960
  972 983 996 1005 1017 1027 1039 1049 1063 1074 1086 1097 1109 1117 1131
  1143 1153 1163 1174 1186 1196 1208 1218 1232 1243 1255 1266 1278 1288
  1298 1310 1323 1333 1345 1357 1368 1380 1392 1402 1413 1425 1436 1448
  1459 1469 1481 1493 1504 1513 1524 1537 1547 1559 1570 1583 1595 1606
  1616 1629 1638 1650 1664 1673 1684 1694 1704 1716 1727 1737 1749 1761
  1774 1786 1796 1810 1820 1834 1844 1855 1865 1874 1887 1900 1913 1926
  1937 1946 1958 1970 1983 1994 2007 2019 2029 2040 2055 2066 2075 2088
  2102 2112 2121 2134 2146 2159 2169 2180 2192 2206 2218 2230 2239 2254
  2264 2276 2286 2302 2314 2323 2338 2350 2360 2371 2382 2395 2408 2418
  2432 2442 2454 2467 2479 2489 2502 2516 2528 2540 2551 2565 2574 2587
  2598 2610 2621 2634 2644 2656 2667 2682 2693 2705 2716 2727 2740 2753
  2766 2778 2790 2803 2816 2827 2838 2852 2865 2876 2887 2898 2912 2924
  2934 2945 2957 2969 2982 2992 3005 3016 3028 3040 3053 3065 3075 3091
  3103 3115 3128 3138 3151 3164 3176 3189 3201 3214 3226 3237 3251 3262
  3276 3285 3299 3313 3322 3337 3350 3360 3373 3385 3398 3410 3423 3435
  3445 3460 3472 3484 3496 3509 3520 3531 3544 3557 3569 3581 3593 3604
  3615 3628 3640 3653 3664 3674 3687 3700 3714 3725 3739 3751 3763 3773
  3787 3797 3810 3821 3834 3847 3859 3871 3883 3897 3909 3921 3935 3946
  3959 3970 3982 3994 4007 4019 4031 4044 4057 4069 4078 4091 4101 4116
  4127 4142 4154 4166 4176 4190 4202 4215 4227 4240 4252 4265 4277 4288
  4301 4313 4326 4337 4351 4362 4373 4385 4397 4410 4422 4436 4448 4459
  4471 4484 4497 4508 4523 4535 4545 4558 4569 4582 4596 4608 4621 4633
  4645 4656 4670 4681 4695 4708 4719 4733 4744 4755 4768 4781 4794 4806
  4819 4830 4842 4856 4867 4880 4891 4902 4915 4928 4941 4954 4966 4979
  4991 5002 5016 5027 5039 5052 5065 5077 5089 5103 5115 5128 5139 5153
  5166 5177 5190 5203 5214 5225 5238 5251 5262 5274 5285 5298 5310 5323
  5336 5348 5360 5372 5386 5399 5412 5423 5437 5450 5462 5473 5488 5499
  5510 5523 5535 5547 5558 5570 5584 5596 5609 5622 5635 5646 5658 5670
  5681 5692 5706 5718 5732 5744 5756 5770 5782 5797 5810 5822 5835 5847
  5860 5872 5884 5897 5908 5921 5934 5948 5959 5971 5983 5996 6008 6020
  6033 6046 6059 6072 6085 6096 6110 6123 6134 6149 6161 6172 6187 6200
  6210 6224 6235 6248 6259 6272 6285 6299 6312 6324 6339 6352 6364 6375
  6389 6402 6414 6426 6439 6451 6463 6477 6489 6502 6513 6528 6541 6554
  6568 6580 6593 6603 6617 6632 6644 6658 6671 6682 6695 6709 6721 6734
  6747 6758 6770 6783 6795 6807 6820 6833 6845 6858 6871 6884 6895 6908
  6920 6934 6947 6960 6972 6985 6996 7011 7024 7038 7051 7063 7077 7088
  7100 7115 7127 7140 7151 7162 7176 7191 7203 7220 7230 7241 7254 7267
  7279 7294 7307 7322 7335 7347 7361 7371 7383 7395 7410 7423 7434 7450
  7461 7473 7487 7499 7510 7520 7533 7548 7559 7570 7583 7597 7610 7622
  7637 7653 7663 7673 7684 7699 7711 7723 7735 7747 7761 7774 7789 7801
  7813 7828 7838 7851 7864 7876 7888 7901 7917 7930 7941 7954 7967 7980
  7995 8008 8020 8032 8043 8054 8065 8074 8086 8099 8112 8126 8140 8153
  8164 8177 8188 8202 8211 8221 8230 8239 8249 8262 8274 8287 8301 8315
  8326 8342 8354 8366 8378 8391 8406 8419 8431 8443 8456 8471 8481 8490
  8499 8508 8519 8530 8541 8552 8566 8579 8592 8604 8616 8629 8642 8655
  8668 8680 8693 8708 8723 8734 8745 8756 8769 8780 8792 8804 8814 8829
  8842 8851);

is_deeply (\@b_calls,\@base_calls); 
$seq = "cgcNtGACGCNCCTTACGCAAATCTCGNCACGAACCTTCCCCTGAAGAAATTGCCAATCTGC
 TCGAAAAACCCGTCGCAGAGGTCAAGCGCATGCTTGGACTGAATGAGCGGGTGTCCTCGGTG
 GATGTTTCTTTAGGCCCTGATTCCGATAAAACCCTGCTCGATACCCTGACAGATGATCGACCT
 ACAGATCCTTGCTAGCTGCTTCAGGACGATGACCTGTCGCAAAGTATCGATCAGTGGTTGTCT
 GAACTTACAGACAAGCAGCGTGAGGTGGTGATTCGCCGCTTCGGGTTGCGTGGTCATGAAAGC
 AGTACCCTCGAAGATGTTGGTCTGGAGATTGGTCTGACACGCGAACGTGTTCGGCAGATTCAA
 GTCGAGGGGCTCAAGCGTTTGCGCGAGATCCTTGAGCGCAACGGTTTGTCCAGTGAGTCGCTG
 TTTCAGTAACAGGCATCCTGCTCGCTAAAAAGCCCCGAAATATTCGGGGCTTTTTTGTGCCCG
 CAGAATCTGGACCGCTGCTGCCAAGGGGTTTTTTTGAGTGCGTGCGGGTGACCGGTCAGTCTC
 AAAAGTGCAGTCAGGCAGGGGTTGGAACTTTATCTGTCATGGGCTGTAAGCCTTTGCTTACCT
 TTNATGTAAGCCAAGGGCGAAAACAGGCTTGCGGATAGNTTCGCTTCTGACTTTTCATAGGTT
 GNAACTGATTGAAATTTAAACATTNTNATTGTTNTGNTAAGAN";
$seq =~ s/\n//g;
$seq =~ s/\s//g;

is ($seq,$abi->get_corrected_sequence);

#print STDERR "\n", $abi->{_index},"\n";
#print STDERR "\n", $abi->{_seq_length_corrected},"\n";
#print "@array", "\n";

#ok(1); # If we made it this far, we're ok.
#########################
# Insert your test code below, the Test module is use()ed here so read
# its man page ( perldoc Test ) for help writing this test script.
