/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.generic;

import java.io.Serializable;
import java.util.Objects;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.reflect.generic.ValueComparisonStrategy;
import org.apache.cayenne.reflect.generic.ValueComparisonStrategyFactory;

public class DefaultValueComparisonStrategyFactory
implements ValueComparisonStrategyFactory {
    private static final ValueComparisonStrategy<Object> DEFAULT_STRATEGY = new DefaultValueComparisonStrategy();
    private final ValueObjectTypeRegistry valueObjectTypeRegistry;

    public DefaultValueComparisonStrategyFactory(@Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        this.valueObjectTypeRegistry = valueObjectTypeRegistry;
    }

    @Override
    public ValueComparisonStrategy<Object> getStrategy(ObjAttribute attribute) {
        ValueObjectType<?, ?> valueObjectType = this.valueObjectTypeRegistry.getValueType(attribute.getJavaClass());
        if (valueObjectType == null) {
            return DEFAULT_STRATEGY;
        }
        return new ValueObjectTypeComparisonStrategy(valueObjectType);
    }

    static class DefaultValueComparisonStrategy
    implements ValueComparisonStrategy<Object>,
    Serializable {
        DefaultValueComparisonStrategy() {
        }

        @Override
        public boolean equals(Object a, Object b) {
            return Objects.equals(a, b);
        }
    }

    static class ValueObjectTypeComparisonStrategy
    implements ValueComparisonStrategy<Object>,
    Serializable {
        private final ValueObjectType valueObjectType;

        public ValueObjectTypeComparisonStrategy(ValueObjectType<?, ?> valueObjectType) {
            this.valueObjectType = valueObjectType;
        }

        @Override
        public boolean equals(Object value1, Object value2) {
            return this.valueObjectType.equals(value1, value2);
        }
    }
}

