/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.wrapper.ObjAttributeWrapper;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.CellEditorForAttributeTable;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.util.Util;

public class ObjAttributeTableModel
extends CayenneTableModel<ObjAttributeWrapper> {
    public static final int OBJ_ATTRIBUTE = 0;
    public static final int OBJ_ATTRIBUTE_TYPE = 1;
    public static final int DB_ATTRIBUTE = 2;
    public static final int DB_ATTRIBUTE_TYPE = 3;
    public static final int LOCKING = 4;
    public static final int LAZY = 5;
    public static final int COMMENT = 6;
    public static final int COLUMN_COUNT = 7;
    private ObjEntity entity;
    private DbEntity dbEntity;
    private CellEditorForAttributeTable cellEditor;
    private CayenneTable table;

    public ObjAttributeTableModel(ObjEntity entity, ProjectController mediator, Object eventSource) {
        super(mediator, eventSource, ObjAttributeTableModel.wrapObjAttributes(entity.getAttributes()));
        this.entity = entity;
        this.dbEntity = entity.getDbEntity();
        Collections.sort(this.objectList, new AttributeComparator());
    }

    private static List<ObjAttributeWrapper> wrapObjAttributes(Collection<ObjAttribute> attributes) {
        ArrayList<ObjAttributeWrapper> wrappedAttributes = new ArrayList<ObjAttributeWrapper>();
        for (ObjAttribute attr : attributes) {
            wrappedAttributes.add(new ObjAttributeWrapper(attr));
        }
        return wrappedAttributes;
    }

    protected void orderList() {
    }

    public CayenneTable getTable() {
        return this.table;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 4: 
            case 5: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Class<?> getElementsClass() {
        return ObjAttributeWrapper.class;
    }

    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    public ObjAttributeWrapper getAttribute(int row) {
        return row >= 0 && row < this.objectList.size() ? (ObjAttributeWrapper)this.objectList.get(row) : null;
    }

    public void resetDbEntity() {
        if (this.dbEntity == this.entity.getDbEntity()) {
            return;
        }
        boolean wasShowing = this.isShowingDb();
        this.dbEntity = this.entity.getDbEntity();
        boolean isShowing = this.isShowingDb();
        if (wasShowing != isShowing) {
            this.fireTableStructureChanged();
        }
        this.fireTableDataChanged();
    }

    private boolean isShowingDb() {
        return this.dbEntity != null;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Java Type";
            }
            case 2: {
                return "DbAttribute Path";
            }
            case 3: {
                return "DB Type";
            }
            case 4: {
                return "Used for Locking";
            }
            case 5: {
                return "Lazy loading";
            }
            case 6: {
                return "Comment";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        ObjAttributeWrapper attribute = this.getAttribute(row);
        DbAttribute dbAttribute = attribute.getDbAttribute();
        switch (column) {
            case 0: {
                return attribute.getName();
            }
            case 1: {
                return attribute.getType();
            }
            case 2: {
                return this.getDBAttribute(attribute, dbAttribute);
            }
            case 3: {
                return this.getDBAttributeType(attribute, dbAttribute);
            }
            case 4: {
                return attribute.isUsedForLocking();
            }
            case 5: {
                return attribute.isLazy();
            }
            case 6: {
                return this.getComment(attribute.getValue());
            }
        }
        return null;
    }

    private String getDBAttribute(ObjAttributeWrapper attribute, DbAttribute dbAttribute) {
        if (dbAttribute == null) {
            if (!attribute.isInherited() && attribute.getEntity().isAbstract()) {
                return attribute.getDbAttributePath();
            }
            return null;
        }
        if (attribute.getDbAttributePath() != null && attribute.getDbAttributePath().contains(".")) {
            return attribute.getDbAttributePath();
        }
        return dbAttribute.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDBAttributeType(ObjAttributeWrapper attribute, DbAttribute dbAttribute) {
        int type;
        if (dbAttribute == null) {
            if (attribute.getValue() instanceof EmbeddedAttribute) return null;
            try {
                type = TypesMapping.getSqlTypeByJava(attribute.getJavaClass());
                return TypesMapping.getSqlNameByType(type);
            }
            catch (CayenneRuntimeException cre) {
                return null;
            }
        } else {
            type = dbAttribute.getType();
        }
        return TypesMapping.getSqlNameByType(type);
    }

    public CellEditorForAttributeTable setCellEditor(Collection<String> nameAttr, CayenneTable table) {
        this.cellEditor = new CellEditorForAttributeTable(table, Application.getWidgetFactory().createComboBox(nameAttr, true));
        this.table = table;
        return this.cellEditor;
    }

    public CellEditorForAttributeTable getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public void resetModel() {
        for (ObjAttributeWrapper attribute : this.objectList) {
            attribute.resetEdits();
        }
    }

    @Override
    public boolean isValid() {
        for (ObjAttributeWrapper attribute : this.getObjectList()) {
            if (attribute.isValid()) continue;
            return false;
        }
        return true;
    }

    private void setObjAttribute(ObjAttributeWrapper attribute, Object value) {
        attribute.setName(value != null ? value.toString().trim() : null);
        if (attribute.isValid()) {
            attribute.commitEdits();
        }
    }

    private void setObjAttributeType(ObjAttributeWrapper attribute, Object value) {
        ObjAttribute attributeNew;
        String oldType = attribute.getType();
        String newType = value != null ? value.toString() : null;
        attribute.setType(newType);
        if (oldType == null || newType == null) {
            return;
        }
        String[] registeredTypes = ModelerUtil.getRegisteredTypeNames();
        List<String> registeredTypesList = Arrays.asList(registeredTypes);
        if (registeredTypesList.contains(oldType) == registeredTypesList.contains(newType)) {
            return;
        }
        ObjEntity entity = attribute.getEntity();
        if (registeredTypesList.contains(newType) || !this.mediator.getEmbeddableNamesInCurrentDataDomain().contains(newType)) {
            attributeNew = new ObjAttribute();
            attributeNew.setDbAttributePath(attribute.getDbAttributePath());
        } else {
            attributeNew = new EmbeddedAttribute();
            attributeNew.setDbAttributePath(null);
        }
        attributeNew.setName(attribute.getName());
        attributeNew.setEntity(entity);
        attributeNew.setParent(attribute.getParent());
        attributeNew.setType(attribute.getType());
        attributeNew.setUsedForLocking(attribute.isUsedForLocking());
        attributeNew.setLazy(attribute.isLazy());
        entity.updateAttribute(attributeNew);
        this.mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity, 1));
        this.mediator.fireObjEntityDisplayEvent(new EntityDisplayEvent((Object)this, this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode()));
        this.mediator.fireObjAttributeEvent(new AttributeEvent((Object)this, (Attribute)attributeNew, (Entity)entity, 1));
        this.mediator.fireObjAttributeDisplayEvent(new AttributeDisplayEvent((Object)this, attributeNew, (Entity)this.mediator.getCurrentObjEntity(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode()));
    }

    private void setColumnLocking(ObjAttributeWrapper attribute, Object value) {
        attribute.setUsedForLocking(value instanceof Boolean && (Boolean)value != false);
    }

    private void setColumnLazy(ObjAttributeWrapper attribute, Object value) {
        attribute.setLazy(value instanceof Boolean && (Boolean)value != false);
    }

    private void setDbAttribute(ObjAttributeWrapper attribute, Object value) {
        if (value != null) {
            if (ProjectUtil.isDbAttributePathCorrect(this.dbEntity, value.toString())) {
                attribute.setDbAttributePath(value.toString());
            } else {
                attribute.setDbAttributePath(null);
            }
        } else if (attribute.getDbAttribute() != null) {
            attribute.setDbAttributePath(null);
        }
    }

    @Override
    public void setUpdatedValueAt(Object value, int row, int column) {
        ObjAttributeWrapper attribute = this.getAttribute(row);
        attribute.resetEdits();
        AttributeEvent event = new AttributeEvent(this.eventSource, attribute.getValue(), this.entity);
        switch (column) {
            case 0: {
                event.setOldName(attribute.getName());
                this.setObjAttribute(attribute, value);
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 1: {
                this.setObjAttributeType(attribute, value);
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 2: {
                this.setDbAttribute(attribute, value);
                this.fireTableRowsUpdated(row, row);
                break;
            }
            case 4: {
                this.setColumnLocking(attribute, value);
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 5: {
                this.setColumnLazy(attribute, value);
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 6: {
                this.setComment((String)value, attribute.getValue());
            }
            default: {
                this.fireTableRowsUpdated(row, row);
            }
        }
        this.mediator.fireObjAttributeEvent(event);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.getAttribute(row).isInherited()) {
            return col == 2;
        }
        return col != 3;
    }

    public ObjEntity getEntity() {
        return this.entity;
    }

    @Override
    public void sortByColumn(int sortCol, boolean isAscent) {
        switch (sortCol) {
            case 0: {
                this.sortByElementProperty("name", isAscent);
                break;
            }
            case 1: {
                this.sortByElementProperty("type", isAscent);
                break;
            }
            case 4: {
                this.sortByElementProperty("usedForLocking", isAscent);
                break;
            }
            case 5: {
                this.sortByElementProperty("lazy", isAscent);
                break;
            }
            case 2: 
            case 3: {
                Collections.sort(this.objectList, new ObjAttributeTableComparator(sortCol));
                if (isAscent) break;
                Collections.reverse(this.objectList);
            }
        }
    }

    private String getComment(ObjAttribute attr) {
        return ObjectInfo.getFromMetaData(this.mediator.getApplication().getMetaData(), attr, "comment");
    }

    private void setComment(String newVal, ObjAttribute attr) {
        ObjectInfo.putToMetaData(this.mediator.getApplication().getMetaData(), attr, "comment", newVal);
    }

    @Override
    public boolean isColumnSortable(int sortCol) {
        return true;
    }

    private class ObjAttributeTableComparator
    implements Comparator<ObjAttributeWrapper> {
        private int sortCol;

        public ObjAttributeTableComparator(int sortCol) {
            this.sortCol = sortCol;
        }

        @Override
        public int compare(ObjAttributeWrapper o1, ObjAttributeWrapper o2) {
            Integer compareObjAttributesVal = this.compareObjAttributes(o1, o2);
            if (compareObjAttributesVal != null) {
                return compareObjAttributesVal;
            }
            String valToCompare1 = ObjAttributeTableModel.this.getDBAttribute(o1, o1.getDbAttribute());
            String valToCompare2 = ObjAttributeTableModel.this.getDBAttribute(o2, o2.getDbAttribute());
            switch (this.sortCol) {
                case 2: {
                    valToCompare1 = ObjAttributeTableModel.this.getDBAttribute(o1, o1.getDbAttribute());
                    valToCompare2 = ObjAttributeTableModel.this.getDBAttribute(o2, o2.getDbAttribute());
                    break;
                }
                case 3: {
                    valToCompare1 = ObjAttributeTableModel.this.getDBAttributeType(o1, o1.getDbAttribute());
                    valToCompare2 = ObjAttributeTableModel.this.getDBAttributeType(o2, o2.getDbAttribute());
                    break;
                }
            }
            return valToCompare1 == null ? -1 : (valToCompare2 == null ? 1 : valToCompare1.compareTo(valToCompare2));
        }

        private Integer compareObjAttributes(ObjAttributeWrapper o1, ObjAttributeWrapper o2) {
            if (o1 == null && o2 == null || o1 == o2) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            return null;
        }
    }

    final class AttributeComparator
    implements Comparator {
        AttributeComparator() {
        }

        public int compare(Object o1, Object o2) {
            ObjAttribute a1 = ((ObjAttributeWrapper)o1).getValue();
            ObjAttribute a2 = ((ObjAttributeWrapper)o2).getValue();
            int delta = this.getWeight(a1) - this.getWeight(a2);
            return delta != 0 ? delta : Util.nullSafeCompare(true, a1.getName(), a2.getName());
        }

        private int getWeight(Attribute a) {
            return a.getEntity() == ObjAttributeTableModel.this.entity ? 1 : -1;
        }
    }
}

