/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.ParameterisedAddress;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTemporaryTopic;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jndi.JNDIStorable;
import org.apache.activemq.artemis.utils.DestinationUtil;

public class ActiveMQDestination
extends JNDIStorable
implements Destination,
Serializable {
    private static final long serialVersionUID = 5027962425462382883L;
    public static final String QUEUE_QUALIFIED_PREFIX = "queue://";
    public static final String TOPIC_QUALIFIED_PREFIX = "topic://";
    public static final String TEMP_QUEUE_QUALIFED_PREFIX = "temp-queue://";
    public static final String TEMP_TOPIC_QUALIFED_PREFIX = "temp-topic://";
    private SimpleString simpleAddress;
    private QueueConfiguration queueConfiguration;
    @Deprecated
    private String address;
    private String name;
    private final boolean temporary;
    private final boolean queue;
    private transient TYPE thetype;
    private final transient ActiveMQSession session;
    private transient boolean created;

    void setName(String name) {
        this.name = name;
    }

    public static ActiveMQDestination createDestination(RoutingType routingType, SimpleString address) {
        if (address == null) {
            return null;
        }
        if (RoutingType.ANYCAST.equals((Object)routingType)) {
            return ActiveMQDestination.createQueue(address);
        }
        if (RoutingType.MULTICAST.equals((Object)routingType)) {
            return ActiveMQDestination.createTopic(address);
        }
        return ActiveMQDestination.fromPrefixedName(address.toString());
    }

    public static ActiveMQDestination createDestination(String name, TYPE defaultType) {
        if (name.startsWith(QUEUE_QUALIFIED_PREFIX)) {
            return new ActiveMQQueue(name.substring(QUEUE_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TOPIC_QUALIFIED_PREFIX)) {
            return new ActiveMQTopic(name.substring(TOPIC_QUALIFIED_PREFIX.length()));
        }
        if (name.startsWith(TEMP_QUEUE_QUALIFED_PREFIX)) {
            return new ActiveMQQueue(name.substring(TEMP_QUEUE_QUALIFED_PREFIX.length()), true);
        }
        if (name.startsWith(TEMP_TOPIC_QUALIFED_PREFIX)) {
            return new ActiveMQTopic(name.substring(TEMP_TOPIC_QUALIFED_PREFIX.length()), true);
        }
        return switch (defaultType) {
            case TYPE.QUEUE -> new ActiveMQQueue(name);
            case TYPE.TOPIC -> new ActiveMQTopic(name);
            case TYPE.TEMP_QUEUE -> new ActiveMQQueue(name, true);
            case TYPE.TEMP_TOPIC -> new ActiveMQTopic(name, true);
            case TYPE.DESTINATION -> new ActiveMQDestination(name, TYPE.DESTINATION, null);
            default -> throw new IllegalArgumentException("Invalid default destination type: " + String.valueOf((Object)defaultType));
        };
    }

    public static ActiveMQDestination fromPrefixedName(String name) {
        return ActiveMQDestination.fromPrefixedName(name, name);
    }

    public static ActiveMQDestination fromPrefixedName(String addr, String name) {
        ActiveMQDestination destination;
        if (addr.startsWith(QUEUE_QUALIFIED_PREFIX)) {
            String address = addr.substring(QUEUE_QUALIFIED_PREFIX.length());
            destination = ActiveMQDestination.createQueue(address);
        } else if (addr.startsWith(TOPIC_QUALIFIED_PREFIX)) {
            String address = addr.substring(TOPIC_QUALIFIED_PREFIX.length());
            destination = ActiveMQDestination.createTopic(address);
        } else if (addr.startsWith(TEMP_QUEUE_QUALIFED_PREFIX)) {
            String address = addr.substring(TEMP_QUEUE_QUALIFED_PREFIX.length());
            destination = new ActiveMQTemporaryQueue(address, null);
        } else if (addr.startsWith(TEMP_TOPIC_QUALIFED_PREFIX)) {
            String address = addr.substring(TEMP_TOPIC_QUALIFED_PREFIX.length());
            destination = new ActiveMQTemporaryTopic(address, null);
        } else {
            destination = new ActiveMQDestination(addr, TYPE.DESTINATION, null);
        }
        return destination;
    }

    public static Destination fromPrefixed1XName(String addr, String name) {
        ActiveMQDestination destination = addr.startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString()) ? ActiveMQDestination.createQueue(addr) : (addr.startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString()) ? ActiveMQDestination.createTopic(addr) : (addr.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString()) ? new ActiveMQTemporaryQueue(addr, null) : (addr.startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString()) ? new ActiveMQTemporaryTopic(addr, null) : new ActiveMQDestination(addr, TYPE.DESTINATION, null))));
        String unprefixedName = name;
        if (name.startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString())) {
            unprefixedName = name.substring(PacketImpl.OLD_QUEUE_PREFIX.length());
        } else if (name.startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString())) {
            unprefixedName = name.substring(PacketImpl.OLD_TOPIC_PREFIX.length());
        } else if (name.startsWith(PacketImpl.OLD_TEMP_QUEUE_PREFIX.toString())) {
            unprefixedName = name.substring(PacketImpl.OLD_TEMP_QUEUE_PREFIX.length());
        } else if (name.startsWith(PacketImpl.OLD_TEMP_TOPIC_PREFIX.toString())) {
            unprefixedName = name.substring(PacketImpl.OLD_TEMP_TOPIC_PREFIX.length());
        }
        destination.setName(unprefixedName);
        return destination;
    }

    public static SimpleString createQueueNameForSubscription(boolean isDurable, String clientID, String subscriptionName) {
        return DestinationUtil.createQueueNameForSubscription((boolean)isDurable, (String)clientID, (String)subscriptionName);
    }

    public static String createQueueNameForSharedSubscription(boolean isDurable, String clientID, String subscriptionName) {
        return DestinationUtil.createQueueNameForSharedSubscription((boolean)isDurable, (String)clientID, (String)subscriptionName);
    }

    public static Pair<String, String> decomposeQueueNameForDurableSubscription(String queueName) {
        StringBuilder[] parts = new StringBuilder[2];
        int currentPart = 0;
        parts[0] = new StringBuilder();
        parts[1] = new StringBuilder();
        int pos = 0;
        while (pos < queueName.length()) {
            char ch = queueName.charAt(pos);
            ++pos;
            if (ch == '.') {
                if (++currentPart < parts.length) continue;
                throw new JMSRuntimeException("Invalid message queue name: " + queueName);
            }
            if (ch == '\\') {
                if (pos >= queueName.length()) {
                    throw new JMSRuntimeException("Invalid message queue name: " + queueName);
                }
                ch = queueName.charAt(pos);
                ++pos;
            }
            parts[currentPart].append(ch);
        }
        if (currentPart != 1) {
            parts[1] = parts[0];
            parts[0] = new StringBuilder();
        }
        Pair pair = new Pair((Object)parts[0].toString(), (Object)parts[1].toString());
        return pair;
    }

    public static SimpleString createQueueAddressFromName(String name) {
        return SimpleString.of((String)(QUEUE_QUALIFIED_PREFIX + name));
    }

    public static SimpleString createTopicAddressFromName(String name) {
        return SimpleString.of((String)(TOPIC_QUALIFIED_PREFIX + name));
    }

    public static ActiveMQQueue createQueue(String address) {
        return new ActiveMQQueue(address);
    }

    public static ActiveMQQueue createQueue(SimpleString address) {
        return new ActiveMQQueue(address);
    }

    public static ActiveMQQueue createQueue(String address, String name) {
        return new ActiveMQQueue(address, name);
    }

    public static ActiveMQTopic createTopic(String address) {
        return new ActiveMQTopic(address);
    }

    public static ActiveMQTopic createTopic(SimpleString address) {
        return new ActiveMQTopic(address);
    }

    public static ActiveMQTopic createTopic(String address, String name) {
        return new ActiveMQTopic(address, name);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(String address, ActiveMQSession session) {
        return new ActiveMQTemporaryQueue(address, session);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(String address) {
        return ActiveMQDestination.createTemporaryQueue(address, null);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(ActiveMQSession session) {
        String address = UUID.randomUUID().toString();
        return ActiveMQDestination.createTemporaryQueue(address, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(ActiveMQSession session) {
        String address = UUID.randomUUID().toString();
        return ActiveMQDestination.createTemporaryTopic(address, session);
    }

    public static ActiveMQTemporaryQueue createTemporaryQueue(ActiveMQSession session, String prefix) {
        String name = UUID.randomUUID().toString();
        String address = prefix + name;
        ActiveMQTemporaryQueue queue = ActiveMQDestination.createTemporaryQueue(address, session);
        queue.setName(name);
        return queue;
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(ActiveMQSession session, String prefix) {
        String name = UUID.randomUUID().toString();
        String address = prefix + name;
        ActiveMQTemporaryTopic topic = ActiveMQDestination.createTemporaryTopic(address, session);
        topic.setName(name);
        return topic;
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(String address, ActiveMQSession session) {
        return new ActiveMQTemporaryTopic(address, session);
    }

    public static ActiveMQTemporaryTopic createTemporaryTopic(String address) {
        return ActiveMQDestination.createTemporaryTopic(address, null);
    }

    protected ActiveMQDestination(String address, TYPE type, ActiveMQSession session) {
        this(SimpleString.of((String)address), type, session);
    }

    protected ActiveMQDestination(SimpleString address, TYPE type, ActiveMQSession session) {
        if (address != null) {
            this.setSimpleAddress(address);
        }
        this.thetype = type;
        this.session = session;
        this.temporary = TYPE.isTemporary(type);
        this.queue = TYPE.isQueue(type);
    }

    protected ActiveMQDestination(String address, String name, TYPE type, ActiveMQSession session) {
        this(SimpleString.of((String)address), name, type, session);
    }

    @Deprecated
    protected ActiveMQDestination(SimpleString address, String name, TYPE type, ActiveMQSession session) {
        this(address, type, session);
        this.name = name;
        this.address = Objects.toString(this.simpleAddress, null);
    }

    public void setAddress(String address) {
        this.setSimpleAddress(SimpleString.of((String)address));
    }

    public String toString() {
        return "ActiveMQDestination [address=" + this.simpleAddress.toString() + ", name=" + this.name + ", type =" + String.valueOf((Object)this.thetype) + "]";
    }

    public void setSimpleAddress(SimpleString address) {
        if (address == null) {
            throw new IllegalArgumentException("address cannot be null");
        }
        if (ParameterisedAddress.isParameterised((SimpleString)address)) {
            ParameterisedAddress parameteredAddress = new ParameterisedAddress(address);
            this.simpleAddress = parameteredAddress.getAddress();
            this.address = parameteredAddress.getAddress().toString();
            this.queueConfiguration = parameteredAddress.getQueueConfiguration();
        } else {
            this.simpleAddress = address;
            this.address = address.toString();
            this.queueConfiguration = null;
        }
    }

    public void setSimpleAddress(String address) {
        this.setSimpleAddress(SimpleString.of((String)address));
    }

    public void delete() throws JMSException {
        if (this.session != null) {
            boolean openedHere = false;
            ActiveMQSession sessionToUse = this.session;
            if (this.session.getCoreSession().isClosed()) {
                sessionToUse = (ActiveMQSession)this.session.getConnection().createSession();
                openedHere = true;
            }
            try {
                if (this.isQueue()) {
                    sessionToUse.deleteTemporaryQueue(this);
                } else {
                    sessionToUse.deleteTemporaryTopic(this);
                }
                this.setCreated(false);
            }
            finally {
                if (openedHere) {
                    sessionToUse.close();
                }
            }
        }
    }

    public boolean isQueue() {
        return this.queue;
    }

    public String getAddress() {
        return Objects.toString(this.simpleAddress, null);
    }

    public SimpleString getSimpleAddress() {
        return this.simpleAddress;
    }

    @Deprecated
    public QueueAttributes getQueueAttributes() {
        return QueueAttributes.fromQueueConfiguration((QueueConfiguration)this.queueConfiguration);
    }

    public QueueConfiguration getQueueConfiguration() {
        return this.queueConfiguration;
    }

    public String getName() {
        return this.name != null ? this.name : this.getAddress();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean getCreated() {
        return this.created;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }

    public void setCreated(String created) {
        this.created = Boolean.parseBoolean(created);
    }

    public TYPE getType() {
        if (this.thetype == null) {
            this.thetype = this.temporary ? (this.isQueue() ? TYPE.TEMP_QUEUE : TYPE.TEMP_TOPIC) : (this.isQueue() ? TYPE.QUEUE : TYPE.TOPIC);
        }
        return this.thetype;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ActiveMQDestination)) {
            return false;
        }
        ActiveMQDestination other = (ActiveMQDestination)obj;
        return Objects.equals(this.simpleAddress, other.simpleAddress);
    }

    public int hashCode() {
        return this.simpleAddress.hashCode();
    }

    @Override
    protected void buildFromProperties(Properties props) {
        this.setAddress(props.getProperty("address"));
    }

    @Override
    protected void populateProperties(Properties props) {
        props.put("address", this.getAddress());
    }

    public static enum TYPE {
        QUEUE,
        TOPIC,
        TEMP_QUEUE,
        TEMP_TOPIC,
        DESTINATION;


        public byte getType() {
            return switch (this) {
                case QUEUE -> 0;
                case TOPIC -> 1;
                case TEMP_QUEUE -> 2;
                case TEMP_TOPIC -> 3;
                case DESTINATION -> 4;
                default -> -1;
            };
        }

        public static TYPE getType(byte type) {
            return switch (type) {
                case 0 -> QUEUE;
                case 1 -> TOPIC;
                case 2 -> TEMP_QUEUE;
                case 3 -> TEMP_TOPIC;
                case 4 -> DESTINATION;
                default -> null;
            };
        }

        public static boolean isQueue(TYPE type) {
            boolean result = false;
            if (type != null && (type.equals((Object)QUEUE) || type.equals((Object)TEMP_QUEUE))) {
                result = true;
            }
            return result;
        }

        public static boolean isTemporary(TYPE type) {
            boolean result = false;
            if (type != null && (type.equals((Object)TEMP_TOPIC) || type.equals((Object)TEMP_QUEUE))) {
                result = true;
            }
            return result;
        }
    }
}

