/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.DisabledProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoiceReifier
extends ProcessorReifier<ChoiceDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceReifier.class);

    public ChoiceReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ChoiceDefinition)ChoiceDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        boolean isPrecondition = Boolean.TRUE == this.parseBoolean(((ChoiceDefinition)this.definition).getPrecondition());
        ArrayList<FilterProcessor> filters = isPrecondition ? null : new ArrayList<FilterProcessor>();
        for (WhenDefinition whenClause : ((ChoiceDefinition)this.definition).getWhenClauses()) {
            if (filters == null) continue;
            whenClause.preCreateProcessor();
            Predicate when = null;
            Processor output = null;
            if (!ChoiceReifier.isDisabled(this.camelContext, (NamedNode)whenClause)) {
                whenClause.idOrCreate((NodeIdFactory)this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class));
                when = this.createPredicate(whenClause.getExpression());
                output = this.createOutputsProcessor(whenClause.getOutputs());
                if (output == null) {
                    output = new DisabledProcessor();
                }
            }
            if (when == null) continue;
            filters.add(new FilterProcessor(this.camelContext, when, output));
        }
        if (isPrecondition) {
            return this.getMatchingBranchProcessor();
        }
        Processor otherwiseProcessor = null;
        if (((ChoiceDefinition)this.definition).getOtherwise() != null && !ChoiceReifier.isDisabled(this.camelContext, (NamedNode)((ChoiceDefinition)this.definition).getOtherwise())) {
            ((ChoiceDefinition)this.definition).getOtherwise().idOrCreate((NodeIdFactory)this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class));
            otherwiseProcessor = this.createOutputsProcessor(((ChoiceDefinition)this.definition).getOtherwise().getOutputs());
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }

    private Processor getMatchingBranchProcessor() throws Exception {
        Exchange dummy = ExchangeHelper.getDummy((CamelContext)this.camelContext);
        for (WhenDefinition whenClause : ((ChoiceDefinition)this.definition).getWhenClauses()) {
            ExpressionDefinition exp = whenClause.getExpression();
            exp.initPredicate(this.camelContext);
            Predicate predicate = exp.getPredicate();
            predicate.initPredicate(this.camelContext);
            boolean matches = predicate.matches(dummy);
            if (!matches) continue;
            LOG.debug("doSwitch selected: {}", (Object)whenClause.getLabel());
            return this.createOutputsProcessor(whenClause.getOutputs());
        }
        if (((ChoiceDefinition)this.definition).getOtherwise() != null) {
            LOG.debug("doSwitch selected: otherwise");
            return this.createOutputsProcessor(((ChoiceDefinition)this.definition).getOtherwise().getOutputs());
        }
        LOG.debug("doSwitch no when or otherwise selected");
        return null;
    }
}

