/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.PrimitiveType;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.fusesource.hawtbuf.UTF8Buffer;

public class UTF8BufferType
implements PrimitiveType<UTF8Buffer> {
    private final UTF8BufferEncoding largeBufferEncoding;
    private final UTF8BufferEncoding smallBufferEncoding;

    public UTF8BufferType(EncoderImpl encoder, DecoderImpl decoder) {
        this.largeBufferEncoding = new LargeUTF8BufferEncoding(encoder, decoder);
        this.smallBufferEncoding = new SmallUTF8BufferEncoding(encoder, decoder);
    }

    public Class<UTF8Buffer> getTypeClass() {
        return UTF8Buffer.class;
    }

    public PrimitiveTypeEncoding<UTF8Buffer> getEncoding(UTF8Buffer value) {
        return value.getLength() <= 255 ? this.smallBufferEncoding : this.largeBufferEncoding;
    }

    public PrimitiveTypeEncoding<UTF8Buffer> getCanonicalEncoding() {
        return this.largeBufferEncoding;
    }

    public Collection<? extends PrimitiveTypeEncoding<UTF8Buffer>> getAllEncodings() {
        return Arrays.asList(this.smallBufferEncoding, this.largeBufferEncoding);
    }

    public void write(UTF8Buffer value) {
        PrimitiveTypeEncoding<UTF8Buffer> encoding = this.getEncoding(value);
        encoding.writeConstructor();
        encoding.writeValue((Object)value);
    }

    public class SmallUTF8BufferEncoding
    extends UTF8BufferEncoding {
        public SmallUTF8BufferEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        public byte getEncodingCode() {
            return -95;
        }

        @Override
        public int getSizeBytes() {
            return 1;
        }

        @Override
        public void writeSize(UTF8Buffer value) {
            this.getEncoder().getBuffer().put((byte)value.getLength());
        }
    }

    public class LargeUTF8BufferEncoding
    extends UTF8BufferEncoding {
        public LargeUTF8BufferEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        public byte getEncodingCode() {
            return -79;
        }

        @Override
        public int getSizeBytes() {
            return 4;
        }

        @Override
        public void writeSize(UTF8Buffer value) {
            this.getEncoder().getBuffer().putInt(value.getLength());
        }
    }

    public abstract class UTF8BufferEncoding
    implements PrimitiveTypeEncoding<UTF8Buffer> {
        private final EncoderImpl encoder;
        private final DecoderImpl decoder;

        public UTF8BufferEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            this.encoder = encoder;
            this.decoder = decoder;
        }

        public int getConstructorSize() {
            return 1;
        }

        public boolean isFixedSizeVal() {
            return false;
        }

        public boolean encodesJavaPrimitive() {
            return false;
        }

        public abstract int getSizeBytes();

        public void writeConstructor() {
            this.getEncoder().writeRaw(this.getEncodingCode());
        }

        public void writeValue(UTF8Buffer value) {
            this.writeSize(value);
            WritableBuffer buffer = this.getEncoder().getBuffer();
            buffer.put(value.getData(), value.getOffset(), value.getLength());
        }

        public abstract void writeSize(UTF8Buffer var1);

        public int getValueSize(UTF8Buffer value) {
            return this.getSizeBytes() + value.getLength();
        }

        public Class<UTF8Buffer> getTypeClass() {
            return UTF8Buffer.class;
        }

        public PrimitiveType<UTF8Buffer> getType() {
            return UTF8BufferType.this;
        }

        public boolean encodesSuperset(TypeEncoding<UTF8Buffer> encoding) {
            return this.getType() == encoding.getType();
        }

        public UTF8Buffer readValue() {
            throw new UnsupportedOperationException("No decoding to UTF8Buffer exists");
        }

        public void skipValue() {
            throw new UnsupportedOperationException("No decoding to UTF8Buffer exists");
        }

        public DecoderImpl getDecoder() {
            return this.decoder;
        }

        public EncoderImpl getEncoder() {
            return this.encoder;
        }
    }
}

