/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.CircuitBreakerLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;

@Metadata(label="eip,routing")
@XmlRootElement(name="loadBalance")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoadBalanceDefinition
extends ProcessorDefinition<LoadBalanceDefinition> {
    @XmlElements(value={@XmlElement(required=false, name="failover", type=FailoverLoadBalancerDefinition.class), @XmlElement(required=false, name="random", type=RandomLoadBalancerDefinition.class), @XmlElement(required=false, name="custom", type=CustomLoadBalancerDefinition.class), @XmlElement(required=false, name="roundRobin", type=RoundRobinLoadBalancerDefinition.class), @XmlElement(required=false, name="sticky", type=StickyLoadBalancerDefinition.class), @XmlElement(required=false, name="topic", type=TopicLoadBalancerDefinition.class), @XmlElement(required=false, name="weighted", type=WeightedLoadBalancerDefinition.class), @XmlElement(required=false, name="circuitBreaker", type=CircuitBreakerLoadBalancerDefinition.class)})
    private LoadBalancerDefinition loadBalancerType;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
        if (outputs != null) {
            for (ProcessorDefinition<?> output : outputs) {
                this.configureChild(output);
            }
        }
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public LoadBalancerDefinition getLoadBalancerType() {
        return this.loadBalancerType;
    }

    public void setLoadBalancerType(LoadBalancerDefinition loadbalancer) {
        if (this.loadBalancerType != null) {
            throw new IllegalArgumentException("Loadbalancer already configured to: " + this.loadBalancerType + ". Cannot set it to: " + loadbalancer);
        }
        this.loadBalancerType = loadbalancer;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        LoadBalancer loadBalancer = this.loadBalancerType.getLoadBalancer(routeContext);
        if (loadBalancer == null) {
            loadBalancer = this.loadBalancerType.createLoadBalancer(routeContext);
            this.loadBalancerType.setLoadBalancer(loadBalancer);
            int max = this.loadBalancerType.getMaximumNumberOfOutputs();
            int size2 = this.getOutputs().size();
            if (size2 > max) {
                throw new IllegalArgumentException("To many outputs configured on " + this.loadBalancerType + ": " + size2 + " > " + max);
            }
            for (ProcessorDefinition<?> processorType : this.getOutputs()) {
                if (LoadBalanceDefinition.class.isInstance(processorType)) {
                    throw new IllegalArgumentException("Loadbalancer already configured to: " + this.loadBalancerType + ". Cannot set it to: " + processorType);
                }
                Processor processor = this.createProcessor(routeContext, processorType);
                processor = this.wrapChannel(routeContext, processor, processorType);
                loadBalancer.addProcessor(processor);
            }
        }
        Boolean inherit = this.inheritErrorHandler;
        if (this.loadBalancerType instanceof FailoverLoadBalancerDefinition) {
            inherit = true;
        }
        Processor target = this.wrapChannel(routeContext, loadBalancer, this, inherit);
        return target;
    }

    @Override
    public LoadBalanceDefinition loadBalance(LoadBalancer loadBalancer) {
        CustomLoadBalancerDefinition def = new CustomLoadBalancerDefinition();
        def.setLoadBalancer(loadBalancer);
        this.setLoadBalancerType(def);
        return this;
    }

    public LoadBalanceDefinition failover() {
        return this.failover(-1, true, false, new Class[0]);
    }

    public LoadBalanceDefinition failover(Class<?> ... exceptions) {
        return this.failover(-1, true, false, exceptions);
    }

    public LoadBalanceDefinition failover(int maximumFailoverAttempts, boolean inheritErrorHandler, boolean roundRobin, Class<?> ... exceptions) {
        return this.failover(maximumFailoverAttempts, inheritErrorHandler, roundRobin, false, exceptions);
    }

    public LoadBalanceDefinition failover(int maximumFailoverAttempts, boolean inheritErrorHandler, boolean roundRobin, boolean sticky, Class<?> ... exceptions) {
        FailoverLoadBalancerDefinition def = new FailoverLoadBalancerDefinition();
        def.setExceptionTypes(Arrays.asList(exceptions));
        def.setMaximumFailoverAttempts(maximumFailoverAttempts);
        def.setRoundRobin(roundRobin);
        def.setSticky(sticky);
        this.setLoadBalancerType(def);
        this.setInheritErrorHandler(inheritErrorHandler);
        return this;
    }

    public LoadBalanceDefinition weighted(boolean roundRobin, String distributionRatio) {
        return this.weighted(roundRobin, distributionRatio, ",");
    }

    @Deprecated
    public LoadBalanceDefinition circuitBreaker(int threshold, long halfOpenAfter, Class<?> ... exceptions) {
        CircuitBreakerLoadBalancerDefinition def = new CircuitBreakerLoadBalancerDefinition();
        def.setExceptionTypes(Arrays.asList(exceptions));
        def.setThreshold(threshold);
        def.setHalfOpenAfter(halfOpenAfter);
        this.setLoadBalancerType(def);
        return this;
    }

    public LoadBalanceDefinition weighted(boolean roundRobin, String distributionRatio, String distributionRatioDelimiter) {
        WeightedLoadBalancerDefinition def = new WeightedLoadBalancerDefinition();
        def.setRoundRobin(roundRobin);
        def.setDistributionRatio(distributionRatio);
        def.setDistributionRatioDelimiter(distributionRatioDelimiter);
        this.setLoadBalancerType(def);
        return this;
    }

    public LoadBalanceDefinition roundRobin() {
        this.setLoadBalancerType(new RoundRobinLoadBalancerDefinition());
        return this;
    }

    public LoadBalanceDefinition random() {
        this.setLoadBalancerType(new RandomLoadBalancerDefinition());
        return this;
    }

    public LoadBalanceDefinition custom(String ref) {
        CustomLoadBalancerDefinition balancer = new CustomLoadBalancerDefinition();
        balancer.setRef(ref);
        this.setLoadBalancerType(balancer);
        return this;
    }

    public LoadBalanceDefinition sticky(Expression correlationExpression) {
        StickyLoadBalancerDefinition def = new StickyLoadBalancerDefinition();
        def.setCorrelationExpression(correlationExpression);
        this.setLoadBalancerType(def);
        return this;
    }

    public LoadBalanceDefinition topic() {
        this.setLoadBalancerType(new TopicLoadBalancerDefinition());
        return this;
    }

    @Override
    public String getShortName() {
        return "loadBalance";
    }

    @Override
    public String getLabel() {
        CollectionStringBuffer buffer = new CollectionStringBuffer("loadBalance[");
        List<ProcessorDefinition<?>> list = this.getOutputs();
        for (ProcessorDefinition<?> processorType : list) {
            buffer.append(processorType.getLabel());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String toString() {
        return "LoadBalanceType[" + this.loadBalancerType + ", " + this.getOutputs() + "]";
    }
}

