/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.cloud.ServiceFilterFactory;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="routing,cloud,service-discovery")
@XmlRootElement(name="serviceFilterConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceCallServiceFilterConfiguration
extends IdentifiedType
implements ServiceFilterFactory {
    @XmlTransient
    private final ServiceCallDefinition parent;
    @XmlTransient
    private final String factoryKey;
    @XmlElement(name="properties")
    @Metadata(label="advanced")
    private List<PropertyDefinition> properties;

    public ServiceCallServiceFilterConfiguration() {
        this(null, null);
    }

    public ServiceCallServiceFilterConfiguration(ServiceCallDefinition parent, String factoryKey) {
        this.parent = parent;
        this.factoryKey = factoryKey;
    }

    public ServiceCallDefinition end() {
        return this.parent;
    }

    public ProcessorDefinition<?> endParent() {
        return this.parent.end();
    }

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyDefinition> properties) {
        this.properties = properties;
    }

    public ServiceCallServiceFilterConfiguration property(String key, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyDefinition>();
        }
        PropertyDefinition prop = new PropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.properties.add(prop);
        return this;
    }

    protected Map<String, String> getPropertiesAsMap(CamelContext camelContext) throws Exception {
        Map<String, String> answer;
        if (this.properties == null || this.properties.isEmpty()) {
            answer = Collections.emptyMap();
        } else {
            answer = new HashMap<String, String>();
            for (PropertyDefinition prop : this.properties) {
                String key = CamelContextHelper.parseText(camelContext, prop.getKey());
                String value = CamelContextHelper.parseText(camelContext, prop.getValue());
                answer.put(key, value);
            }
        }
        return answer;
    }

    @Override
    public ServiceFilter newInstance(CamelContext camelContext) throws Exception {
        ServiceFilter answer;
        ObjectHelper.notNull(this.factoryKey, "ServiceFilter factoryKey");
        ServiceFilterFactory factory = CamelContextHelper.lookup(camelContext, this.factoryKey, ServiceFilterFactory.class);
        if (factory != null) {
            answer = (ServiceFilter)factory.newInstance(camelContext);
        } else {
            Class<?> type;
            try {
                type = camelContext.getFactoryFinder("META-INF/services/org/apache/camel/cloud/").findClass(this.factoryKey);
            }
            catch (Exception e) {
                throw new NoFactoryAvailableException("META-INF/services/org/apache/camel/cloud/" + this.factoryKey, e);
            }
            if (type != null) {
                if (ServiceFilterFactory.class.isAssignableFrom(type)) {
                    factory = (ServiceFilterFactory)camelContext.getInjector().newInstance(type);
                } else {
                    throw new NoFactoryAvailableException("Resolving ServiceFilter: " + this.factoryKey + " detected type conflict: Not a ServiceFilterFactory implementation. Found: " + type.getName());
                }
            }
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                IntrospectionSupport.getProperties(this, parameters, null, false);
                parameters.replaceAll((k, v) -> {
                    if (v instanceof String) {
                        try {
                            v = camelContext.resolvePropertyPlaceholders((String)v);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Exception while resolving %s (%s)", k, v.toString()), e);
                        }
                    }
                    return v;
                });
                parameters.put("properties", this.getPropertiesAsMap(camelContext));
                this.postProcessFactoryParameters(camelContext, parameters);
                IntrospectionSupport.setProperties(factory, parameters);
                answer = (ServiceFilter)factory.newInstance(camelContext);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return answer;
    }

    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
    }
}

