/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelFactoryBean<T>
extends IdentifiedType
implements CamelContextAware {
    @XmlAttribute
    @Metadata(description="Id of CamelContext to use if there are multiple CamelContexts in the same JVM")
    private String camelContextId;
    @XmlTransient
    private CamelContext camelContext;
    @XmlTransient
    private Boolean customId;

    public abstract T getObject() throws Exception;

    protected abstract CamelContext getCamelContextWithId(String var1);

    protected CamelContext discoverDefaultCamelContext() {
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        if (ObjectHelper.isNotEmpty(this.camelContextId)) {
            this.camelContext = this.getCamelContextWithId(this.camelContextId);
            if (this.camelContext == null) {
                throw new IllegalStateException("Cannot find CamelContext with id: " + this.camelContextId);
            }
        }
        if (this.camelContext == null) {
            this.camelContext = this.discoverDefaultCamelContext();
        }
    }

    public void destroy() throws Exception {
    }

    @Override
    public CamelContext getCamelContext() {
        if (ObjectHelper.isNotEmpty(this.camelContextId)) {
            return this.getCamelContextWithId(this.camelContextId);
        }
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getCamelContextId() {
        return this.camelContextId;
    }

    public void setCamelContextId(String camelContextId) {
        this.camelContextId = camelContextId;
    }

    public Boolean getCustomId() {
        return this.customId;
    }

    public void setCustomId(Boolean customId) {
        this.customId = customId;
    }

    public boolean isSingleton() {
        return true;
    }

    public abstract Class<? extends T> getObjectType();
}

