/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.authz;

import java.util.Collection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.shiro.authz.ActionPermissionResolver;
import org.apache.activemq.shiro.authz.DestinationAction;
import org.apache.activemq.shiro.authz.DestinationActionPermissionResolver;
import org.apache.activemq.shiro.env.EnvironmentFilter;
import org.apache.activemq.shiro.subject.ConnectionSubjectResolver;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;

public class AuthorizationFilter
extends EnvironmentFilter {
    private ActionPermissionResolver actionPermissionResolver = new DestinationActionPermissionResolver();

    public ActionPermissionResolver getActionPermissionResolver() {
        return this.actionPermissionResolver;
    }

    public void setActionPermissionResolver(ActionPermissionResolver actionPermissionResolver) {
        this.actionPermissionResolver = actionPermissionResolver;
    }

    protected Subject getSubject(ConnectionContext ctx) {
        return new ConnectionSubjectResolver(ctx).getSubject();
    }

    protected String toString(Subject subject) {
        PrincipalCollection pc = subject.getPrincipals();
        if (pc != null && !pc.isEmpty()) {
            return "[" + pc.toString() + "] ";
        }
        return "";
    }

    protected void assertAuthorized(DestinationAction action) {
        this.assertAuthorized(action, action.getVerb());
    }

    protected boolean isSystemBroker(DestinationAction action) {
        ConnectionContext context = action.getConnectionContext();
        SecurityContext securityContext = context.getSecurityContext();
        return securityContext != null && securityContext.isBrokerContext();
    }

    protected void assertAuthorized(DestinationAction action, String verbText) {
        Collection<Permission> perms;
        if (!this.isEnabled() || this.isSystemBroker(action)) {
            return;
        }
        Subject subject = this.getSubject(action.getConnectionContext());
        if (!subject.isPermittedAll(perms = this.actionPermissionResolver.getPermissions(action))) {
            String msg = this.createUnauthorizedMessage(subject, action, verbText);
            throw new UnauthorizedException(msg);
        }
    }

    protected String createUnauthorizedMessage(Subject subject, DestinationAction action, String verbDisplayText) {
        return "Subject " + this.toString(subject) + "is not authorized to " + verbDisplayText + " destination: " + action.getDestination();
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        DestinationAction action = new DestinationAction(context, info.getDestination(), "create");
        this.assertAuthorized(action);
        super.addDestinationInfo(context, info);
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean create) throws Exception {
        DestinationAction action = new DestinationAction(context, destination, "create");
        this.assertAuthorized(action);
        return super.addDestination(context, destination, create);
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        DestinationAction action = new DestinationAction(context, destination, "remove");
        this.assertAuthorized(action);
        super.removeDestination(context, destination, timeout);
    }

    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        DestinationAction action = new DestinationAction(context, info.getDestination(), "remove");
        this.assertAuthorized(action);
        super.removeDestinationInfo(context, info);
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        DestinationAction action = new DestinationAction(context, info.getDestination(), "read");
        this.assertAuthorized(action, "read from");
        return super.addConsumer(context, info);
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
        if (info.getDestination() != null) {
            DestinationAction action = new DestinationAction(context, info.getDestination(), "write");
            this.assertAuthorized(action, "write to");
        }
        super.addProducer(context, info);
    }

    public void send(ProducerBrokerExchange exchange, Message message) throws Exception {
        DestinationAction action = new DestinationAction(exchange.getConnectionContext(), message.getDestination(), "write");
        this.assertAuthorized(action, "write to");
        super.send(exchange, message);
    }
}

