/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import com.google.common.base.Suppliers;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.TColumn;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TRange;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.manager.thrift.FateOperation;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.KerberosAuthenticator;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKAuthenticator;
import org.apache.accumulo.server.security.handler.ZKAuthorizor;
import org.apache.accumulo.server.security.handler.ZKPermHandler;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityOperation {
    private static final Logger log = LoggerFactory.getLogger(SecurityOperation.class);
    private final Authorizor authorizor;
    private final Authenticator authenticator;
    private final PermissionHandler permHandle;
    private final boolean isKerberos;
    private final Supplier<String> rootUserName;
    private final ZooCache zooCache;
    private final String zkUserPath;
    protected final ServerContext context;

    public static Authorizor getAuthorizor(ServerContext context) {
        Authorizor toRet = (Authorizor)Property.createInstanceFromPropertyName((AccumuloConfiguration)context.getConfiguration(), (Property)Property.INSTANCE_SECURITY_AUTHORIZOR, Authorizor.class, (Object)new ZKAuthorizor());
        toRet.initialize(context);
        return toRet;
    }

    public static Authenticator getAuthenticator(ServerContext context) {
        Authenticator toRet = (Authenticator)Property.createInstanceFromPropertyName((AccumuloConfiguration)context.getConfiguration(), (Property)Property.INSTANCE_SECURITY_AUTHENTICATOR, Authenticator.class, (Object)new ZKAuthenticator());
        toRet.initialize(context);
        return toRet;
    }

    public static PermissionHandler getPermHandler(ServerContext context) {
        PermissionHandler toRet = (PermissionHandler)Property.createInstanceFromPropertyName((AccumuloConfiguration)context.getConfiguration(), (Property)Property.INSTANCE_SECURITY_PERMISSION_HANDLER, PermissionHandler.class, (Object)new ZKPermHandler());
        toRet.initialize(context);
        return toRet;
    }

    protected SecurityOperation(ServerContext context, Authorizor author, Authenticator authent, PermissionHandler pm) {
        this.context = context;
        this.zkUserPath = "/accumulo/" + context.getInstanceID() + "/users";
        this.zooCache = new ZooCache(context.getZooReader(), null);
        this.rootUserName = Suppliers.memoize(() -> new String(this.zooCache.get(this.zkUserPath), StandardCharsets.UTF_8));
        this.authorizor = author;
        this.authenticator = authent;
        this.permHandle = pm;
        if (!(this.authorizor.validSecurityHandlers(this.authenticator, pm) && this.authenticator.validSecurityHandlers() && this.permHandle.validSecurityHandlers(authent, author))) {
            throw new RuntimeException(this.authorizor + ", " + this.authenticator + ", and " + pm + " do not play nice with each other. Please choose authentication and authorization mechanisms that are compatible with one another.");
        }
        this.isKerberos = KerberosAuthenticator.class.isAssignableFrom(this.authenticator.getClass());
    }

    public void initializeSecurity(TCredentials credentials, String rootPrincipal, byte[] token) throws AccumuloSecurityException {
        if (!this.isSystemUser(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.authenticator.initializeSecurity(rootPrincipal, token);
        this.authorizor.initializeSecurity(credentials, rootPrincipal);
        this.permHandle.initializeSecurity(credentials, rootPrincipal);
        try {
            this.permHandle.grantTablePermission(rootPrincipal, MetadataTable.ID.canonical(), TablePermission.ALTER_TABLE);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String getRootUsername() {
        return this.rootUserName.get();
    }

    public boolean isSystemUser(TCredentials credentials) {
        return this.context.getCredentials().getToken().getClass().getName().equals(credentials.getTokenClassName());
    }

    protected void authenticate(TCredentials credentials) throws ThriftSecurityException {
        if (!credentials.getInstanceId().equals(this.context.getInstanceID().canonical())) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.INVALID_INSTANCEID);
        }
        Credentials creds = Credentials.fromThrift((TCredentials)credentials);
        if (this.isSystemUser(credentials)) {
            if (this.isKerberos) {
                if (!this.context.getCredentials().getToken().equals(creds.getToken())) {
                    log.debug("With SASL enabled, System AuthenticationTokens did not match.");
                    throw new ThriftSecurityException(creds.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
                }
            } else if (!this.context.getCredentials().equals((Object)creds)) {
                log.debug("Provided credentials did not match server's expected credentials. Expected {} but got {}", (Object)this.context.getCredentials(), (Object)creds);
                throw new ThriftSecurityException(creds.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
            }
        } else {
            block13: {
                if (this.isKerberos && !this.authenticator.userExists(creds.getPrincipal())) {
                    try {
                        this._createUser(credentials, creds);
                    }
                    catch (ThriftSecurityException e) {
                        if (e.getCode() == SecurityErrorCode.USER_EXISTS) break block13;
                        throw e;
                    }
                }
            }
            try {
                if (!this.authenticator.authenticateUser(creds.getPrincipal(), creds.getToken())) {
                    throw new ThriftSecurityException(creds.getPrincipal(), SecurityErrorCode.BAD_CREDENTIALS);
                }
            }
            catch (AccumuloSecurityException e) {
                log.debug("AccumuloSecurityException", (Throwable)e);
                throw e.asThriftException();
            }
        }
    }

    public boolean authenticateUser(TCredentials credentials, TCredentials toAuth) throws ThriftSecurityException {
        this.authenticate(credentials);
        if (!credentials.getPrincipal().equals(toAuth.getPrincipal()) && !this.hasSystemPermission(credentials, SystemPermission.SYSTEM, false)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (credentials.equals(toAuth)) {
            return true;
        }
        try {
            Credentials toCreds = Credentials.fromThrift((TCredentials)toAuth);
            if (this.isKerberos && !this.authenticator.userExists(toCreds.getPrincipal())) {
                this.createUser(credentials, toCreds, Authorizations.EMPTY);
            }
            return this.authenticator.authenticateUser(toCreds.getPrincipal(), toCreds.getToken());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public Authorizations getUserAuthorizations(TCredentials credentials, String user) throws ThriftSecurityException {
        this.authenticate(credentials);
        this.targetUserExists(user);
        if (!(credentials.getPrincipal().equals(user) || this.hasSystemPermission(credentials, SystemPermission.SYSTEM, false) || this.hasSystemPermission(credentials, SystemPermission.ALTER_USER, false))) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.authorizor.getCachedUserAuthorizations(user);
    }

    public Authorizations getUserAuthorizations(TCredentials credentials) throws ThriftSecurityException {
        if (this.isSystemUser(credentials)) {
            this.authenticate(credentials);
            return Authorizations.EMPTY;
        }
        return this.getUserAuthorizations(credentials, credentials.getPrincipal());
    }

    public boolean authenticatedUserHasAuthorizations(TCredentials credentials, List<ByteBuffer> list) {
        if (this.isSystemUser(credentials)) {
            return list.isEmpty();
        }
        return this.authorizor.isValidAuthorizations(credentials.getPrincipal(), list);
    }

    private boolean hasSystemPermission(TCredentials credentials, SystemPermission permission, boolean useCached) throws ThriftSecurityException {
        return this.hasSystemPermissionWithNamespaceId(credentials, permission, null, useCached);
    }

    private boolean hasSystemPermissionWithNamespaceId(TCredentials credentials, SystemPermission permission, NamespaceId namespaceId, boolean useCached) throws ThriftSecurityException {
        if (this.isSystemUser(credentials)) {
            return true;
        }
        if (this._hasSystemPermission(credentials.getPrincipal(), permission, useCached)) {
            return true;
        }
        if (namespaceId != null) {
            return this._hasNamespacePermission(credentials.getPrincipal(), namespaceId, NamespacePermission.getEquivalent((SystemPermission)permission), useCached);
        }
        return false;
    }

    private boolean _hasSystemPermission(String user, SystemPermission permission, boolean useCached) throws ThriftSecurityException {
        if (user.equals(this.getRootUsername())) {
            return true;
        }
        this.targetUserExists(user);
        if (useCached) {
            return this.permHandle.hasCachedSystemPermission(user, permission);
        }
        return this.permHandle.hasSystemPermission(user, permission);
    }

    protected boolean hasTablePermission(TCredentials credentials, TableId tableId, NamespaceId namespaceId, TablePermission permission, boolean useCached) throws ThriftSecurityException {
        if (this.isSystemUser(credentials)) {
            return true;
        }
        return this._hasTablePermission(credentials.getPrincipal(), tableId, permission, useCached) || this._hasNamespacePermission(credentials.getPrincipal(), namespaceId, NamespacePermission.getEquivalent((TablePermission)permission), useCached);
    }

    private boolean _hasTablePermission(String user, TableId table, TablePermission permission, boolean useCached) throws ThriftSecurityException {
        this.targetUserExists(user);
        TableId replicationTableId = ReplicationTable.ID;
        if ((table.equals((Object)MetadataTable.ID) || table.equals((Object)RootTable.ID) || table.equals((Object)replicationTableId)) && permission.equals((Object)TablePermission.READ)) {
            return true;
        }
        try {
            if (useCached) {
                return this.permHandle.hasCachedTablePermission(user, table.canonical(), permission);
            }
            return this.permHandle.hasTablePermission(user, table.canonical(), permission);
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(user, SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    private boolean _hasNamespacePermission(String user, NamespaceId namespace, NamespacePermission permission, boolean useCached) throws ThriftSecurityException {
        if (permission == null) {
            return false;
        }
        this.targetUserExists(user);
        if (namespace.equals((Object)Namespace.ACCUMULO.id()) && permission.equals((Object)NamespacePermission.READ)) {
            return true;
        }
        try {
            if (useCached) {
                return this.permHandle.hasCachedNamespacePermission(user, namespace.canonical(), permission);
            }
            return this.permHandle.hasNamespacePermission(user, namespace.canonical(), permission);
        }
        catch (NamespaceNotFoundException e) {
            throw new ThriftSecurityException(user, SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
    }

    private boolean canAskAboutOtherUsers(TCredentials credentials, String user) throws ThriftSecurityException {
        this.authenticate(credentials);
        return credentials.getPrincipal().equals(user) || this.hasSystemPermission(credentials, SystemPermission.SYSTEM, false) || this.hasSystemPermission(credentials, SystemPermission.CREATE_USER, false) || this.hasSystemPermission(credentials, SystemPermission.ALTER_USER, false) || this.hasSystemPermission(credentials, SystemPermission.DROP_USER, false);
    }

    private void targetUserExists(String user) throws ThriftSecurityException {
        if (user.equals(this.getRootUsername())) {
            return;
        }
        if (!this.authenticator.userExists(user)) {
            throw new ThriftSecurityException(user, SecurityErrorCode.USER_DOESNT_EXIST);
        }
    }

    public boolean canScan(TCredentials credentials, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials, tableId, namespaceId, TablePermission.READ, true);
    }

    public boolean canScan(TCredentials credentials, TableId tableId, NamespaceId namespaceId, TRange range, List<TColumn> columns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        return this.canScan(credentials, tableId, namespaceId);
    }

    public boolean canScan(TCredentials credentials, TableId table, NamespaceId namespaceId, Map<TKeyExtent, List<TRange>> tbatch, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        return this.canScan(credentials, table, namespaceId);
    }

    public boolean canWrite(TCredentials credentials, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials, tableId, namespaceId, TablePermission.WRITE, true);
    }

    public boolean canConditionallyUpdate(TCredentials credentials, TableId tableID, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials, tableID, namespaceId, TablePermission.WRITE, true) && this.hasTablePermission(credentials, tableID, namespaceId, TablePermission.READ, true);
    }

    public boolean canSplitTablet(TCredentials credentials, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.SYSTEM, namespaceId, false) || this.hasTablePermission(credentials, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canPerformSystemActions(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermission(credentials, SystemPermission.SYSTEM, false);
    }

    public boolean canFlush(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasTablePermission(c, tableId, namespaceId, TablePermission.WRITE, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canAlterTable(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false) || this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false);
    }

    public boolean canCreateTable(TCredentials c, String tableName, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.CREATE_TABLE, namespaceId, false);
    }

    public boolean canRenameTable(TCredentials c, TableId tableId, String oldTableName, String newTableName, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canCloneTable(TCredentials c, TableId tableId, String tableName, NamespaceId destinationNamespaceId, NamespaceId srcNamespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.CREATE_TABLE, destinationNamespaceId, false) && this.hasTablePermission(c, tableId, srcNamespaceId, TablePermission.READ, false);
    }

    public boolean canDeleteTable(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.DROP_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.DROP_TABLE, false);
    }

    public boolean canOnlineOfflineTable(TCredentials c, TableId tableId, FateOperation op, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.SYSTEM, namespaceId, false) || this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canMerge(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.SYSTEM, namespaceId, false) || this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false);
    }

    public boolean canDeleteRange(TCredentials c, TableId tableId, String tableName, Text startRow, Text endRow, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.SYSTEM, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.WRITE, false);
    }

    public boolean canBulkImport(TCredentials c, TableId tableId, String tableName, String dir, String failDir, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasTablePermission(c, tableId, namespaceId, TablePermission.BULK_IMPORT, false);
    }

    public boolean canCompact(TCredentials c, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.ALTER_TABLE, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.WRITE, false);
    }

    public boolean canChangeAuthorizations(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c, SystemPermission.ALTER_USER, false);
    }

    public boolean canChangePassword(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        return c.getPrincipal().equals(user) || this.hasSystemPermission(c, SystemPermission.ALTER_USER, false);
    }

    public boolean canCreateUser(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c, SystemPermission.CREATE_USER, false);
    }

    public boolean canDropUser(TCredentials c, String user) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals(this.getRootUsername())) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(c, SystemPermission.DROP_USER, false);
    }

    public boolean canGrantSystem(TCredentials c, String user, SystemPermission sysPerm) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermission(c, SystemPermission.GRANT, false);
    }

    public boolean canGrantTable(TCredentials c, String user, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.GRANT, false);
    }

    public boolean canGrantNamespace(TCredentials c, NamespaceId namespace) throws ThriftSecurityException {
        return this.canModifyNamespacePermission(c, namespace);
    }

    private boolean canModifyNamespacePermission(TCredentials c, NamespaceId namespace) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_NAMESPACE, namespace, false) || this.hasNamespacePermission(c, c.principal, namespace, NamespacePermission.GRANT);
    }

    public boolean canRevokeSystem(TCredentials c, String user, SystemPermission sysPerm) throws ThriftSecurityException {
        this.authenticate(c);
        if (user.equals(this.getRootUsername())) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this.hasSystemPermission(c, SystemPermission.GRANT, false);
    }

    public boolean canRevokeTable(TCredentials c, String user, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(c);
        return this.hasSystemPermissionWithNamespaceId(c, SystemPermission.ALTER_TABLE, namespaceId, false) || this.hasTablePermission(c, tableId, namespaceId, TablePermission.GRANT, false);
    }

    public boolean canRevokeNamespace(TCredentials c, NamespaceId namespace) throws ThriftSecurityException {
        return this.canModifyNamespacePermission(c, namespace);
    }

    public void changeAuthorizations(TCredentials credentials, String user, Authorizations authorizations) throws ThriftSecurityException {
        if (!this.canChangeAuthorizations(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.authorizor.changeAuthorizations(user, authorizations);
            log.info("Changed authorizations for user {} at the request of user {}", (Object)user, (Object)credentials.getPrincipal());
        }
        catch (AccumuloSecurityException ase) {
            throw ase.asThriftException();
        }
    }

    public void changePassword(TCredentials credentials, Credentials toChange) throws ThriftSecurityException {
        if (!this.canChangePassword(credentials, toChange.getPrincipal())) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            AuthenticationToken token = toChange.getToken();
            this.authenticator.changePassword(toChange.getPrincipal(), token);
            log.info("Changed password for user {} at the request of user {}", (Object)toChange.getPrincipal(), (Object)credentials.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void createUser(TCredentials credentials, Credentials newUser, Authorizations authorizations) throws ThriftSecurityException {
        if (!this.canCreateUser(credentials, newUser.getPrincipal())) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this._createUser(credentials, newUser);
        if (this.canChangeAuthorizations(credentials, newUser.getPrincipal())) {
            try {
                this.authorizor.changeAuthorizations(newUser.getPrincipal(), authorizations);
            }
            catch (AccumuloSecurityException ase) {
                throw ase.asThriftException();
            }
        }
    }

    private void _createUser(TCredentials credentials, Credentials newUser) throws ThriftSecurityException {
        try {
            AuthenticationToken token = newUser.getToken();
            this.authenticator.createUser(newUser.getPrincipal(), token);
            this.authorizor.initUser(newUser.getPrincipal());
            this.permHandle.initUser(newUser.getPrincipal());
            log.info("Created user {} at the request of user {}", (Object)newUser.getPrincipal(), (Object)credentials.getPrincipal());
        }
        catch (AccumuloSecurityException ase) {
            throw ase.asThriftException();
        }
    }

    public void dropUser(TCredentials credentials, String user) throws ThriftSecurityException {
        if (!this.canDropUser(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            this.authorizor.dropUser(user);
            this.authenticator.dropUser(user);
            this.permHandle.cleanUser(user);
            log.info("Deleted user {} at the request of user {}", (Object)user, (Object)credentials.getPrincipal());
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void grantSystemPermission(TCredentials credentials, String user, SystemPermission permissionById) throws ThriftSecurityException {
        if (!this.canGrantSystem(credentials, user, permissionById)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.grantSystemPermission(user, permissionById);
            log.info("Granted system permission {} for user {} at the request of user {}", new Object[]{permissionById, user, credentials.getPrincipal()});
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void grantTablePermission(TCredentials c, String user, TableId tableId, String tableName, TablePermission permission, NamespaceId namespaceId) throws ThriftSecurityException, TableNotFoundException {
        if (!this.canGrantTable(c, user, tableId, namespaceId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.grantTablePermission(user, tableId.canonical(), permission);
            log.info("Granted table permission {} for user {} on the table {} at the request of user {}", new Object[]{permission, user, tableId, c.getPrincipal()});
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    public void grantNamespacePermission(TCredentials c, String user, NamespaceId namespace, NamespacePermission permission) throws ThriftSecurityException {
        if (!this.canGrantNamespace(c, namespace)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.grantNamespacePermission(user, namespace.canonical(), permission);
            log.info("Granted namespace permission {} for user {} on the namespace {} at the request of user {}", new Object[]{permission, user, namespace, c.getPrincipal()});
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (NamespaceNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
    }

    public void revokeSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        if (!this.canRevokeSystem(credentials, user, permission)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.revokeSystemPermission(user, permission);
            log.info("Revoked system permission {} for user {} at the request of user {}", new Object[]{permission, user, credentials.getPrincipal()});
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
    }

    public void revokeTablePermission(TCredentials c, String user, TableId tableId, TablePermission permission, NamespaceId namespaceId) throws ThriftSecurityException {
        if (!this.canRevokeTable(c, user, tableId, namespaceId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.revokeTablePermission(user, tableId.canonical(), permission);
            log.info("Revoked table permission {} for user {} on the table {} at the request of user {}", new Object[]{permission, user, tableId, c.getPrincipal()});
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    public void revokeNamespacePermission(TCredentials c, String user, NamespaceId namespace, NamespacePermission permission) throws ThriftSecurityException {
        if (!this.canRevokeNamespace(c, namespace)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.targetUserExists(user);
        try {
            this.permHandle.revokeNamespacePermission(user, namespace.canonical(), permission);
            log.info("Revoked namespace permission {} for user {} on the namespace {} at the request of user {}", new Object[]{permission, user, namespace, c.getPrincipal()});
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (NamespaceNotFoundException e) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
    }

    public boolean hasSystemPermission(TCredentials credentials, String user, SystemPermission permissionById) throws ThriftSecurityException {
        if (!this.canAskAboutOtherUsers(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this._hasSystemPermission(user, permissionById, false);
    }

    public boolean hasTablePermission(TCredentials credentials, String user, TableId tableId, TablePermission permissionById) throws ThriftSecurityException {
        if (!this.canAskAboutOtherUsers(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this._hasTablePermission(user, tableId, permissionById, false);
    }

    public boolean hasNamespacePermission(TCredentials credentials, String user, NamespaceId namespace, NamespacePermission permissionById) throws ThriftSecurityException {
        if (!this.canAskAboutOtherUsers(credentials, user)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        return this._hasNamespacePermission(user, namespace, permissionById, false);
    }

    public Set<String> listUsers(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.authenticator.listUsers();
    }

    public void deleteTable(TCredentials credentials, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        if (!this.canDeleteTable(credentials, tableId, namespaceId)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            this.permHandle.cleanTablePermissions(tableId.canonical());
        }
        catch (AccumuloSecurityException e) {
            e.setUser(credentials.getPrincipal());
            throw e.asThriftException();
        }
        catch (TableNotFoundException e) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
        }
    }

    public void deleteNamespace(TCredentials credentials, NamespaceId namespace) throws ThriftSecurityException {
        if (!this.canDeleteNamespace(credentials, namespace)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            this.permHandle.cleanNamespacePermissions(namespace.canonical());
        }
        catch (AccumuloSecurityException e) {
            e.setUser(credentials.getPrincipal());
            throw e.asThriftException();
        }
        catch (NamespaceNotFoundException e) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.NAMESPACE_DOESNT_EXIST);
        }
    }

    public boolean canExport(TCredentials credentials, TableId tableId, String tableName, String exportDir, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials, tableId, namespaceId, TablePermission.READ, false);
    }

    public boolean canImport(TCredentials credentials, String tableName, Set<String> importDir, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.CREATE_TABLE, namespaceId, false);
    }

    public boolean canAlterNamespace(TCredentials credentials, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.ALTER_NAMESPACE, namespaceId, false);
    }

    public boolean canCreateNamespace(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermission(credentials, SystemPermission.CREATE_NAMESPACE, false);
    }

    public boolean canDeleteNamespace(TCredentials credentials, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.DROP_NAMESPACE, namespaceId, false);
    }

    public boolean canRenameNamespace(TCredentials credentials, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermissionWithNamespaceId(credentials, SystemPermission.ALTER_NAMESPACE, namespaceId, false);
    }

    public boolean canObtainDelegationToken(TCredentials credentials) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasSystemPermission(credentials, SystemPermission.OBTAIN_DELEGATION_TOKEN, false);
    }

    public boolean canGetSummaries(TCredentials credentials, TableId tableId, NamespaceId namespaceId) throws ThriftSecurityException {
        this.authenticate(credentials);
        return this.hasTablePermission(credentials, tableId, namespaceId, TablePermission.GET_SUMMARIES, false);
    }

    public boolean validateStoredUserCreditentials() {
        if (this.authenticator instanceof ZKAuthenticator) {
            return !((ZKAuthenticator)this.authenticator).hasOutdatedHashes();
        }
        return true;
    }
}

