/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinorCompactionTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MinorCompactionTask.class);
    private final Tablet tablet;
    private long queued;
    private CommitSession commitSession;
    private DataFileValue stats;
    private long flushId;
    private MinorCompactionReason mincReason;

    MinorCompactionTask(Tablet tablet, CommitSession commitSession, long flushId, MinorCompactionReason mincReason) {
        this.tablet = tablet;
        this.queued = System.currentTimeMillis();
        tablet.minorCompactionWaitingToStart();
        this.commitSession = commitSession;
        this.flushId = flushId;
        this.mincReason = mincReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.tablet.minorCompactionStarted();
        try {
            Span span = TraceUtil.startSpan(this.getClass(), (String)"minorCompaction");
            try (Scope scope = span.makeCurrent();){
                Span span2 = TraceUtil.startSpan(this.getClass(), (String)"waitForCommits");
                try (Scope scope2 = span2.makeCurrent();){
                    Tablet tablet = this.tablet;
                    synchronized (tablet) {
                        this.commitSession.waitForCommitsToFinish();
                    }
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)span2, (Throwable)e, (boolean)true);
                    throw e;
                }
                finally {
                    span2.end();
                }
                TabletFile newFile = null;
                TabletFile tmpFile = null;
                Span span3 = TraceUtil.startSpan(this.getClass(), (String)"start");
                try (Scope scope3 = span3.makeCurrent();){
                    while (true) {
                        try {
                            if (newFile == null) {
                                newFile = this.tablet.getNextMapFilename("F");
                                tmpFile = new TabletFile(new Path(newFile.getPathStr() + "_tmp"));
                            }
                            this.tablet.getTabletServer().minorCompactionStarted(this.commitSession, this.commitSession.getWALogSeq() + 1L, newFile.getMetaInsert());
                        }
                        catch (Exception e) {
                            if (newFile == null) {
                                log.warn("Failed to create new file for minor compaction {}", (Object)e.getMessage(), (Object)e);
                                continue;
                            }
                            log.warn("Failed to write to write ahead log {}", (Object)e.getMessage(), (Object)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)span3, (Throwable)e, (boolean)true);
                    throw e;
                }
                finally {
                    span3.end();
                }
                Span span4 = TraceUtil.startSpan(this.getClass(), (String)"compact");
                try (Scope scope4 = span4.makeCurrent();){
                    this.stats = this.tablet.minorCompact(this.tablet.getTabletMemory().getMinCMemTable(), tmpFile, newFile, this.queued, this.commitSession, this.flushId, this.mincReason);
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)span4, (Throwable)e, (boolean)true);
                    throw e;
                }
                finally {
                    span4.end();
                }
                span.setAttribute("extent", this.tablet.getExtent().toString());
                span.setAttribute("numEntries", Long.toString(this.stats.getNumEntries()));
                span.setAttribute("size", Long.toString(this.stats.getSize()));
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span.end();
            }
            if (this.tablet.needsSplit(this.tablet.getSplitComputations())) {
                this.tablet.getTabletServer().executeSplit(this.tablet);
            }
        }
        catch (Exception e) {
            log.error("Unknown error during minor compaction for extent: {}", (Object)this.tablet.getExtent(), (Object)e);
            throw e;
        }
        finally {
            this.tablet.minorCompactionComplete();
        }
    }
}

