/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.blockfile.cache.impl.BlockCacheManagerFactory;
import org.apache.accumulo.core.file.blockfile.impl.CacheProvider;
import org.apache.accumulo.core.file.blockfile.impl.ScanCacheProvider;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.BlockCacheManager;
import org.apache.accumulo.core.spi.cache.CacheType;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.scan.ScanDispatch;
import org.apache.accumulo.core.spi.scan.ScanDispatcher;
import org.apache.accumulo.core.spi.scan.ScanExecutor;
import org.apache.accumulo.core.spi.scan.ScanInfo;
import org.apache.accumulo.core.spi.scan.ScanPrioritizer;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServiceEnvironmentImpl;
import org.apache.accumulo.server.fs.FileManager;
import org.apache.accumulo.tserver.ActiveAssignmentRunnable;
import org.apache.accumulo.tserver.AssignmentHandler;
import org.apache.accumulo.tserver.HoldTimeoutException;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.RunnableStartedAt;
import org.apache.accumulo.tserver.ScanServer;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.memory.LargestFirstMemoryManager;
import org.apache.accumulo.tserver.memory.NativeMapLoader;
import org.apache.accumulo.tserver.memory.TabletMemoryReport;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerResourceManager {
    private static final Logger log = LoggerFactory.getLogger(TabletServerResourceManager.class);
    private final ThreadPoolExecutor minorCompactionThreadPool;
    private final ThreadPoolExecutor splitThreadPool;
    private final ThreadPoolExecutor defaultSplitThreadPool;
    private final ThreadPoolExecutor defaultMigrationPool;
    private final ThreadPoolExecutor migrationPool;
    private final ThreadPoolExecutor assignmentPool;
    private final ThreadPoolExecutor assignMetaDataPool;
    private final ThreadPoolExecutor summaryRetrievalPool;
    private final ThreadPoolExecutor summaryPartitionPool;
    private final ThreadPoolExecutor summaryRemotePool;
    private final Map<String, ThreadPoolExecutor> scanExecutors;
    private final Map<String, ScanExecutor> scanExecutorChoices;
    private final ConcurrentHashMap<KeyExtent, RunnableStartedAt> activeAssignments;
    private final FileManager fileManager;
    private final LargestFirstMemoryManager memoryManager;
    private final MemoryManagementFramework memMgmt;
    private final BlockCacheManager cacheManager;
    private final BlockCache _dCache;
    private final BlockCache _iCache;
    private final BlockCache _sCache;
    private final ServerContext context;
    private Cache<String, Long> fileLenCache;
    private final Object commitHold = new Object();
    private volatile boolean holdCommits = false;
    private long holdStartTime;

    private void modifyThreadPoolSizesAtRuntime(IntSupplier maxThreads, String pool, ThreadPoolExecutor tp) {
        ThreadPools.watchCriticalScheduledTask(this.context.getScheduledExecutor().scheduleWithFixedDelay(() -> ThreadPools.resizePool((ThreadPoolExecutor)tp, (IntSupplier)maxThreads, (String)pool), 1L, 10L, TimeUnit.SECONDS));
    }

    private ThreadPoolExecutor createPriorityExecutor(final AccumuloConfiguration.ScanExecutorConfig sec, Map<String, Queue<Runnable>> scanExecQueues, boolean enableMetrics) {
        AbstractQueue queue;
        if (sec.prioritizerClass.orElse("").isEmpty()) {
            queue = new LinkedBlockingQueue();
        } else {
            ScanPrioritizer factory = null;
            try {
                factory = (ScanPrioritizer)ConfigurationTypeHelper.getClassInstance(null, (String)((String)sec.prioritizerClass.orElseThrow()), ScanPrioritizer.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (factory == null) {
                queue = new LinkedBlockingQueue();
            } else {
                Comparator comparator = factory.createComparator(new ScanPrioritizer.CreateParameters(){
                    private final ServiceEnvironment senv;
                    {
                        this.senv = new ServiceEnvironmentImpl(TabletServerResourceManager.this.context);
                    }

                    public Map<String, String> getOptions() {
                        return sec.prioritizerOpts;
                    }

                    public ServiceEnvironment getServiceEnv() {
                        return this.senv;
                    }
                });
                Function<Runnable, ScanInfo> extractor = r -> ((ScanSession.ScanMeasurer)TraceUtil.unwrap((Runnable)r)).getScanInfo();
                queue = new PriorityBlockingQueue<Runnable>(sec.maxThreads, Comparator.comparing(extractor, comparator));
            }
        }
        scanExecQueues.put(sec.name, queue);
        ThreadPoolExecutor es = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.ACCUMULO_POOL_PREFIX.poolName + ".scan." + sec.name).numCoreThreads(sec.getCurrentMaxThreads()).numMaxThreads(sec.getCurrentMaxThreads()).withTimeOut(0L, TimeUnit.MILLISECONDS).withQueue(queue).atPriority(sec.priority).enableThreadPoolMetrics(enableMetrics).build();
        this.modifyThreadPoolSizesAtRuntime(() -> ((AccumuloConfiguration.ScanExecutorConfig)sec).getCurrentMaxThreads(), ThreadPoolNames.ACCUMULO_POOL_PREFIX.poolName + ".scan." + sec.name, es);
        return es;
    }

    @SuppressFBWarnings(value={"DM_GC"}, justification="GC is run to get a good estimate of memory availability")
    public TabletServerResourceManager(ServerContext context, TabletHostingServer tserver) {
        this.context = context;
        AccumuloConfiguration acuConf = context.getConfiguration();
        boolean enableMetrics = context.getMetricsInfo().isMetricsEnabled();
        long maxMemory = acuConf.getAsBytes(Property.TSERV_MAXMEM);
        boolean usingNativeMap = acuConf.getBoolean(Property.TSERV_NATIVEMAP_ENABLED);
        if (usingNativeMap) {
            NativeMapLoader.load();
        }
        long totalQueueSize = acuConf.getAsBytes(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX);
        try {
            this.cacheManager = BlockCacheManagerFactory.getInstance((AccumuloConfiguration)acuConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating BlockCacheManager", e);
        }
        this.cacheManager.start(tserver.getBlockCacheConfiguration(acuConf));
        this._iCache = this.cacheManager.getBlockCache(CacheType.INDEX);
        this._dCache = this.cacheManager.getBlockCache(CacheType.DATA);
        this._sCache = this.cacheManager.getBlockCache(CacheType.SUMMARY);
        long dCacheSize = this._dCache.getMaxHeapSize();
        long iCacheSize = this._iCache.getMaxHeapSize();
        long sCacheSize = this._sCache.getMaxHeapSize();
        Runtime runtime = Runtime.getRuntime();
        if (usingNativeMap) {
            if (dCacheSize + iCacheSize + sCacheSize + totalQueueSize > runtime.maxMemory()) {
                throw new IllegalArgumentException(String.format("Block cache sizes %,d and mutation queue size %,d is too large for this JVM configuration %,d", dCacheSize + iCacheSize + sCacheSize, totalQueueSize, runtime.maxMemory()));
            }
        } else if (maxMemory + dCacheSize + iCacheSize + sCacheSize + totalQueueSize > runtime.maxMemory()) {
            throw new IllegalArgumentException(String.format("Maximum tablet server map memory %,d block cache sizes %,d and mutation queue size %,d is too large for this JVM configuration %,d", maxMemory, dCacheSize + iCacheSize + sCacheSize, totalQueueSize, runtime.maxMemory()));
        }
        runtime.gc();
        if (!usingNativeMap && maxMemory > runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) {
            log.warn("In-memory map may not fit into local memory space.");
        }
        this.minorCompactionThreadPool = ThreadPools.getServerThreadPools().createExecutorService(acuConf, Property.TSERV_MINC_MAXCONCURRENT, true);
        this.modifyThreadPoolSizesAtRuntime(() -> context.getConfiguration().getCount(Property.TSERV_MINC_MAXCONCURRENT), ThreadPoolNames.TSERVER_MINOR_COMPACTOR_POOL.poolName, this.minorCompactionThreadPool);
        this.splitThreadPool = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.SPLIT_POOL).numCoreThreads(0).numMaxThreads(1).withTimeOut(1L, TimeUnit.SECONDS).build();
        this.defaultSplitThreadPool = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.METADATA_DEFAULT_SPLIT_POOL).numCoreThreads(0).numMaxThreads(1).withTimeOut(60L, TimeUnit.SECONDS).build();
        this.defaultMigrationPool = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.METADATA_TABLET_MIGRATION_POOL).numCoreThreads(0).numMaxThreads(1).withTimeOut(60L, TimeUnit.SECONDS).build();
        this.migrationPool = ThreadPools.getServerThreadPools().createExecutorService(acuConf, Property.TSERV_MIGRATE_MAXCONCURRENT, enableMetrics);
        this.modifyThreadPoolSizesAtRuntime(() -> context.getConfiguration().getCount(Property.TSERV_MIGRATE_MAXCONCURRENT), ThreadPoolNames.TSERVER_TABLET_MIGRATION_POOL.poolName, this.migrationPool);
        this.assignmentPool = ThreadPools.getServerThreadPools().createExecutorService(acuConf, Property.TSERV_ASSIGNMENT_MAXCONCURRENT, enableMetrics);
        this.modifyThreadPoolSizesAtRuntime(() -> context.getConfiguration().getCount(Property.TSERV_ASSIGNMENT_MAXCONCURRENT), ThreadPoolNames.TABLET_ASSIGNMENT_POOL.poolName, this.assignmentPool);
        this.assignMetaDataPool = ThreadPools.getServerThreadPools().getPoolBuilder(ThreadPoolNames.METADATA_TABLET_ASSIGNMENT_POOL).numCoreThreads(0).numMaxThreads(1).withTimeOut(60L, TimeUnit.SECONDS).build();
        this.activeAssignments = new ConcurrentHashMap();
        this.summaryRetrievalPool = ThreadPools.getServerThreadPools().createExecutorService(acuConf, Property.TSERV_SUMMARY_RETRIEVAL_THREADS, enableMetrics);
        this.modifyThreadPoolSizesAtRuntime(() -> context.getConfiguration().getCount(Property.TSERV_SUMMARY_RETRIEVAL_THREADS), ThreadPoolNames.TSERVER_SUMMARY_FILE_RETRIEVER_POOL.poolName, this.summaryRetrievalPool);
        this.summaryRemotePool = ThreadPools.getServerThreadPools().createExecutorService(acuConf, Property.TSERV_SUMMARY_REMOTE_THREADS, enableMetrics);
        this.modifyThreadPoolSizesAtRuntime(() -> context.getConfiguration().getCount(Property.TSERV_SUMMARY_REMOTE_THREADS), ThreadPoolNames.TSERVER_SUMMARY_REMOTE_POOL.poolName, this.summaryRemotePool);
        this.summaryPartitionPool = ThreadPools.getServerThreadPools().createExecutorService(acuConf, Property.TSERV_SUMMARY_PARTITION_THREADS, enableMetrics);
        this.modifyThreadPoolSizesAtRuntime(() -> context.getConfiguration().getCount(Property.TSERV_SUMMARY_PARTITION_THREADS), ThreadPoolNames.TSERVER_SUMMARY_PARTITION_POOL.poolName, this.summaryPartitionPool);
        boolean isScanServer = tserver instanceof ScanServer;
        Collection scanExecCfg = acuConf.getScanExecutors(isScanServer);
        HashMap scanExecQueues = new HashMap();
        this.scanExecutors = scanExecCfg.stream().collect(Collectors.toUnmodifiableMap(cfg -> cfg.name, cfg -> this.createPriorityExecutor((AccumuloConfiguration.ScanExecutorConfig)cfg, scanExecQueues, enableMetrics)));
        this.scanExecutorChoices = scanExecCfg.stream().collect(Collectors.toUnmodifiableMap(cfg -> cfg.name, cfg -> new ScanExecutorImpl((AccumuloConfiguration.ScanExecutorConfig)cfg, (Queue)scanExecQueues.get(cfg.name))));
        int maxOpenFiles = acuConf.getCount(Property.TSERV_SCAN_MAX_OPENFILES);
        this.fileLenCache = CacheBuilder.newBuilder().maximumSize(Math.min((long)maxOpenFiles * 1000L, 100000L)).build();
        this.fileManager = new FileManager(context, maxOpenFiles, this.fileLenCache);
        this.memoryManager = new LargestFirstMemoryManager();
        this.memoryManager.init(context);
        this.memMgmt = new MemoryManagementFramework();
        this.memMgmt.startThreads();
        ThreadPools.watchCriticalScheduledTask(context.getScheduledExecutor().schedule(new AssignmentWatcher(acuConf, context, this.activeAssignments), 5000L, TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void holdAllCommits(boolean holdAllCommits) {
        Object object = this.commitHold;
        synchronized (object) {
            if (this.holdCommits != holdAllCommits) {
                this.holdCommits = holdAllCommits;
                if (this.holdCommits) {
                    this.holdStartTime = System.currentTimeMillis();
                }
                if (!this.holdCommits) {
                    log.debug(String.format("Commits held for %6.2f secs", (double)(System.currentTimeMillis() - this.holdStartTime) / 1000.0));
                    this.commitHold.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilCommitsAreEnabled() {
        if (this.holdCommits) {
            long timeout = System.currentTimeMillis() + this.context.getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT);
            Object object = this.commitHold;
            synchronized (object) {
                while (this.holdCommits) {
                    try {
                        if (System.currentTimeMillis() > timeout) {
                            throw new HoldTimeoutException("Commits are held");
                        }
                        this.commitHold.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long holdTime() {
        if (!this.holdCommits) {
            return 0L;
        }
        Object object = this.commitHold;
        synchronized (object) {
            return System.currentTimeMillis() - this.holdStartTime;
        }
    }

    public TabletResourceManager createTabletResourceManager(KeyExtent extent, AccumuloConfiguration conf) {
        return new TabletResourceManager(extent, conf);
    }

    public void executeSplit(KeyExtent tablet, Runnable splitTask) {
        if (tablet.isMeta()) {
            if (tablet.isRootTablet()) {
                log.warn("Saw request to split root tablet, ignoring");
                return;
            }
            this.defaultSplitThreadPool.execute(splitTask);
        } else {
            this.splitThreadPool.execute(splitTask);
        }
    }

    public void executeReadAhead(KeyExtent tablet, ScanDispatcher dispatcher, final ScanSession scanInfo, Runnable task) {
        task = ScanSession.wrap(scanInfo, task);
        if (tablet.isRootTablet()) {
            scanInfo.scanParams.setScanDispatch(ScanDispatch.builder().build());
            task.run();
        } else if (tablet.isMeta()) {
            scanInfo.scanParams.setScanDispatch(ScanDispatch.builder().build());
            this.scanExecutors.get("meta").execute(task);
        } else {
            DispatchParamsImpl params = new DispatchParamsImpl(){
                private final Supplier<ServiceEnvironment> senvSupplier = Suppliers.memoize(() -> new ServiceEnvironmentImpl(TabletServerResourceManager.this.context));

                public ScanInfo getScanInfo() {
                    return scanInfo;
                }

                public Map<String, ScanExecutor> getScanExecutors() {
                    return TabletServerResourceManager.this.scanExecutorChoices;
                }

                public ServiceEnvironment getServiceEnv() {
                    return this.senvSupplier.get();
                }
            };
            ScanDispatch prefs = dispatcher.dispatch((ScanDispatcher.DispatchParameters)params);
            scanInfo.scanParams.setScanDispatch(prefs);
            ThreadPoolExecutor executor = this.scanExecutors.get(prefs.getExecutorName());
            if (executor == null) {
                log.warn("For table id {}, {} dispatched to non-existent executor {} Using default executor.", new Object[]{tablet.tableId(), dispatcher.getClass().getName(), prefs.getExecutorName()});
                executor = this.scanExecutors.get("default");
            } else if ("meta".equals(prefs.getExecutorName())) {
                log.warn("For table id {}, {} dispatched to meta executor. Using default executor.", (Object)tablet.tableId(), (Object)dispatcher.getClass().getName());
                executor = this.scanExecutors.get("default");
            }
            executor.execute(task);
        }
    }

    public void addAssignment(KeyExtent extent, Logger log, AssignmentHandler assignmentHandler) {
        this.assignmentPool.execute(new ActiveAssignmentRunnable(this.activeAssignments, extent, assignmentHandler));
    }

    public void addMetaDataAssignment(KeyExtent extent, Logger log, AssignmentHandler assignmentHandler) {
        this.assignMetaDataPool.execute(new ActiveAssignmentRunnable(this.activeAssignments, extent, assignmentHandler));
    }

    public void addMigration(KeyExtent tablet, Runnable migrationHandler) {
        if (tablet.isRootTablet()) {
            migrationHandler.run();
        } else if (tablet.isMeta()) {
            this.defaultMigrationPool.execute(migrationHandler);
        } else {
            this.migrationPool.execute(migrationHandler);
        }
    }

    public BlockCache getIndexCache() {
        return this._iCache;
    }

    public BlockCache getDataCache() {
        return this._dCache;
    }

    public BlockCache getSummaryCache() {
        return this._sCache;
    }

    public Cache<String, Long> getFileLenCache() {
        return this.fileLenCache;
    }

    public ExecutorService getSummaryRetrievalExecutor() {
        return this.summaryRetrievalPool;
    }

    public ExecutorService getSummaryPartitionExecutor() {
        return this.summaryPartitionPool;
    }

    public ExecutorService getSummaryRemoteExecutor() {
        return this.summaryRemotePool;
    }

    private class MemoryManagementFramework {
        private final Map<KeyExtent, TabletMemoryReport> tabletReports;
        private final LinkedBlockingQueue<TabletMemoryReport> memUsageReports;
        private long lastMemCheckTime = System.currentTimeMillis();
        private long maxMem;
        private long lastMemTotal = 0L;
        private final Thread memoryGuardThread;
        private final Thread minorCompactionInitiatorThread;

        MemoryManagementFramework() {
            this.tabletReports = Collections.synchronizedMap(new HashMap());
            this.memUsageReports = new LinkedBlockingQueue();
            this.maxMem = TabletServerResourceManager.this.context.getConfiguration().getAsBytes(Property.TSERV_MAXMEM);
            this.memoryGuardThread = Threads.createThread((String)"Accumulo Memory Guard", (OptionalInt)OptionalInt.of(6), this::processTabletMemStats);
            this.minorCompactionInitiatorThread = Threads.createThread((String)"Accumulo Minor Compaction Initiator", this::manageMemory);
        }

        void startThreads() {
            this.memoryGuardThread.start();
            this.minorCompactionInitiatorThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTabletMemStats() {
            while (true) {
                try {
                    while (true) {
                        TabletMemoryReport report = this.memUsageReports.take();
                        while (report != null) {
                            this.tabletReports.put(report.getExtent(), report);
                            report = this.memUsageReports.poll();
                        }
                        long delta = System.currentTimeMillis() - this.lastMemCheckTime;
                        if (!TabletServerResourceManager.this.holdCommits && delta <= 50L && !((double)this.lastMemTotal > 0.9 * (double)this.maxMem)) continue;
                        this.lastMemCheckTime = System.currentTimeMillis();
                        long totalMemUsed = 0L;
                        Map<KeyExtent, TabletMemoryReport> map = this.tabletReports;
                        synchronized (map) {
                            for (TabletMemoryReport tsi : this.tabletReports.values()) {
                                totalMemUsed += tsi.getMemTableSize();
                                totalMemUsed += tsi.getMinorCompactingMemTableSize();
                            }
                        }
                        if ((double)totalMemUsed > 0.95 * (double)this.maxMem) {
                            TabletServerResourceManager.this.holdAllCommits(true);
                        } else {
                            TabletServerResourceManager.this.holdAllCommits(false);
                        }
                        this.lastMemTotal = totalMemUsed;
                    }
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted processing tablet memory statistics", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageMemory() {
            while (true) {
                block17: {
                    List<KeyExtent> tabletsToMinorCompact = null;
                    HashMap<KeyExtent, TabletMemoryReport> tabletReportsCopy = null;
                    try {
                        Map<KeyExtent, TabletMemoryReport> map = this.tabletReports;
                        synchronized (map) {
                            tabletReportsCopy = new HashMap<KeyExtent, TabletMemoryReport>(this.tabletReports);
                        }
                        ArrayList<TabletMemoryReport> tabletStates = new ArrayList<TabletMemoryReport>(tabletReportsCopy.values());
                        tabletsToMinorCompact = TabletServerResourceManager.this.memoryManager.tabletsToMinorCompact(tabletStates);
                    }
                    catch (Exception t) {
                        log.error("Memory manager failed {}", (Object)t.getMessage(), (Object)t);
                    }
                    try {
                        if (tabletsToMinorCompact == null || tabletsToMinorCompact.isEmpty()) break block17;
                        for (KeyExtent keyExtent : tabletsToMinorCompact) {
                            TabletMemoryReport tabletReport = (TabletMemoryReport)tabletReportsCopy.get(keyExtent);
                            if (tabletReport == null) {
                                log.warn("Memory manager asked to compact nonexistent tablet {}; manager implementation might be misbehaving", (Object)keyExtent);
                                continue;
                            }
                            Tablet tablet = tabletReport.getTablet();
                            if (tablet.initiateMinorCompaction(MinorCompactionReason.SYSTEM)) continue;
                            if (tablet.isClosed() || tablet.isBeingDeleted()) {
                                Map<KeyExtent, TabletMemoryReport> map = this.tabletReports;
                                synchronized (map) {
                                    TabletMemoryReport latestReport = this.tabletReports.remove(keyExtent);
                                    if (latestReport != null) {
                                        if (latestReport.getTablet() == tablet) {
                                            log.debug("Cleaned up report for closed/deleted tablet {}", (Object)keyExtent);
                                        } else {
                                            this.tabletReports.put(keyExtent, latestReport);
                                        }
                                    }
                                }
                                log.debug("Ignoring memory manager recommendation: not minor compacting closed tablet {}", (Object)keyExtent);
                                continue;
                            }
                            log.info("Ignoring memory manager recommendation: not minor compacting {}", (Object)keyExtent);
                        }
                    }
                    catch (Exception t) {
                        log.error("Minor compactions for memory management failed", (Throwable)t);
                    }
                }
                UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }

        public void updateMemoryUsageStats(Tablet tablet, long size, long lastCommitTime, long mincSize) {
            this.memUsageReports.add(new TabletMemoryReport(tablet, lastCommitTime, size, mincSize));
        }

        public void tabletClosed(KeyExtent extent) {
            this.tabletReports.remove(extent);
        }
    }

    public static class AssignmentWatcher
    implements Runnable {
        private static final Logger log = LoggerFactory.getLogger(AssignmentWatcher.class);
        private static long longAssignments = 0L;
        private final Map<KeyExtent, RunnableStartedAt> activeAssignments;
        private final AccumuloConfiguration conf;
        private final ServerContext context;

        public static long getLongAssignments() {
            return longAssignments;
        }

        public AssignmentWatcher(AccumuloConfiguration conf, ServerContext context, Map<KeyExtent, RunnableStartedAt> activeAssignments) {
            this.conf = conf;
            this.context = context;
            this.activeAssignments = activeAssignments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long millisBeforeWarning = this.conf.getTimeInMillis(Property.TSERV_ASSIGNMENT_DURATION_WARNING);
            try {
                long now = System.currentTimeMillis();
                long warnings = 0L;
                for (Map.Entry<KeyExtent, RunnableStartedAt> entry : this.activeAssignments.entrySet()) {
                    KeyExtent extent = entry.getKey();
                    RunnableStartedAt runnable = entry.getValue();
                    long duration = now - runnable.getStartTime();
                    if (duration > millisBeforeWarning) {
                        ++warnings;
                        log.warn("Assignment for {} has been running for at least {}ms", new Object[]{extent, duration, runnable.getTask().getException()});
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Assignment for {} only running for {}ms", (Object)extent, (Object)duration);
                }
                longAssignments = warnings;
            }
            catch (Exception e) {
                log.warn("Caught exception checking active assignments", (Throwable)e);
            }
            finally {
                long delay = Math.max((long)((double)millisBeforeWarning * 0.5), 5000L);
                if (log.isTraceEnabled()) {
                    log.trace("Rescheduling assignment watcher to run in {}ms", (Object)delay);
                }
                ThreadPools.watchCriticalScheduledTask(this.context.getScheduledExecutor().schedule(this, delay, TimeUnit.MILLISECONDS));
            }
        }
    }

    public class TabletResourceManager {
        private volatile boolean openFilesReserved = false;
        private volatile boolean closed = false;
        private final KeyExtent extent;
        private final AccumuloConfiguration tableConf;
        private final AtomicLong lastReportedSize = new AtomicLong();
        private final AtomicLong lastReportedMincSize = new AtomicLong();
        private volatile long lastReportedCommitTime = 0L;

        TabletResourceManager(KeyExtent extent, AccumuloConfiguration tableConf) {
            Objects.requireNonNull(extent, "extent is null");
            Objects.requireNonNull(tableConf, "tableConf is null");
            this.extent = extent;
            this.tableConf = tableConf;
        }

        @VisibleForTesting
        KeyExtent getExtent() {
            return this.extent;
        }

        @VisibleForTesting
        AccumuloConfiguration getTableConfiguration() {
            return this.tableConf;
        }

        public void importedMapFiles() {
            this.lastReportedCommitTime = System.currentTimeMillis();
        }

        public synchronized FileManager.ScanFileManager newScanFileManager(ScanDispatch scanDispatch) {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            return TabletServerResourceManager.this.fileManager.newScanFileManager(this.extent, (CacheProvider)new ScanCacheProvider(this.tableConf, scanDispatch, TabletServerResourceManager.this._iCache, TabletServerResourceManager.this._dCache));
        }

        public void updateMemoryUsageStats(Tablet tablet, long size, long mincSize) {
            long totalSize = size + mincSize;
            long lrs = this.lastReportedSize.get();
            long delta = totalSize - lrs;
            long lrms = this.lastReportedMincSize.get();
            boolean report = false;
            if ((lrms > 0L && mincSize == 0L || lrms == 0L && mincSize > 0L) && this.lastReportedMincSize.compareAndSet(lrms, mincSize)) {
                report = true;
            }
            long currentTime = System.currentTimeMillis();
            if ((delta > 32000L || delta < 0L || currentTime - this.lastReportedCommitTime > 1000L) && this.lastReportedSize.compareAndSet(lrs, totalSize)) {
                if (delta > 0L) {
                    this.lastReportedCommitTime = currentTime;
                }
                report = true;
            }
            if (report) {
                TabletServerResourceManager.this.memMgmt.updateMemoryUsageStats(tablet, size, this.lastReportedCommitTime, mincSize);
            }
        }

        public void executeMinorCompaction(Runnable r) {
            TabletServerResourceManager.this.minorCompactionThreadPool.execute(r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            TabletServerResourceManager tabletServerResourceManager = TabletServerResourceManager.this;
            synchronized (tabletServerResourceManager) {
                TabletResourceManager tabletResourceManager = this;
                synchronized (tabletResourceManager) {
                    if (this.closed) {
                        throw new IOException("closed");
                    }
                    if (this.openFilesReserved) {
                        throw new IOException("tired to close files while open files reserved");
                    }
                    TabletServerResourceManager.this.memMgmt.tabletClosed(this.extent);
                    this.closed = true;
                }
            }
        }

        public TabletServerResourceManager getTabletServerResourceManager() {
            return TabletServerResourceManager.this;
        }
    }

    private static class ScanExecutorImpl
    implements ScanExecutor {
        private final ConfigImpl config;
        private final Queue<?> queue;

        ScanExecutorImpl(AccumuloConfiguration.ScanExecutorConfig sec, Queue<?> q) {
            this.config = new ConfigImpl(sec);
            this.queue = q;
        }

        public int getQueued() {
            return this.queue.size();
        }

        public ScanExecutor.Config getConfig() {
            return this.config;
        }

        private static class ConfigImpl
        implements ScanExecutor.Config {
            final AccumuloConfiguration.ScanExecutorConfig cfg;

            public ConfigImpl(AccumuloConfiguration.ScanExecutorConfig sec) {
                this.cfg = sec;
            }

            public String getName() {
                return this.cfg.name;
            }

            public int getMaxThreads() {
                return this.cfg.maxThreads;
            }

            public Optional<String> getPrioritizerClass() {
                return this.cfg.prioritizerClass;
            }

            public Map<String, String> getPrioritizerOptions() {
                return this.cfg.prioritizerOpts;
            }
        }
    }

    private static abstract class DispatchParamsImpl
    implements ScanDispatcher.DispatchParameters,
    ScanDispatcher.DispatchParmaters {
        private DispatchParamsImpl() {
        }
    }
}

