/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.mapreduce.lib;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.clientImpl.mapreduce.lib.ConfiguratorBase;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.hadoop.conf.Configuration;

public class FileOutputConfigurator
extends ConfiguratorBase {
    protected static Boolean isSupportedAccumuloProperty(Property property) {
        switch (property) {
            case TABLE_FILE_COMPRESSION_TYPE: 
            case TABLE_FILE_COMPRESSED_BLOCK_SIZE: 
            case TABLE_FILE_BLOCK_SIZE: 
            case TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX: 
            case TABLE_FILE_REPLICATION: {
                return true;
            }
        }
        return false;
    }

    private static <T> void setAccumuloProperty(Class<?> implementingClass, Configuration conf, Property property, T value) {
        String val;
        if (FileOutputConfigurator.isSupportedAccumuloProperty(property).booleanValue()) {
            val = String.valueOf(value);
            if (!property.getType().isValidFormat(val)) {
                throw new IllegalArgumentException("Value is not appropriate for property type '" + property.getType() + "'");
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration property " + property.getKey());
        }
        conf.set(FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + "." + property.getKey(), val);
    }

    public static AccumuloConfiguration getAccumuloConfiguration(Class<?> implementingClass, Configuration conf) {
        String prefix = FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + ".";
        ConfigurationCopy acuConf = new ConfigurationCopy(DefaultConfiguration.getInstance());
        for (Map.Entry entry : conf) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            String propString = ((String)entry.getKey()).substring(prefix.length());
            Property prop = Property.getPropertyByKey(propString);
            if (prop != null) {
                acuConf.set(prop, (String)entry.getValue());
                continue;
            }
            if (Property.isValidTablePropertyKey(propString)) {
                acuConf.set(propString, (String)entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown accumulo file property " + propString);
        }
        return acuConf;
    }

    public static void setCompressionType(Class<?> implementingClass, Configuration conf, String compressionType) {
        if (compressionType == null || !Arrays.asList("none", "gz", "bzip2", "lzo", "lz4", "snappy", "zstd").contains(compressionType)) {
            throw new IllegalArgumentException("Compression type must be one of: none, gz, bzip2, lzo, lz4, snappy, zstd");
        }
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_COMPRESSION_TYPE, compressionType);
    }

    public static void setDataBlockSize(Class<?> implementingClass, Configuration conf, long dataBlockSize) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE, dataBlockSize);
    }

    public static void setFileBlockSize(Class<?> implementingClass, Configuration conf, long fileBlockSize) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_BLOCK_SIZE, fileBlockSize);
    }

    public static void setIndexBlockSize(Class<?> implementingClass, Configuration conf, long indexBlockSize) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX, indexBlockSize);
    }

    public static void setReplication(Class<?> implementingClass, Configuration conf, int replication) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_REPLICATION, replication);
    }

    public static void setSampler(Class<?> implementingClass, Configuration conf, SamplerConfiguration samplerConfig) {
        Map<String, String> props = new SamplerConfigurationImpl(samplerConfig).toTablePropertiesMap();
        Set<Map.Entry<String, String>> es = props.entrySet();
        for (Map.Entry<String, String> entry : es) {
            conf.set(FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + "." + entry.getKey(), entry.getValue());
        }
    }

    public static void setSummarizers(Class<?> implementingClass, Configuration conf, SummarizerConfiguration[] sumarizerConfigs) {
        Map<String, String> props = SummarizerConfiguration.toTableProperties(sumarizerConfigs);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            conf.set(FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + "." + entry.getKey(), entry.getValue());
        }
    }

    public static enum Opts {
        ACCUMULO_PROPERTIES;

    }
}

