/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.scan;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.scan.DefaultScanDispatch;
import org.apache.accumulo.core.spi.scan.ScanDispatch;
import org.apache.accumulo.core.spi.scan.ScanExecutor;
import org.apache.accumulo.core.spi.scan.ScanInfo;

public interface ScanDispatcher {
    default public void init(InitParameters params) {
        Preconditions.checkArgument((boolean)params.getOptions().isEmpty(), (Object)"No options expected");
    }

    @Deprecated(since="2.1.0")
    default public String dispatch(DispatchParmaters params) {
        throw new UnsupportedOperationException();
    }

    default public ScanDispatch dispatch(DispatchParameters params) {
        String executor = this.dispatch((DispatchParmaters)params);
        if (executor.equals(DefaultScanDispatch.DEFAULT_SCAN_DISPATCH.getExecutorName())) {
            return DefaultScanDispatch.DEFAULT_SCAN_DISPATCH;
        }
        return ScanDispatch.builder().setExecutorName(executor).build();
    }

    public static interface DispatchParameters {
        public ScanInfo getScanInfo();

        public Map<String, ScanExecutor> getScanExecutors();

        public ServiceEnvironment getServiceEnv();
    }

    @Deprecated(since="2.1.0")
    public static interface DispatchParmaters
    extends DispatchParameters {
    }

    public static interface InitParameters {
        public Map<String, String> getOptions();

        public TableId getTableId();

        public ServiceEnvironment getServiceEnv();
    }
}

