/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class ScanServerRefTabletFile
extends TabletFile {
    private final Value NULL_VALUE = new Value(new byte[0]);
    private final Text colf;
    private final Text colq;

    public ScanServerRefTabletFile(String file, String serverAddress, UUID serverLockUUID) {
        super(new Path(URI.create(file)));
        this.colf = new Text(serverAddress);
        this.colq = new Text(serverLockUUID.toString());
    }

    public ScanServerRefTabletFile(String file, Text colf, Text colq) {
        super(new Path(URI.create(file)));
        this.colf = colf;
        this.colq = colq;
    }

    public String getRowSuffix() {
        return this.getPathStr();
    }

    public Text getServerAddress() {
        return this.colf;
    }

    public Text getServerLockUUID() {
        return this.colq;
    }

    public Value getValue() {
        return this.NULL_VALUE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.colf == null ? 0 : this.colf.hashCode());
        result = 31 * result + (this.colq == null ? 0 : this.colq.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScanServerRefTabletFile other = (ScanServerRefTabletFile)obj;
        return Objects.equals(this.colf, other.colf) && Objects.equals(this.colq, other.colq);
    }

    @Override
    public String toString() {
        return "ScanServerRefTabletFile [file=" + this.getRowSuffix() + ", server address=" + this.colf + ", server lock uuid=" + this.colq + "]";
    }
}

