/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.logger;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.crypto.CryptoFactoryLoader;
import org.apache.accumulo.core.crypto.CryptoUtils;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.spi.crypto.CryptoEnvironment;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.spi.crypto.NoFileEncrypter;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.RecoveryLogsIterator;
import org.apache.accumulo.tserver.logger.LogEvents;
import org.apache.accumulo.tserver.logger.LogFileKey;
import org.apache.accumulo.tserver.logger.LogFileValue;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class LogReader
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(LogReader.class);

    public static void main(String[] args) throws Exception {
        new LogReader().execute(args);
    }

    public String keyword() {
        return "wal-info";
    }

    public String description() {
        return "Prints WAL Info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit is fine here because it's a utility class executed by a main()")
    public void execute(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs("accumulo wal-info", args, new Object[0]);
        if (opts.files.isEmpty()) {
            System.err.println("No WAL files were given");
            System.exit(1);
        }
        SiteConfiguration siteConfig = opts.getSiteConfiguration();
        ServerContext context = new ServerContext(siteConfig);
        try (VolumeManager fs = context.getVolumeManager();){
            CryptoService walCryptoService = CryptoFactoryLoader.getServiceForClient((CryptoEnvironment.Scope)CryptoEnvironment.Scope.WAL, (Map)siteConfig.getAllCryptoProperties());
            Matcher rowMatcher = null;
            KeyExtent ke = null;
            Text row = null;
            if (opts.row != null) {
                row = new Text(opts.row);
            }
            if (opts.extent != null) {
                String[] sa = opts.extent.split(";");
                ke = new KeyExtent(TableId.of((String)sa[0]), new Text(sa[1]), new Text(sa[2]));
            }
            if (opts.regexp != null) {
                Pattern pattern = Pattern.compile(opts.regexp);
                rowMatcher = pattern.matcher("");
            }
            HashSet<Integer> tabletIds = new HashSet<Integer>();
            block32: for (String file : opts.files) {
                Path path = new Path(file);
                LogFileKey key = new LogFileKey();
                LogFileValue value = new LogFileValue();
                if (fs.getFileStatus(path).isFile()) {
                    FSDataInputStream fsinput;
                    if (file.endsWith(".rf")) {
                        log.error("Unable to read from a single RFile. A non-sorted WAL file was expected. To read sorted WALs, please pass in a directory containing the sorted recovery logs.");
                        continue;
                    }
                    if (opts.printOnlyEncryptionInfo) {
                        fsinput = fs.open(path);
                        try {
                            this.printCryptoParams(fsinput, path);
                            continue;
                        }
                        finally {
                            if (fsinput != null) {
                                fsinput.close();
                            }
                            continue;
                        }
                    }
                    try {
                        fsinput = fs.open(path);
                        try {
                            DataInputStream input = DfsLogger.getDecryptingStream(fsinput, walCryptoService);
                            try {
                                while (true) {
                                    try {
                                        key.readFields(input);
                                        value.readFields(input);
                                    }
                                    catch (EOFException ex) {
                                        continue block32;
                                    }
                                    LogReader.printLogEvent(key, value, row, rowMatcher, ke, tabletIds, opts.maxMutations);
                                }
                            }
                            finally {
                                if (input == null) continue;
                                input.close();
                                continue;
                            }
                        }
                        finally {
                            if (fsinput == null) continue;
                            fsinput.close();
                            continue;
                        }
                    }
                    catch (DfsLogger.LogHeaderIncompleteException e) {
                        log.warn("Could not read header for {} . Ignoring...", (Object)path);
                        continue;
                    }
                    finally {
                        log.info("Done reading {}", (Object)path);
                        continue;
                    }
                }
                try (RecoveryLogsIterator rli = new RecoveryLogsIterator(context, Collections.singletonList(path), null, null, false);){
                    while (rli.hasNext()) {
                        Object entry = rli.next();
                        LogReader.printLogEvent((LogFileKey)entry.getKey(), (LogFileValue)entry.getValue(), row, rowMatcher, ke, tabletIds, opts.maxMutations);
                    }
                }
            }
        }
    }

    private void printCryptoParams(FSDataInputStream input, Path path) {
        block9: {
            byte[] magic4 = "--- Log File Header (v4) ---".getBytes(StandardCharsets.UTF_8);
            byte[] magic3 = "--- Log File Header (v3) ---".getBytes(StandardCharsets.UTF_8);
            byte[] noCryptoBytes = new NoFileEncrypter().getDecryptionParameters();
            if (magic4.length != magic3.length) {
                throw new AssertionError((Object)("Always expect log file headers to be same length : " + magic4.length + " != " + magic3.length));
            }
            byte[] magicBuffer = new byte[magic4.length];
            try {
                input.readFully(magicBuffer);
                if (Arrays.equals(magicBuffer, magic4)) {
                    byte[] cryptoParams = CryptoUtils.readParams((DataInputStream)input);
                    if (Arrays.equals(noCryptoBytes, cryptoParams)) {
                        System.out.println("No on disk encryption detected.");
                    } else {
                        System.out.println("Encrypted with Params: " + Key.toPrintableString((byte[])cryptoParams, (int)0, (int)cryptoParams.length, (int)cryptoParams.length));
                    }
                    break block9;
                }
                if (Arrays.equals(magicBuffer, magic3)) {
                    String cryptoModuleClassname = input.readUTF();
                    if (!cryptoModuleClassname.equals("NullCryptoModule")) {
                        throw new IllegalArgumentException("Old encryption modules not supported at this time.  Unsupported module : " + cryptoModuleClassname);
                    }
                    break block9;
                }
                throw new IllegalArgumentException("Unsupported write ahead log version " + new String(magicBuffer));
            }
            catch (EOFException e) {
                log.warn("Could not read header for {} . Ignoring...", (Object)path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void printLogEvent(LogFileKey key, LogFileValue value, Text row, Matcher rowMatcher, KeyExtent ke, Set<Integer> tabletIds, int maxMutations) {
        if (ke != null) {
            if (key.event == LogEvents.DEFINE_TABLET) {
                if (!key.tablet.equals((Object)ke)) return;
                tabletIds.add(key.tabletId);
            } else if (!tabletIds.contains(key.tabletId)) {
                return;
            }
        }
        if (row != null || rowMatcher != null) {
            if (key.event != LogEvents.MUTATION && key.event != LogEvents.MANY_MUTATIONS) return;
            boolean found = false;
            for (Mutation m : value.mutations) {
                if (row != null && new Text(m.getRow()).equals((Object)row)) {
                    found = true;
                    break;
                }
                if (rowMatcher == null) continue;
                rowMatcher.reset(new String(m.getRow(), StandardCharsets.UTF_8));
                if (!rowMatcher.matches()) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        System.out.println(key);
        System.out.println(LogFileValue.format(value, maxMutations));
    }

    static class Opts
    extends ConfigOpts {
        @Parameter(names={"-e"}, description="Don't read full log and print only encryption information")
        boolean printOnlyEncryptionInfo = false;
        @Parameter(names={"-r"}, description="print only mutations associated with the given row")
        String row;
        @Parameter(names={"-m"}, description="limit the number of mutations printed per row")
        int maxMutations = 5;
        @Parameter(names={"-t"}, description="print only mutations that fall within the given key extent")
        String extent;
        @Parameter(names={"--regex"}, description="search for a row that matches the given regex")
        String regexp;
        @Parameter(description="<logfile> { <logfile> ... }")
        List<String> files = new ArrayList<String>();

        Opts() {
        }
    }
}

