/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.client.PluginEnvironment;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;

public class ConfigurationImpl
implements ServiceEnvironment.Configuration {
    private final AccumuloConfiguration acfg;
    private Map<String, String> customProps;
    private Map<String, String> tableCustomProps;

    public ConfigurationImpl(AccumuloConfiguration acfg) {
        this.acfg = acfg;
    }

    @Override
    public boolean isSet(String key) {
        Property prop = Property.getPropertyByKey(key);
        if (prop != null) {
            return this.acfg.isPropertySet(prop);
        }
        return this.acfg.get(key) != null;
    }

    @Override
    public String get(String key) {
        Property prop = Property.getPropertyByKey(key);
        if (prop != null) {
            if (prop.isSensitive()) {
                return null;
            }
            return this.acfg.get(prop);
        }
        return this.acfg.get(key);
    }

    @Override
    public Map<String, String> getWithPrefix(String prefix) {
        Property propertyPrefix = Property.getPropertyByKey(prefix);
        if (propertyPrefix != null && propertyPrefix.getType() == PropertyType.PREFIX) {
            return this.acfg.getAllPropertiesWithPrefix(propertyPrefix);
        }
        return StreamSupport.stream(this.acfg.spliterator(), false).filter(prop -> ((String)prop.getKey()).startsWith(prefix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, String> getCustom() {
        if (this.customProps == null) {
            this.customProps = this.buildCustom(Property.GENERAL_ARBITRARY_PROP_PREFIX);
        }
        return this.customProps;
    }

    @Override
    public String getCustom(String keySuffix) {
        return this.getCustom().get(keySuffix);
    }

    @Override
    public Map<String, String> getTableCustom() {
        if (this.tableCustomProps == null) {
            this.tableCustomProps = this.buildCustom(Property.TABLE_ARBITRARY_PROP_PREFIX);
        }
        return this.tableCustomProps;
    }

    @Override
    public String getTableCustom(String keySuffix) {
        return this.getTableCustom().get(keySuffix);
    }

    private Map<String, String> buildCustom(Property customPrefix) {
        return this.acfg.getAllPropertiesWithPrefix(customPrefix).entrySet().stream().collect(Collectors.toUnmodifiableMap(e -> ((String)e.getKey()).substring(customPrefix.getKey().length()), Map.Entry::getValue));
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return StreamSupport.stream(this.acfg.spliterator(), false).filter(e -> !Property.isSensitive((String)e.getKey())).iterator();
    }

    @Override
    public <T> Supplier<T> getDerived(Function<PluginEnvironment.Configuration, T> computeDerivedValue) {
        ConfigurationImpl outerConfiguration = this;
        AccumuloConfiguration.Deriver<Object> deriver = this.acfg.newDeriver(entries -> computeDerivedValue.apply(outerConfiguration));
        return deriver::derive;
    }
}

