/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.trace;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.trace.TraceWrappedCallable;
import org.apache.accumulo.core.trace.TraceWrappedRunnable;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceUtil {
    public static final Logger LOG = LoggerFactory.getLogger(TraceUtil.class);
    private static final String SPAN_FORMAT = "%s::%s";
    private static volatile boolean enabled = true;

    public static void initializeTracer(AccumuloConfiguration conf) {
        enabled = conf.getBoolean(Property.GENERAL_OPENTELEMETRY_ENABLED);
        TraceUtil.logTracingState();
    }

    private static void logTracingState() {
        String msg = "Trace enabled in Accumulo: {}, OpenTelemetry instance: {}, Tracer instance: {}";
        String enabledInAccumulo = enabled ? "yes" : "no";
        OpenTelemetry openTelemetry = TraceUtil.getOpenTelemetry();
        Tracer tracer = TraceUtil.getTracer(openTelemetry);
        LOG.info(msg, new Object[]{enabledInAccumulo, openTelemetry.getClass(), tracer.getClass()});
    }

    private static OpenTelemetry getOpenTelemetry() {
        return enabled ? GlobalOpenTelemetry.get() : OpenTelemetry.noop();
    }

    private static Tracer getTracer(OpenTelemetry ot) {
        return ot.getTracer("org.apache.accumulo", "2.1.1");
    }

    public static Span startSpan(Class<?> caller, String spanName) {
        return TraceUtil.startSpan(caller, spanName, null, null, null);
    }

    public static Span startSpan(Class<?> caller, String spanName, Map<String, String> attributes) {
        return TraceUtil.startSpan(caller, spanName, null, attributes, null);
    }

    public static Span startClientRpcSpan(Class<?> caller, String spanName) {
        return TraceUtil.startSpan(caller, spanName, SpanKind.CLIENT, null, null);
    }

    public static Span startFateSpan(Class<?> caller, String spanName, TInfo tinfo) {
        return TraceUtil.startSpan(caller, spanName, null, null, tinfo);
    }

    public static Span startServerRpcSpan(Class<?> caller, String spanName, TInfo tinfo) {
        return TraceUtil.startSpan(caller, spanName, SpanKind.SERVER, null, tinfo);
    }

    private static Span startSpan(Class<?> caller, String spanName, SpanKind kind, Map<String, String> attributes, TInfo tinfo) {
        if (!enabled && !Span.current().getSpanContext().isValid()) {
            return Span.getInvalid();
        }
        String name = String.format(SPAN_FORMAT, caller.getSimpleName(), spanName);
        SpanBuilder builder = TraceUtil.getTracer(TraceUtil.getOpenTelemetry()).spanBuilder(name);
        if (kind != null) {
            builder.setSpanKind(kind);
        }
        if (attributes != null) {
            attributes.forEach((arg_0, arg_1) -> ((SpanBuilder)builder).setAttribute(arg_0, arg_1));
        }
        if (tinfo != null) {
            builder.setParent(TraceUtil.getContext(tinfo));
        }
        return builder.startSpan();
    }

    public static void setException(Span span, Throwable e, boolean rethrown) {
        if (enabled) {
            span.setStatus(StatusCode.ERROR);
            span.recordException(e, Attributes.builder().put(SemanticAttributes.EXCEPTION_TYPE, (Object)e.getClass().getName()).put(SemanticAttributes.EXCEPTION_MESSAGE, (Object)e.getMessage()).put(SemanticAttributes.EXCEPTION_ESCAPED, (Object)rethrown).build());
        }
    }

    public static TInfo traceInfo() {
        TInfo tinfo = new TInfo();
        W3CTraceContextPropagator.getInstance().inject(Context.current(), (Object)tinfo, TInfo::putToHeaders);
        return tinfo;
    }

    private static Context getContext(TInfo tinfo) {
        return W3CTraceContextPropagator.getInstance().extract(Context.current(), (Object)tinfo, (TextMapGetter)new TextMapGetter<TInfo>(){

            public Iterable<String> keys(TInfo carrier) {
                if (carrier.getHeaders() == null) {
                    return null;
                }
                return carrier.getHeaders().keySet();
            }

            public String get(TInfo carrier, String key) {
                if (carrier.getHeaders() == null) {
                    return null;
                }
                return carrier.getHeaders().get(key);
            }
        });
    }

    public static Runnable wrap(Runnable r) {
        return r instanceof TraceWrappedRunnable ? r : new TraceWrappedRunnable(r);
    }

    public static Runnable unwrap(Runnable r) {
        return TraceWrappedRunnable.unwrapFully(r);
    }

    public static <T> Callable<T> wrap(Callable<T> c) {
        return c instanceof TraceWrappedCallable ? c : new TraceWrappedCallable(c);
    }

    public static <T> Callable<T> unwrap(Callable<T> c) {
        return TraceWrappedCallable.unwrapFully(c);
    }

    public static <T> T wrapService(T instance) {
        InvocationHandler handler = (obj, method, args) -> {
            if (args == null || args.length < 1 || args[0] == null || !(args[0] instanceof TInfo)) {
                try {
                    return method.invoke(instance, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            Span span = TraceUtil.startServerRpcSpan(instance.getClass(), method.getName(), (TInfo)args[0]);
            try {
                Object object;
                block14: {
                    Scope scope = span.makeCurrent();
                    try {
                        object = method.invoke(instance, args);
                        if (scope == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            Throwable t = e instanceof InvocationTargetException ? e.getCause() : e;
                            TraceUtil.setException(span, t, true);
                            throw t;
                        }
                    }
                    scope.close();
                }
                return object;
            }
            finally {
                span.end();
            }
        };
        return TraceUtil.wrapRpc(handler, instance);
    }

    private static <T> T wrapRpc(InvocationHandler handler, T instance) {
        Object proxiedInstance = Proxy.newProxyInstance(instance.getClass().getClassLoader(), instance.getClass().getInterfaces(), handler);
        return (T)proxiedInstance;
    }
}

