/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletDirectory;
import org.apache.accumulo.core.metadata.ValidationUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletFile
implements Comparable<TabletFile> {
    private final TabletDirectory tabletDir;
    private final String fileName;
    protected final Path metaPath;
    private final String normalizedPath;
    private static final Logger log = LoggerFactory.getLogger(TabletFile.class);

    public TabletFile(Path metaPath) {
        this.metaPath = Objects.requireNonNull(metaPath);
        String errorMsg = "Missing or invalid part of tablet file metadata entry: " + metaPath;
        log.trace("Parsing TabletFile from {}", (Object)metaPath);
        this.fileName = metaPath.getName();
        ValidationUtil.validateFileName(this.fileName);
        Path tabletDirPath = Objects.requireNonNull(metaPath.getParent(), errorMsg);
        Path tableIdPath = Objects.requireNonNull(tabletDirPath.getParent(), errorMsg);
        String id = tableIdPath.getName();
        Path tablePath = Objects.requireNonNull(tableIdPath.getParent(), errorMsg);
        String tpString = "/" + tablePath.getName();
        Preconditions.checkArgument((boolean)tpString.equals("/tables"), (Object)errorMsg);
        Path volumePath = Objects.requireNonNull(tablePath.getParent(), errorMsg);
        Preconditions.checkArgument((volumePath.toUri().getScheme() != null ? 1 : 0) != 0, (Object)errorMsg);
        String volume = volumePath.toString();
        this.tabletDir = new TabletDirectory(volume, TableId.of(id), tabletDirPath.getName());
        this.normalizedPath = this.tabletDir.getNormalizedPath() + "/" + this.fileName;
    }

    public String getVolume() {
        return this.tabletDir.getVolume();
    }

    public TableId getTableId() {
        return this.tabletDir.getTableId();
    }

    public String getTabletDir() {
        return this.tabletDir.getTabletDir();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathStr() {
        return this.normalizedPath;
    }

    public String getMetaInsert() {
        return this.normalizedPath;
    }

    public Text getMetaInsertText() {
        return new Text(this.getMetaInsert());
    }

    public StoredTabletFile insert() {
        return new StoredTabletFile(this.normalizedPath);
    }

    public Path getPath() {
        return this.metaPath;
    }

    @Override
    public int compareTo(TabletFile o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.normalizedPath.compareTo(o.normalizedPath);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TabletFile) {
            TabletFile that = (TabletFile)obj;
            return this.normalizedPath.equals(that.normalizedPath);
        }
        return false;
    }

    public int hashCode() {
        return this.normalizedPath.hashCode();
    }

    public String toString() {
        return this.normalizedPath;
    }
}

