/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.lru;

import org.apache.accumulo.core.file.blockfile.cache.lru.LruBlockCache;
import org.apache.accumulo.core.file.blockfile.cache.lru.LruBlockCacheConfiguration;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.BlockCacheManager;
import org.apache.accumulo.core.spi.cache.CacheType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LruBlockCacheManager
extends BlockCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(LruBlockCacheManager.class);

    @Override
    protected BlockCache createCache(BlockCacheManager.Configuration conf, CacheType type) {
        LruBlockCacheConfiguration cc = new LruBlockCacheConfiguration(conf, type);
        LOG.info("Creating {} cache with configuration {}", (Object)type, (Object)cc);
        return new LruBlockCache(cc);
    }

    @Override
    public void stop() {
        for (CacheType type : CacheType.values()) {
            LruBlockCache cache = (LruBlockCache)this.getBlockCache(type);
            if (cache == null) continue;
            cache.shutdown();
        }
        super.stop();
    }
}

