/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.fate.Fate;
import org.apache.accumulo.core.fate.ReadOnlyRepo;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.TStore;
import org.apache.accumulo.core.fate.zookeeper.FateLock;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(AdminUtil.class);
    private final boolean exitOnError;

    public AdminUtil(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    public List<TransactionStatus> getTransactionStatus(ReadOnlyTStore<T> zs, Set<Long> filterTxid, EnumSet<ReadOnlyTStore.TStatus> filterStatus) {
        FateStatus status = this.getTransactionStatus(zs, filterTxid, filterStatus, Collections.emptyMap(), Collections.emptyMap());
        return status.getTransactions();
    }

    public FateStatus getStatus(ReadOnlyTStore<T> zs, ZooReader zk, ServiceLock.ServiceLockPath lockPath, Set<Long> filterTxid, EnumSet<ReadOnlyTStore.TStatus> filterStatus) throws KeeperException, InterruptedException {
        HashMap<Long, List<String>> heldLocks = new HashMap<Long, List<String>>();
        HashMap<Long, List<String>> waitingLocks = new HashMap<Long, List<String>>();
        this.findLocks(zk, lockPath, heldLocks, waitingLocks);
        return this.getTransactionStatus(zs, filterTxid, filterStatus, heldLocks, waitingLocks);
    }

    private void findLocks(ZooReader zk, ServiceLock.ServiceLockPath lockPath, Map<Long, List<String>> heldLocks, Map<Long, List<String>> waitingLocks) throws KeeperException, InterruptedException {
        List<String> lockedIds = zk.getChildren(lockPath.toString());
        for (String id : lockedIds) {
            try {
                FateLock.FateLockPath fLockPath = FateLock.path(lockPath + "/" + id);
                List<String> lockNodes = FateLock.validateAndSort(fLockPath, zk.getChildren(fLockPath.toString()));
                int pos = 0;
                boolean sawWriteLock = false;
                for (String node : lockNodes) {
                    try {
                        byte[] data = zk.getData(lockPath + "/" + id + "/" + node);
                        String[] lda = new String(data, StandardCharsets.UTF_8).split(":");
                        if (lda[0].charAt(0) == 'W') {
                            sawWriteLock = true;
                        }
                        Map<Long, List<String>> locks = pos == 0 ? heldLocks : (lda[0].charAt(0) == 'R' && !sawWriteLock ? heldLocks : waitingLocks);
                        locks.computeIfAbsent(Long.parseLong(lda[1], 16), k -> new ArrayList()).add(lda[0].charAt(0) + ":" + id);
                    }
                    catch (Exception e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                    }
                    ++pos;
                }
            }
            catch (KeeperException ex) {
                log.error("Failed to read locks for " + id + " continuing.", (Throwable)ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw ex;
            }
        }
    }

    private FateStatus getTransactionStatus(ReadOnlyTStore<T> zs, Set<Long> filterTxid, EnumSet<ReadOnlyTStore.TStatus> filterStatus, Map<Long, List<String>> heldLocks, Map<Long, List<String>> waitingLocks) {
        List<Long> transactions = zs.list();
        ArrayList<TransactionStatus> statuses = new ArrayList<TransactionStatus>(transactions.size());
        for (Long tid : transactions) {
            List<String> wlocks;
            zs.reserve(tid);
            String txName = (String)((Object)zs.getTransactionInfo(tid, Fate.TxInfo.TX_NAME));
            List<String> hlocks = heldLocks.remove(tid);
            if (hlocks == null) {
                hlocks = Collections.emptyList();
            }
            if ((wlocks = waitingLocks.remove(tid)) == null) {
                wlocks = Collections.emptyList();
            }
            String top = null;
            ReadOnlyRepo<T> repo = zs.top(tid);
            if (repo != null) {
                top = repo.getName();
            }
            ReadOnlyTStore.TStatus status = zs.getStatus(tid);
            long timeCreated = zs.timeCreated(tid);
            zs.unreserve(tid, 0L);
            if (!this.includeByStatus(status, filterStatus) || !this.includeByTxid(tid, filterTxid)) continue;
            statuses.add(new TransactionStatus(tid, status, txName, hlocks, wlocks, top, timeCreated));
        }
        return new FateStatus(statuses, heldLocks, waitingLocks);
    }

    private boolean includeByStatus(ReadOnlyTStore.TStatus status, EnumSet<ReadOnlyTStore.TStatus> filterStatus) {
        return filterStatus == null || filterStatus.contains((Object)status);
    }

    private boolean includeByTxid(Long tid, Set<Long> filterTxid) {
        return filterTxid == null || filterTxid.isEmpty() || filterTxid.contains(tid);
    }

    public void printAll(ReadOnlyTStore<T> zs, ZooReader zk, ServiceLock.ServiceLockPath tableLocksPath) throws KeeperException, InterruptedException {
        this.print(zs, zk, tableLocksPath, new Formatter(System.out), null, null);
    }

    public void print(ReadOnlyTStore<T> zs, ZooReader zk, ServiceLock.ServiceLockPath tableLocksPath, Formatter fmt, Set<Long> filterTxid, EnumSet<ReadOnlyTStore.TStatus> filterStatus) throws KeeperException, InterruptedException {
        FateStatus fateStatus = this.getStatus(zs, zk, tableLocksPath, filterTxid, filterStatus);
        for (TransactionStatus transactionStatus : fateStatus.getTransactions()) {
            fmt.format("%-15s txid: %s  status: %-18s locked: %-15s locking: %-15s op: %-15s created: %s%n", new Object[]{transactionStatus.getTxName(), transactionStatus.getTxid(), transactionStatus.getStatus(), transactionStatus.getHeldLocks(), transactionStatus.getWaitingLocks(), transactionStatus.getTop(), transactionStatus.getTimeCreatedFormatted()});
        }
        fmt.format(" %s transactions", fateStatus.getTransactions().size());
        if (!fateStatus.getDanglingHeldLocks().isEmpty() || !fateStatus.getDanglingWaitingLocks().isEmpty()) {
            fmt.format("%nThe following locks did not have an associated FATE operation%n", new Object[0]);
            for (Map.Entry entry : fateStatus.getDanglingHeldLocks().entrySet()) {
                fmt.format("txid: %s  locked: %s%n", entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : fateStatus.getDanglingWaitingLocks().entrySet()) {
                fmt.format("txid: %s  locking: %s%n", entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean prepDelete(TStore<T> zs, ZooReaderWriter zk, ServiceLock.ServiceLockPath path, String txidStr) {
        long txid;
        if (!this.checkGlobalLock(zk, path)) {
            return false;
        }
        try {
            txid = Long.parseLong(txidStr, 16);
        }
        catch (NumberFormatException nfe) {
            System.out.printf("Invalid transaction ID format: %s%n", txidStr);
            return false;
        }
        boolean state = false;
        zs.reserve(txid);
        ReadOnlyTStore.TStatus ts = zs.getStatus(txid);
        switch (ts) {
            case UNKNOWN: {
                System.out.printf("Invalid transaction ID: %016x%n", txid);
                break;
            }
            case SUBMITTED: 
            case IN_PROGRESS: 
            case NEW: 
            case FAILED: 
            case FAILED_IN_PROGRESS: 
            case SUCCESSFUL: {
                System.out.printf("Deleting transaction: %016x (%s)%n", new Object[]{txid, ts});
                zs.delete(txid);
                state = true;
            }
        }
        zs.unreserve(txid, 0L);
        return state;
    }

    public boolean prepFail(TStore<T> zs, ZooReaderWriter zk, ServiceLock.ServiceLockPath zLockManagerPath, String txidStr) {
        long txid;
        if (!this.checkGlobalLock(zk, zLockManagerPath)) {
            return false;
        }
        try {
            txid = Long.parseLong(txidStr, 16);
        }
        catch (NumberFormatException nfe) {
            System.out.printf("Invalid transaction ID format: %s%n", txidStr);
            return false;
        }
        boolean state = false;
        zs.reserve(txid);
        ReadOnlyTStore.TStatus ts = zs.getStatus(txid);
        switch (ts) {
            case UNKNOWN: {
                System.out.printf("Invalid transaction ID: %016x%n", txid);
                break;
            }
            case SUBMITTED: 
            case IN_PROGRESS: 
            case NEW: {
                System.out.printf("Failing transaction: %016x (%s)%n", new Object[]{txid, ts});
                zs.setStatus(txid, ReadOnlyTStore.TStatus.FAILED_IN_PROGRESS);
                state = true;
                break;
            }
            case SUCCESSFUL: {
                System.out.printf("Transaction already completed: %016x (%s)%n", new Object[]{txid, ts});
                break;
            }
            case FAILED: 
            case FAILED_IN_PROGRESS: {
                System.out.printf("Transaction already failed: %016x (%s)%n", new Object[]{txid, ts});
                state = true;
            }
        }
        zs.unreserve(txid, 0L);
        return state;
    }

    public void deleteLocks(ZooReaderWriter zk, ServiceLock.ServiceLockPath path, String txidStr) throws KeeperException, InterruptedException {
        List<String> lockedIds = zk.getChildren(path.toString());
        for (String id : lockedIds) {
            List<String> lockNodes = zk.getChildren(path + "/" + id);
            for (String node : lockNodes) {
                String lockPath = path + "/" + id + "/" + node;
                byte[] data = zk.getData(path + "/" + id + "/" + node);
                String[] lda = new String(data, StandardCharsets.UTF_8).split(":");
                if (!lda[1].equals(txidStr)) continue;
                zk.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.SKIP);
            }
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="TODO - should probably avoid System.exit here; this code is used by the fate admin shell command")
    public boolean checkGlobalLock(ZooReaderWriter zk, ServiceLock.ServiceLockPath zLockManagerPath) {
        block6: {
            try {
                if (ServiceLock.getLockData(zk.getZooKeeper(), zLockManagerPath) == null) break block6;
                System.err.println("ERROR: Manager lock is held, not running");
                if (this.exitOnError) {
                    System.exit(1);
                    break block6;
                }
                return false;
            }
            catch (KeeperException e) {
                System.err.println("ERROR: Could not read manager lock, not running " + e.getMessage());
                if (this.exitOnError) {
                    System.exit(1);
                }
                return false;
            }
            catch (InterruptedException e) {
                System.err.println("ERROR: Could not read manager lock, not running" + e.getMessage());
                if (this.exitOnError) {
                    System.exit(1);
                }
                return false;
            }
        }
        return true;
    }

    public static class FateStatus {
        private final List<TransactionStatus> transactions;
        private final Map<String, List<String>> danglingHeldLocks;
        private final Map<String, List<String>> danglingWaitingLocks;

        private static Map<String, List<String>> convert(Map<Long, List<String>> danglocks) {
            if (danglocks.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
            for (Map.Entry<Long, List<String>> entry : danglocks.entrySet()) {
                ret.put(FastFormat.toHexString(entry.getKey()), Collections.unmodifiableList(entry.getValue()));
            }
            return Collections.unmodifiableMap(ret);
        }

        private FateStatus(List<TransactionStatus> transactions, Map<Long, List<String>> danglingHeldLocks, Map<Long, List<String>> danglingWaitingLocks) {
            this.transactions = Collections.unmodifiableList(transactions);
            this.danglingHeldLocks = FateStatus.convert(danglingHeldLocks);
            this.danglingWaitingLocks = FateStatus.convert(danglingWaitingLocks);
        }

        public List<TransactionStatus> getTransactions() {
            return this.transactions;
        }

        public Map<String, List<String>> getDanglingHeldLocks() {
            return this.danglingHeldLocks;
        }

        public Map<String, List<String>> getDanglingWaitingLocks() {
            return this.danglingWaitingLocks;
        }
    }

    public static class TransactionStatus {
        private final long txid;
        private final ReadOnlyTStore.TStatus status;
        private final String txName;
        private final List<String> hlocks;
        private final List<String> wlocks;
        private final String top;
        private final long timeCreated;

        private TransactionStatus(Long tid, ReadOnlyTStore.TStatus status, String txName, List<String> hlocks, List<String> wlocks, String top, Long timeCreated) {
            this.txid = tid;
            this.status = status;
            this.txName = txName;
            this.hlocks = Collections.unmodifiableList(hlocks);
            this.wlocks = Collections.unmodifiableList(wlocks);
            this.top = top;
            this.timeCreated = timeCreated;
        }

        public String getTxid() {
            return FastFormat.toHexString(this.txid);
        }

        public ReadOnlyTStore.TStatus getStatus() {
            return this.status;
        }

        public String getTxName() {
            return this.txName;
        }

        public List<String> getHeldLocks() {
            return this.hlocks;
        }

        public List<String> getWaitingLocks() {
            return this.wlocks;
        }

        public String getTop() {
            return this.top;
        }

        public String getTimeCreatedFormatted() {
            return this.timeCreated > 0L ? new Date(this.timeCreated).toInstant().atZone(ZoneOffset.UTC).format(DateTimeFormatter.ISO_DATE_TIME) : "ERROR";
        }

        public long getTimeCreated() {
            return this.timeCreated;
        }
    }
}

