/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedBytes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.io.Text;

public class LoadPlan {
    private final List<Destination> destinations;

    private static byte[] copy(byte[] data) {
        return data == null ? null : Arrays.copyOf(data, data.length);
    }

    private static byte[] copy(Text data) {
        return data == null ? null : data.copyBytes();
    }

    private static byte[] copy(CharSequence data) {
        return data == null ? null : data.toString().getBytes(StandardCharsets.UTF_8);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="this code is validating the input")
    private static String checkFileName(String fileName) {
        Preconditions.checkArgument((Paths.get(fileName, new String[0]).getNameCount() == 1 ? 1 : 0) != 0, (String)"Expected only filename, but got %s", (Object)fileName);
        return fileName;
    }

    private LoadPlan(List<Destination> destinations) {
        this.destinations = destinations;
    }

    public Collection<Destination> getDestinations() {
        return this.destinations;
    }

    public static Builder builder() {
        return new Builder(){
            final ImmutableList.Builder<Destination> fmb = ImmutableList.builder();

            @Override
            public Builder loadFileTo(String fileName, RangeType rangeType, Text startRow, Text endRow) {
                this.fmb.add((Object)new Destination(fileName, rangeType, LoadPlan.copy(startRow), LoadPlan.copy(endRow)));
                return this;
            }

            @Override
            public Builder loadFileTo(String fileName, RangeType rangeType, byte[] startRow, byte[] endRow) {
                this.fmb.add((Object)new Destination(fileName, rangeType, LoadPlan.copy(startRow), LoadPlan.copy(endRow)));
                return this;
            }

            @Override
            public Builder loadFileTo(String fileName, RangeType rangeType, CharSequence startRow, CharSequence endRow) {
                this.fmb.add((Object)new Destination(fileName, rangeType, LoadPlan.copy(startRow), LoadPlan.copy(endRow)));
                return this;
            }

            @Override
            public Builder addPlan(LoadPlan plan) {
                this.fmb.addAll(plan.getDestinations());
                return this;
            }

            @Override
            public LoadPlan build() {
                return new LoadPlan((List<Destination>)this.fmb.build());
            }
        };
    }

    public static interface Builder {
        public Builder loadFileTo(String var1, RangeType var2, Text var3, Text var4);

        public Builder loadFileTo(String var1, RangeType var2, byte[] var3, byte[] var4);

        public Builder loadFileTo(String var1, RangeType var2, CharSequence var3, CharSequence var4);

        public Builder addPlan(LoadPlan var1);

        public LoadPlan build();
    }

    public static class Destination {
        private final String fileName;
        private final byte[] startRow;
        private final byte[] endRow;
        private final RangeType rangeType;

        private byte[] checkRow(RangeType type, byte[] row) {
            if (type == RangeType.FILE && row == null) {
                throw new IllegalArgumentException("Row can not be null when range type is " + RangeType.FILE);
            }
            return row;
        }

        private Destination(String fileName, RangeType rangeType, byte[] startRow, byte[] endRow) {
            this.fileName = LoadPlan.checkFileName(fileName);
            this.rangeType = rangeType;
            this.startRow = this.checkRow(rangeType, startRow);
            this.endRow = this.checkRow(rangeType, endRow);
            if (rangeType == RangeType.FILE) {
                if (UnsignedBytes.lexicographicalComparator().compare(startRow, endRow) > 0) {
                    String srs = new String(startRow, StandardCharsets.UTF_8);
                    String ers = new String(endRow, StandardCharsets.UTF_8);
                    throw new IllegalArgumentException("Start row is greater than end row : " + srs + " " + ers);
                }
            } else if (rangeType == RangeType.TABLE) {
                if (startRow != null && endRow != null && UnsignedBytes.lexicographicalComparator().compare(startRow, endRow) >= 0) {
                    String srs = new String(startRow, StandardCharsets.UTF_8);
                    String ers = new String(endRow, StandardCharsets.UTF_8);
                    throw new IllegalArgumentException("Start row is greater than or equal to end row : " + srs + " " + ers);
                }
            } else {
                throw new RuntimeException();
            }
        }

        public String getFileName() {
            return this.fileName;
        }

        public byte[] getStartRow() {
            return LoadPlan.copy(this.startRow);
        }

        public byte[] getEndRow() {
            return LoadPlan.copy(this.endRow);
        }

        public RangeType getRangeType() {
            return this.rangeType;
        }
    }

    public static enum RangeType {
        TABLE,
        FILE;

    }
}

