/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.PluginConfig;
import org.apache.accumulo.core.clientImpl.CompactionStrategyConfigUtil;
import org.apache.hadoop.io.Text;

public class UserCompactionUtils {
    private static final int MAGIC = 33818640;
    private static final int SELECTOR_MAGIC = -1366134593;
    private static final int CONFIGURER_MAGIC = -113354998;
    public static final PluginConfig DEFAULT_CONFIGURER = new PluginConfig("", Map.of());
    public static final PluginConfig DEFAULT_SELECTOR = new PluginConfig("", Map.of());

    public static void encode(DataOutput dout, Map<String, String> options) {
        try {
            dout.writeInt(options.size());
            for (Map.Entry<String, String> entry : options.entrySet()) {
                dout.writeUTF(entry.getKey());
                dout.writeUTF(entry.getValue());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void encode(DataOutput dout, int magic, int version, String className, Map<String, String> options) {
        try {
            dout.writeInt(magic);
            dout.writeByte(version);
            dout.writeUTF(className);
            UserCompactionUtils.encode(dout, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> byte[] encode(T csc, Encoder<T> encoder) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            encoder.encode(dos, csc);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static Map<String, String> decodeMap(DataInput din) {
        try {
            int numEntries = din.readInt();
            HashMap<String, String> opts = new HashMap<String, String>();
            for (int i = 0; i < numEntries; ++i) {
                String k = din.readUTF();
                String v = din.readUTF();
                opts.put(k, v);
            }
            return opts;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static PluginConfigData decode(DataInput din, int magic, int version) {
        try {
            if (din.readInt() != magic) {
                throw new IllegalArgumentException("Unexpected MAGIC ");
            }
            if (din.readByte() != version) {
                throw new IllegalArgumentException("Unexpected version");
            }
            PluginConfigData pcd = new PluginConfigData();
            pcd.className = din.readUTF();
            int numEntries = din.readInt();
            pcd.opts = new HashMap<String, String>();
            for (int i = 0; i < numEntries; ++i) {
                String k = din.readUTF();
                String v = din.readUTF();
                pcd.opts.put(k, v);
            }
            return pcd;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T decode(byte[] encodedCsc, Decoder<T> decoder) {
        ByteArrayInputStream bais = new ByteArrayInputStream(encodedCsc);
        DataInputStream dis = new DataInputStream(bais);
        return decoder.decode(dis);
    }

    public static void encodeSelector(DataOutput dout, PluginConfig csc) {
        UserCompactionUtils.encode(dout, -1366134593, 1, csc.getClassName(), csc.getOptions());
    }

    public static byte[] encodeSelector(PluginConfig csc) {
        return UserCompactionUtils.encode(csc, UserCompactionUtils::encodeSelector);
    }

    public static PluginConfig decodeSelector(DataInput di) {
        PluginConfigData pcd = UserCompactionUtils.decode(di, -1366134593, 1);
        return new PluginConfig(pcd.className, pcd.opts);
    }

    public static PluginConfig decodeSelector(byte[] bytes) {
        return UserCompactionUtils.decode(bytes, UserCompactionUtils::decodeSelector);
    }

    public static void encodeConfigurer(DataOutput dout, PluginConfig ccc) {
        UserCompactionUtils.encode(dout, -113354998, 1, ccc.getClassName(), ccc.getOptions());
    }

    public static byte[] encodeConfigurer(PluginConfig ccc) {
        return UserCompactionUtils.encode(ccc, UserCompactionUtils::encodeConfigurer);
    }

    public static PluginConfig decodeConfigurer(DataInput di) {
        PluginConfigData pcd = UserCompactionUtils.decode(di, -113354998, 1);
        return new PluginConfig(pcd.className, pcd.opts);
    }

    public static PluginConfig decodeConfigurer(byte[] bytes) {
        return UserCompactionUtils.decode(bytes, UserCompactionUtils::decodeConfigurer);
    }

    public static byte[] encode(Map<String, String> options) {
        return UserCompactionUtils.encode(options, UserCompactionUtils::encode);
    }

    public static Map<String, String> decodeMap(byte[] bytes) {
        return UserCompactionUtils.decode(bytes, UserCompactionUtils::decodeMap);
    }

    public static void encode(DataOutput dout, CompactionConfig cc) {
        try {
            dout.writeInt(33818640);
            dout.writeBoolean(cc.getStartRow() != null);
            if (cc.getStartRow() != null) {
                cc.getStartRow().write(dout);
            }
            dout.writeBoolean(cc.getEndRow() != null);
            if (cc.getEndRow() != null) {
                cc.getEndRow().write(dout);
            }
            dout.writeInt(cc.getIterators().size());
            for (IteratorSetting is : cc.getIterators()) {
                is.write(dout);
            }
            CompactionStrategyConfigUtil.encode(dout, cc);
            UserCompactionUtils.encodeConfigurer(dout, cc.getConfigurer());
            UserCompactionUtils.encodeSelector(dout, cc.getSelector());
            UserCompactionUtils.encode(dout, cc.getExecutionHints());
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static byte[] encode(CompactionConfig cc) {
        return UserCompactionUtils.encode(cc, UserCompactionUtils::encode);
    }

    public static CompactionConfig decodeCompactionConfig(DataInput din) {
        try {
            PluginConfig selector;
            Preconditions.checkArgument((33818640 == din.readInt() ? 1 : 0) != 0);
            CompactionConfig cc = new CompactionConfig();
            if (din.readBoolean()) {
                Text startRow = new Text();
                startRow.readFields(din);
                cc.setStartRow(startRow);
            }
            if (din.readBoolean()) {
                Text endRow = new Text();
                endRow.readFields(din);
                cc.setEndRow(endRow);
            }
            int num = din.readInt();
            ArrayList<IteratorSetting> iterators = new ArrayList<IteratorSetting>(num);
            for (int i = 0; i < num; ++i) {
                iterators.add(new IteratorSetting(din));
            }
            cc.setIterators(iterators);
            CompactionStrategyConfigUtil.decode(cc, din);
            PluginConfig configurer = UserCompactionUtils.decodeConfigurer(din);
            if (!UserCompactionUtils.isDefault(configurer)) {
                cc.setConfigurer(configurer);
            }
            if (!UserCompactionUtils.isDefault(selector = UserCompactionUtils.decodeSelector(din))) {
                cc.setSelector(selector);
            }
            Map<String, String> hints = UserCompactionUtils.decodeMap(din);
            cc.setExecutionHints(hints);
            return cc;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static boolean isDefault(PluginConfig configurer) {
        return configurer.equals(DEFAULT_CONFIGURER);
    }

    public static CompactionConfig decodeCompactionConfig(byte[] bytes) {
        return UserCompactionUtils.decode(bytes, UserCompactionUtils::decodeCompactionConfig);
    }

    public static interface Decoder<T> {
        public T decode(DataInput var1);
    }

    public static class PluginConfigData {
        String className;
        Map<String, String> opts;
    }

    public static interface Encoder<T> {
        public void encode(DataOutput var1, T var2);
    }
}

