/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.util.ConfigurationImpl;
import org.apache.accumulo.server.ServerContext;

public class ServiceEnvironmentImpl
implements ServiceEnvironment {
    private final ServerContext context;
    private final ServiceEnvironment.Configuration conf;
    private final Map<TableId, ServiceEnvironment.Configuration> tableConfigs = new ConcurrentHashMap<TableId, ServiceEnvironment.Configuration>();

    public ServiceEnvironmentImpl(ServerContext context) {
        this.context = context;
        this.conf = new ConfigurationImpl(this.context.getConfiguration());
    }

    public ServiceEnvironment.Configuration getConfiguration() {
        return this.conf;
    }

    public ServiceEnvironment.Configuration getConfiguration(TableId tableId) {
        return this.tableConfigs.computeIfAbsent(tableId, tid -> new ConfigurationImpl((AccumuloConfiguration)this.context.getTableConfiguration((TableId)tid)));
    }

    public String getTableName(TableId tableId) throws TableNotFoundException {
        return this.context.getTableName(tableId);
    }

    public <T> T instantiate(String className, Class<T> base) throws ReflectiveOperationException, IOException {
        return (T)ConfigurationTypeHelper.getClassInstance(null, (String)className, base);
    }

    public <T> T instantiate(TableId tableId, String className, Class<T> base) throws ReflectiveOperationException, IOException {
        String ctx = ClassLoaderUtil.tableContext((AccumuloConfiguration)this.context.getTableConfiguration(tableId));
        return (T)ConfigurationTypeHelper.getClassInstance((String)ctx, (String)className, base);
    }

    public ServerContext getContext() {
        return this.context;
    }
}

