/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessageV3;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.DurabilityImpl;
import org.apache.accumulo.core.clientImpl.UserCompactionUtils;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.constraints.Constraint;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.MapFileInfo;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.system.SourceSwitchingIterator;
import org.apache.accumulo.core.logging.TabletLogger;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionMetadata;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationConfigurationUtil;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.apache.accumulo.core.spi.scan.ScanDispatch;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.compaction.CompactionStats;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeChooserEnvironmentImpl;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.tablets.TabletTime;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.accumulo.server.util.ManagerMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.tserver.ConditionCheckerContext;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.TabletStatsKeeper;
import org.apache.accumulo.tserver.TservConstraintEnv;
import org.apache.accumulo.tserver.compactions.Compactable;
import org.apache.accumulo.tserver.constraints.ConstraintChecker;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.metrics.TabletServerMinCMetrics;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetrics;
import org.apache.accumulo.tserver.scan.ScanParameters;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.CompactableImpl;
import org.apache.accumulo.tserver.tablet.DatafileManager;
import org.apache.accumulo.tserver.tablet.MetadataUpdateCount;
import org.apache.accumulo.tserver.tablet.MinorCompactionTask;
import org.apache.accumulo.tserver.tablet.MinorCompactor;
import org.apache.accumulo.tserver.tablet.PreparedMutations;
import org.apache.accumulo.tserver.tablet.Rate;
import org.apache.accumulo.tserver.tablet.ScanDataSource;
import org.apache.accumulo.tserver.tablet.SplitRowSpec;
import org.apache.accumulo.tserver.tablet.TabletBase;
import org.apache.accumulo.tserver.tablet.TabletData;
import org.apache.accumulo.tserver.tablet.TabletMemory;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tablet
extends TabletBase {
    private static final Logger log = LoggerFactory.getLogger(Tablet.class);
    private final TabletServer tabletServer;
    private final TabletServerResourceManager.TabletResourceManager tabletResources;
    private final DatafileManager datafileManager;
    private final String dirName;
    private final TabletMemory tabletMemory;
    private final TabletTime tabletTime;
    private final Object timeLock = new Object();
    private long persistedTime;
    private TServerInstance lastLocation = null;
    private volatile Set<Path> checkedTabletDirs = new ConcurrentSkipListSet<Path>();
    private final AtomicLong dataSourceDeletions = new AtomicLong(0L);
    private volatile CloseState closeState = CloseState.OPEN;
    private boolean updatingFlushID = false;
    private AtomicLong lastFlushID = new AtomicLong(-1L);
    private AtomicLong lastCompactID = new AtomicLong(-1L);
    private final CompactionWaitInfo compactionWaitInfo = new CompactionWaitInfo();
    private CompactableImpl compactable;
    private volatile CompactionState minorCompactionState = null;
    private final AccumuloConfiguration.Deriver<ConstraintChecker> constraintChecker;
    private int writesInProgress = 0;
    private final TabletStatsKeeper timer = new TabletStatsKeeper();
    private long ingestCount = 0L;
    private long ingestBytes = 0L;
    private final Rate queryRate = new Rate(0.95);
    private final Rate queryByteRate = new Rate(0.95);
    private final Rate ingestRate = new Rate(0.95);
    private final Rate ingestByteRate = new Rate(0.95);
    private final Rate scannedRate = new Rate(0.95);
    private long lastMinorCompactionFinishTime = 0L;
    private long lastMapFileImportTime = 0L;
    private volatile long numEntries = 0L;
    private volatile long numEntriesInMemory = 0L;
    private final Set<TabletFile> bulkImporting = new HashSet<TabletFile>();
    private final ConcurrentHashMap<Long, List<TabletFile>> bulkImported = new ConcurrentHashMap();
    private final int logId;
    private boolean closeCompleting = false;
    private final long splitCreationTime;
    private boolean supressFindSplits = false;
    private long timeOfLastMinCWhenFindSplitsWasSupressed = 0L;
    private long timeOfLastImportWhenFindSplitsWasSupressed = 0L;
    private Set<DfsLogger> currentLogs = new HashSet<DfsLogger>();
    private Set<DfsLogger> otherLogs = Collections.emptySet();
    private volatile Set<DfsLogger> referencedLogs = Collections.emptySet();
    private boolean removingLogs = false;
    private final ReentrantLock logLock = new ReentrantLock();

    @Override
    public long getDataSourceDeletions() {
        return this.dataSourceDeletions.get();
    }

    public int getLogId() {
        return this.logId;
    }

    private String chooseTabletDir() throws IOException {
        VolumeChooserEnvironmentImpl chooserEnv = new VolumeChooserEnvironmentImpl(this.extent.tableId(), this.extent.endRow(), this.context);
        String dirUri = this.tabletServer.getVolumeManager().choose((VolumeChooserEnvironment)chooserEnv, this.context.getBaseUris()) + "/tables/" + this.extent.tableId() + "/" + this.dirName;
        this.checkTabletDir(new Path(dirUri));
        return dirUri;
    }

    TabletFile getNextMapFilename(String prefix) throws IOException {
        String extension = FileOperations.getNewFileExtension((AccumuloConfiguration)this.tableConfiguration);
        return new TabletFile(new Path(this.chooseTabletDir() + "/" + prefix + this.context.getUniqueNameAllocator().getNextName() + "." + extension));
    }

    TabletFile getNextMapFilenameForMajc(boolean propagateDeletes) throws IOException {
        String tmpFileName = this.getNextMapFilename(!propagateDeletes ? "A" : "C").getMetaInsert() + "_tmp";
        return new TabletFile(new Path(tmpFileName));
    }

    private void checkTabletDir(Path path) throws IOException {
        if (!this.checkedTabletDirs.contains(path)) {
            FileStatus[] files = null;
            try {
                files = this.getTabletServer().getVolumeManager().listStatus(path);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (files == null) {
                log.debug("Tablet {} had no dir, creating {}", (Object)this.extent, (Object)path);
                this.getTabletServer().getVolumeManager().mkdirs(path);
            }
            this.checkedTabletDirs.add(path);
        }
    }

    public Tablet(TabletServer tabletServer, KeyExtent extent, TabletServerResourceManager.TabletResourceManager trm, TabletData data) throws IOException, IllegalArgumentException {
        super(tabletServer, extent);
        this.tabletServer = tabletServer;
        this.tabletResources = trm;
        this.lastLocation = data.getLastLocation();
        this.lastFlushID.set(data.getFlushID());
        this.lastCompactID.set(data.getCompactID());
        this.splitCreationTime = data.getSplitTime();
        this.tabletTime = TabletTime.getInstance((MetadataTime)data.getTime());
        this.persistedTime = this.tabletTime.getTime();
        this.logId = tabletServer.createLogId();
        boolean replicationEnabled = ReplicationConfigurationUtil.isEnabled((KeyExtent)extent, (AccumuloConfiguration)this.tableConfiguration);
        VolumeUtil.TabletFiles tabletPaths = new VolumeUtil.TabletFiles(data.getDirectoryName(), data.getLogEntries(), data.getDataFiles());
        tabletPaths = VolumeUtil.updateTabletVolumes((ServerContext)tabletServer.getContext(), (ServiceLock)tabletServer.getLock(), (KeyExtent)extent, (VolumeUtil.TabletFiles)tabletPaths, (boolean)replicationEnabled);
        this.dirName = data.getDirectoryName();
        for (Map.Entry<Long, List<TabletFile>> entry : data.getBulkImported().entrySet()) {
            this.bulkImported.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        List logEntries = tabletPaths.logEntries;
        SortedMap datafiles = tabletPaths.datafiles;
        this.constraintChecker = this.tableConfiguration.newDeriver(ConstraintChecker::new);
        this.tabletMemory = new TabletMemory(this);
        if (!logEntries.isEmpty() && !this.isBeingDeleted()) {
            TabletLogger.recovering((KeyExtent)extent, (List)logEntries);
            AtomicLong entriesUsedOnTablet = new AtomicLong(0L);
            AtomicLong maxTime = new AtomicLong(Long.MIN_VALUE);
            CommitSession commitSession = this.getTabletMemory().getCommitSession();
            try {
                HashSet<String> absPaths = new HashSet<String>();
                for (TabletFile ref : datafiles.keySet()) {
                    absPaths.add(ref.getPathStr());
                }
                tabletServer.recover(this.getTabletServer().getVolumeManager(), extent, logEntries, absPaths, m -> {
                    List muts = m.getUpdates();
                    for (ColumnUpdate columnUpdate : muts) {
                        if (columnUpdate.hasTimestamp()) continue;
                        maxTime.set(Math.max(maxTime.get(), columnUpdate.getTimestamp()));
                    }
                    this.getTabletMemory().mutate(commitSession, Collections.singletonList(m), 1);
                    entriesUsedOnTablet.incrementAndGet();
                });
                if (maxTime.get() != Long.MIN_VALUE) {
                    this.tabletTime.useMaxTimeFromWALog(maxTime.get());
                }
                commitSession.updateMaxCommittedTime(this.tabletTime.getTime());
                boolean replicationEnabledForTable = ReplicationConfigurationUtil.isEnabled((KeyExtent)extent, (AccumuloConfiguration)tabletServer.getTableConfiguration(extent));
                if (entriesUsedOnTablet.get() == 0L) {
                    log.debug("No replayed mutations applied, removing unused entries for {}", (Object)extent);
                    MetadataTableUtil.removeUnusedWALEntries((ServerContext)this.getTabletServer().getContext(), (KeyExtent)extent, (List)logEntries, (ServiceLock)tabletServer.getLock());
                    logEntries.clear();
                } else if (replicationEnabledForTable) {
                    Replication.Status status = StatusUtil.openWithUnknownLength();
                    for (LogEntry logEntry : logEntries) {
                        log.debug("Writing updated status to metadata table for {} {}", (Object)logEntry.filename, (Object)ProtobufUtil.toString((GeneratedMessageV3)status));
                        ReplicationTableUtil.updateFiles((ClientContext)tabletServer.getContext(), (KeyExtent)extent, (String)logEntry.filename, (Replication.Status)status);
                    }
                }
            }
            catch (Exception t) {
                String msg = "Error recovering tablet " + extent + " from log files";
                if (this.tableConfiguration.getBoolean(Property.TABLE_FAILURES_IGNORE)) {
                    log.warn(msg, (Throwable)t);
                }
                throw new RuntimeException(msg, t);
            }
            this.currentLogs = new HashSet<DfsLogger>();
            for (LogEntry logEntry : logEntries) {
                this.currentLogs.add(new DfsLogger(tabletServer.getContext(), tabletServer.getServerConfig(), logEntry.filename, logEntry.getColumnQualifier().toString()));
            }
            this.rebuildReferencedLogs();
            TabletLogger.recovered((KeyExtent)extent, (List)logEntries, (long)entriesUsedOnTablet.get(), (long)this.getTabletMemory().getNumEntries());
        }
        this.datafileManager = new DatafileManager(this, datafiles);
        this.computeNumEntries();
        this.getDatafileManager().removeFilesAfterScan(data.getScanFiles());
        if (!logEntries.isEmpty()) {
            this.removeOldTemporaryFiles(data.getExternalCompactions());
        }
        this.compactable = new CompactableImpl(this, tabletServer.getCompactionManager(), data.getExternalCompactions());
    }

    private void removeOldTemporaryFiles(Map<ExternalCompactionId, ExternalCompactionMetadata> externalCompactions) {
        try {
            Set extCompactionFiles = externalCompactions.values().stream().map(ecMeta -> ecMeta.getCompactTmpName().getPath()).collect(Collectors.toSet());
            for (Volume volume : this.getTabletServer().getVolumeManager().getVolumes()) {
                String dirUri = volume.getBasePath() + "/tables/" + this.extent.tableId() + "/" + this.dirName;
                for (FileStatus tmp : volume.getFileSystem().globStatus(new Path(dirUri, "*_tmp"))) {
                    if (extCompactionFiles.contains(tmp.getPath())) continue;
                    try {
                        log.debug("Removing old temp file {}", (Object)tmp.getPath());
                        volume.getFileSystem().delete(tmp.getPath(), false);
                    }
                    catch (IOException ex) {
                        log.error("Unable to remove old temp file " + tmp.getPath() + ": " + ex);
                    }
                }
            }
        }
        catch (IOException ex) {
            log.error("Error scanning for old temp files", (Throwable)ex);
        }
    }

    public void checkConditions(ConditionCheckerContext.ConditionChecker checker, Authorizations authorizations, AtomicBoolean iFlag) throws IOException {
        ScanParameters scanParams = new ScanParameters(-1, authorizations, Collections.emptySet(), null, null, false, null, -1L, null);
        scanParams.setScanDispatch(ScanDispatch.builder().build());
        ScanDataSource dataSource = this.createDataSource(scanParams, false, iFlag);
        try {
            SourceSwitchingIterator iter = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)dataSource);
            checker.check((SortedKeyValueIterator<Key, Value>)iter);
        }
        catch (IOException ioe) {
            dataSource.close(true);
            throw ioe;
        }
        finally {
            dataSource.close(false);
        }
    }

    DataFileValue minorCompact(InMemoryMap memTable, TabletFile tmpDatafile, TabletFile newDatafile, long queued, CommitSession commitSession, long flushId, MinorCompactionReason mincReason) {
        boolean failed = false;
        long start = System.currentTimeMillis();
        this.timer.incrementStatusMinor();
        long count = 0L;
        String oldName = Thread.currentThread().getName();
        try {
            CompactionStats stats;
            Thread.currentThread().setName("Minor compacting " + this.extent);
            Span span = TraceUtil.startSpan(this.getClass(), (String)"minorCompact::write");
            try (Scope scope = span.makeCurrent();){
                count = memTable.getNumEntries();
                MinorCompactor compactor = new MinorCompactor(this.tabletServer, this, memTable, tmpDatafile, mincReason, this.tableConfiguration);
                stats = compactor.call();
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span.end();
            }
            Span span2 = TraceUtil.startSpan(this.getClass(), (String)"minorCompact::bringOnline");
            try (Scope scope = span2.makeCurrent();){
                Optional<StoredTabletFile> storedFile = this.getDatafileManager().bringMinorCompactionOnline(tmpDatafile, newDatafile, new DataFileValue(stats.getFileSize(), stats.getEntriesWritten()), commitSession, flushId);
                storedFile.ifPresent(stf -> this.compactable.filesAdded(true, List.of(stf)));
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span2, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span2.end();
            }
            DataFileValue dataFileValue = new DataFileValue(stats.getFileSize(), stats.getEntriesWritten());
            return dataFileValue;
        }
        catch (Error | Exception e) {
            failed = true;
            throw new RuntimeException("Exception occurred during minor compaction on " + this.extent, e);
        }
        finally {
            Thread.currentThread().setName(oldName);
            try {
                this.getTabletMemory().finalizeMinC();
            }
            catch (Exception t) {
                log.error("Failed to free tablet memory on {}", (Object)this.extent, (Object)t);
            }
            if (!failed) {
                this.lastMinorCompactionFinishTime = System.currentTimeMillis();
            }
            TabletServerMinCMetrics minCMetrics = this.getTabletServer().getMinCMetrics();
            minCMetrics.addActive(this.lastMinorCompactionFinishTime - start);
            this.timer.updateTime(TabletStatsKeeper.Operation.MINOR, queued, start, count, failed);
            minCMetrics.addQueued(start - queued);
        }
    }

    private synchronized MinorCompactionTask prepareForMinC(long flushId, MinorCompactionReason mincReason) {
        Preconditions.checkState((boolean)this.otherLogs.isEmpty());
        Preconditions.checkState((boolean)this.referencedLogs.equals(this.currentLogs));
        CommitSession oldCommitSession = this.getTabletMemory().prepareForMinC();
        this.otherLogs = this.currentLogs;
        this.currentLogs = new HashSet<DfsLogger>();
        return new MinorCompactionTask(this, oldCommitSession, flushId, mincReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void flush(long tableFlushID) {
        Tablet tablet;
        boolean initiateMinor;
        boolean updateMetadata;
        block25: {
            updateMetadata = false;
            initiateMinor = false;
            tablet = this;
            // MONITORENTER : tablet
            if (!this.updatingFlushID) break block25;
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet2 = this;
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet2
            return;
        }
        if (this.lastFlushID.get() >= tableFlushID) {
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet3 = this;
            // MONITORENTER : tablet3
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet3
            return;
        }
        if (this.isClosing() || this.isClosed() || this.isBeingDeleted() || this.getTabletMemory().memoryReservedForMinC()) {
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet4 = this;
            // MONITORENTER : tablet4
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet4
            return;
        }
        try {
            if (this.getTabletMemory().getMemTable().getNumEntries() == 0L) {
                this.lastFlushID.set(tableFlushID);
                this.updatingFlushID = true;
                updateMetadata = true;
            } else {
                initiateMinor = true;
            }
            // MONITOREXIT : tablet
            if (updateMetadata) {
                MetadataTableUtil.updateTabletFlushID((KeyExtent)this.extent, (long)tableFlushID, (ServerContext)this.context, (ServiceLock)this.getTabletServer().getLock());
                return;
            }
            if (!initiateMinor) return;
            this.initiateMinorCompaction(tableFlushID, MinorCompactionReason.USER);
            return;
        }
        finally {
            if (updateMetadata) {
                tablet = this;
            }
        }
    }

    public boolean initiateMinorCompaction(MinorCompactionReason mincReason) {
        long flushId;
        if (this.isClosed()) {
            return false;
        }
        if (this.isBeingDeleted()) {
            log.debug("Table {} is being deleted so don't flush {}", (Object)this.extent.tableId(), (Object)this.extent);
            return false;
        }
        try {
            flushId = this.getFlushID();
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Asked to initiate MinC when there was no flush id {} {}", (Object)this.getExtent(), (Object)e.getMessage());
            return false;
        }
        return this.initiateMinorCompaction(flushId, mincReason);
    }

    public boolean minorCompactNow(MinorCompactionReason mincReason) {
        long flushId;
        try {
            flushId = this.getFlushID();
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Asked to initiate MinC when there was no flush id {} {}", (Object)this.getExtent(), (Object)e.getMessage());
            return false;
        }
        MinorCompactionTask mct = this.createMinorCompactionTask(flushId, mincReason);
        if (mct == null) {
            return false;
        }
        mct.run();
        return true;
    }

    boolean initiateMinorCompaction(long flushId, MinorCompactionReason mincReason) {
        MinorCompactionTask mct = this.createMinorCompactionTask(flushId, mincReason);
        if (mct == null) {
            return false;
        }
        this.getTabletResources().executeMinorCompaction(mct);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MinorCompactionTask createMinorCompactionTask(long flushId, MinorCompactionReason mincReason) {
        long t1;
        StringBuilder logMessage;
        block9: {
            MinorCompactionTask minorCompactionTask;
            logMessage = null;
            try {
                Tablet tablet = this;
                // MONITORENTER : tablet
                t1 = System.currentTimeMillis();
                if (!this.isClosing() && !this.isClosed() && !this.getTabletMemory().memoryReservedForMinC() && this.getTabletMemory().getMemTable().getNumEntries() != 0L && !this.updatingFlushID) break block9;
                logMessage = new StringBuilder();
                logMessage.append(this.extent);
                logMessage.append(" closeState " + this.closeState);
                if (this.getTabletMemory() != null) {
                    logMessage.append(" tabletMemory.memoryReservedForMinC() " + this.getTabletMemory().memoryReservedForMinC());
                }
                if (this.getTabletMemory() != null && this.getTabletMemory().getMemTable() != null) {
                    logMessage.append(" tabletMemory.getMemTable().getNumEntries() " + this.getTabletMemory().getMemTable().getNumEntries());
                }
                logMessage.append(" updatingFlushID " + this.updatingFlushID);
                minorCompactionTask = null;
                // MONITOREXIT : tablet
                if (logMessage == null) return minorCompactionTask;
            }
            catch (Throwable throwable) {
                if (logMessage == null) throw throwable;
                if (!log.isDebugEnabled()) throw throwable;
                log.debug("{}", logMessage);
                throw throwable;
            }
            if (!log.isDebugEnabled()) return minorCompactionTask;
            log.debug("{}", (Object)logMessage);
            return minorCompactionTask;
        }
        MinorCompactionTask mct = this.prepareForMinC(flushId, mincReason);
        long t2 = System.currentTimeMillis();
        // MONITOREXIT : tablet
        if (logMessage != null && log.isDebugEnabled()) {
            log.debug("{}", (Object)logMessage);
        }
        log.debug(String.format("MinC initiate lock %.2f secs", (double)(t2 - t1) / 1000.0));
        return mct;
    }

    public long getFlushID() throws KeeperException.NoNodeException {
        try {
            String zTablePath = "/accumulo/" + this.tabletServer.getInstanceID() + "/tables/" + this.extent.tableId() + "/flush-id";
            String id = new String(this.context.getZooReaderWriter().getData(zTablePath), StandardCharsets.UTF_8);
            return Long.parseLong(id);
        }
        catch (InterruptedException | NumberFormatException e) {
            throw new RuntimeException("Exception on " + this.extent + " getting flush ID", e);
        }
        catch (KeeperException ke) {
            if (ke instanceof KeeperException.NoNodeException) {
                throw (KeeperException.NoNodeException)((Object)ke);
            }
            throw new RuntimeException("Exception on " + this.extent + " getting flush ID", ke);
        }
    }

    long getCompactionCancelID() {
        String zTablePath = "/accumulo/" + this.tabletServer.getInstanceID() + "/tables/" + this.extent.tableId() + "/compact-cancel-id";
        String id = new String(this.context.getZooCache().get(zTablePath), StandardCharsets.UTF_8);
        return Long.parseLong(id);
    }

    public Pair<Long, CompactionConfig> getCompactionID() throws KeeperException.NoNodeException {
        try {
            String zTablePath = "/accumulo/" + this.tabletServer.getInstanceID() + "/tables/" + this.extent.tableId() + "/compact-id";
            String[] tokens = new String(this.context.getZooReaderWriter().getData(zTablePath), StandardCharsets.UTF_8).split(",");
            long compactID = Long.parseLong(tokens[0]);
            CompactionConfig overlappingConfig = null;
            if (tokens.length > 1) {
                Hex hex = new Hex();
                ByteArrayInputStream bais = new ByteArrayInputStream(hex.decode(tokens[1].split("=")[1].getBytes(StandardCharsets.UTF_8)));
                DataInputStream dis = new DataInputStream(bais);
                CompactionConfig compactionConfig = UserCompactionUtils.decodeCompactionConfig((DataInput)dis);
                KeyExtent ke = new KeyExtent(this.extent.tableId(), compactionConfig.getEndRow(), compactionConfig.getStartRow());
                if (ke.overlaps(this.extent)) {
                    overlappingConfig = compactionConfig;
                }
            }
            if (overlappingConfig == null) {
                overlappingConfig = new CompactionConfig();
            }
            return new Pair((Object)compactID, (Object)overlappingConfig);
        }
        catch (InterruptedException | NumberFormatException | DecoderException e) {
            throw new RuntimeException("Exception on " + this.extent + " getting compaction ID", e);
        }
        catch (KeeperException ke) {
            if (ke instanceof KeeperException.NoNodeException) {
                throw (KeeperException.NoNodeException)((Object)ke);
            }
            throw new RuntimeException("Exception on " + this.extent + " getting compaction ID", ke);
        }
    }

    private synchronized CommitSession finishPreparingMutations(long time) {
        if (this.isClosed() || this.getTabletMemory() == null) {
            return null;
        }
        CommitSession commitSession = this.getTabletMemory().getCommitSession();
        this.incrementWritesInProgress(commitSession);
        commitSession.updateMaxCommittedTime(time);
        return commitSession;
    }

    public PreparedMutations prepareMutationsForCommit(TservConstraintEnv cenv, List<Mutation> mutations) {
        long time;
        cenv.setExtent(this.extent);
        ConstraintChecker constraints = (ConstraintChecker)this.constraintChecker.derive();
        Violations violations = null;
        Set<Mutation> violators = null;
        List<Object> nonViolators = null;
        for (Mutation mutation : mutations) {
            Violations mutationViolations = constraints.check((Constraint.Environment)cenv, mutation);
            if (mutationViolations == null) continue;
            if (violations == null) {
                violations = new Violations();
                violators = new HashSet();
            }
            violations.add(mutationViolations);
            violators.add(mutation);
        }
        if (violations == null) {
            nonViolators = mutations;
            violators = Collections.emptySet();
            violations = Violations.EMPTY;
        } else if (violators.size() != mutations.size()) {
            nonViolators = new ArrayList(mutations.size() - violators.size());
            for (Mutation mutation : mutations) {
                if (violators.contains(mutation)) continue;
                nonViolators.add(mutation);
            }
        } else {
            nonViolators = Collections.emptyList();
        }
        CommitSession cs = null;
        if (!nonViolators.isEmpty() && (cs = this.finishPreparingMutations(time = this.tabletTime.setUpdateTimes(nonViolators))) == null) {
            return new PreparedMutations();
        }
        return new PreparedMutations(cs, nonViolators, violations, violators);
    }

    private synchronized void incrementWritesInProgress(CommitSession cs) {
        this.incrementWritesInProgress();
        cs.incrementCommitsInProgress();
    }

    private synchronized void incrementWritesInProgress() {
        if (this.writesInProgress < 0) {
            throw new IllegalStateException("FATAL: Something really bad went wrong. Attempted to increment a negative number of writes in progress " + this.writesInProgress + "on tablet " + this.extent);
        }
        ++this.writesInProgress;
    }

    private synchronized void decrementWritesInProgress(CommitSession cs) {
        this.decrementWritesInProgress();
        cs.decrementCommitsInProgress();
    }

    private synchronized void decrementWritesInProgress() {
        if (this.writesInProgress <= 0) {
            throw new IllegalStateException("FATAL: Something really bad went wrong. Attempted to decrement the number of writes in progress " + this.writesInProgress + " to < 0 on tablet " + this.extent);
        }
        --this.writesInProgress;
        if (this.writesInProgress == 0) {
            this.notifyAll();
        }
    }

    public synchronized void abortCommit(CommitSession commitSession) {
        if (this.isCloseComplete() || this.getTabletMemory() == null) {
            throw new IllegalStateException("Aborting commit when tablet " + this.extent + " is closed");
        }
        this.decrementWritesInProgress(commitSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CommitSession commitSession, List<Mutation> mutations) {
        int totalCount = 0;
        long totalBytes = 0L;
        for (Mutation mutation : mutations) {
            totalCount += mutation.size();
            totalBytes += mutation.numBytes();
        }
        this.getTabletMemory().mutate(commitSession, mutations, totalCount);
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.isCloseComplete()) {
                throw new IllegalStateException("Tablet " + this.extent + " closed with outstanding messages to the logger");
            }
            this.decrementWritesInProgress(commitSession);
            this.getTabletMemory().updateMemoryUsageStats();
            this.numEntries += (long)totalCount;
            this.numEntriesInMemory += (long)totalCount;
            this.ingestCount += (long)totalCount;
            this.ingestBytes += totalBytes;
        }
    }

    @Override
    public void close(boolean saveState) throws IOException {
        this.initiateClose(saveState);
        this.completeClose(saveState, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initiateClose(boolean saveState) {
        log.trace("initiateClose(saveState={}) {}", (Object)saveState, (Object)this.getExtent());
        MinorCompactionTask mct = null;
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.isClosed() || this.isClosing()) {
                String msg = "Tablet " + this.getExtent() + " already " + this.closeState;
                throw new IllegalStateException(msg);
            }
            this.closeState = CloseState.CLOSING;
            this.notifyAll();
        }
        this.compactable.close();
        tablet = this;
        synchronized (tablet) {
            Preconditions.checkState((this.closeState == CloseState.CLOSING ? 1 : 0) != 0);
            while (this.updatingFlushID) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    log.error(e.toString());
                }
            }
            Preconditions.checkState((this.closeState == CloseState.CLOSING ? 1 : 0) != 0);
            if (!saveState || this.getTabletMemory().getMemTable().getNumEntries() == 0L) {
                return;
            }
            this.getTabletMemory().waitForMinC();
            Preconditions.checkState((this.closeState == CloseState.CLOSING ? 1 : 0) != 0);
            try {
                mct = this.prepareForMinC(this.getFlushID(), MinorCompactionReason.CLOSE);
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException("Exception on " + this.extent + " during prep for MinC", e);
            }
        }
        mct.run();
    }

    synchronized void completeClose(boolean saveState, boolean completeClose) throws IOException {
        if (!this.isClosing() || this.isCloseComplete() || this.closeCompleting) {
            throw new IllegalStateException("Bad close state " + this.closeState + " on tablet " + this.extent);
        }
        log.trace("completeClose(saveState={} completeClose={}) {}", new Object[]{saveState, completeClose, this.extent});
        this.closeCompleting = true;
        this.closeState = CloseState.CLOSED;
        this.dataSourceDeletions.incrementAndGet();
        for (ScanDataSource activeScan : this.activeScans) {
            activeScan.interrupt();
        }
        while (this.writesInProgress > 0 || !this.activeScans.isEmpty()) {
            try {
                log.debug("Waiting to completeClose for {}. {} writes {} scans", new Object[]{this.extent, this.writesInProgress, this.activeScans.size()});
                this.wait(50L);
            }
            catch (InterruptedException e) {
                log.error(e.toString());
            }
        }
        this.getTabletMemory().waitForMinC();
        if (saveState && this.getTabletMemory().getMemTable().getNumEntries() > 0L) {
            try {
                this.prepareForMinC(this.getFlushID(), MinorCompactionReason.CLOSE).run();
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException("Exception on " + this.extent + " during prep for MinC", e);
            }
        }
        if (saveState) {
            RuntimeException err = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    this.closeConsistencyCheck();
                    err = null;
                    continue;
                }
                catch (RuntimeException t) {
                    err = t;
                    log.error("Consistency check fails, retrying", (Throwable)t);
                    UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
            if (err != null) {
                ProblemReports.getInstance((ServerContext)this.context).report(new ProblemReport(this.extent.tableId(), ProblemType.TABLET_LOAD, this.extent.toString(), (Throwable)err));
                log.error("Tablet closed consistency check has failed for {} giving up and closing", (Object)this.extent);
            }
        }
        try {
            this.getTabletMemory().getMemTable().delete(0L);
        }
        catch (Exception t) {
            log.error("Failed to delete mem table : " + t.getMessage() + " for tablet " + this.extent, (Throwable)t);
        }
        this.getTabletMemory().close();
        this.getTabletResources().close();
        if (completeClose) {
            this.closeState = CloseState.COMPLETE;
        }
    }

    private void closeConsistencyCheck() {
        long num = this.tabletMemory.getMemTable().getNumEntries();
        if (num != 0L) {
            String msg = "Closed tablet " + this.extent + " has " + num + " entries in memory";
            log.error(msg);
            throw new RuntimeException(msg);
        }
        if (this.tabletMemory.memoryReservedForMinC()) {
            String msg = "Closed tablet " + this.extent + " has minor compacting memory";
            log.error(msg);
            throw new RuntimeException(msg);
        }
        try {
            TabletMetadata tabletMeta = this.context.getAmple().readTablet(this.extent, new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FILES, TabletMetadata.ColumnType.LOGS, TabletMetadata.ColumnType.ECOMP, TabletMetadata.ColumnType.PREV_ROW, TabletMetadata.ColumnType.FLUSH_ID, TabletMetadata.ColumnType.COMPACT_ID});
            if (tabletMeta == null) {
                String msg = "Closed tablet " + this.extent + " not found in metadata";
                log.error(msg);
                throw new RuntimeException(msg);
            }
            HashSet ecids = new HashSet();
            this.compactable.getExternalCompactionIds(ecids::add);
            if (!tabletMeta.getExternalCompactions().keySet().equals(ecids)) {
                String msg = "Closed tablet " + this.extent + " external compaction ids differ " + ecids + " != " + tabletMeta.getExternalCompactions().keySet();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            if (!tabletMeta.getLogs().isEmpty()) {
                String msg = "Closed tablet " + this.extent + " has walog entries in " + MetadataTable.NAME + " " + tabletMeta.getLogs();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            tabletMeta.getFlushId().ifPresent(flushId -> {
                if (flushId != this.lastFlushID.get()) {
                    String msg = "Closed tablet " + this.extent + " lastFlushID is inconsistent with metadata : " + flushId + " != " + this.lastFlushID;
                    log.error(msg);
                    throw new RuntimeException(msg);
                }
            });
            tabletMeta.getCompactId().ifPresent(compactId -> {
                if (compactId != this.lastCompactID.get()) {
                    String msg = "Closed tablet " + this.extent + " lastCompactID is inconsistent with metadata : " + compactId + " != " + this.lastCompactID;
                    log.error(msg);
                    throw new RuntimeException(msg);
                }
            });
            if (!tabletMeta.getFilesMap().equals(this.getDatafileManager().getDatafileSizes())) {
                String msg = "Data files in " + this.extent + " differ from in-memory data " + tabletMeta.getFilesMap() + " " + this.getDatafileManager().getDatafileSizes();
                log.error(msg);
            }
        }
        catch (Exception e) {
            String msg = "Failed to do close consistency check for tablet " + this.extent;
            log.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        if (!(this.otherLogs.isEmpty() && this.currentLogs.isEmpty() && this.referencedLogs.isEmpty())) {
            String msg = "Closed tablet " + this.extent + " has walog entries in memory currentLogs = " + this.currentLogs + "  otherLogs = " + this.otherLogs + " referencedLogs = " + this.referencedLogs;
            log.error(msg);
            throw new RuntimeException(msg);
        }
    }

    public synchronized void compareTabletInfo(MetadataUpdateCount updateCounter, TabletMetadata tabletMetadata) {
        Preconditions.checkArgument((boolean)updateCounter.getExtent().equals((Object)this.getExtent()), (String)"Counter had unexpected extent %s != %s", (Object)updateCounter.getExtent(), (Object)this.getExtent());
        Preconditions.checkArgument((boolean)tabletMetadata.getExtent().equals((Object)this.getExtent()), (String)"Tablet metadata had unexpected extent %s != %s", (Object)tabletMetadata.getExtent(), (Object)this.getExtent());
        if (this.isClosed() || this.isClosing()) {
            log.trace("AMCC Tablet {} was closed, so skipping check", (Object)tabletMetadata.getExtent());
            return;
        }
        SortedMap<StoredTabletFile, DataFileValue> dataFileSizes = this.getDatafileManager().getDatafileSizes();
        if (!tabletMetadata.getFilesMap().equals(dataFileSizes)) {
            MetadataUpdateCount latestCount = this.getUpdateCount();
            if (updateCounter.overlapsUpdate() || !updateCounter.equals(latestCount)) {
                log.trace("AMCC Tablet {} may have been updating its metadata while it was being read for check, so skipping check {} {}", new Object[]{tabletMetadata.getExtent(), updateCounter, latestCount});
            } else {
                log.error("Data files in {} differ from in-memory data {} {} {} {}", new Object[]{this.extent, tabletMetadata.getFilesMap(), dataFileSizes, updateCounter, latestCount});
            }
        } else {
            log.trace("AMCC Tablet {} files in memory are same as in metadata table {}", (Object)tabletMetadata.getExtent(), (Object)updateCounter);
        }
    }

    public long estimateTabletSize() {
        long size = 0L;
        for (DataFileValue sz : this.getDatafileManager().getDatafileSizes().values()) {
            size += sz.getSize();
        }
        return size;
    }

    private SplitRowSpec findSplitRow(Collection<TabletFile> files) {
        long splitThreshold = this.tableConfiguration.getAsBytes(Property.TABLE_SPLIT_THRESHOLD);
        long maxEndRow = this.tableConfiguration.getAsBytes(Property.TABLE_MAX_END_ROW_SIZE);
        if (this.extent.isRootTablet() || this.isFindSplitsSuppressed() || this.estimateTabletSize() <= splitThreshold) {
            return null;
        }
        SortedMap keys = null;
        try {
            keys = FileUtil.findMidPoint((ServerContext)this.context, (TableConfiguration)this.tableConfiguration, (String)this.chooseTabletDir(), (Text)this.extent.prevEndRow(), (Text)this.extent.endRow(), (Collection)FileUtil.toPathStrings(files), (double)0.25, (boolean)true);
        }
        catch (IOException e) {
            log.error("Failed to find midpoint {}", (Object)e.getMessage());
            return null;
        }
        if (keys.isEmpty()) {
            log.info("Cannot split tablet " + this.extent + ", files contain no data for tablet.");
            this.suppressFindSplits();
            return null;
        }
        try {
            Text lastRow;
            if (this.extent.endRow() == null) {
                Key lastKey = (Key)FileUtil.findLastKey((ServerContext)this.context, (TableConfiguration)this.tableConfiguration, files);
                lastRow = lastKey.getRow();
            } else {
                lastRow = this.extent.endRow();
            }
            Key mid = (Key)keys.get(0.5);
            if (mid == null) {
                throw new IllegalStateException("Could not determine midpoint for files on " + this.extent);
            }
            if (mid.compareRow(lastRow) == 0) {
                if ((Double)keys.firstKey() < 0.5) {
                    Key candidate = (Key)keys.get(keys.firstKey());
                    if ((long)candidate.getLength() > maxEndRow) {
                        log.warn("Cannot split tablet {}, selected split point too long.  Length :  {}", (Object)this.extent, (Object)candidate.getLength());
                        this.suppressFindSplits();
                        return null;
                    }
                    if (candidate.compareRow(lastRow) != 0) {
                        if (log.isTraceEnabled()) {
                            log.trace(String.format("Splitting at %6.2f instead of .5, row at .5 is same as end row%n", keys.firstKey()));
                        }
                        return new SplitRowSpec((Double)keys.firstKey(), candidate.getRow());
                    }
                }
                log.warn("Cannot split tablet {} it contains a big row : {}", (Object)this.extent, (Object)lastRow);
                this.suppressFindSplits();
                return null;
            }
            Text text = mid.getRow();
            SortedMap firstHalf = keys.headMap(0.5);
            if (!firstHalf.isEmpty()) {
                Text beforeMid = ((Key)firstHalf.get(firstHalf.lastKey())).getRow();
                Text shorter = new Text();
                int trunc = Tablet.longestCommonLength(text, beforeMid);
                shorter.set(text.getBytes(), 0, Math.min(text.getLength(), trunc + 1));
                text = shorter;
            }
            if ((long)text.getLength() > maxEndRow) {
                log.warn("Cannot split tablet {}, selected split point too long.  Length :  {}", (Object)this.extent, (Object)text.getLength());
                this.suppressFindSplits();
                return null;
            }
            return new SplitRowSpec(0.5, text);
        }
        catch (IOException e) {
            log.error("Failed to find lastkey {}", (Object)e.getMessage());
            return null;
        }
    }

    private boolean isFindSplitsSuppressed() {
        if (this.supressFindSplits) {
            if (this.timeOfLastMinCWhenFindSplitsWasSupressed != this.lastMinorCompactionFinishTime || this.timeOfLastImportWhenFindSplitsWasSupressed != this.lastMapFileImportTime) {
                this.supressFindSplits = false;
            } else {
                return true;
            }
        }
        return false;
    }

    private void suppressFindSplits() {
        this.supressFindSplits = true;
        this.timeOfLastMinCWhenFindSplitsWasSupressed = this.lastMinorCompactionFinishTime;
        this.timeOfLastImportWhenFindSplitsWasSupressed = this.lastMapFileImportTime;
    }

    private static int longestCommonLength(Text text, Text beforeMid) {
        int common;
        for (common = 0; common < text.getLength() && common < beforeMid.getLength() && text.getBytes()[common] == beforeMid.getBytes()[common]; ++common) {
        }
        return common;
    }

    public synchronized boolean needsSplit() {
        if (this.isClosing() || this.isClosed()) {
            return false;
        }
        return this.findSplitRow(this.getDatafileManager().getFiles()) != null;
    }

    synchronized void computeNumEntries() {
        Collection<DataFileValue> vals = this.getDatafileManager().getDatafileSizes().values();
        long numEntries = 0L;
        for (DataFileValue tableValue : vals) {
            numEntries += tableValue.getNumEntries();
        }
        this.numEntriesInMemory = this.getTabletMemory().getNumEntries();
        this.numEntries = numEntries += this.getTabletMemory().getNumEntries();
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    public long getNumEntriesInMemory() {
        return this.numEntriesInMemory;
    }

    public boolean isClosing() {
        return this.closeState == CloseState.CLOSING;
    }

    @Override
    public boolean isClosed() {
        CloseState localCS = this.closeState;
        return localCS == CloseState.CLOSED || localCS == CloseState.COMPLETE;
    }

    public boolean isBeingDeleted() {
        return this.context.getTableManager().getTableState(this.extent.tableId()) == TableState.DELETING;
    }

    public boolean isCloseComplete() {
        return this.closeState == CloseState.COMPLETE;
    }

    public boolean isMajorCompactionRunning() {
        return this.compactable.isMajorCompactionRunning();
    }

    public boolean isMajorCompactionQueued() {
        return this.compactable.isMajorCompactionQueued();
    }

    public boolean isMinorCompactionQueued() {
        return this.minorCompactionState == CompactionState.WAITING_TO_START;
    }

    public boolean isMinorCompactionRunning() {
        return this.minorCompactionState == CompactionState.IN_PROGRESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<KeyExtent, TabletData> split(byte[] sp) throws IOException {
        if (sp != null && this.extent.endRow() != null && this.extent.endRow().equals((Object)new Text(sp))) {
            throw new IllegalArgumentException("Attempting to split on EndRow " + this.extent.endRow() + " for " + this.extent);
        }
        if (sp != null && (long)sp.length > this.tableConfiguration.getAsBytes(Property.TABLE_MAX_END_ROW_SIZE)) {
            String msg = "Cannot split tablet " + this.extent + ", selected split point too long.  Length :  " + sp.length;
            log.warn(msg);
            throw new IOException(msg);
        }
        if (this.extent.isRootTablet()) {
            String msg = "Cannot split root tablet";
            log.warn(msg);
            throw new RuntimeException(msg);
        }
        try {
            this.initiateClose(true);
        }
        catch (IllegalStateException ise) {
            log.debug("File {} not splitting : {}", (Object)this.extent, (Object)ise.getMessage());
            return null;
        }
        Map firstAndLastRows = FileUtil.tryToGetFirstAndLastRows((ServerContext)this.context, (TableConfiguration)this.tableConfiguration, this.getDatafileManager().getFiles());
        Tablet tablet = this;
        synchronized (tablet) {
            SplitRowSpec splitPoint;
            TreeMap<KeyExtent, TabletData> newTablets = new TreeMap<KeyExtent, TabletData>();
            long t1 = System.currentTimeMillis();
            if (sp == null) {
                splitPoint = this.findSplitRow(this.getDatafileManager().getFiles());
            } else {
                Text tsp = new Text(sp);
                Collection fileStrings = FileUtil.toPathStrings(this.getDatafileManager().getFiles());
                double ratio = FileUtil.estimatePercentageLTE((ServerContext)this.context, (TableConfiguration)this.tableConfiguration, (String)this.chooseTabletDir(), (Text)this.extent.prevEndRow(), (Text)this.extent.endRow(), (Collection)fileStrings, (Text)tsp);
                splitPoint = new SplitRowSpec(ratio, tsp);
            }
            if (splitPoint == null || splitPoint.row == null) {
                log.info("had to abort split because splitRow was null");
                this.closeState = CloseState.OPEN;
                return null;
            }
            this.closeState = CloseState.CLOSING;
            this.completeClose(true, false);
            Text midRow = splitPoint.row;
            double splitRatio = splitPoint.splitRatio;
            KeyExtent low = new KeyExtent(this.extent.tableId(), midRow, this.extent.prevEndRow());
            KeyExtent high = new KeyExtent(this.extent.tableId(), this.extent.endRow(), midRow);
            String lowDirectoryName = Tablet.createTabletDirectoryName(this.context, midRow);
            TreeMap<StoredTabletFile, DataFileValue> lowDatafileSizes = new TreeMap<StoredTabletFile, DataFileValue>();
            TreeMap<StoredTabletFile, DataFileValue> highDatafileSizes = new TreeMap<StoredTabletFile, DataFileValue>();
            ArrayList highDatafilesToRemove = new ArrayList();
            MetadataTableUtil.splitDatafiles((Text)midRow, (double)splitRatio, (Map)firstAndLastRows, this.getDatafileManager().getDatafileSizes(), lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
            log.debug("Files for low split {} {}", (Object)low, lowDatafileSizes.keySet());
            log.debug("Files for high split {} {}", (Object)high, highDatafileSizes.keySet());
            MetadataTime time = this.tabletTime.getMetadataTime();
            HashSet ecids = new HashSet();
            this.compactable.getExternalCompactionIds(ecids::add);
            MetadataTableUtil.splitTablet((KeyExtent)high, (Text)this.extent.prevEndRow(), (double)splitRatio, (ServerContext)this.getTabletServer().getContext(), (ServiceLock)this.getTabletServer().getLock(), ecids);
            ManagerMetadataUtil.addNewTablet((ServerContext)this.getTabletServer().getContext(), (KeyExtent)low, (String)lowDirectoryName, (TServerInstance)this.getTabletServer().getTabletSession(), lowDatafileSizes, this.bulkImported, (MetadataTime)time, (long)this.lastFlushID.get(), (long)this.lastCompactID.get(), (ServiceLock)this.getTabletServer().getLock());
            MetadataTableUtil.finishSplit((KeyExtent)high, highDatafileSizes, highDatafilesToRemove, (ServerContext)this.getTabletServer().getContext(), (ServiceLock)this.getTabletServer().getLock());
            TabletLogger.split((KeyExtent)this.extent, (KeyExtent)low, (KeyExtent)high, (TServerInstance)this.getTabletServer().getTabletSession());
            newTablets.put(high, new TabletData(this.dirName, highDatafileSizes, time, this.lastFlushID.get(), this.lastCompactID.get(), this.lastLocation, this.bulkImported));
            newTablets.put(low, new TabletData(lowDirectoryName, lowDatafileSizes, time, this.lastFlushID.get(), this.lastCompactID.get(), this.lastLocation, this.bulkImported));
            long t2 = System.currentTimeMillis();
            log.debug(String.format("offline split time : %6.2f secs", (double)(t2 - t1) / 1000.0));
            this.closeState = CloseState.COMPLETE;
            return newTablets;
        }
    }

    @Override
    public SortedMap<StoredTabletFile, DataFileValue> getDatafiles() {
        return this.getDatafileManager().getDatafileSizes();
    }

    @Override
    public void addToYieldMetric(int i) {
        this.getTabletServer().getScanMetrics().addYield(i);
    }

    public double queryRate() {
        return this.queryRate.rate();
    }

    public double queryByteRate() {
        return this.queryByteRate.rate();
    }

    public double ingestRate() {
        return this.ingestRate.rate();
    }

    public double ingestByteRate() {
        return this.ingestByteRate.rate();
    }

    public double scanRate() {
        return this.scannedRate.rate();
    }

    public long totalQueriesResults() {
        return this.queryResultCount.get();
    }

    public long totalIngest() {
        return this.ingestCount;
    }

    public long totalIngestBytes() {
        return this.ingestBytes;
    }

    public long totalQueryResultsBytes() {
        return this.queryResultBytes.get();
    }

    public long totalScannedCount() {
        return this.scannedCount.get();
    }

    public long totalLookupCount() {
        return this.lookupCount.get();
    }

    public void updateRates(long now) {
        this.queryRate.update(now, this.queryResultCount.get());
        this.queryByteRate.update(now, this.queryResultBytes.get());
        this.ingestRate.update(now, this.ingestCount);
        this.ingestByteRate.update(now, this.ingestBytes);
        this.scannedRate.update(now, this.scannedCount.get());
    }

    public long getSplitCreationTime() {
        return this.splitCreationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMapFiles(long tid, Map<TabletFile, MapFileInfo> fileMap, boolean setTime) throws IOException {
        HashMap<TabletFile, DataFileValue> entries = new HashMap<TabletFile, DataFileValue>(fileMap.size());
        ArrayList<String> files = new ArrayList<String>();
        for (Map.Entry<TabletFile, MapFileInfo> entry : fileMap.entrySet()) {
            entries.put(entry.getKey(), new DataFileValue(entry.getValue().estimatedSize, 0L));
            files.add(entry.getKey().getPathStr());
        }
        long now = System.currentTimeMillis();
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.isClosed()) {
                throw new IOException("tablet " + this.extent + " is closed");
            }
            long lockWait = System.currentTimeMillis() - now;
            if (lockWait > this.getTabletServer().getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT)) {
                throw new IOException("Timeout waiting " + (double)lockWait / 1000.0 + " seconds to get tablet lock for " + this.extent);
            }
            List<TabletFile> alreadyImported = this.bulkImported.get(tid);
            if (alreadyImported != null) {
                for (TabletFile entry : alreadyImported) {
                    if (fileMap.remove(entry) == null) continue;
                    log.trace("Ignoring import of bulk file already imported: {}", (Object)entry);
                }
            }
            fileMap.keySet().removeIf(file -> {
                if (this.bulkImporting.contains(file)) {
                    log.info("Ignoring import of bulk file currently importing: " + file);
                    return true;
                }
                return false;
            });
            if (fileMap.isEmpty()) {
                return;
            }
            this.incrementWritesInProgress();
            this.bulkImporting.addAll(fileMap.keySet());
        }
        try {
            this.tabletServer.updateBulkImportState(files, BulkImportState.LOADING);
            Collection<StoredTabletFile> storedTabletFile = this.getDatafileManager().importMapFiles(tid, entries, setTime);
            this.lastMapFileImportTime = System.currentTimeMillis();
            if (this.needsSplit()) {
                this.getTabletServer().executeSplit(this);
            } else {
                this.compactable.filesAdded(false, storedTabletFile);
            }
        }
        finally {
            tablet = this;
            synchronized (tablet) {
                this.decrementWritesInProgress();
                if (!this.bulkImporting.removeAll(fileMap.keySet())) {
                    throw new AssertionError((Object)"Likely bug in code, always expect to remove something.  Please open an Accumulo issue.");
                }
                try {
                    this.bulkImported.computeIfAbsent(tid, k -> new ArrayList()).addAll(fileMap.keySet());
                }
                catch (Exception ex) {
                    log.info(ex.toString(), (Throwable)ex);
                }
                this.tabletServer.removeBulkImportState(files);
            }
        }
    }

    private synchronized void rebuildReferencedLogs() {
        Set<DfsLogger> prev = this.referencedLogs;
        this.referencedLogs = Stream.concat(this.currentLogs.stream(), this.otherLogs.stream()).collect(Collectors.toUnmodifiableSet());
        if (TabletLogger.isWalRefLoggingEnabled() && !prev.equals(this.referencedLogs)) {
            TabletLogger.walRefsChanged((KeyExtent)this.extent, (Collection)this.referencedLogs.stream().map(DfsLogger::getPath).map(Path::getName).collect(Collectors.toList()));
        }
    }

    public void removeInUseLogs(Set<DfsLogger> candidates) {
        candidates.removeAll(this.referencedLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIfMinorCompactionNeededForLogs(List<DfsLogger> closedLogs) {
        Property prop = this.tableConfiguration.resolve(Property.TSERV_WAL_MAX_REFERENCED, new Property[]{Property.TSERV_WALOG_MAX_REFERENCED, Property.TABLE_MINC_LOGS_MAX});
        int maxLogs = this.tableConfiguration.getCount(prop);
        String reason = null;
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.currentLogs.size() >= maxLogs) {
                reason = "referenced " + this.currentLogs.size() + " write ahead logs";
            } else if (maxLogs < closedLogs.size()) {
                List<DfsLogger> oldClosed = closedLogs.subList(0, closedLogs.size() - maxLogs);
                for (DfsLogger closedLog : oldClosed) {
                    if (!this.currentLogs.contains(closedLog)) continue;
                    reason = "referenced at least one old write ahead log " + closedLog.getFileName();
                    break;
                }
            }
        }
        if (reason != null) {
            log.debug("Initiating minor compaction for {} because {}", (Object)this.getExtent(), (Object)reason);
            this.initiateMinorCompaction(MinorCompactionReason.SYSTEM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> beginClearingUnusedLogs() {
        HashSet<String> unusedLogs = new HashSet<String>();
        ArrayList<String> otherLogsCopy = new ArrayList<String>();
        ArrayList<String> currentLogsCopy = new ArrayList<String>();
        this.logLock.lock();
        Iterator iterator = this;
        synchronized (iterator) {
            if (this.removingLogs) {
                throw new IllegalStateException("Attempted to clear logs when removal of logs in progress on " + this.extent);
            }
            for (DfsLogger logger : this.otherLogs) {
                otherLogsCopy.add(logger.toString());
                unusedLogs.add(logger.getMeta());
            }
            for (DfsLogger logger : this.currentLogs) {
                currentLogsCopy.add(logger.toString());
                unusedLogs.remove(logger.getMeta());
            }
            this.otherLogs = Collections.emptySet();
            if (!unusedLogs.isEmpty()) {
                this.removingLogs = true;
            }
        }
        for (String logger : otherLogsCopy) {
            log.trace("Logs for memory compacted: {} {}", (Object)this.getExtent(), (Object)logger);
        }
        for (String logger : currentLogsCopy) {
            log.trace("Logs for current memory: {} {}", (Object)this.getExtent(), (Object)logger);
        }
        for (String logger : unusedLogs) {
            log.trace("Logs to be destroyed: {} {}", (Object)this.getExtent(), (Object)logger);
        }
        return unusedLogs;
    }

    synchronized void finishClearingUnusedLogs() {
        this.removingLogs = false;
        this.rebuildReferencedLogs();
        this.logLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"UL_UNRELEASED_LOCK"}, justification="lock is released by caller calling finishedUpdatingLogsUsed method")
    public boolean beginUpdatingLogsUsed(InMemoryMap memTable, DfsLogger more, boolean mincFinish) {
        boolean bl;
        boolean bl2;
        boolean releaseLock = true;
        this.logLock.lock();
        try {
            Tablet tablet = this;
            synchronized (tablet) {
                boolean contained;
                boolean added;
                boolean addToOther;
                if (this.isCloseComplete()) {
                    throw new IllegalStateException("Can not update logs of closed tablet " + this.extent);
                }
                if (memTable == this.getTabletMemory().getMinCMemTable()) {
                    addToOther = true;
                } else {
                    if (memTable != this.getTabletMemory().getMemTable()) {
                        throw new IllegalArgumentException("Passed in memtable that is not in use for " + this.extent);
                    }
                    addToOther = false;
                }
                if (mincFinish) {
                    if (addToOther) {
                        throw new IllegalStateException("Adding to other logs for mincFinish on " + this.extent);
                    }
                    if (!this.otherLogs.isEmpty()) {
                        throw new IllegalStateException("Expect other logs to be 0 when minC finish, but its " + this.otherLogs + " for " + this.extent);
                    }
                    if (this.currentLogs.isEmpty()) {
                        boolean bl3 = !releaseLock;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 10, 13] lbl21 : MonitorExitStatement: MONITOREXIT : var5_5
                        if (!releaseLock) return bl3;
                        this.logLock.unlock();
                        return bl3;
                    }
                }
                if (addToOther) {
                    added = this.otherLogs.add(more);
                    contained = this.currentLogs.contains(more);
                } else {
                    added = this.currentLogs.add(more);
                    contained = this.otherLogs.contains(more);
                }
                if (added) {
                    this.rebuildReferencedLogs();
                }
                if (added && !contained) {
                    return true;
                }
                bl2 = !releaseLock;
            }
        }
        catch (Throwable throwable) {
            if (!releaseLock) throw throwable;
            this.logLock.unlock();
            throw throwable;
        }
        {
            bl = bl2;
        }
        if (!releaseLock) return bl;
        this.logLock.unlock();
        return bl;
    }

    public void finishUpdatingLogsUsed() {
        this.logLock.unlock();
    }

    public void chopFiles() {
        this.compactable.initiateChop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactAll(long compactionId, CompactionConfig compactionConfig) {
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.lastCompactID.get() >= compactionId) {
                return;
            }
            if (this.isMinorCompactionRunning()) {
                if (this.compactionWaitInfo.compactionID == compactionId) {
                    if (this.lastFlushID.get() == this.compactionWaitInfo.flushID) {
                        return;
                    }
                } else {
                    this.compactionWaitInfo.compactionID = compactionId;
                    this.compactionWaitInfo.flushID = this.lastFlushID.get();
                    return;
                }
            }
            if (this.isClosing() || this.isClosed() || this.isBeingDeleted()) {
                return;
            }
        }
        this.compactable.initiateUserCompaction(compactionId, compactionConfig);
    }

    public Durability getDurability() {
        return DurabilityImpl.fromString((String)this.getTableConfiguration().get(Property.TABLE_DURABILITY));
    }

    public void updateMemoryUsageStats(long size, long mincSize) {
        this.getTabletResources().updateMemoryUsageStats(this, size, mincSize);
    }

    public long incrementDataSourceDeletions() {
        return this.dataSourceDeletions.incrementAndGet();
    }

    public void updateTimer(TabletStatsKeeper.Operation operation, long queued, long start, long count, boolean failed) {
        this.timer.updateTime(operation, queued, start, count, failed);
    }

    public void incrementStatusMajor() {
        this.timer.incrementStatusMajor();
    }

    TabletServer getTabletServer() {
        return this.tabletServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<StoredTabletFile, DataFileValue> updatePersistedTime(long bulkTime, Map<TabletFile, DataFileValue> paths, long tid) {
        Object object = this.timeLock;
        synchronized (object) {
            if (bulkTime > this.persistedTime) {
                this.persistedTime = bulkTime;
            }
            return MetadataTableUtil.updateTabletDataFile((long)tid, (KeyExtent)this.extent, paths, (MetadataTime)this.tabletTime.getMetadataTime(this.persistedTime), (ServerContext)this.getTabletServer().getContext(), (ServiceLock)this.getTabletServer().getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<StoredTabletFile> updateTabletDataFile(long maxCommittedTime, TabletFile newDatafile, DataFileValue dfv, Set<String> unusedWalLogs, long flushId) {
        Object object = this.timeLock;
        synchronized (object) {
            if (maxCommittedTime > this.persistedTime) {
                this.persistedTime = maxCommittedTime;
            }
            return ManagerMetadataUtil.updateTabletDataFile((ServerContext)this.getTabletServer().getContext(), (KeyExtent)this.extent, (TabletFile)newDatafile, (DataFileValue)dfv, (MetadataTime)this.tabletTime.getMetadataTime(this.persistedTime), (String)this.tabletServer.getClientAddressString(), (ServiceLock)this.tabletServer.getLock(), unusedWalLogs, (TServerInstance)this.lastLocation, (long)flushId);
        }
    }

    @Override
    TabletServerResourceManager.TabletResourceManager getTabletResources() {
        return this.tabletResources;
    }

    @Override
    public TabletServerScanMetrics getScanMetrics() {
        return this.getTabletServer().getScanMetrics();
    }

    DatafileManager getDatafileManager() {
        return this.datafileManager;
    }

    @Override
    public Pair<Long, Map<TabletFile, DataFileValue>> reserveFilesForScan() {
        return this.getDatafileManager().reserveFilesForScan();
    }

    @Override
    public void returnFilesForScan(long scanId) {
        this.getDatafileManager().returnFilesForScan(scanId);
    }

    public MetadataUpdateCount getUpdateCount() {
        return this.getDatafileManager().getUpdateCount();
    }

    TabletMemory getTabletMemory() {
        return this.tabletMemory;
    }

    @Override
    public List<InMemoryMap.MemoryIterator> getMemIterators(SamplerConfigurationImpl samplerConfig) {
        return this.getTabletMemory().getIterators(samplerConfig);
    }

    @Override
    public void returnMemIterators(List<InMemoryMap.MemoryIterator> iters) {
        this.getTabletMemory().returnIterators(iters);
    }

    public long getAndUpdateTime() {
        return this.tabletTime.getAndUpdateTime();
    }

    public void flushComplete(long flushId) {
        this.lastLocation = null;
        this.dataSourceDeletions.incrementAndGet();
        this.tabletMemory.finishedMinC();
        this.lastFlushID.set(flushId);
        this.computeNumEntries();
    }

    public TServerInstance resetLastLocation() {
        TServerInstance result = this.lastLocation;
        this.lastLocation = null;
        return result;
    }

    public synchronized void setLastCompactionID(Long compactionId) {
        if (compactionId != null) {
            this.lastCompactID.set(compactionId);
        }
    }

    public void minorCompactionWaitingToStart() {
        this.minorCompactionState = CompactionState.WAITING_TO_START;
    }

    public void minorCompactionStarted() {
        this.minorCompactionState = CompactionState.IN_PROGRESS;
    }

    public void minorCompactionComplete() {
        this.minorCompactionState = null;
    }

    public TabletStats getTabletStats() {
        return this.timer.getTabletStats();
    }

    private static String createTabletDirectoryName(ServerContext context, Text endRow) {
        if (endRow == null) {
            return "default_tablet";
        }
        UniqueNameAllocator namer = context.getUniqueNameAllocator();
        return "t-" + namer.getNextName();
    }

    public Set<Long> getBulkIngestedTxIds() {
        return this.bulkImported.keySet();
    }

    public void cleanupBulkLoadedFiles(Set<Long> tids) {
        ((ConcurrentHashMap.KeySetView)this.bulkImported.keySet()).removeAll(tids);
    }

    public String getDirName() {
        return this.dirName;
    }

    public Compactable asCompactable() {
        return this.compactable;
    }

    public static class LookupResult {
        public List<Range> unfinishedRanges = new ArrayList<Range>();
        public long bytesAdded = 0L;
        public long dataSize = 0L;
        public boolean closed = false;
    }

    static enum CompactionState {
        WAITING_TO_START,
        IN_PROGRESS;

    }

    private static class CompactionWaitInfo {
        long flushID = -1L;
        long compactionID = -1L;

        private CompactionWaitInfo() {
        }
    }

    private static enum CloseState {
        OPEN,
        CLOSING,
        CLOSED,
        COMPLETE;

    }
}

