/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.monitor.Monitor;
import org.glassfish.jersey.server.mvc.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"text/html"})
public class WebViews {
    private static final Logger log = LoggerFactory.getLogger(WebViews.class);
    @Inject
    private Monitor monitor;

    private void addExternalResources(Map<String, Object> model) {
        AccumuloConfiguration conf = this.monitor.getContext().getConfiguration();
        String resourcesProperty = conf.get(Property.MONITOR_RESOURCES_EXTERNAL);
        if (resourcesProperty.isBlank()) {
            return;
        }
        ArrayList monitorResources = new ArrayList();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Collections.addAll(monitorResources, (String[])objectMapper.readValue(resourcesProperty, String[].class));
        }
        catch (IOException e) {
            log.error("Error Monitor Resources config property {}: {}", (Object)Property.MONITOR_RESOURCES_EXTERNAL, (Object)e);
            return;
        }
        if (!monitorResources.isEmpty()) {
            model.put("externalResources", monitorResources);
        }
    }

    private Map<String, Object> getModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("version", "2.1.0");
        model.put("instance_name", this.monitor.getContext().getInstanceName());
        model.put("instance_id", this.monitor.getContext().getInstanceID());
        model.put("zk_hosts", this.monitor.getContext().getZooKeepers());
        this.addExternalResources(model);
        return model;
    }

    @GET
    @Template(name="/default.ftl")
    public Map<String, Object> get() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Accumulo Overview");
        model.put("template", "overview.ftl");
        model.put("js", "overview.js");
        return model;
    }

    @GET
    @Path(value="{parameter: manager|monitor}")
    @Template(name="/default.ftl")
    public Map<String, Object> getManager() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Manager Server");
        model.put("template", "manager.ftl");
        model.put("js", "manager.js");
        model.put("tablesTitle", "Table Status");
        model.put("tablesTemplate", "tables.ftl");
        return model;
    }

    @GET
    @Path(value="tservers")
    @Template(name="/default.ftl")
    public Map<String, Object> getTabletServers(@QueryParam(value="s") @Pattern(regexp="[a-zA-Z0-9.-]+:[0-9]{2,5}") @Pattern(regexp="[a-zA-Z0-9.-]+:[0-9]{2,5}") String server) {
        Map<String, Object> model = this.getModel();
        model.put("title", "Tablet Server Status");
        if (server != null && !server.isBlank()) {
            model.put("template", "server.ftl");
            model.put("js", "server.js");
            model.put("server", server);
            return model;
        }
        model.put("template", "tservers.ftl");
        model.put("js", "tservers.js");
        return model;
    }

    @GET
    @Path(value="scans")
    @Template(name="/default.ftl")
    public Map<String, Object> getScans() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Active scans");
        model.put("template", "scans.ftl");
        model.put("js", "scans.js");
        return model;
    }

    @GET
    @Path(value="compactions")
    @Template(name="/default.ftl")
    public Map<String, Object> getCompactions() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Active Compactions");
        model.put("template", "compactions.ftl");
        model.put("js", "compactions.js");
        return model;
    }

    @GET
    @Path(value="ec")
    @Template(name="/default.ftl")
    public Map<String, Object> getExternalCompactions() {
        Optional<HostAndPort> ccHost = this.monitor.getCoordinatorHost();
        Map<String, Object> model = this.getModel();
        model.put("title", "External Compactions");
        model.put("template", "ec.ftl");
        if (ccHost.isPresent()) {
            model.put("coordinatorRunning", true);
            model.put("js", "ec.js");
        } else {
            model.put("coordinatorRunning", false);
        }
        return model;
    }

    @GET
    @Path(value="bulkImports")
    @Template(name="/default.ftl")
    public Map<String, Object> getBulkImports() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Bulk Imports");
        model.put("template", "bulkImport.ftl");
        model.put("js", "bulkImport.js");
        return model;
    }

    @GET
    @Path(value="gc")
    @Template(name="/default.ftl")
    public Map<String, Object> getGC() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Garbage Collector Status");
        model.put("template", "gc.ftl");
        model.put("js", "gc.js");
        return model;
    }

    @GET
    @Path(value="tables")
    @Template(name="/default.ftl")
    public Map<String, Object> getTables() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Table Status");
        model.put("tablesTitle", "Table Status");
        model.put("template", "tables.ftl");
        return model;
    }

    @GET
    @Path(value="tables/{tableID}")
    @Template(name="/default.ftl")
    public Map<String, Object> getTables(@PathParam(value="tableID") @NotNull @Pattern(regexp="[!+]?\\w+") @NotNull @Pattern(regexp="[!+]?\\w+") String tableID) throws TableNotFoundException {
        String tableName = this.monitor.getContext().getTableName(TableId.of((String)tableID));
        Map<String, Object> model = this.getModel();
        model.put("title", "Table Status");
        model.put("template", "table.ftl");
        model.put("js", "table.js");
        model.put("tableID", tableID);
        model.put("table", tableName);
        return model;
    }

    @GET
    @Path(value="log")
    @Template(name="/default.ftl")
    public Map<String, Object> getLogs() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Recent Logs");
        model.put("template", "log.ftl");
        return model;
    }

    @GET
    @Path(value="problems")
    @Template(name="/default.ftl")
    public Map<String, Object> getProblems(@QueryParam(value="table") @Pattern(regexp="\\w*") @Pattern(regexp="\\w*") String table) {
        Map<String, Object> model = this.getModel();
        model.put("title", "Per-Table Problem Report");
        model.put("template", "problems.ftl");
        model.put("js", "problems.js");
        if (table != null && !table.isBlank()) {
            model.put("table", table);
        }
        return model;
    }

    @GET
    @Path(value="replication")
    @Template(name="/default.ftl")
    public Map<String, Object> getReplication() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Replication Overview");
        model.put("template", "replication.ftl");
        model.put("js", "replication.js");
        return model;
    }
}

