/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.tables;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.monitor.rest.tables.CompactionsList;
import org.apache.accumulo.monitor.util.JaxbAbstractIdSerializer;

public class TableInformation {
    private final String ZERO_COMBO = "0(0)";
    public String tablename;
    @XmlJavaTypeAdapter(value=JaxbAbstractIdSerializer.class)
    public TableId tableId;
    public String tableState;
    public int tablets;
    public int onlineTablets;
    public long recs;
    public long recsInMemory;
    public double ingestRate;
    public double ingestByteRate;
    public double query;
    public double queryByteRate;
    public CompactionsList majorCompactions;
    public String majorCombo;
    public CompactionsList minorCompactions;
    public String minorCombo;
    public CompactionsList scans;
    public String scansCombo;
    private int queuedMajorCompactions;
    private int runningMajorCompactions;
    private int queuedMinorCompactions;
    private int runningMinorCompactions;
    private int queuedScans;
    private int runningScans;
    public double entriesRead;
    public double entriesReturned;
    public Double holdTime;
    public int offlineTablets;

    public TableInformation() {
    }

    public TableInformation(String tableName, TableId tableId, String tableState) {
        this.tablename = tableName;
        this.tableId = tableId;
        this.tableState = tableState;
        this.tablets = 0;
        this.offlineTablets = 0;
        this.onlineTablets = 0;
        this.recs = 0L;
        this.recsInMemory = 0L;
        this.ingestRate = 0.0;
        this.ingestByteRate = 0.0;
        this.query = 0.0;
        this.queryByteRate = 0.0;
        this.entriesRead = 0.0;
        this.entriesReturned = 0.0;
        this.holdTime = 0.0;
        this.majorCompactions = new CompactionsList(0, 0);
        this.majorCombo = "0(0)";
        this.minorCompactions = new CompactionsList(0, 0);
        this.minorCombo = "0(0)";
        this.scans = new CompactionsList(0, 0);
        this.scansCombo = "0(0)";
    }

    public TableInformation(String tableName, TableId tableId, TableInfo info, Double holdTime, String tableState) {
        this.tablename = tableName;
        this.tableId = tableId;
        this.tablets = info.tablets;
        this.offlineTablets = info.tablets - info.onlineTablets;
        this.onlineTablets = info.onlineTablets;
        this.recs = info.recs;
        this.recsInMemory = info.recsInMemory;
        this.ingestRate = this.cleanNumber(info.getIngestRate());
        this.ingestByteRate = this.cleanNumber(info.getIngestByteRate());
        this.query = this.cleanNumber(info.getQueryRate());
        this.queryByteRate = this.cleanNumber(info.getQueryByteRate());
        this.entriesRead = this.cleanNumber(info.scanRate);
        this.entriesReturned = this.cleanNumber(info.queryRate);
        this.holdTime = holdTime;
        if (info.scans != null) {
            this.queuedScans = info.scans.queued;
            this.runningScans = info.scans.running;
            this.scansCombo = info.scans.running + "(" + info.scans.queued + ")";
        } else {
            this.queuedScans = 0;
            this.runningScans = 0;
            this.scansCombo = "0(0)";
        }
        if (info.minors != null) {
            this.queuedMinorCompactions = info.minors.queued;
            this.runningMinorCompactions = info.minors.running;
            this.minorCombo = info.minors.running + "(" + info.minors.queued + ")";
        } else {
            this.queuedMinorCompactions = 0;
            this.runningMinorCompactions = 0;
            this.minorCombo = "0(0)";
        }
        if (info.majors != null) {
            this.queuedMajorCompactions = info.majors.queued;
            this.runningMajorCompactions = info.majors.running;
            this.majorCombo = info.majors.running + "(" + info.majors.queued + ")";
        } else {
            this.queuedMajorCompactions = 0;
            this.runningMajorCompactions = 0;
            this.majorCombo = "0(0)";
        }
        this.majorCompactions = new CompactionsList(this.runningMajorCompactions, this.queuedMajorCompactions);
        this.minorCompactions = new CompactionsList(this.runningMinorCompactions, this.queuedMinorCompactions);
        this.scans = new CompactionsList(this.runningScans, this.queuedScans);
        this.tableState = tableState;
    }

    private double cleanNumber(double dirtyNumber) {
        return dirtyNumber < 1.0 ? 0.0 : dirtyNumber;
    }
}

