/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.fs;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.accumulo.core.spi.fs.RandomVolumeChooser;
import org.apache.accumulo.core.spi.fs.VolumeChooserEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferredVolumeChooser
extends RandomVolumeChooser {
    private static final Logger log = LoggerFactory.getLogger(PreferredVolumeChooser.class);
    private static final String TABLE_CUSTOM_SUFFIX = "volume.preferred";
    private static final String DEFAULT_SCOPED_PREFERRED_VOLUMES = PreferredVolumeChooser.getCustomPropertySuffix(VolumeChooserEnvironment.Scope.DEFAULT);

    private static final String getCustomPropertySuffix(VolumeChooserEnvironment.Scope scope) {
        return "volume.preferred." + scope.name().toLowerCase();
    }

    @Override
    public String choose(VolumeChooserEnvironment env, Set<String> options) {
        log.trace("{}.choose", (Object)this.getClass().getSimpleName());
        String choice = super.choose(env, this.getPreferredVolumes(env, options));
        log.trace("Choice = {}", (Object)choice);
        return choice;
    }

    @Override
    public Set<String> choosable(VolumeChooserEnvironment env, Set<String> options) {
        return this.getPreferredVolumes(env, options);
    }

    Set<String> getPreferredVolumes(VolumeChooserEnvironment env, Set<String> options) {
        if (env.getChooserScope() == VolumeChooserEnvironment.Scope.TABLE) {
            return this.getPreferredVolumesForTable(env, options);
        }
        return this.getPreferredVolumesForScope(env, options);
    }

    private Set<String> getPreferredVolumesForTable(VolumeChooserEnvironment env, Set<String> options) {
        log.trace("Looking up property {} + for Table id: {}", (Object)TABLE_CUSTOM_SUFFIX, env.getTable());
        String preferredVolumes = env.getServiceEnv().getConfiguration(env.getTable().get()).getTableCustom(TABLE_CUSTOM_SUFFIX);
        if (preferredVolumes == null || preferredVolumes.isEmpty()) {
            preferredVolumes = env.getServiceEnv().getConfiguration().getCustom(DEFAULT_SCOPED_PREFERRED_VOLUMES);
        }
        if (preferredVolumes == null || preferredVolumes.isEmpty()) {
            String msg = "Property volume.preferred or " + DEFAULT_SCOPED_PREFERRED_VOLUMES + " must be a subset of " + options + " to use the " + this.getClass().getSimpleName();
            throw new RuntimeException(msg);
        }
        return this.parsePreferred(TABLE_CUSTOM_SUFFIX, preferredVolumes, options);
    }

    private Set<String> getPreferredVolumesForScope(VolumeChooserEnvironment env, Set<String> options) {
        VolumeChooserEnvironment.Scope scope = env.getChooserScope();
        String property = PreferredVolumeChooser.getCustomPropertySuffix(scope);
        log.trace("Looking up property {} for scope: {}", (Object)property, (Object)scope);
        String preferredVolumes = env.getServiceEnv().getConfiguration().getCustom(property);
        if ((preferredVolumes == null || preferredVolumes.isEmpty()) && scope != VolumeChooserEnvironment.Scope.DEFAULT) {
            log.debug("{} not found; using {}", (Object)property, (Object)DEFAULT_SCOPED_PREFERRED_VOLUMES);
            preferredVolumes = env.getServiceEnv().getConfiguration().getCustom(DEFAULT_SCOPED_PREFERRED_VOLUMES);
            if (preferredVolumes == null || preferredVolumes.isEmpty()) {
                String msg = "Property " + property + " or " + DEFAULT_SCOPED_PREFERRED_VOLUMES + " must be a subset of " + options + " to use the " + this.getClass().getSimpleName();
                throw new RuntimeException(msg);
            }
            property = DEFAULT_SCOPED_PREFERRED_VOLUMES;
        }
        return this.parsePreferred(property, preferredVolumes, options);
    }

    private Set<String> parsePreferred(String property, String preferredVolumes, Set<String> options) {
        log.trace("Found {} = {}", (Object)property, (Object)preferredVolumes);
        Set<String> preferred = Arrays.stream(preferredVolumes.split(",")).map(String::trim).collect(Collectors.toSet());
        if (preferred.isEmpty()) {
            String msg = "No volumes could be parsed from '" + property + "', which had a value of '" + preferredVolumes + "'";
            throw new RuntimeException(msg);
        }
        if (Collections.disjoint(preferred, options)) {
            String msg = "Some volumes in " + preferred + " are not valid volumes from " + options;
            throw new RuntimeException(msg);
        }
        return preferred;
    }
}

