/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.security.AuthorizationContainer;
import org.apache.accumulo.core.util.ByteBufferUtil;

public class Authorizations
implements Iterable<byte[]>,
Serializable,
AuthorizationContainer {
    private static final long serialVersionUID = 1L;
    private final HashSet<ByteSequence> auths = new HashSet();
    private final ArrayList<byte[]> authsList = new ArrayList();
    public static final Authorizations EMPTY;
    private static final boolean[] validAuthChars;
    public static final String HEADER = "!AUTH1:";

    static final boolean isValidAuthChar(byte b) {
        return validAuthChars[0xFF & b];
    }

    private void checkAuths() {
        TreeSet<ByteSequence> sortedAuths = new TreeSet<ByteSequence>(this.auths);
        for (ByteSequence bs : sortedAuths) {
            if (bs.length() == 0) {
                throw new IllegalArgumentException("Empty authorization");
            }
            this.authsList.add(bs.toArray());
        }
    }

    public Authorizations(Collection<byte[]> authorizations) {
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        for (byte[] auth : authorizations) {
            this.auths.add(new ArrayByteSequence(auth));
        }
        this.checkAuths();
    }

    public Authorizations(List<ByteBuffer> authorizations) {
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        for (ByteBuffer buffer : authorizations) {
            this.auths.add(new ArrayByteSequence(ByteBufferUtil.toBytes(buffer)));
        }
        this.checkAuths();
    }

    public Authorizations(byte[] authorizations) {
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        String authsString = new String(authorizations, StandardCharsets.UTF_8);
        if (authsString.startsWith(HEADER)) {
            if (!(authsString = authsString.substring(HEADER.length())).isEmpty()) {
                for (String encAuth : authsString.split(",")) {
                    byte[] auth = Base64.getDecoder().decode(encAuth);
                    this.auths.add(new ArrayByteSequence(auth));
                }
                this.checkAuths();
            }
        } else if (authorizations.length > 0) {
            this.setAuthorizations(authsString.split(","));
        }
    }

    public Authorizations() {
    }

    public Authorizations(String ... authorizations) {
        this.setAuthorizations(authorizations);
    }

    private void setAuthorizations(String ... authorizations) {
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.auths.clear();
        for (String str : authorizations) {
            str = str.trim();
            this.auths.add(new ArrayByteSequence(str.getBytes(StandardCharsets.UTF_8)));
        }
        this.checkAuths();
    }

    public byte[] getAuthorizationsArray() {
        return this.serialize().getBytes(StandardCharsets.UTF_8);
    }

    public List<byte[]> getAuthorizations() {
        ArrayList<byte[]> copy = new ArrayList<byte[]>(this.authsList.size());
        for (byte[] auth : this.authsList) {
            byte[] bytes = new byte[auth.length];
            System.arraycopy(auth, 0, bytes, 0, auth.length);
            copy.add(bytes);
        }
        return Collections.unmodifiableList(copy);
    }

    public List<ByteBuffer> getAuthorizationsBB() {
        ArrayList<ByteBuffer> copy = new ArrayList<ByteBuffer>(this.authsList.size());
        for (byte[] auth : this.authsList) {
            byte[] bytes = new byte[auth.length];
            System.arraycopy(auth, 0, bytes, 0, auth.length);
            copy.add(ByteBuffer.wrap(bytes));
        }
        return Collections.unmodifiableList(copy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (ByteSequence auth : this.auths) {
            sb.append(sep);
            sep = ",";
            sb.append(new String(auth.toArray(), StandardCharsets.UTF_8));
        }
        return sb.toString();
    }

    public boolean contains(byte[] auth) {
        return this.auths.contains(new ArrayByteSequence(auth));
    }

    @Override
    public boolean contains(ByteSequence auth) {
        return this.auths.contains(auth);
    }

    public boolean contains(String auth) {
        return this.auths.contains(new ArrayByteSequence(auth));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Authorizations) {
            Authorizations ao = (Authorizations)o;
            return this.auths.equals(ao.auths);
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (ByteSequence b : this.auths) {
            result += b.hashCode();
        }
        return result;
    }

    public int size() {
        return this.auths.size();
    }

    public boolean isEmpty() {
        return this.auths.isEmpty();
    }

    @Override
    public Iterator<byte[]> iterator() {
        return this.getAuthorizations().iterator();
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder(HEADER);
        String sep = "";
        for (byte[] auth : this.authsList) {
            sb.append(sep);
            sep = ",";
            sb.append(Base64.getEncoder().encodeToString(auth));
        }
        return sb.toString();
    }

    static {
        int i;
        EMPTY = new Authorizations();
        validAuthChars = new boolean[256];
        for (i = 0; i < 256; ++i) {
            Authorizations.validAuthChars[i] = false;
        }
        for (i = 97; i <= 122; ++i) {
            Authorizations.validAuthChars[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            Authorizations.validAuthChars[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            Authorizations.validAuthChars[i] = true;
        }
        Authorizations.validAuthChars[95] = true;
        Authorizations.validAuthChars[45] = true;
        Authorizations.validAuthChars[58] = true;
        Authorizations.validAuthChars[46] = true;
        Authorizations.validAuthChars[47] = true;
    }
}

