/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.ScanServerRefTabletFile;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionFinalState;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionMetadata;
import org.apache.accumulo.core.metadata.schema.MetadataTime;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.hadoop.io.Text;

public interface Ample {
    default public TabletMetadata readTablet(KeyExtent extent, TabletMetadata.ColumnType ... colsToFetch) {
        return this.readTablet(extent, ReadConsistency.IMMEDIATE, colsToFetch);
    }

    public TabletMetadata readTablet(KeyExtent var1, ReadConsistency var2, TabletMetadata.ColumnType ... var3);

    public TabletsMetadata.TableOptions readTablets();

    default public TabletMutator mutateTablet(KeyExtent extent) {
        throw new UnsupportedOperationException();
    }

    default public TabletsMutator mutateTablets() {
        throw new UnsupportedOperationException();
    }

    default public void putGcCandidates(TableId tableId, Collection<StoredTabletFile> candidates) {
        throw new UnsupportedOperationException();
    }

    default public void putGcFileAndDirCandidates(TableId tableId, Collection<ReferenceFile> candidates) {
        throw new UnsupportedOperationException();
    }

    default public void deleteGcCandidates(DataLevel level, Collection<String> paths) {
        throw new UnsupportedOperationException();
    }

    default public Iterator<String> getGcCandidates(DataLevel level) {
        throw new UnsupportedOperationException();
    }

    default public void putExternalCompactionFinalStates(Collection<ExternalCompactionFinalState> finalStates) {
        throw new UnsupportedOperationException();
    }

    default public Stream<ExternalCompactionFinalState> getExternalCompactionFinalStates() {
        throw new UnsupportedOperationException();
    }

    default public void deleteExternalCompactionFinalStates(Collection<ExternalCompactionId> statusesToDelete) {
        throw new UnsupportedOperationException();
    }

    default public Mutation createDeleteMutation(ReferenceFile tabletFilePathToRemove) {
        throw new UnsupportedOperationException();
    }

    default public void putScanServerFileReferences(Collection<ScanServerRefTabletFile> scanRefs) {
        throw new UnsupportedOperationException();
    }

    default public Stream<ScanServerRefTabletFile> getScanServerFileReferences() {
        throw new UnsupportedOperationException();
    }

    default public void deleteScanServerFileReferences(Collection<ScanServerRefTabletFile> refsToDelete) {
        throw new UnsupportedOperationException();
    }

    default public void deleteScanServerFileReferences(String serverAddress, UUID serverSessionId) {
        throw new UnsupportedOperationException();
    }

    public static interface TabletMutator {
        public TabletMutator putPrevEndRow(Text var1);

        public TabletMutator putFile(TabletFile var1, DataFileValue var2);

        public TabletMutator deleteFile(StoredTabletFile var1);

        public TabletMutator putScan(TabletFile var1);

        public TabletMutator deleteScan(StoredTabletFile var1);

        public TabletMutator putCompactionId(long var1);

        public TabletMutator putFlushId(long var1);

        public TabletMutator putLocation(TServerInstance var1, TabletMetadata.LocationType var2);

        public TabletMutator deleteLocation(TServerInstance var1, TabletMetadata.LocationType var2);

        public TabletMutator putZooLock(ServiceLock var1);

        public TabletMutator putDirName(String var1);

        public TabletMutator putWal(LogEntry var1);

        public TabletMutator deleteWal(String var1);

        public TabletMutator deleteWal(LogEntry var1);

        public TabletMutator putTime(MetadataTime var1);

        public TabletMutator putBulkFile(TabletFile var1, long var2);

        public TabletMutator deleteBulkFile(TabletFile var1);

        public TabletMutator putChopped();

        public TabletMutator putSuspension(TServerInstance var1, long var2);

        public TabletMutator deleteSuspension();

        public TabletMutator putExternalCompaction(ExternalCompactionId var1, ExternalCompactionMetadata var2);

        public TabletMutator deleteExternalCompaction(ExternalCompactionId var1);

        public void mutate();
    }

    public static interface TabletsMutator
    extends AutoCloseable {
        public TabletMutator mutateTablet(KeyExtent var1);

        @Override
        public void close();
    }

    public static enum ReadConsistency {
        IMMEDIATE,
        EVENTUAL;

    }

    public static enum DataLevel {
        ROOT(null, null),
        METADATA(RootTable.NAME, RootTable.ID),
        USER(MetadataTable.NAME, MetadataTable.ID);

        private final String table;
        private final TableId id;

        private DataLevel(String table, TableId id) {
            this.table = table;
            this.id = id;
        }

        public String metaTable() {
            if (this.table == null) {
                throw new UnsupportedOperationException();
            }
            return this.table;
        }

        public TableId tableId() {
            if (this.id == null) {
                throw new UnsupportedOperationException();
            }
            return this.id;
        }

        public static DataLevel of(TableId tableId) {
            if (tableId.equals(RootTable.ID)) {
                return ROOT;
            }
            if (tableId.equals(MetadataTable.ID)) {
                return METADATA;
            }
            return USER;
        }
    }
}

