/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.SuspendingTServer;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletState;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.io.Text;

public class TabletLocationState {
    public final KeyExtent extent;
    public final TServerInstance future;
    public final TServerInstance current;
    public final TServerInstance last;
    public final SuspendingTServer suspend;
    public final Collection<Collection<String>> walogs;
    public final boolean chopped;

    public TabletLocationState(KeyExtent extent, TServerInstance future, TServerInstance current, TServerInstance last, SuspendingTServer suspend, Collection<Collection<String>> walogs, boolean chopped) throws BadLocationStateException {
        this.extent = extent;
        this.future = future;
        this.current = current;
        this.last = last;
        this.suspend = suspend;
        if (walogs == null) {
            walogs = Collections.emptyList();
        }
        this.walogs = walogs;
        this.chopped = chopped;
        if (this.hasCurrent() && this.hasFuture()) {
            throw new BadLocationStateException(extent + " is both assigned and hosted, which should never happen: " + this, extent.toMetaRow());
        }
    }

    public TServerInstance futureOrCurrent() {
        if (this.hasCurrent()) {
            return this.current;
        }
        return this.future;
    }

    public String toString() {
        return this.extent + "@(" + this.future + "," + this.current + "," + this.last + ")" + (this.chopped ? " chopped" : "");
    }

    public TServerInstance getLocation() {
        TServerInstance result = null;
        result = this.hasCurrent() ? this.current : (this.hasFuture() ? this.future : this.last);
        return result;
    }

    public boolean hasCurrent() {
        return this.current != null;
    }

    public boolean hasFuture() {
        return this.future != null;
    }

    public boolean hasSuspend() {
        return this.suspend != null;
    }

    public TabletState getState(Set<TServerInstance> liveServers) {
        if (this.hasFuture()) {
            return liveServers.contains(this.future) ? TabletState.ASSIGNED : TabletState.ASSIGNED_TO_DEAD_SERVER;
        }
        if (this.hasCurrent()) {
            return liveServers.contains(this.current) ? TabletState.HOSTED : TabletState.ASSIGNED_TO_DEAD_SERVER;
        }
        if (this.hasSuspend()) {
            return TabletState.SUSPENDED;
        }
        return TabletState.UNASSIGNED;
    }

    public static class BadLocationStateException
    extends Exception {
        private static final long serialVersionUID = 2L;
        private final byte[] metadataTableEntry;

        public BadLocationStateException(String msg, Text row) {
            super(msg);
            this.metadataTableEntry = TextUtil.getBytes(Objects.requireNonNull(row));
        }

        public Text getEncodedEndRow() {
            return new Text(this.metadataTableEntry);
        }
    }
}

