/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl.bulk;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Stream;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.bulk.BulkImport;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.TabletDeletedException;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConcurrentKeyExtentCache
implements BulkImport.KeyExtentCache {
    private static Logger log = LoggerFactory.getLogger(ConcurrentKeyExtentCache.class);
    private static final Text MAX = new Text();
    private Set<Text> rowsToLookup = Collections.synchronizedSet(new HashSet());
    List<Text> lookupRows = new ArrayList<Text>();
    private ConcurrentSkipListMap<Text, KeyExtent> extents = new ConcurrentSkipListMap((t1, t2) -> t1 == t2 ? 0 : (t1 == MAX ? 1 : (t2 == MAX ? -1 : t1.compareTo((BinaryComparable)t2))));
    private TableId tableId;
    private ClientContext ctx;

    ConcurrentKeyExtentCache(TableId tableId, ClientContext ctx) {
        this.tableId = tableId;
        this.ctx = ctx;
    }

    private KeyExtent getFromCache(Text row) {
        Map.Entry<Text, KeyExtent> entry = this.extents.ceilingEntry(row);
        if (entry != null && entry.getValue().contains((BinaryComparable)row)) {
            return entry.getValue();
        }
        return null;
    }

    private boolean inCache(KeyExtent e) {
        return Objects.equals(e, this.extents.get(e.endRow() == null ? MAX : e.endRow()));
    }

    @VisibleForTesting
    protected void updateCache(KeyExtent e) {
        Text prevRow = e.prevEndRow() == null ? new Text() : e.prevEndRow();
        Text endRow = e.endRow() == null ? MAX : e.endRow();
        this.extents.subMap((Object)prevRow, e.prevEndRow() == null, (Object)endRow, true).clear();
        this.extents.put(endRow, e);
    }

    @VisibleForTesting
    protected Stream<KeyExtent> lookupExtents(Text row) {
        return TabletsMetadata.builder(this.ctx).forTable(this.tableId).overlapping(row, true, null).checkConsistency().fetch(TabletMetadata.ColumnType.PREV_ROW).build().stream().limit(100L).map(TabletMetadata::getExtent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyExtent lookup(Text row) {
        KeyExtent ke;
        while ((ke = this.getFromCache(row)) == null) {
            this.rowsToLookup.add(row);
            ConcurrentKeyExtentCache concurrentKeyExtentCache = this;
            synchronized (concurrentKeyExtentCache) {
                ke = this.getFromCache(row);
                if (ke != null) {
                    this.rowsToLookup.remove(row);
                    return ke;
                }
                this.lookupRows.clear();
                Set<Text> set = this.rowsToLookup;
                synchronized (set) {
                    this.rowsToLookup.forEach(this.lookupRows::add);
                    this.rowsToLookup.clear();
                }
                this.lookupRows.sort(BinaryComparable::compareTo);
                block9: for (Text lookupRow : this.lookupRows) {
                    if (this.getFromCache(lookupRow) != null) continue;
                    while (true) {
                        try {
                            KeyExtent ke2;
                            Iterator iter = this.lookupExtents(lookupRow).iterator();
                            while (iter.hasNext() && !this.inCache(ke2 = (KeyExtent)iter.next())) {
                                this.updateCache(ke2);
                            }
                            continue block9;
                        }
                        catch (TabletDeletedException tde) {
                            log.debug("While trying to obtain a tablet location for bulk import, a tablet was deleted. If this was caused by a concurrent merge tablet operation, this is okay. Otherwise, it could be a problem.", (Throwable)tde);
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        return ke;
    }
}

