/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.clientImpl.TabletServerBatchReaderIterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.cleaner.CleanerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerBatchReader
extends ScannerOptions
implements BatchScanner {
    private static final Logger log = LoggerFactory.getLogger(TabletServerBatchReader.class);
    private static final AtomicInteger nextBatchReaderInstance = new AtomicInteger(1);
    private final int batchReaderInstance = nextBatchReaderInstance.getAndIncrement();
    private final TableId tableId;
    private final String tableName;
    private final int numThreads;
    private final ThreadPoolExecutor queryThreadPool;
    private final ClientContext context;
    private final Authorizations authorizations;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Cleaner.Cleanable cleanable;
    private ArrayList<Range> ranges = null;

    public TabletServerBatchReader(ClientContext context, TableId tableId, String tableName, Authorizations authorizations, int numQueryThreads) {
        this(context, BatchScanner.class, tableId, tableName, authorizations, numQueryThreads);
    }

    protected TabletServerBatchReader(ClientContext context, Class<?> scopeClass, TableId tableId, String tableName, Authorizations authorizations, int numQueryThreads) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.context = context;
        this.authorizations = authorizations;
        this.tableId = tableId;
        this.tableName = tableName;
        this.numThreads = numQueryThreads;
        this.queryThreadPool = context.threadPools().createFixedThreadPool(numQueryThreads, "batch scanner " + this.batchReaderInstance + "-", false);
        this.cleanable = CleanerUtil.shutdownThreadPoolExecutor(this.queryThreadPool, this.closed, log);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.queryThreadPool.shutdownNow();
            this.cleanable.clean();
        }
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public void setRanges(Collection<Range> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            throw new IllegalArgumentException("ranges must be non null and contain at least 1 range");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("batch reader closed");
        }
        this.ranges = new ArrayList<Range>(ranges);
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        if (this.ranges == null) {
            throw new IllegalStateException("ranges not set");
        }
        if (this.closed.get()) {
            throw new IllegalStateException("batch reader closed");
        }
        return new TabletServerBatchReaderIterator(this.context, this.tableId, this.tableName, this.authorizations, this.ranges, this.numThreads, this.queryThreadPool, this, this.timeOut);
    }
}

