/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.sample;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.sample.Sampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.sample.impl.DataoutputHasher;

public abstract class AbstractHashSampler
implements Sampler {
    private HashFunction hashFunction;
    private int modulus;
    private static final Set<String> VALID_OPTIONS = Set.of("hasher", "modulus");
    private static final Set<String> VALID_VALUES_HASHER = Set.of("murmur3_32", "md5", "sha1");

    @Override
    public void validateOptions(Map<String, String> config) {
        for (Map.Entry<String, String> entry : config.entrySet()) {
            Preconditions.checkArgument((boolean)VALID_OPTIONS.contains(entry.getKey()), (String)"Unknown option: %s", (Object)entry.getKey());
            if (entry.getKey().equals("hasher")) {
                Preconditions.checkArgument((boolean)VALID_VALUES_HASHER.contains(entry.getValue()), (String)"Unknown value for hasher: %s", (Object)entry.getValue());
            }
            if (!entry.getKey().equals("modulus")) continue;
            Preconditions.checkArgument((Integer.parseInt(entry.getValue()) > 0 ? 1 : 0) != 0, (String)"Improper Integer value for modulus: %s", (Object)entry.getValue());
        }
    }

    @Deprecated(since="2.1.0")
    protected boolean isValidOption(String option) {
        return VALID_OPTIONS.contains(option);
    }

    @Override
    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"}, justification="these hashes don't protect any secrets, just used for binning")
    public void init(SamplerConfiguration config) {
        String hasherOpt = config.getOptions().get("hasher");
        String modulusOpt = config.getOptions().get("modulus");
        Objects.requireNonNull(hasherOpt, "Hasher not specified");
        Objects.requireNonNull(modulusOpt, "Modulus not specified");
        switch (hasherOpt) {
            case "murmur3_32": {
                this.hashFunction = Hashing.murmur3_32_fixed();
                break;
            }
            case "md5": {
                HashFunction deprecatedMd5;
                this.hashFunction = deprecatedMd5 = Hashing.md5();
                break;
            }
            case "sha1": {
                HashFunction deprecatedSha1;
                this.hashFunction = deprecatedSha1 = Hashing.sha1();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hasher " + hasherOpt);
            }
        }
        this.modulus = Integer.parseInt(modulusOpt);
    }

    protected abstract void hash(DataOutput var1, Key var2) throws IOException;

    @Override
    public boolean accept(Key k) {
        Hasher hasher = this.hashFunction.newHasher();
        try {
            this.hash(new DataoutputHasher(hasher), k);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hasher.hash().asInt() % this.modulus == 0;
    }
}

