/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import org.apache.accumulo.core.client.lexicoder.AbstractLexicoder;

public class ULongLexicoder
extends AbstractLexicoder<Long> {
    @Override
    public byte[] encode(Long l) {
        int index;
        int shift = 56;
        int prefix = l < 0L ? 255 : 0;
        for (index = 0; index < 8 && (l >>> shift & 0xFFL) == (long)prefix; ++index) {
            shift -= 8;
        }
        byte[] ret = new byte[9 - index];
        ret[0] = (byte)(8 - index);
        for (index = 1; index < ret.length; ++index) {
            ret[index] = (byte)(l >>> shift);
            shift -= 8;
        }
        if (l < 0L) {
            ret[0] = (byte)(16 - ret[0]);
        }
        return ret;
    }

    @Override
    protected Long decodeUnchecked(byte[] data, int offset, int len) {
        long l = 0L;
        int shift = 0;
        if (data[offset] < 0 || data[offset] > 16) {
            throw new IllegalArgumentException("Unexpected length " + (0xFF & data[offset]));
        }
        for (int i = offset + len - 1; i >= offset + 1; --i) {
            l += ((long)data[i] & 0xFFL) << shift;
            shift += 8;
        }
        if (data[offset] > 8) {
            l |= -1L << (16 - data[offset] << 3);
        }
        return l;
    }

    @Override
    public Long decode(byte[] b) {
        return (Long)super.decode(b);
    }
}

