/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.clientImpl.IsolationException;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.io.Text;

public class IsolatedScanner
extends ScannerOptions
implements Scanner {
    private Scanner scanner;
    private Range range;
    private int batchSize;
    private long readaheadThreshold;
    private RowBufferFactory bufferFactory;

    public IsolatedScanner(Scanner scanner) {
        this(scanner, new MemoryRowBufferFactory());
    }

    public IsolatedScanner(Scanner scanner, RowBufferFactory bufferFactory) {
        this.scanner = scanner;
        this.range = scanner.getRange();
        this.timeOut = scanner.getTimeout(TimeUnit.MILLISECONDS);
        this.batchTimeOut = scanner.getBatchTimeout(TimeUnit.MILLISECONDS);
        this.batchSize = scanner.getBatchSize();
        this.readaheadThreshold = scanner.getReadaheadThreshold();
        this.bufferFactory = bufferFactory;
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        return new RowBufferingIterator(this.scanner, this, this.range, this.timeOut, this.batchSize, this.readaheadThreshold, this.bufferFactory);
    }

    @Override
    public void setRange(Range range) {
        this.range = range;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void enableIsolation() {
    }

    @Override
    public void disableIsolation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getReadaheadThreshold() {
        return this.readaheadThreshold;
    }

    @Override
    public void setReadaheadThreshold(long batches) {
        if (batches < 0L) {
            throw new IllegalArgumentException("Number of batches before read-ahead must be non-negative");
        }
        this.readaheadThreshold = batches;
    }

    @Override
    public void close() {
        this.scanner.close();
    }

    public static class MemoryRowBuffer
    implements RowBuffer {
        private ArrayList<Map.Entry<Key, Value>> buffer = new ArrayList();

        @Override
        public void add(Map.Entry<Key, Value> entry) {
            this.buffer.add(entry);
        }

        @Override
        public Iterator<Map.Entry<Key, Value>> iterator() {
            return this.buffer.iterator();
        }

        @Override
        public void clear() {
            this.buffer.clear();
        }
    }

    public static class MemoryRowBufferFactory
    implements RowBufferFactory {
        @Override
        public RowBuffer newBuffer() {
            return new MemoryRowBuffer();
        }
    }

    public static interface RowBuffer
    extends Iterable<Map.Entry<Key, Value>> {
        public void add(Map.Entry<Key, Value> var1);

        @Override
        public Iterator<Map.Entry<Key, Value>> iterator();

        public void clear();
    }

    public static interface RowBufferFactory {
        public RowBuffer newBuffer();
    }

    private static class RowBufferingIterator
    implements Iterator<Map.Entry<Key, Value>> {
        private Iterator<Map.Entry<Key, Value>> source;
        private RowBuffer buffer;
        private Map.Entry<Key, Value> nextRowStart;
        private Iterator<Map.Entry<Key, Value>> rowIter;
        private ByteSequence lastRow = null;
        private long timeout;
        private final Scanner scanner;
        private ScannerOptions opts;
        private Range range;
        private int batchSize;
        private long readaheadThreshold;

        private void readRow() {
            ByteSequence row = null;
            while (true) {
                this.buffer.clear();
                try {
                    Map.Entry<Key, Value> entry;
                    if (this.nextRowStart != null) {
                        this.buffer.add(this.nextRowStart);
                        row = this.nextRowStart.getKey().getRowData();
                        this.nextRowStart = null;
                    } else if (this.source.hasNext()) {
                        entry = this.source.next();
                        this.buffer.add(entry);
                        row = entry.getKey().getRowData();
                    }
                    while (this.source.hasNext()) {
                        entry = this.source.next();
                        if (entry.getKey().getRowData().equals(row)) {
                            this.buffer.add(entry);
                            continue;
                        }
                        this.nextRowStart = entry;
                        break;
                    }
                    this.lastRow = row;
                    this.rowIter = this.buffer.iterator();
                    return;
                }
                catch (IsolationException ie) {
                    Range seekRange = null;
                    this.nextRowStart = null;
                    if (this.lastRow == null) {
                        seekRange = this.range;
                    } else {
                        Text lastRowText = new Text();
                        lastRowText.set(this.lastRow.getBackingArray(), this.lastRow.offset(), this.lastRow.length());
                        Key startKey = new Key(lastRowText).followingKey(PartialKey.ROW);
                        if (!this.range.afterEndKey(startKey)) {
                            seekRange = new Range(startKey, true, this.range.getEndKey(), this.range.isEndKeyInclusive());
                        }
                    }
                    if (seekRange == null) {
                        this.buffer.clear();
                        this.rowIter = this.buffer.iterator();
                        return;
                    }
                    UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                    this.source = this.newIterator(seekRange);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator<Map.Entry<Key, Value>> newIterator(Range r) {
            Scanner scanner = this.scanner;
            synchronized (scanner) {
                this.scanner.enableIsolation();
                this.scanner.setBatchSize(this.batchSize);
                this.scanner.setTimeout(this.timeout, TimeUnit.MILLISECONDS);
                this.scanner.setRange(r);
                this.scanner.setReadaheadThreshold(this.readaheadThreshold);
                IsolatedScanner.setOptions((ScannerOptions)((Object)this.scanner), this.opts);
                return this.scanner.iterator();
            }
        }

        public RowBufferingIterator(Scanner scanner, ScannerOptions opts, Range range, long timeout, int batchSize, long readaheadThreshold, RowBufferFactory bufferFactory) {
            this.scanner = scanner;
            this.opts = new ScannerOptions(opts);
            this.range = range;
            this.timeout = timeout;
            this.batchSize = batchSize;
            this.readaheadThreshold = readaheadThreshold;
            this.buffer = bufferFactory.newBuffer();
            this.source = this.newIterator(range);
            this.readRow();
        }

        @Override
        public boolean hasNext() {
            return this.rowIter.hasNext();
        }

        @Override
        public Map.Entry<Key, Value> next() {
            Map.Entry<Key, Value> next = this.rowIter.next();
            if (!this.rowIter.hasNext()) {
                this.readRow();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

