/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.IParameterSplitter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOpts
extends Help {
    private static final Logger log = LoggerFactory.getLogger(ConfigOpts.class);
    @Parameter(names={"-p", "-props", "--props"}, description="Sets path to accumulo.properties.The classpath will be searched if this property is not set")
    private String propsPath;
    private String legacyOpts = null;
    @Parameter(names={"-s", "--safemode"}, hidden=true)
    private boolean legacyOptsBoolean = false;
    private static Map<String, String> LEGACY_OPTION_MSG = new HashMap<String, String>();
    @Parameter(names={"-o"}, splitter=NullSplitter.class, description="Overrides configuration set in accumulo.properties (but NOT system-wide config set in Zookeeper). Expected format: -o <key>=<value>")
    private List<String> overrides = new ArrayList<String>();
    private SiteConfiguration siteConfig = null;

    public synchronized String getPropertiesPath() {
        return this.propsPath;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="process runs in same security context as admin who provided path")
    public synchronized SiteConfiguration getSiteConfiguration() {
        if (this.siteConfig == null) {
            String propsPath = this.getPropertiesPath();
            this.siteConfig = (propsPath == null ? SiteConfiguration.fromEnv() : SiteConfiguration.fromFile(new File(propsPath))).withOverrides(this.getOverrides()).build();
        }
        return this.siteConfig;
    }

    public Map<String, String> getOverrides() {
        return ConfigOpts.getOverrides(this.overrides);
    }

    public static Map<String, String> getOverrides(List<String> args) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (String prop : args) {
            String value;
            String[] propArgs = prop.split("=", 2);
            String key = propArgs[0].trim();
            if (propArgs.length == 2) {
                value = propArgs[1].trim();
            } else {
                String string = value = Property.isValidBooleanPropertyKey(key) ? "true" : "";
            }
            if (key.isEmpty() || value.isEmpty()) {
                throw new IllegalArgumentException("Invalid command line -o option: " + prop);
            }
            config.put(key, value);
        }
        return config;
    }

    @Override
    public void parseArgs(String programName, String[] args, Object ... others) {
        super.parseArgs(programName, args, others);
        if (this.legacyOpts != null || this.legacyOptsBoolean) {
            Object errMsg = "";
            for (String option : args) {
                if (!LEGACY_OPTION_MSG.containsKey(option)) continue;
                errMsg = (String)errMsg + "Option " + option + " has been dropped - " + LEGACY_OPTION_MSG.get(option) + "\n";
            }
            errMsg = (String)errMsg + "See '-o' property override option";
            System.err.println((String)errMsg);
            throw new IllegalArgumentException((String)errMsg);
        }
        if (!this.getOverrides().isEmpty()) {
            log.info("The following configuration was set on the command line:");
            for (Map.Entry<String, String> entry : this.getOverrides().entrySet()) {
                String key;
                log.info(key + " = " + (Property.isSensitive(key = entry.getKey()) ? "<hidden>" : entry.getValue()));
            }
        }
    }

    static {
        LEGACY_OPTION_MSG.put("-s", "Replaced by configuration property " + Property.GC_SAFEMODE);
        LEGACY_OPTION_MSG.put("--safemode", "Replaced by configuration property " + Property.GC_SAFEMODE);
    }

    public static class NullSplitter
    implements IParameterSplitter {
        public List<String> split(String value) {
            return Collections.singletonList(value);
        }
    }
}

