/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.bulkVer1;

import java.util.Collections;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpBulkImport
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CleanUpBulkImport.class);
    private TableId tableId;
    private String source;
    private String bulk;
    private String error;

    CleanUpBulkImport(TableId tableId, String source, String bulk, String error) {
        this.tableId = tableId;
        this.source = source;
        this.bulk = bulk;
        this.error = error;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        manager.updateBulkImportStatus(this.source, BulkImportState.CLEANUP);
        log.debug("removing the bulkDir processing flag file in " + this.bulk);
        Path bulkDir = new Path(this.bulk);
        MetadataTableUtil.removeBulkLoadInProgressFlag((ServerContext)manager.getContext(), (String)("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName()));
        manager.getContext().getAmple().putGcFileAndDirCandidates(this.tableId, Collections.singleton(new ReferenceFile(this.tableId, bulkDir.toString())));
        log.debug("removing the metadata table markers for loaded files");
        ServerContext client = manager.getContext();
        MetadataTableUtil.removeBulkLoadEntries((AccumuloClient)client, (TableId)this.tableId, (long)tid);
        log.debug("releasing HDFS reservations for " + this.source + " and " + this.error);
        Utils.unreserveHdfsDirectory(manager, this.source, tid);
        Utils.unreserveHdfsDirectory(manager, this.error, tid);
        Utils.getReadLock(manager, this.tableId, tid).unlock();
        log.debug("completing bulkDir import transaction " + FateTxId.formatTid((long)tid));
        TransactionWatcher.ZooArbitrator.cleanup((ServerContext)manager.getContext(), (String)"bulkTx", (long)tid);
        manager.removeBulkImportStatus(this.source);
        return null;
    }
}

