/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.clientImpl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.DelegationTokenConfigSerializer;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TVersionedProperties;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftConcurrentModificationException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.DeprecatedPropertyUtil;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.fate.Fate;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.manager.thrift.ManagerClientService;
import org.apache.accumulo.core.manager.thrift.ManagerGoalState;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.manager.thrift.ManagerState;
import org.apache.accumulo.core.manager.thrift.TabletLoadState;
import org.apache.accumulo.core.manager.thrift.TabletSplit;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletDeletedException;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.securityImpl.thrift.TDelegationToken;
import org.apache.accumulo.core.securityImpl.thrift.TDelegationTokenConfig;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.EventCoordinator;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.TraceRepo;
import org.apache.accumulo.manager.tserverOps.ShutdownTServer;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.accumulo.server.util.PropUtil;
import org.apache.accumulo.server.util.SystemPropUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerClientServiceHandler
implements ManagerClientService.Iface {
    private static final Logger log = Manager.log;
    private static final Logger drainLog = LoggerFactory.getLogger((String)"org.apache.accumulo.manager.ManagerDrainImpl");
    private final Manager manager;

    protected ManagerClientServiceHandler(Manager manager) {
        this.manager = manager;
    }

    public long initiateFlush(TInfo tinfo, TCredentials c, String tableIdStr) throws ThriftSecurityException, ThriftTableOperationException {
        byte[] fid;
        NamespaceId namespaceId;
        TableId tableId = TableId.of((String)tableIdStr);
        if (!this.manager.security.canFlush(c, tableId, namespaceId = this.getNamespaceIdFromTableId(TableOperation.FLUSH, tableId))) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        String zTablePath = "/accumulo/" + this.manager.getInstanceID() + "/tables/" + tableId + "/flush-id";
        ZooReaderWriter zoo = this.manager.getContext().getZooReaderWriter();
        try {
            fid = zoo.mutateExisting(zTablePath, currentValue -> {
                long flushID = Long.parseLong(new String(currentValue, StandardCharsets.UTF_8));
                return Long.toString(flushID + 1L).getBytes(StandardCharsets.UTF_8);
            });
        }
        catch (KeeperException.NoNodeException nne) {
            throw new ThriftTableOperationException(tableId.canonical(), null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
        }
        catch (Exception e) {
            Manager.log.warn("{}", (Object)e.getMessage(), (Object)e);
            throw new ThriftTableOperationException(tableId.canonical(), null, TableOperation.FLUSH, TableOperationExceptionType.OTHER, null);
        }
        return Long.parseLong(new String(fid));
    }

    /*
     * WARNING - void declaration
     */
    public void waitForFlush(TInfo tinfo, TCredentials c, String tableIdStr, ByteBuffer startRowBB, ByteBuffer endRowBB, long flushID, long maxLoops) throws ThriftSecurityException, ThriftTableOperationException {
        NamespaceId namespaceId;
        TableId tableId = TableId.of((String)tableIdStr);
        if (!this.manager.security.canFlush(c, tableId, namespaceId = this.getNamespaceIdFromTableId(TableOperation.FLUSH, tableId))) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        Text startRow = ByteBufferUtil.toText((ByteBuffer)startRowBB);
        Text endRow = ByteBufferUtil.toText((ByteBuffer)endRowBB);
        if (endRow != null && startRow != null && startRow.compareTo((BinaryComparable)endRow) >= 0) {
            throw new ThriftTableOperationException(tableId.canonical(), null, TableOperation.FLUSH, TableOperationExceptionType.BAD_RANGE, "start row must be less than end row");
        }
        HashSet<TabletMetadata.Location> serversToFlush = new HashSet<TabletMetadata.Location>(this.manager.tserverSet.getCurrentServers());
        for (long l = 0L; l < maxLoops; ++l) {
            for (TServerInstance tServerInstance : serversToFlush) {
                try {
                    LiveTServerSet.TServerConnection server = this.manager.tserverSet.getConnection(tServerInstance);
                    if (server == null) continue;
                    server.flush(this.manager.managerLock, tableId, ByteBufferUtil.toBytes((ByteBuffer)startRowBB), ByteBufferUtil.toBytes((ByteBuffer)endRowBB));
                }
                catch (TException ex) {
                    Manager.log.error(ex.toString());
                }
            }
            if (tableId.equals((Object)RootTable.ID) || l == maxLoops - 1L) break;
            UtilWaitThread.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            serversToFlush.clear();
            try (TabletsMetadata tablets = TabletsMetadata.builder((AccumuloClient)this.manager.getContext()).forTable(tableId).overlapping(startRow, endRow).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.FLUSH_ID, TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.LOGS, TabletMetadata.ColumnType.PREV_ROW}).build();){
                void var18_18;
                boolean bl = false;
                int tabletCount = 0;
                for (TabletMetadata tablet : tablets) {
                    int logs = tablet.getLogs().size();
                    if ((tablet.hasCurrent() || logs > 0) && tablet.getFlushId().orElse(-1L) < flushID) {
                        ++var18_18;
                        if (tablet.hasCurrent()) {
                            serversToFlush.add(tablet.getLocation());
                        }
                    }
                    ++tabletCount;
                }
                if (var18_18 == false) break;
                if (tabletCount != 0 || this.manager.getContext().tableNodeExists(tableId)) continue;
                throw new ThriftTableOperationException(tableId.canonical(), null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
            }
            catch (TabletDeletedException e) {
                Manager.log.debug("Failed to scan {} table to wait for flush {}", new Object[]{MetadataTable.NAME, tableId, e});
            }
        }
    }

    private NamespaceId getNamespaceIdFromTableId(TableOperation tableOp, TableId tableId) throws ThriftTableOperationException {
        NamespaceId namespaceId;
        try {
            namespaceId = this.manager.getContext().getNamespaceId(tableId);
        }
        catch (TableNotFoundException e) {
            throw new ThriftTableOperationException(tableId.canonical(), null, tableOp, TableOperationExceptionType.NOTFOUND, e.getMessage());
        }
        return namespaceId;
    }

    public ManagerMonitorInfo getManagerStats(TInfo info, TCredentials credentials) {
        return this.manager.getManagerMonitorInfo();
    }

    public void removeTableProperty(TInfo info, TCredentials credentials, String tableName, String property) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterTableProperty(credentials, tableName, property, null, TableOperation.REMOVE_PROPERTY);
    }

    public void setTableProperty(TInfo info, TCredentials credentials, String tableName, String property, String value) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterTableProperty(credentials, tableName, property, value, TableOperation.SET_PROPERTY);
    }

    public void modifyTableProperties(TInfo tinfo, TCredentials credentials, String tableName, TVersionedProperties properties) throws TException {
        NamespaceId namespaceId;
        TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)tableName, (TableOperation)TableOperation.SET_PROPERTY);
        if (!this.manager.security.canAlterTable(credentials, tableId, namespaceId = this.getNamespaceIdFromTableId(TableOperation.SET_PROPERTY, tableId))) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            PropUtil.replaceProperties((ServerContext)this.manager.getContext(), (PropStoreKey)TablePropKey.of((ServerContext)this.manager.getContext(), (TableId)tableId), (long)properties.getVersion(), (Map)properties.getProperties());
        }
        catch (ConcurrentModificationException cme) {
            log.warn("Error modifying table properties, properties have changed", (Throwable)cme);
            throw new ThriftConcurrentModificationException(cme.getMessage());
        }
        catch (IllegalStateException ex) {
            log.warn("Error modifying table properties: tableId: {}", (Object)tableId.canonical());
            ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)tableName, (TableOperation)TableOperation.SET_PROPERTY);
            throw new ThriftTableOperationException(tableId.canonical(), tableName, TableOperation.SET_PROPERTY, TableOperationExceptionType.OTHER, "Error modifying table properties: tableId: " + tableId.canonical());
        }
    }

    public void shutdown(TInfo info, TCredentials c, boolean stopTabletServers) throws ThriftSecurityException {
        if (!this.manager.security.canPerformSystemActions(c)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (stopTabletServers) {
            this.manager.setManagerGoalState(ManagerGoalState.CLEAN_STOP);
            EventCoordinator.Listener eventListener = this.manager.nextEvent.getListener();
            do {
                eventListener.waitForEvents(1000L);
            } while (this.manager.tserverSet.size() > 0);
        }
        this.manager.setManagerState(ManagerState.STOP);
    }

    public void shutdownTabletServer(TInfo info, TCredentials c, String tabletServer, boolean force) throws ThriftSecurityException {
        LiveTServerSet.TServerConnection server;
        if (!this.manager.security.canPerformSystemActions(c)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        TServerInstance doomed = this.manager.tserverSet.find(tabletServer);
        if (doomed == null) {
            Manager.log.warn("No server found for name {}, unable to shut it down", (Object)tabletServer);
            return;
        }
        if (!force && (server = this.manager.tserverSet.getConnection(doomed)) == null) {
            Manager.log.warn("No server found for name {}, unable to shut it down", (Object)tabletServer);
            return;
        }
        Fate<Manager> fate = this.manager.fate();
        long tid = fate.startTransaction();
        String msg = "Shutdown tserver " + tabletServer;
        fate.seedTransaction("ShutdownTServer", tid, new TraceRepo<Manager>(new ShutdownTServer(doomed, force)), false, msg);
        fate.waitForCompletion(tid);
        fate.delete(tid);
        log.debug("FATE op shutting down " + tabletServer + " finished");
    }

    public void reportSplitExtent(TInfo info, TCredentials credentials, String serverName, TabletSplit split) throws ThriftSecurityException {
        if (!this.manager.security.canPerformSystemActions(credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        KeyExtent oldTablet = KeyExtent.fromThrift((TKeyExtent)split.oldTablet);
        if (this.manager.migrations.remove(oldTablet) != null) {
            Manager.log.info("Canceled migration of {}", (Object)split.oldTablet);
        }
        for (TServerInstance instance : this.manager.tserverSet.getCurrentServers()) {
            if (!serverName.equals(instance.getHostPort())) continue;
            this.manager.nextEvent.event("%s reported split %s, %s", serverName, KeyExtent.fromThrift((TKeyExtent)((TKeyExtent)split.newTablets.get(0))), KeyExtent.fromThrift((TKeyExtent)((TKeyExtent)split.newTablets.get(1))));
            return;
        }
        Manager.log.warn("Got a split from a server we don't recognize: {}", (Object)serverName);
    }

    public void reportTabletStatus(TInfo info, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent ttablet) throws ThriftSecurityException {
        if (!this.manager.security.canPerformSystemActions(credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        KeyExtent tablet = KeyExtent.fromThrift((TKeyExtent)ttablet);
        switch (status) {
            case LOAD_FAILURE: {
                Manager.log.error("{} reports assignment failed for tablet {}", (Object)serverName, (Object)tablet);
                break;
            }
            case LOADED: {
                this.manager.nextEvent.event("tablet %s was loaded on %s", tablet, serverName);
                break;
            }
            case UNLOADED: {
                this.manager.nextEvent.event("tablet %s was unloaded from %s", tablet, serverName);
                break;
            }
            case UNLOAD_ERROR: {
                Manager.log.error("{} reports unload failed for tablet {}", (Object)serverName, (Object)tablet);
                break;
            }
            case UNLOAD_FAILURE_NOT_SERVING: {
                if (!Manager.log.isTraceEnabled()) break;
                Manager.log.trace("{} reports unload failed: not serving tablet, could be a split: {}", (Object)serverName, (Object)tablet);
                break;
            }
            case CHOPPED: {
                this.manager.nextEvent.event("tablet %s chopped", tablet);
            }
        }
    }

    public void setManagerGoalState(TInfo info, TCredentials c, ManagerGoalState state) throws ThriftSecurityException {
        if (!this.manager.security.canPerformSystemActions(c)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.manager.setManagerGoalState(state);
    }

    public void removeSystemProperty(TInfo info, TCredentials c, String property) throws ThriftSecurityException {
        if (!this.manager.security.canPerformSystemActions(c)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            SystemPropUtil.removeSystemProperty((ServerContext)this.manager.getContext(), (String)property);
            this.updatePlugins(property);
        }
        catch (Exception e) {
            Manager.log.error("Problem removing config property in zookeeper", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setSystemProperty(TInfo info, TCredentials c, String property, String value) throws TException {
        if (!this.manager.security.canPerformSystemActions(c)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            SystemPropUtil.setSystemProperty((ServerContext)this.manager.getContext(), (String)property, (String)value);
            this.updatePlugins(property);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Manager.log.error("Problem setting config property in zookeeper", (Throwable)e);
            throw new TException(e.getMessage());
        }
    }

    public void modifySystemProperties(TInfo info, TCredentials c, TVersionedProperties properties) throws TException {
        if (!this.manager.security.canPerformSystemActions(c)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            SystemPropUtil.modifyProperties((ServerContext)this.manager.getContext(), (long)properties.getVersion(), (Map)properties.getProperties());
            for (Map.Entry entry : properties.getProperties().entrySet()) {
                this.updatePlugins((String)entry.getKey());
            }
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (ConcurrentModificationException cme) {
            log.warn("Error modifying system properties, properties have changed", (Throwable)cme);
            throw new ThriftConcurrentModificationException(cme.getMessage());
        }
        catch (Exception e) {
            Manager.log.error("Problem setting config property in zookeeper", (Throwable)e);
            throw new TException(e.getMessage());
        }
    }

    public void setNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property, String value) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterNamespaceProperty(credentials, ns, property, value, TableOperation.SET_PROPERTY);
    }

    public void modifyNamespaceProperties(TInfo tinfo, TCredentials credentials, String ns, TVersionedProperties properties) throws TException {
        NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId((ClientContext)this.manager.getContext(), (String)ns, (TableOperation)TableOperation.SET_PROPERTY);
        if (!this.manager.security.canAlterNamespace(credentials, namespaceId)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            PropUtil.replaceProperties((ServerContext)this.manager.getContext(), (PropStoreKey)NamespacePropKey.of((ServerContext)this.manager.getContext(), (NamespaceId)namespaceId), (long)properties.getVersion(), (Map)properties.getProperties());
        }
        catch (ConcurrentModificationException cme) {
            log.warn("Error modifying namespace properties, properties have changed", (Throwable)cme);
            throw new ThriftConcurrentModificationException(cme.getMessage());
        }
        catch (IllegalStateException ex) {
            ClientServiceHandler.checkNamespaceId((ClientContext)this.manager.getContext(), (String)ns, (TableOperation)TableOperation.SET_PROPERTY);
            log.warn("Error modifying namespace properties", (Throwable)ex);
            throw new ThriftTableOperationException(namespaceId.canonical(), ns, TableOperation.SET_PROPERTY, TableOperationExceptionType.OTHER, "Error modifying namespace properties");
        }
    }

    public void removeNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterNamespaceProperty(credentials, ns, property, null, TableOperation.REMOVE_PROPERTY);
    }

    private void alterNamespaceProperty(TCredentials c, String namespace, String property, String value, TableOperation op) throws ThriftSecurityException, ThriftTableOperationException {
        NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId((ClientContext)this.manager.getContext(), (String)namespace, (TableOperation)op);
        if (!this.manager.security.canAlterNamespace(c, namespaceId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            if (value == null) {
                PropUtil.removeProperties((ServerContext)this.manager.getContext(), (PropStoreKey)NamespacePropKey.of((ServerContext)this.manager.getContext(), (NamespaceId)namespaceId), List.of(property));
            } else {
                PropUtil.setProperties((ServerContext)this.manager.getContext(), (PropStoreKey)NamespacePropKey.of((ServerContext)this.manager.getContext(), (NamespaceId)namespaceId), Map.of(property, value));
            }
        }
        catch (IllegalStateException ex) {
            ClientServiceHandler.checkNamespaceId((ClientContext)this.manager.getContext(), (String)namespace, (TableOperation)op);
            log.info("Error altering namespace property", (Throwable)ex);
            throw new ThriftTableOperationException(namespaceId.canonical(), namespace, op, TableOperationExceptionType.OTHER, "Problem altering namespace property");
        }
    }

    private void alterTableProperty(TCredentials c, String tableName, String property, String value, TableOperation op) throws ThriftSecurityException, ThriftTableOperationException {
        NamespaceId namespaceId;
        TableId tableId = ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)tableName, (TableOperation)op);
        if (!this.manager.security.canAlterTable(c, tableId, namespaceId = this.getNamespaceIdFromTableId(op, tableId))) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            if (value == null || value.isEmpty()) {
                PropUtil.removeProperties((ServerContext)this.manager.getContext(), (PropStoreKey)TablePropKey.of((ServerContext)this.manager.getContext(), (TableId)tableId), List.of(property));
            } else {
                PropUtil.setProperties((ServerContext)this.manager.getContext(), (PropStoreKey)TablePropKey.of((ServerContext)this.manager.getContext(), (TableId)tableId), Map.of(property, value));
            }
        }
        catch (IllegalStateException ex) {
            log.warn("Invalid table property, tried to set: tableId: " + tableId.canonical() + " to: " + property + "=" + value);
            ClientServiceHandler.checkTableId((ClientContext)this.manager.getContext(), (String)tableName, (TableOperation)op);
            throw new ThriftTableOperationException(tableId.canonical(), tableName, op, TableOperationExceptionType.OTHER, "Invalid table property, tried to set: tableId: " + tableId.canonical() + " to: " + property + "=" + value);
        }
    }

    private void updatePlugins(String property) {
        String resolved = DeprecatedPropertyUtil.getReplacementName((String)property, (log, replacement) -> {});
        if (resolved.equals(Property.MANAGER_TABLET_BALANCER.getKey())) {
            this.manager.initializeBalancer();
            ManagerClientServiceHandler.log.info("tablet balancer changed to {}", (Object)this.manager.getBalancerClass().getName());
        }
    }

    public void waitForBalance(TInfo tinfo) {
        this.manager.waitForBalance();
    }

    public List<String> getActiveTservers(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        if (!this.manager.security.canPerformSystemActions(credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        Set<TServerInstance> tserverInstances = this.manager.onlineTabletServers();
        ArrayList<String> servers = new ArrayList<String>();
        for (TServerInstance tserverInstance : tserverInstances) {
            servers.add(tserverInstance.getHostPort());
        }
        return servers;
    }

    public TDelegationToken getDelegationToken(TInfo tinfo, TCredentials credentials, TDelegationTokenConfig tConfig) throws ThriftSecurityException, TException {
        if (!this.manager.security.canObtainDelegationToken(credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (!this.manager.delegationTokensAvailable()) {
            throw new TException("Delegation tokens are not available for use");
        }
        DelegationTokenConfig config = DelegationTokenConfigSerializer.deserialize((TDelegationTokenConfig)tConfig);
        AuthenticationTokenSecretManager secretManager = this.manager.getContext().getSecretManager();
        try {
            Map.Entry pair = secretManager.generateToken(credentials.principal, config);
            return new TDelegationToken(ByteBuffer.wrap(((Token)pair.getKey()).getPassword()), ((AuthenticationTokenIdentifier)pair.getValue()).getThriftIdentifier());
        }
        catch (Exception e) {
            throw new TException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainReplicationTable(TInfo tfino, TCredentials credentials, String tableName, Set<String> logsToWatch) throws TException {
        BatchScanner bs;
        ServerContext client = this.manager.getContext();
        Text tableId = new Text(this.getTableId((ClientContext)this.manager.getContext(), tableName).canonical());
        drainLog.trace("Waiting for {} to be replicated for {}", logsToWatch, (Object)tableId);
        drainLog.trace("Reading from metadata table");
        Set<Range> range = Collections.singleton(new Range(MetadataSchema.ReplicationSection.getRange()));
        try {
            bs = client.createBatchScanner(MetadataTable.NAME, Authorizations.EMPTY, 4);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException("Could not read metadata table", e);
        }
        bs.setRanges(range);
        bs.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        try {
            if (!this.allReferencesReplicated(bs, tableId, logsToWatch)) {
                boolean e = false;
                return e;
            }
        }
        finally {
            bs.close();
        }
        drainLog.trace("reading from replication table");
        try {
            bs = client.createBatchScanner(ReplicationTable.NAME, Authorizations.EMPTY, 4);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException("Replication table was not found", e);
        }
        bs.setRanges(Collections.singleton(new Range()));
        try {
            boolean bl = this.allReferencesReplicated(bs, tableId, logsToWatch);
            return bl;
        }
        finally {
            bs.close();
        }
    }

    protected TableId getTableId(ClientContext context, String tableName) throws ThriftTableOperationException {
        return ClientServiceHandler.checkTableId((ClientContext)context, (String)tableName, null);
    }

    @Deprecated
    protected boolean allReferencesReplicated(BatchScanner bs, Text tableId, Set<String> relevantLogs) {
        Text rowHolder = new Text();
        Text colfHolder = new Text();
        for (Map.Entry entry : bs) {
            String file;
            drainLog.trace("Got key {}", (Object)((Key)entry.getKey()).toStringNoTruncate());
            ((Key)entry.getKey()).getColumnQualifier(rowHolder);
            if (!tableId.equals((Object)rowHolder)) continue;
            ((Key)entry.getKey()).getRow(rowHolder);
            ((Key)entry.getKey()).getColumnFamily(colfHolder);
            if (colfHolder.equals((Object)MetadataSchema.ReplicationSection.COLF)) {
                file = rowHolder.toString();
                file = file.substring(MetadataSchema.ReplicationSection.getRowPrefix().length());
            } else if (colfHolder.equals((Object)ReplicationSchema.OrderSection.NAME)) {
                file = ReplicationSchema.OrderSection.getFile((Key)((Key)entry.getKey()), (Text)rowHolder);
                long timeClosed = ReplicationSchema.OrderSection.getTimeClosed((Key)((Key)entry.getKey()), (Text)rowHolder);
                drainLog.trace("Order section: {} and {}", (Object)timeClosed, (Object)file);
            } else {
                file = rowHolder.toString();
            }
            if (!relevantLogs.contains(file)) {
                drainLog.trace("Found file that we didn't care about {}", (Object)file);
                continue;
            }
            drainLog.trace("Found file that we *do* care about {}", (Object)file);
            try {
                Replication.Status stat = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                if (!StatusUtil.isFullyReplicated((Replication.Status)stat)) {
                    drainLog.trace("{} and {} is not replicated", (Object)file, (Object)ProtobufUtil.toString((GeneratedMessageV3)stat));
                    return false;
                }
                drainLog.trace("{} and {} is replicated", (Object)file, (Object)ProtobufUtil.toString((GeneratedMessageV3)stat));
            }
            catch (InvalidProtocolBufferException e) {
                drainLog.trace("Could not parse protobuf for {}", entry.getKey(), (Object)e);
            }
        }
        return true;
    }
}

