/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metadata;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.ScanServerRefTabletFile;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.ValidationUtil;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.AmpleImpl;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionFinalState;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.metadata.RootGcCandidates;
import org.apache.accumulo.server.metadata.TabletMutatorBase;
import org.apache.accumulo.server.metadata.TabletsMutatorImpl;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAmpleImpl
extends AmpleImpl
implements Ample {
    private static Logger log = LoggerFactory.getLogger(ServerAmpleImpl.class);
    private ServerContext context;

    public ServerAmpleImpl(ServerContext context) {
        super((AccumuloClient)context);
        this.context = context;
    }

    public Ample.TabletMutator mutateTablet(KeyExtent extent) {
        Ample.TabletsMutator tmi = this.mutateTablets();
        Ample.TabletMutator tabletMutator = tmi.mutateTablet(extent);
        ((TabletMutatorBase)tabletMutator).setCloseAfterMutate((AutoCloseable)tmi);
        return tabletMutator;
    }

    public Ample.TabletsMutator mutateTablets() {
        return new TabletsMutatorImpl(this.context);
    }

    private void mutateRootGcCandidates(Consumer<RootGcCandidates> mutator) {
        String zpath = this.context.getZooKeeperRoot() + "/root_tablet/gc_candidates";
        try {
            this.context.getZooReaderWriter().mutateOrCreate(zpath, new byte[0], currVal -> {
                String currJson = new String(currVal, StandardCharsets.UTF_8);
                RootGcCandidates rgcc = new RootGcCandidates(currJson);
                log.debug("Root GC candidates before change : {}", (Object)currJson);
                mutator.accept(rgcc);
                String newJson = rgcc.toJson();
                log.debug("Root GC candidates after change  : {}", (Object)newJson);
                if (newJson.length() > 262144) {
                    log.warn("Root tablet deletion candidates stored in ZK at {} are getting large ({} bytes), is Accumulo GC process running?  Large nodes may cause problems for Zookeeper!", (Object)zpath, (Object)newJson.length());
                }
                return newJson.getBytes(StandardCharsets.UTF_8);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void putGcCandidates(TableId tableId, Collection<StoredTabletFile> candidates) {
        if (RootTable.ID.equals((Object)tableId)) {
            this.mutateRootGcCandidates(rgcc -> rgcc.add(candidates.stream()));
            return;
        }
        try (BatchWriter writer = this.createWriter(tableId);){
            for (StoredTabletFile file : candidates) {
                writer.addMutation(this.createDeleteMutation(file));
            }
        }
        catch (MutationsRejectedException e) {
            throw new RuntimeException(e);
        }
    }

    public void putGcFileAndDirCandidates(TableId tableId, Collection<ReferenceFile> candidates) {
        if (RootTable.ID.equals((Object)tableId)) {
            this.mutateRootGcCandidates(rgcc -> rgcc.add(candidates.stream().map(reference -> new StoredTabletFile(reference.getMetadataEntry()))));
            return;
        }
        try (BatchWriter writer = this.createWriter(tableId);){
            for (ReferenceFile fileOrDir : candidates) {
                writer.addMutation(this.createDeleteMutation(fileOrDir));
            }
        }
        catch (MutationsRejectedException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteGcCandidates(Ample.DataLevel level, Collection<String> paths) {
        if (level == Ample.DataLevel.ROOT) {
            this.mutateRootGcCandidates(rgcc -> rgcc.remove(paths.stream()));
            return;
        }
        try (BatchWriter writer = this.context.createBatchWriter(level.metaTable());){
            for (String path : paths) {
                Mutation m = new Mutation((CharSequence)MetadataSchema.DeletesSection.encodeRow((String)path));
                m.putDelete(MetadataTableUtil.EMPTY_TEXT, MetadataTableUtil.EMPTY_TEXT);
                writer.addMutation(m);
            }
        }
        catch (MutationsRejectedException | TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<String> getGcCandidates(Ample.DataLevel level) {
        if (level == Ample.DataLevel.ROOT) {
            byte[] jsonBytes;
            ZooReader zooReader = this.context.getZooReader();
            try {
                jsonBytes = zooReader.getData(this.context.getZooKeeperRoot() + "/root_tablet/gc_candidates");
            }
            catch (InterruptedException | KeeperException e) {
                throw new RuntimeException(e);
            }
            return new RootGcCandidates(new String(jsonBytes, StandardCharsets.UTF_8)).sortedStream().iterator();
        }
        if (level == Ample.DataLevel.METADATA || level == Ample.DataLevel.USER) {
            Scanner scanner;
            Range range = MetadataSchema.DeletesSection.getRange();
            try {
                scanner = this.context.createScanner(level.metaTable(), Authorizations.EMPTY);
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException(e);
            }
            scanner.setRange(range);
            return scanner.stream().filter(entry -> ((Value)entry.getValue()).equals((Object)MetadataSchema.DeletesSection.SkewedKeyValue.NAME)).map(entry -> MetadataSchema.DeletesSection.decodeRow((String)((Key)entry.getKey()).getRow().toString())).iterator();
        }
        throw new IllegalArgumentException();
    }

    private BatchWriter createWriter(TableId tableId) {
        Preconditions.checkArgument((!RootTable.ID.equals((Object)tableId) ? 1 : 0) != 0);
        try {
            if (MetadataTable.ID.equals((Object)tableId)) {
                return this.context.createBatchWriter(RootTable.NAME);
            }
            return this.context.createBatchWriter(MetadataTable.NAME);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Mutation createDeleteMutation(ReferenceFile tabletFilePathToRemove) {
        return this.createDelMutation(ValidationUtil.validate((ReferenceFile)tabletFilePathToRemove).getMetadataEntry());
    }

    public Mutation createDeleteMutation(StoredTabletFile pathToRemove) {
        return this.createDelMutation(pathToRemove.getMetaUpdateDelete());
    }

    private Mutation createDelMutation(String path) {
        Mutation delFlag = new Mutation(new Text(MetadataSchema.DeletesSection.encodeRow((String)path)));
        delFlag.put(MetadataTableUtil.EMPTY_TEXT, MetadataTableUtil.EMPTY_TEXT, MetadataSchema.DeletesSection.SkewedKeyValue.NAME);
        return delFlag;
    }

    public void putExternalCompactionFinalStates(Collection<ExternalCompactionFinalState> finalStates) {
        try (BatchWriter writer = this.context.createBatchWriter(Ample.DataLevel.USER.metaTable());){
            String prefix = MetadataSchema.ExternalCompactionSection.getRowPrefix();
            for (ExternalCompactionFinalState finalState : finalStates) {
                Mutation m = new Mutation((CharSequence)(prefix + finalState.getExternalCompactionId().canonical()));
                m.put((CharSequence)"", (CharSequence)"", (CharSequence)finalState.toJson());
                writer.addMutation(m);
            }
        }
        catch (MutationsRejectedException | TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<ExternalCompactionFinalState> getExternalCompactionFinalStates() {
        Scanner scanner;
        try {
            scanner = this.context.createScanner(Ample.DataLevel.USER.metaTable(), Authorizations.EMPTY);
        }
        catch (TableNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        scanner.setRange(MetadataSchema.ExternalCompactionSection.getRange());
        int pLen = MetadataSchema.ExternalCompactionSection.getRowPrefix().length();
        return scanner.stream().map(e -> ExternalCompactionFinalState.fromJson((ExternalCompactionId)ExternalCompactionId.of((String)((Key)e.getKey()).getRowData().toString().substring(pLen)), (String)((Value)e.getValue()).toString()));
    }

    public void deleteExternalCompactionFinalStates(Collection<ExternalCompactionId> statusesToDelete) {
        try (BatchWriter writer = this.context.createBatchWriter(Ample.DataLevel.USER.metaTable());){
            String prefix = MetadataSchema.ExternalCompactionSection.getRowPrefix();
            for (ExternalCompactionId ecid : statusesToDelete) {
                Mutation m = new Mutation((CharSequence)(prefix + ecid.canonical()));
                m.putDelete(MetadataTableUtil.EMPTY_TEXT, MetadataTableUtil.EMPTY_TEXT);
                writer.addMutation(m);
            }
            log.debug("Deleted external compaction final state entries for external compactions: {}", statusesToDelete);
        }
        catch (MutationsRejectedException | TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void putScanServerFileReferences(Collection<ScanServerRefTabletFile> scanRefs) {
        try (BatchWriter writer = this.context.createBatchWriter(Ample.DataLevel.USER.metaTable());){
            String prefix = MetadataSchema.ScanServerFileReferenceSection.getRowPrefix();
            for (ScanServerRefTabletFile ref : scanRefs) {
                Mutation m = new Mutation((CharSequence)(prefix + ref.getRowSuffix()));
                m.put(ref.getServerAddress(), ref.getServerLockUUID(), ref.getValue());
                writer.addMutation(m);
            }
        }
        catch (MutationsRejectedException | TableNotFoundException e) {
            throw new IllegalStateException("Error inserting scan server file references into " + Ample.DataLevel.USER.metaTable(), e);
        }
    }

    public Stream<ScanServerRefTabletFile> getScanServerFileReferences() {
        try {
            Scanner scanner = this.context.createScanner(Ample.DataLevel.USER.metaTable(), Authorizations.EMPTY);
            scanner.setRange(MetadataSchema.ScanServerFileReferenceSection.getRange());
            int pLen = MetadataSchema.ScanServerFileReferenceSection.getRowPrefix().length();
            return StreamSupport.stream(scanner.spliterator(), false).map(e -> new ScanServerRefTabletFile(((Key)e.getKey()).getRowData().toString().substring(pLen), ((Key)e.getKey()).getColumnFamily(), ((Key)e.getKey()).getColumnQualifier()));
        }
        catch (TableNotFoundException e2) {
            throw new IllegalStateException(Ample.DataLevel.USER.metaTable() + " not found!", e2);
        }
    }

    public void deleteScanServerFileReferences(String serverAddress, UUID scanServerLockUUID) {
        Objects.requireNonNull(serverAddress, "Server address must be supplied");
        Objects.requireNonNull(scanServerLockUUID, "Server uuid must be supplied");
        try (Scanner scanner = this.context.createScanner(Ample.DataLevel.USER.metaTable(), Authorizations.EMPTY);){
            scanner.setRange(MetadataSchema.ScanServerFileReferenceSection.getRange());
            scanner.fetchColumn(new Text(serverAddress), new Text(scanServerLockUUID.toString()));
            int pLen = MetadataSchema.ScanServerFileReferenceSection.getRowPrefix().length();
            Set<ScanServerRefTabletFile> refsToDelete = StreamSupport.stream(scanner.spliterator(), false).map(e -> new ScanServerRefTabletFile(((Key)e.getKey()).getRowData().toString().substring(pLen), ((Key)e.getKey()).getColumnFamily(), ((Key)e.getKey()).getColumnQualifier())).collect(Collectors.toSet());
            if (!refsToDelete.isEmpty()) {
                this.deleteScanServerFileReferences(refsToDelete);
            }
        }
        catch (TableNotFoundException e2) {
            throw new IllegalStateException(Ample.DataLevel.USER.metaTable() + " not found!", e2);
        }
    }

    public void deleteScanServerFileReferences(Collection<ScanServerRefTabletFile> refsToDelete) {
        try (BatchWriter writer = this.context.createBatchWriter(Ample.DataLevel.USER.metaTable());){
            String prefix = MetadataSchema.ScanServerFileReferenceSection.getRowPrefix();
            for (ScanServerRefTabletFile ref : refsToDelete) {
                Mutation m = new Mutation((CharSequence)(prefix + ref.getRowSuffix()));
                m.putDelete(ref.getServerAddress(), ref.getServerLockUUID());
                writer.addMutation(m);
            }
            log.debug("Deleted scan server file reference entries for files: {}", refsToDelete);
        }
        catch (MutationsRejectedException | TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

