/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.util.ComparablePair;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.LoggerFactory;

@Deprecated(since="2.1.0")
public abstract class GroupBalancer
extends TabletBalancer {
    private final TableId tableId;
    private long lastRun = 0L;

    protected abstract Function<KeyExtent, String> getPartitioner();

    public GroupBalancer(TableId tableId) {
        this.tableId = tableId;
        LoggerFactory.getLogger((String)this.getClass().getName()).warn("{} has been deprecated and will be removed in a future release. Please update your configuration to use the equivalent {} instead.", (Object)this.getClass().getName(), (Object)org.apache.accumulo.core.spi.balancer.GroupBalancer.class.getName());
    }

    protected Map<KeyExtent, TServerInstance> getLocationProvider() {
        LinkedHashMap<KeyExtent, TServerInstance> tablets = new LinkedHashMap<KeyExtent, TServerInstance>();
        for (TabletMetadata tm : TabletsMetadata.builder((AccumuloClient)this.context).forTable(this.tableId).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.PREV_ROW}).build()) {
            tablets.put(tm.getExtent(), (TServerInstance)tm.getLocation());
        }
        return tablets;
    }

    protected long getWaitTime() {
        return 60000L;
    }

    protected int getMaxMigrations() {
        return 1000;
    }

    protected boolean shouldBalance(SortedMap<TServerInstance, TabletServerStatus> current, Set<KeyExtent> migrations) {
        if (current.size() < 2) {
            return false;
        }
        for (KeyExtent keyExtent : migrations) {
            if (!keyExtent.tableId().equals((Object)this.tableId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void getAssignments(SortedMap<TServerInstance, TabletServerStatus> current, Map<KeyExtent, TServerInstance> unassigned, Map<KeyExtent, TServerInstance> assignments) {
        if (current.isEmpty()) {
            return;
        }
        Function<KeyExtent, String> partitioner = this.getPartitioner();
        ArrayList<ComparablePair> tabletsByGroup = new ArrayList<ComparablePair>();
        for (Map.Entry<KeyExtent, TServerInstance> entry : unassigned.entrySet()) {
            TServerInstance last = entry.getValue();
            if (last != null) {
                TServerInstance tserver;
                String fakeSessionID = " ";
                TServerInstance simple = new TServerInstance(last.getHostAndPort(), fakeSessionID);
                Iterator<TServerInstance> find = current.tailMap(simple).keySet().iterator();
                if (find.hasNext() && (tserver = find.next()).getHost().equals(last.getHost())) {
                    assignments.put(entry.getKey(), tserver);
                    continue;
                }
            }
            tabletsByGroup.add(new ComparablePair((Comparable)((Object)partitioner.apply(entry.getKey())), (Comparable)entry.getKey()));
        }
        Collections.sort(tabletsByGroup);
        Iterator tserverIter = Iterators.cycle(current.keySet());
        for (ComparablePair pair : tabletsByGroup) {
            KeyExtent ke = (KeyExtent)pair.getSecond();
            assignments.put(ke, (TServerInstance)tserverIter.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long balance(SortedMap<TServerInstance, TabletServerStatus> current, Set<KeyExtent> migrations, List<TabletMigration> migrationsOut) {
        void var8_13;
        if (!this.shouldBalance(current, migrations)) {
            return 5000L;
        }
        if (System.currentTimeMillis() - this.lastRun < this.getWaitTime()) {
            return 5000L;
        }
        MapCounter groupCounts = new MapCounter();
        Map<TServerInstance, TserverGroupInfo> tservers = new HashMap<TServerInstance, TserverGroupInfo>();
        for (TServerInstance tServerInstance : current.keySet()) {
            tservers.put(tServerInstance, new TserverGroupInfo(tServerInstance));
        }
        Function<KeyExtent, String> partitioner = this.getPartitioner();
        for (Map.Entry<KeyExtent, TServerInstance> entry : this.getLocationProvider().entrySet()) {
            String group = partitioner.apply(entry.getKey());
            TServerInstance loc = entry.getValue();
            if (loc == null || !tservers.containsKey(loc)) {
                return 5000L;
            }
            groupCounts.increment((Object)group, 1L);
            TserverGroupInfo tgi = (TserverGroupInfo)tservers.get(loc);
            tgi.addGroup(group);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        boolean bl = false;
        for (String group : groupCounts.keySet()) {
            int groupCount = groupCounts.getInt((Object)group);
            var8_13 += groupCount % current.size();
            hashMap.put(group, groupCount / current.size());
        }
        void expectedExtra = var8_13 / current.size();
        void maxExtraGroups = expectedExtra + true;
        Map<String, Integer> map = Collections.unmodifiableMap(hashMap);
        tservers = Collections.unmodifiableMap(tservers);
        for (TserverGroupInfo tgi : tservers.values()) {
            tgi.finishedAdding(map);
        }
        Moves moves = new Moves();
        this.balanceExpected(tservers, moves);
        if (moves.size() < this.getMaxMigrations()) {
            boolean cont;
            this.balanceExtraExpected(tservers, (int)expectedExtra, moves);
            if (moves.size() < this.getMaxMigrations() && (cont = this.balanceExtraMultiple(tservers, (int)maxExtraGroups, moves)) && moves.size() < this.getMaxMigrations()) {
                this.balanceExtraExtra(tservers, (int)maxExtraGroups, moves);
            }
        }
        this.populateMigrations(tservers.keySet(), migrationsOut, moves);
        this.lastRun = System.currentTimeMillis();
        return 5000L;
    }

    private void balanceExtraExtra(Map<TServerInstance, TserverGroupInfo> tservers, int maxExtraGroups, Moves moves) {
        HashBasedTable surplusExtra = HashBasedTable.create();
        for (TserverGroupInfo tgi : tservers.values()) {
            Map<String, Integer> extras = tgi.getExtras();
            if (extras.size() <= maxExtraGroups) continue;
            for (String group : extras.keySet()) {
                surplusExtra.put((Object)group, (Object)tgi.getTserverInstance(), (Object)tgi);
            }
        }
        ArrayList<Pair> serversGroupsToRemove = new ArrayList<Pair>();
        ArrayList<TServerInstance> serversToRemove = new ArrayList<TServerInstance>();
        for (TserverGroupInfo destTgi : tservers.values()) {
            if (surplusExtra.isEmpty()) break;
            Map<String, Integer> extras = destTgi.getExtras();
            if (extras.size() >= maxExtraGroups) continue;
            serversToRemove.clear();
            serversGroupsToRemove.clear();
            for (String group : surplusExtra.rowKeySet()) {
                if (extras.containsKey(group)) continue;
                TserverGroupInfo srcTgi = (TserverGroupInfo)surplusExtra.row((Object)group).values().iterator().next();
                moves.move(group, 1, srcTgi, destTgi);
                if (srcTgi.getExtras().size() <= maxExtraGroups) {
                    serversToRemove.add(srcTgi.getTserverInstance());
                } else {
                    serversGroupsToRemove.add(new Pair((Object)group, (Object)srcTgi.getTserverInstance()));
                }
                if (destTgi.getExtras().size() < maxExtraGroups && moves.size() < this.getMaxMigrations()) continue;
                break;
            }
            if (!serversToRemove.isEmpty()) {
                surplusExtra.columnKeySet().removeAll(serversToRemove);
            }
            for (Pair pair : serversGroupsToRemove) {
                surplusExtra.remove(pair.getFirst(), pair.getSecond());
            }
            if (moves.size() < this.getMaxMigrations()) continue;
            break;
        }
    }

    private boolean balanceExtraMultiple(Map<TServerInstance, TserverGroupInfo> tservers, int maxExtraGroups, Moves moves) {
        HashMultimap extraMultiple = HashMultimap.create();
        for (TserverGroupInfo tgi : tservers.values()) {
            Map<String, Integer> extras = tgi.getExtras();
            for (Map.Entry<String, Integer> entry : extras.entrySet()) {
                if (entry.getValue() <= 1) continue;
                extraMultiple.put((Object)entry.getKey(), (Object)tgi);
            }
        }
        this.balanceExtraMultiple(tservers, maxExtraGroups, moves, (Multimap<String, TserverGroupInfo>)extraMultiple, false);
        if (moves.size() < this.getMaxMigrations() && !extraMultiple.isEmpty()) {
            this.balanceExtraMultiple(tservers, maxExtraGroups, moves, (Multimap<String, TserverGroupInfo>)extraMultiple, true);
            return false;
        }
        return true;
    }

    private void balanceExtraMultiple(Map<TServerInstance, TserverGroupInfo> tservers, int maxExtraGroups, Moves moves, Multimap<String, TserverGroupInfo> extraMultiple, boolean alwaysAdd) {
        ArrayList<Pair> serversToRemove = new ArrayList<Pair>();
        for (TserverGroupInfo destTgi : tservers.values()) {
            Map<String, Integer> extras = destTgi.getExtras();
            if (!alwaysAdd && extras.size() >= maxExtraGroups) continue;
            serversToRemove.clear();
            for (String group : extraMultiple.keySet()) {
                if (extras.containsKey(group)) continue;
                Collection sources = extraMultiple.get((Object)group);
                Iterator iter = sources.iterator();
                TserverGroupInfo srcTgi = (TserverGroupInfo)iter.next();
                int num = srcTgi.getExtras().get(group);
                moves.move(group, 1, srcTgi, destTgi);
                if (num == 2) {
                    serversToRemove.add(new Pair((Object)group, (Object)srcTgi));
                }
                if (destTgi.getExtras().size() < maxExtraGroups && moves.size() < this.getMaxMigrations()) continue;
                break;
            }
            for (Pair pair : serversToRemove) {
                extraMultiple.remove(pair.getFirst(), pair.getSecond());
            }
            if (!extraMultiple.isEmpty() && moves.size() < this.getMaxMigrations()) continue;
            break;
        }
    }

    private void balanceExtraExpected(Map<TServerInstance, TserverGroupInfo> tservers, int expectedExtra, Moves moves) {
        HashBasedTable extraSurplus = HashBasedTable.create();
        for (TserverGroupInfo tgi : tservers.values()) {
            Map<String, Integer> extras = tgi.getExtras();
            if (extras.size() <= expectedExtra) continue;
            for (String group : extras.keySet()) {
                extraSurplus.put((Object)group, (Object)tgi.getTserverInstance(), (Object)tgi);
            }
        }
        ArrayList<TServerInstance> emptyServers = new ArrayList<TServerInstance>();
        ArrayList<Pair> emptyServerGroups = new ArrayList<Pair>();
        for (TserverGroupInfo destTgi : tservers.values()) {
            if (extraSurplus.isEmpty()) break;
            Map<String, Integer> extras = destTgi.getExtras();
            if (extras.size() >= expectedExtra) continue;
            emptyServers.clear();
            emptyServerGroups.clear();
            block3: for (String group : extraSurplus.rowKeySet()) {
                if (extras.containsKey(group)) continue;
                Iterator iter = extraSurplus.row((Object)group).values().iterator();
                TserverGroupInfo srcTgi = (TserverGroupInfo)iter.next();
                while (srcTgi.getExtras().size() <= expectedExtra) {
                    if (!iter.hasNext()) continue block3;
                    srcTgi = (TserverGroupInfo)iter.next();
                }
                moves.move(group, 1, srcTgi, destTgi);
                if (srcTgi.getExtras().size() <= expectedExtra) {
                    emptyServers.add(srcTgi.getTserverInstance());
                } else if (srcTgi.getExtras().get(group) == null) {
                    emptyServerGroups.add(new Pair((Object)group, (Object)srcTgi.getTserverInstance()));
                }
                if (destTgi.getExtras().size() < expectedExtra && moves.size() < this.getMaxMigrations()) continue;
                break;
            }
            if (!emptyServers.isEmpty()) {
                extraSurplus.columnKeySet().removeAll(emptyServers);
            }
            for (Pair pair : emptyServerGroups) {
                extraSurplus.remove(pair.getFirst(), pair.getSecond());
            }
            if (moves.size() < this.getMaxMigrations()) continue;
            break;
        }
    }

    private void balanceExpected(Map<TServerInstance, TserverGroupInfo> tservers, Moves moves) {
        HashMultimap groupDefecits = HashMultimap.create();
        HashMultimap groupSurplus = HashMultimap.create();
        for (TserverGroupInfo tgi : tservers.values()) {
            for (String group : tgi.getExpectedDeficits().keySet()) {
                groupDefecits.put((Object)group, (Object)tgi);
            }
            for (String group : tgi.getExtras().keySet()) {
                groupSurplus.put((Object)group, (Object)tgi);
            }
        }
        for (String group : groupDefecits.keySet()) {
            Collection defecitServers = groupDefecits.get((Object)group);
            for (TserverGroupInfo defecitTsi : defecitServers) {
                int transfer;
                Iterator surplusIter = groupSurplus.get((Object)group).iterator();
                for (int numToMove = defecitTsi.getExpectedDeficits().get(group).intValue(); numToMove > 0; numToMove -= transfer) {
                    TserverGroupInfo surplusTsi = (TserverGroupInfo)surplusIter.next();
                    int available = surplusTsi.getExtras().get(group);
                    if (numToMove >= available) {
                        surplusIter.remove();
                    }
                    transfer = Math.min(numToMove, available);
                    moves.move(group, transfer, surplusTsi, defecitTsi);
                    if (moves.size() < this.getMaxMigrations()) continue;
                    return;
                }
            }
        }
    }

    private void populateMigrations(Set<TServerInstance> current, List<TabletMigration> migrationsOut, Moves moves) {
        if (moves.size() == 0) {
            return;
        }
        Function<KeyExtent, String> partitioner = this.getPartitioner();
        for (Map.Entry<KeyExtent, TServerInstance> tablet : this.getLocationProvider().entrySet()) {
            String group = partitioner.apply(tablet.getKey());
            TServerInstance loc = tablet.getValue();
            if (loc == null || !current.contains(loc)) {
                migrationsOut.clear();
                return;
            }
            TServerInstance dest = moves.removeMove(loc, group);
            if (dest == null) continue;
            migrationsOut.add(new TabletMigration(tablet.getKey(), loc, dest));
            if (moves.size() != 0) continue;
            break;
        }
    }

    private static class Moves {
        private final HashBasedTable<TServerInstance, String, List<Move>> moves = HashBasedTable.create();
        private int totalMoves = 0;

        private Moves() {
        }

        public void move(String group, int num, TserverGroupInfo src, TserverGroupInfo dest) {
            Preconditions.checkArgument((num > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((!src.equals(dest) ? 1 : 0) != 0);
            src.moveOff(group, num);
            dest.moveTo(group, num);
            ArrayList<Move> srcMoves = (ArrayList<Move>)this.moves.get((Object)src.getTserverInstance(), (Object)group);
            if (srcMoves == null) {
                srcMoves = new ArrayList<Move>();
                this.moves.put((Object)src.getTserverInstance(), (Object)group, srcMoves);
            }
            srcMoves.add(new Move(dest, num));
            this.totalMoves += num;
        }

        public TServerInstance removeMove(TServerInstance src, String group) {
            List srcMoves = (List)this.moves.get((Object)src, (Object)group);
            if (srcMoves == null) {
                return null;
            }
            Move move = (Move)srcMoves.get(srcMoves.size() - 1);
            TServerInstance ret = move.dest.getTserverInstance();
            --this.totalMoves;
            --move.count;
            if (move.count == 0) {
                srcMoves.remove(srcMoves.size() - 1);
                if (srcMoves.isEmpty()) {
                    this.moves.remove((Object)src, (Object)group);
                }
            }
            return ret;
        }

        public int size() {
            return this.totalMoves;
        }
    }

    private static class Move {
        TserverGroupInfo dest;
        int count;

        public Move(TserverGroupInfo dest, int num) {
            this.dest = dest;
            this.count = num;
        }
    }

    static class TserverGroupInfo {
        private Map<String, Integer> expectedCounts;
        private final Map<String, MutableInt> initialCounts = new HashMap<String, MutableInt>();
        private final Map<String, Integer> extraCounts = new HashMap<String, Integer>();
        private final Map<String, Integer> expectedDeficits = new HashMap<String, Integer>();
        private final TServerInstance tsi;
        private boolean finishedAdding = false;

        TserverGroupInfo(TServerInstance tsi) {
            this.tsi = tsi;
        }

        public void addGroup(String group) {
            Preconditions.checkState((!this.finishedAdding ? 1 : 0) != 0);
            MutableInt mi = this.initialCounts.get(group);
            if (mi == null) {
                mi = new MutableInt();
                this.initialCounts.put(group, mi);
            }
            mi.increment();
        }

        public void finishedAdding(Map<String, Integer> expectedCounts) {
            Preconditions.checkState((!this.finishedAdding ? 1 : 0) != 0);
            this.finishedAdding = true;
            this.expectedCounts = expectedCounts;
            for (Map.Entry<String, Integer> entry : expectedCounts.entrySet()) {
                int num;
                String group = entry.getKey();
                int expected = entry.getValue();
                MutableInt count = this.initialCounts.get(group);
                int n = num = count == null ? 0 : count.intValue();
                if (num < expected) {
                    this.expectedDeficits.put(group, expected - num);
                    continue;
                }
                if (num <= expected) continue;
                this.extraCounts.put(group, num - expected);
            }
        }

        public void moveOff(String group, int num) {
            Preconditions.checkArgument((num > 0 ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.finishedAdding);
            Integer extraCount = this.extraCounts.get(group);
            String formatString = "group=%s num=%s extraCount=%s";
            Preconditions.checkArgument((extraCount != null && extraCount >= num ? 1 : 0) != 0, (String)formatString, (Object)group, (Object)num, (Object)extraCount);
            MutableInt initialCount = this.initialCounts.get(group);
            Preconditions.checkArgument((initialCount.intValue() >= num ? 1 : 0) != 0);
            initialCount.subtract(num);
            if (extraCount - num == 0) {
                this.extraCounts.remove(group);
            } else {
                this.extraCounts.put(group, extraCount - num);
            }
        }

        public void moveTo(String group, int num) {
            Preconditions.checkArgument((num > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)this.expectedCounts.containsKey(group));
            Preconditions.checkState((boolean)this.finishedAdding);
            Integer deficit = this.expectedDeficits.get(group);
            if (deficit != null) {
                if (num >= deficit) {
                    this.expectedDeficits.remove(group);
                    num -= deficit.intValue();
                } else {
                    this.expectedDeficits.put(group, deficit - num);
                    num = 0;
                }
            }
            if (num > 0) {
                Integer extra = this.extraCounts.get(group);
                if (extra == null) {
                    extra = 0;
                }
                this.extraCounts.put(group, extra + num);
            }
        }

        public Map<String, Integer> getExpectedDeficits() {
            Preconditions.checkState((boolean)this.finishedAdding);
            return Collections.unmodifiableMap(this.expectedDeficits);
        }

        public Map<String, Integer> getExtras() {
            Preconditions.checkState((boolean)this.finishedAdding);
            return Collections.unmodifiableMap(this.extraCounts);
        }

        public TServerInstance getTserverInstance() {
            return this.tsi;
        }

        public int hashCode() {
            return this.tsi.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof TserverGroupInfo) {
                TserverGroupInfo otgi = (TserverGroupInfo)o;
                return this.tsi.equals((Object)otgi.tsi);
            }
            return false;
        }

        public String toString() {
            return this.tsi.getHostPortSession();
        }
    }
}

