/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager.state;

import java.io.IOException;
import java.lang.ref.Cleaner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.accumulo.core.metadata.SuspendingTServer;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.cleaner.CleanerUtil;
import org.apache.accumulo.server.manager.state.ClosableIterator;
import org.apache.accumulo.server.manager.state.CurrentState;
import org.apache.accumulo.server.manager.state.TabletStateChangeIterator;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataTableScanner
implements ClosableIterator<TabletLocationState> {
    private static final Logger log = LoggerFactory.getLogger(MetaDataTableScanner.class);
    private final Cleaner.Cleanable cleanable;
    private final BatchScanner mdScanner;
    private final Iterator<Map.Entry<Key, Value>> iter;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    MetaDataTableScanner(ClientContext context, Range range, CurrentState state, String tableName) {
        try {
            this.mdScanner = context.createBatchScanner(tableName, Authorizations.EMPTY, 8);
        }
        catch (TableNotFoundException e) {
            throw new IllegalStateException("Metadata table " + tableName + " should exist", e);
        }
        this.cleanable = CleanerUtil.unclosed((AutoCloseable)this, MetaDataTableScanner.class, (AtomicBoolean)this.closed, (Logger)log, (AutoCloseable)this.mdScanner);
        MetaDataTableScanner.configureScanner((ScannerBase)this.mdScanner, state);
        this.mdScanner.setRanges(Collections.singletonList(range));
        this.iter = this.mdScanner.iterator();
    }

    public static void configureScanner(ScannerBase scanner, CurrentState state) {
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch(scanner);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.SuspendLocationColumn.SUSPEND_COLUMN.getColumnFamily());
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.ChoppedColumnFamily.NAME);
        scanner.addScanIterator(new IteratorSetting(1000, "wholeRows", WholeRowIterator.class));
        IteratorSetting tabletChange = new IteratorSetting(1001, "tabletChange", TabletStateChangeIterator.class);
        if (state != null) {
            TabletStateChangeIterator.setCurrentServers(tabletChange, state.onlineTabletServers());
            TabletStateChangeIterator.setOnlineTables(tabletChange, state.onlineTables());
            TabletStateChangeIterator.setMerges(tabletChange, state.merges());
            TabletStateChangeIterator.setMigrations(tabletChange, state.migrationsSnapshot());
            TabletStateChangeIterator.setManagerState(tabletChange, state.getManagerState());
            TabletStateChangeIterator.setShuttingDown(tabletChange, state.shutdownServers());
        }
        scanner.addScanIterator(tabletChange);
    }

    public MetaDataTableScanner(ClientContext context, Range range, String tableName) {
        this(context, range, null, tableName);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.cleanable.clean();
            this.mdScanner.close();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.closed.get()) {
            return false;
        }
        boolean result = this.iter.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public TabletLocationState next() {
        if (this.closed.get()) {
            throw new NoSuchElementException(this.getClass().getSimpleName() + " is closed");
        }
        try {
            Map.Entry<Key, Value> e = this.iter.next();
            return MetaDataTableScanner.createTabletLocationState(e.getKey(), e.getValue());
        }
        catch (IOException | TabletLocationState.BadLocationStateException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static TabletLocationState createTabletLocationState(Key k, Value v) throws IOException, TabletLocationState.BadLocationStateException {
        SortedMap decodedRow = WholeRowIterator.decodeRow((Key)k, (Value)v);
        KeyExtent extent = null;
        TServerInstance future = null;
        TServerInstance current = null;
        TServerInstance last = null;
        SuspendingTServer suspend = null;
        long lastTimestamp = 0L;
        ArrayList<List<String>> walogs = new ArrayList<List<String>>();
        boolean chopped = false;
        for (Map.Entry entry : decodedRow.entrySet()) {
            TServerInstance location;
            Key key = (Key)entry.getKey();
            Text row = key.getRow();
            Text cf = key.getColumnFamily();
            Text cq = key.getColumnQualifier();
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME) == 0) {
                location = new TServerInstance((Value)entry.getValue(), cq);
                if (future != null) {
                    throw new TabletLocationState.BadLocationStateException("found two assignments for the same extent " + row + ": " + future + " and " + location, row);
                }
                future = location;
                continue;
            }
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) == 0) {
                location = new TServerInstance((Value)entry.getValue(), cq);
                if (current != null) {
                    throw new TabletLocationState.BadLocationStateException("found two locations for the same extent " + row + ": " + current + " and " + location, row);
                }
                current = location;
                continue;
            }
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.LogColumnFamily.NAME) == 0) {
                String[] split = ((Value)entry.getValue()).toString().split("\\|")[0].split(";");
                walogs.add(Arrays.asList(split));
                continue;
            }
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME) == 0) {
                if (lastTimestamp >= ((Key)entry.getKey()).getTimestamp()) continue;
                last = new TServerInstance((Value)entry.getValue(), cq);
                continue;
            }
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.ChoppedColumnFamily.NAME) == 0) {
                chopped = true;
                continue;
            }
            if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.equals(cf, cq)) {
                extent = KeyExtent.fromMetaPrevRow(entry);
                continue;
            }
            if (!MetadataSchema.TabletsSection.SuspendLocationColumn.SUSPEND_COLUMN.equals(cf, cq)) continue;
            suspend = SuspendingTServer.fromValue((Value)((Value)entry.getValue()));
        }
        if (extent == null) {
            String msg = "No prev-row for key extent " + decodedRow;
            log.error(msg);
            throw new TabletLocationState.BadLocationStateException(msg, k.getRow());
        }
        return new TabletLocationState(extent, future, current, last, suspend, walogs, chopped);
    }
}

