/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.manager;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.ClientService;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransport;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveTServerSet
implements Watcher {
    private static final Logger log = LoggerFactory.getLogger(LiveTServerSet.class);
    private final Listener cback;
    private final ServerContext context;
    private ZooCache zooCache;
    private Map<String, TServerInfo> current = new HashMap<String, TServerInfo>();
    private Map<TServerInstance, TServerInfo> currentInstances = new HashMap<TServerInstance, TServerInfo>();
    private Map<String, Long> locklessServers = new HashMap<String, Long>();

    public LiveTServerSet(ServerContext context, Listener cback) {
        this.cback = cback;
        this.context = context;
    }

    public synchronized ZooCache getZooCache() {
        if (this.zooCache == null) {
            this.zooCache = new ZooCache(this.context.getZooReader(), (Watcher)this);
        }
        return this.zooCache;
    }

    public synchronized void startListeningForTabletServerChanges() {
        this.scanServers();
        ThreadPools.watchCriticalScheduledTask(this.context.getScheduledExecutor().scheduleWithFixedDelay(this::scanServers, 0L, 5000L, TimeUnit.MILLISECONDS));
    }

    public synchronized void scanServers() {
        try {
            HashSet<TServerInstance> updates = new HashSet<TServerInstance>();
            HashSet<TServerInstance> doomed = new HashSet<TServerInstance>();
            String path = this.context.getZooKeeperRoot() + "/tservers";
            HashSet<String> all = new HashSet<String>(this.current.keySet());
            all.addAll(this.getZooCache().getChildren(path));
            this.locklessServers.keySet().retainAll(all);
            for (String zPath : all) {
                this.checkServer(updates, doomed, path, zPath);
            }
            this.cback.update(this, doomed, updates);
        }
        catch (Exception ex) {
            log.error("{}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void deleteServerNode(String serverNode) throws InterruptedException, KeeperException {
        try {
            this.context.getZooReaderWriter().delete(serverNode);
        }
        catch (KeeperException.NotEmptyException notEmptyException) {
            // empty catch block
        }
    }

    private synchronized void checkServer(Set<TServerInstance> updates, Set<TServerInstance> doomed, String path, String zPath) throws InterruptedException, KeeperException {
        TServerInfo info = this.current.get(zPath);
        ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(path + "/" + zPath));
        ZooCache.ZcStat stat = new ZooCache.ZcStat();
        byte[] lockData = ServiceLock.getLockData((ZooCache)this.getZooCache(), (ServiceLock.ServiceLockPath)zLockPath, (ZooCache.ZcStat)stat);
        if (lockData == null) {
            Long firstSeen;
            if (info != null) {
                doomed.add(info.instance);
                this.current.remove(zPath);
                this.currentInstances.remove(info.instance);
            }
            if ((firstSeen = this.locklessServers.get(zPath)) == null) {
                this.locklessServers.put(zPath, System.currentTimeMillis());
            } else if (System.currentTimeMillis() - firstSeen > TimeUnit.MINUTES.toMillis(10L)) {
                this.deleteServerNode(path + "/" + zPath);
                this.locklessServers.remove(zPath);
            }
        } else {
            this.locklessServers.remove(zPath);
            ServerServices services = new ServerServices(new String(lockData, StandardCharsets.UTF_8));
            HostAndPort client = services.getAddress(ServerServices.Service.TSERV_CLIENT);
            TServerInstance instance = new TServerInstance(client, stat.getEphemeralOwner());
            if (info == null) {
                updates.add(instance);
                TServerInfo tServerInfo = new TServerInfo(instance, new TServerConnection(client));
                this.current.put(zPath, tServerInfo);
                this.currentInstances.put(instance, tServerInfo);
            } else if (!info.instance.equals((Object)instance)) {
                doomed.add(info.instance);
                updates.add(instance);
                TServerInfo tServerInfo = new TServerInfo(instance, new TServerConnection(client));
                this.current.put(zPath, tServerInfo);
                this.currentInstances.remove(info.instance);
                this.currentInstances.put(instance, tServerInfo);
            }
        }
    }

    public void process(WatchedEvent event) {
        if (event.getPath() != null) {
            int pos;
            if (event.getPath().endsWith("/tservers")) {
                this.scanServers();
            } else if (event.getPath().contains("/tservers") && (pos = event.getPath().lastIndexOf(47)) >= 0 && event.getPath().substring(0, pos).endsWith("/tservers")) {
                String server = event.getPath().substring(pos + 1);
                HashSet<TServerInstance> updates = new HashSet<TServerInstance>();
                HashSet<TServerInstance> doomed = new HashSet<TServerInstance>();
                String path = this.context.getZooKeeperRoot() + "/tservers";
                try {
                    this.checkServer(updates, doomed, path, server);
                    this.cback.update(this, doomed, updates);
                }
                catch (Exception ex) {
                    log.error("Exception", (Throwable)ex);
                }
            }
        }
    }

    public synchronized TServerConnection getConnection(TServerInstance server) {
        if (server == null) {
            return null;
        }
        TServerInfo tServerInfo = this.currentInstances.get(server);
        if (tServerInfo == null) {
            return null;
        }
        return tServerInfo.connection;
    }

    public synchronized Set<TServerInstance> getCurrentServers() {
        return new HashSet<TServerInstance>(this.currentInstances.keySet());
    }

    public synchronized int size() {
        return this.current.size();
    }

    public synchronized TServerInstance find(String tabletServer) {
        return this.find(this.current, tabletServer);
    }

    TServerInstance find(Map<String, TServerInfo> servers, String tabletServer) {
        HostAndPort addr;
        String sessionId = null;
        if (tabletServer.charAt(tabletServer.length() - 1) == ']') {
            int index = tabletServer.indexOf(91);
            if (index == -1) {
                throw new IllegalArgumentException("Could not parse tabletserver '" + tabletServer + "'");
            }
            addr = AddressUtil.parseAddress((String)tabletServer.substring(0, index), (boolean)false);
            sessionId = tabletServer.substring(index + 1, tabletServer.length() - 1);
        } else {
            addr = AddressUtil.parseAddress((String)tabletServer, (boolean)false);
        }
        for (Map.Entry<String, TServerInfo> entry : servers.entrySet()) {
            if (!entry.getValue().instance.getHostAndPort().equals((Object)addr) || sessionId != null && !sessionId.equals(entry.getValue().instance.getSession())) continue;
            return entry.getValue().instance;
        }
        return null;
    }

    public synchronized void remove(TServerInstance server) {
        String zPath = null;
        for (Map.Entry<String, TServerInfo> entry : this.current.entrySet()) {
            if (!entry.getValue().instance.equals((Object)server)) continue;
            zPath = entry.getKey();
            break;
        }
        if (zPath == null) {
            return;
        }
        this.current.remove(zPath);
        this.currentInstances.remove(server);
        log.info("Removing zookeeper lock for {}", (Object)server);
        String fullpath = this.context.getZooKeeperRoot() + "/tservers/" + zPath;
        try {
            this.context.getZooReaderWriter().recursiveDelete(fullpath, ZooUtil.NodeMissingPolicy.SKIP);
        }
        catch (Exception e) {
            String msg = "error removing tablet server lock";
            log.error("FATAL: {}", (Object)msg, (Object)e);
            Halt.halt((String)msg, (int)-1);
        }
        this.getZooCache().clear(fullpath);
    }

    static class TServerInfo {
        TServerConnection connection;
        TServerInstance instance;

        TServerInfo(TServerInstance instance, TServerConnection connection) {
            this.connection = connection;
            this.instance = instance;
        }
    }

    public class TServerConnection {
        private final HostAndPort address;

        public TServerConnection(HostAndPort addr) {
            this.address = addr;
        }

        public HostAndPort getAddress() {
            return this.address;
        }

        private String lockString(ServiceLock mlock) {
            return mlock.getLockID().serialize(LiveTServerSet.this.context.getZooKeeperRoot() + "/managers/lock");
        }

        private void loadTablet(TabletClientService.Client client, ServiceLock lock, KeyExtent extent) throws TException {
            client.loadTablet(TraceUtil.traceInfo(), LiveTServerSet.this.context.rpcCreds(), this.lockString(lock), extent.toThrift());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void assignTablet(ServiceLock lock, KeyExtent extent) throws TException {
            if (extent.isMeta()) {
                try (TTransport transport = ThriftUtil.createTransport((HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);){
                    TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.createClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (TTransport)transport);
                    this.loadTablet(client, lock, extent);
                }
            }
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);
            try {
                this.loadTablet(client, lock, extent);
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)LiveTServerSet.this.context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unloadTablet(ServiceLock lock, KeyExtent extent, TUnloadTabletGoal goal, long requestTime) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);
            try {
                client.unloadTablet(TraceUtil.traceInfo(), LiveTServerSet.this.context.rpcCreds(), this.lockString(lock), extent.toThrift(), goal, requestTime);
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)LiveTServerSet.this.context);
            }
        }

        public TabletServerStatus getTableMap(boolean usePooledConnection) throws TException, ThriftSecurityException {
            if (usePooledConnection) {
                throw new UnsupportedOperationException();
            }
            long start = System.currentTimeMillis();
            try (TTransport transport = ThriftUtil.createTransport((HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);){
                TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.createClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (TTransport)transport);
                TabletServerStatus status = client.getTabletServerStatus(TraceUtil.traceInfo(), LiveTServerSet.this.context.rpcCreds());
                if (status != null) {
                    status.setResponseTime(System.currentTimeMillis() - start);
                }
                TabletServerStatus tabletServerStatus = status;
                return tabletServerStatus;
            }
        }

        public void halt(ServiceLock lock) throws TException, ThriftSecurityException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);
            try {
                client.halt(TraceUtil.traceInfo(), LiveTServerSet.this.context.rpcCreds(), this.lockString(lock));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)LiveTServerSet.this.context);
            }
        }

        public void fastHalt(ServiceLock lock) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);
            try {
                client.fastHalt(TraceUtil.traceInfo(), LiveTServerSet.this.context.rpcCreds(), this.lockString(lock));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)LiveTServerSet.this.context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush(ServiceLock lock, TableId tableId, byte[] startRow, byte[] endRow) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);
            try {
                client.flush(TraceUtil.traceInfo(), LiveTServerSet.this.context.rpcCreds(), this.lockString(lock), tableId.canonical(), startRow == null ? null : ByteBuffer.wrap(startRow), endRow == null ? null : ByteBuffer.wrap(endRow));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)LiveTServerSet.this.context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void chop(ServiceLock lock, KeyExtent extent) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);
            try {
                client.chop(TraceUtil.traceInfo(), LiveTServerSet.this.context.rpcCreds(), this.lockString(lock), extent.toThrift());
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)LiveTServerSet.this.context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void splitTablet(KeyExtent extent, Text splitPoint) throws TException, ThriftSecurityException, NotServingTabletException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);
            try {
                client.splitTablet(TraceUtil.traceInfo(), LiveTServerSet.this.context.rpcCreds(), extent.toThrift(), ByteBuffer.wrap(splitPoint.getBytes(), 0, splitPoint.getLength()));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)LiveTServerSet.this.context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void compact(ServiceLock lock, String tableId, byte[] startRow, byte[] endRow) throws TException {
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);
            try {
                client.compact(TraceUtil.traceInfo(), LiveTServerSet.this.context.rpcCreds(), this.lockString(lock), tableId, startRow == null ? null : ByteBuffer.wrap(startRow), endRow == null ? null : ByteBuffer.wrap(endRow));
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)LiveTServerSet.this.context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive(long tid) throws TException {
            ClientService.Client client = (ClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.CLIENT, (HostAndPort)this.address, (ClientContext)LiveTServerSet.this.context);
            try {
                boolean bl = client.isActive(TraceUtil.traceInfo(), tid);
                return bl;
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)LiveTServerSet.this.context);
            }
        }
    }

    public static interface Listener {
        public void update(LiveTServerSet var1, Set<TServerInstance> var2, Set<TServerInstance> var3);
    }
}

