/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.log;

import org.apache.hadoop.fs.Path;

public enum SortedLogState {
    FINISHED("finished"),
    FAILED("failed");

    private String marker;

    private SortedLogState(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public static boolean isFinished(String fileName) {
        return FINISHED.getMarker().equals(fileName);
    }

    public static Path getFinishedMarkerPath(String rootPath) {
        return new Path(rootPath, FINISHED.getMarker());
    }

    public static Path getFinishedMarkerPath(Path rootPath) {
        return new Path(rootPath, FINISHED.getMarker());
    }

    public static Path getFailedMarkerPath(String rootPath) {
        return new Path(rootPath, FAILED.getMarker());
    }

    public String toString() {
        return this.marker;
    }
}

